/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.laser;

import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.common.blockentity.LaserPipeBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeNet;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserRoutePath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserNetHandler
implements ILaserContainer {
    private LaserPipeNet net;
    private final LaserPipeBlockEntity pipe;
    private final Direction facing;
    private final Level world;

    public LaserNetHandler(LaserPipeNet net, @NotNull LaserPipeBlockEntity pipe, @Nullable Direction facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
        this.world = pipe.getLevel();
    }

    public void updateNetwork(LaserPipeNet net) {
        this.net = net;
    }

    private void setPipesActive() {
        for (BlockPos pos : this.net.getAllNodes().keySet()) {
            BlockEntity blockEntity = this.world.getBlockEntity(pos);
            if (!(blockEntity instanceof LaserPipeBlockEntity)) continue;
            LaserPipeBlockEntity laserPipe = (LaserPipeBlockEntity)blockEntity;
            laserPipe.setActive(true, 100);
        }
    }

    @Nullable
    private ILaserContainer getInnerContainer() {
        if (this.net == null || this.pipe == null || this.pipe.isInValid() || this.facing == null || this.pipe.isBlocked(this.facing)) {
            return null;
        }
        LaserRoutePath data = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (data == null) {
            return null;
        }
        return data.getHandler((Level)this.net.getLevel());
    }

    @Override
    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        this.setPipesActive();
        return handler.acceptEnergyFromNetwork(side, voltage, amperage);
    }

    @Override
    public boolean inputsEnergy(Direction side) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return false;
        }
        return handler.inputsEnergy(side);
    }

    @Override
    public boolean outputsEnergy(Direction side) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return false;
        }
        return handler.outputsEnergy(side);
    }

    @Override
    public long changeEnergy(long amount) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        this.setPipesActive();
        return handler.changeEnergy(amount);
    }

    @Override
    public long getEnergyStored() {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        return handler.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        return handler.getEnergyCapacity();
    }

    @Override
    public long getInputAmperage() {
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        return 0L;
    }

    public LaserPipeNet getNet() {
        return this.net;
    }

    @Override
    public boolean isOneProbeHidden() {
        return true;
    }
}

