/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.ConditionSerializeUtils;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.common.data.GTRecipeConditions;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjacentBlockCondition
extends RecipeCondition {
    public static final Codec<AdjacentBlockCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse(instance).and((App)Codec.STRING.fieldOf("blockString").forGetter(AdjacentBlockCondition::getBlockString)).apply((Applicative)instance, AdjacentBlockCondition::new));
    @NotNull
    private String blockString = "";
    @Nullable
    private List<HolderSet<Block>> blocks = null;

    public void setBlocks(@NotNull List<HolderSet<Block>> blocks) {
        this.blocks = blocks;
        this.blockString = ConditionSerializeUtils.encodeHolderSets(blocks);
    }

    public List<HolderSet<Block>> getBlocks() {
        if (this.blocks == null) {
            this.blocks = ConditionSerializeUtils.decodeHolderSets(this.getBlockString(), Registries.BLOCK);
        }
        return this.blocks;
    }

    public AdjacentBlockCondition(@NotNull List<HolderSet<Block>> blocks) {
        this.setBlocks(blocks);
    }

    public AdjacentBlockCondition(boolean isReverse, @NotNull List<HolderSet<Block>> blocks) {
        super(isReverse);
        this.setBlocks(blocks);
    }

    public AdjacentBlockCondition(boolean isReverse, String blockString) {
        super(isReverse);
        this.blockString = blockString;
    }

    public static AdjacentBlockCondition fromBlocks(Collection<Block> blocks) {
        return new AdjacentBlockCondition(blocks.stream().map(Block::builtInRegistryHolder).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})).toList());
    }

    public static AdjacentBlockCondition fromBlocks(Block ... blocks) {
        return AdjacentBlockCondition.fromBlocks(Arrays.asList(blocks));
    }

    public static AdjacentBlockCondition fromTags(Collection<TagKey<Block>> tags) {
        return new AdjacentBlockCondition(tags.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getOrCreateTag(arg_0)).toList());
    }

    @SafeVarargs
    public static AdjacentBlockCondition fromTags(TagKey<Block> ... tags) {
        return AdjacentBlockCondition.fromTags(Arrays.asList(tags));
    }

    @Override
    public RecipeConditionType<?> getType() {
        return GTRecipeConditions.ADJACENT_BLOCK;
    }

    @Override
    public Component getTooltips() {
        return Component.translatable((String)"recipe.condition.adjacent_block.tooltip");
    }

    @Override
    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        Level level = recipeLogic.getMachine().getLevel();
        BlockPos pos = recipeLogic.getMachine().getPos();
        if (level == null) {
            return false;
        }
        HashSet<HolderSet<Block>> remainingBlocks = new HashSet<HolderSet<Block>>(this.getOrInitBlocks(recipe));
        if (remainingBlocks.isEmpty()) {
            return true;
        }
        for (BlockPos offset : GTUtil.NON_CORNER_NEIGHBOURS) {
            BlockState block = level.getBlockState(pos.offset((Vec3i)offset));
            Iterator it = remainingBlocks.iterator();
            while (it.hasNext()) {
                if (!block.is((HolderSet)it.next())) continue;
                it.remove();
                break;
            }
            if (!remainingBlocks.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<HolderSet<Block>> getOrInitBlocks(@NotNull GTRecipe recipe) {
        if (this.getBlocks().isEmpty() || recipe.data.contains("blockA") && recipe.data.contains("blockB")) {
            Block blockB;
            ArrayList<HolderSet<Block>> blocks = new ArrayList<HolderSet<Block>>();
            Block blockA = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(recipe.data.getString("blockA")));
            if (!blockA.defaultBlockState().isAir()) {
                blocks.add((HolderSet<Block>)HolderSet.direct((Holder[])new Holder[]{blockA.builtInRegistryHolder()}));
            }
            if (!(blockB = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(recipe.data.getString("blockB")))).defaultBlockState().isAir()) {
                blocks.add((HolderSet<Block>)HolderSet.direct((Holder[])new Holder[]{blockB.builtInRegistryHolder()}));
            }
            this.setBlocks(blocks);
        }
        return this.getBlocks();
    }

    @Override
    public RecipeCondition createTemplate() {
        return new AdjacentBlockCondition();
    }

    @Generated
    public AdjacentBlockCondition() {
    }

    @NotNull
    @Generated
    public String getBlockString() {
        return this.blockString;
    }
}

