/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.valueprovider;

import com.gregtechceu.gtceu.common.data.GTValueProviderTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;
import org.jetbrains.annotations.NotNull;

public class MultipliedFloat
extends FloatProvider {
    public static final Codec<MultipliedFloat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FloatProvider.CODEC.fieldOf("source").forGetter(provider -> provider.source), (App)FloatProvider.CODEC.fieldOf("multiplier").forGetter(provider -> provider.multiplier)).apply((Applicative)instance, MultipliedFloat::new));
    private final FloatProvider source;
    private final FloatProvider multiplier;

    public static MultipliedFloat of(FloatProvider source, FloatProvider multiplier) {
        return new MultipliedFloat(source, multiplier);
    }

    public MultipliedFloat(FloatProvider source, FloatProvider multiplier) {
        this.source = source;
        this.multiplier = multiplier;
    }

    public float sample(@NotNull RandomSource random) {
        return this.source.sample(random) * this.multiplier.sample(random);
    }

    public float getMinValue() {
        return this.source.getMinValue() * this.multiplier.getMinValue();
    }

    public float getMaxValue() {
        float f;
        float f2 = this.source.getMaxValue();
        FloatProvider floatProvider = this.multiplier;
        if (floatProvider instanceof ConstantFloat) {
            ConstantFloat c = (ConstantFloat)floatProvider;
            f = c.getValue();
        } else {
            f = this.multiplier.getMaxValue();
        }
        return f2 * f;
    }

    @NotNull
    public FloatProviderType<?> getType() {
        return (FloatProviderType)GTValueProviderTypes.MULTIPLIED.get();
    }
}

