/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.worldgen.feature;

import com.gregtechceu.gtceu.common.worldgen.feature.configurations.FluidSproutConfiguration;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableInt;

public class FluidSproutFeature
extends Feature<FluidSproutConfiguration> {
    public FluidSproutFeature() {
        super(FluidSproutConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<FluidSproutConfiguration> context) {
        RandomSource random = context.random();
        BlockPos blockpos = context.origin();
        WorldGenLevel level = context.level();
        FluidSproutConfiguration config = (FluidSproutConfiguration)context.config();
        MutableInt placedAmount = new MutableInt(0);
        int size = config.size().sample(random);
        int radius = Mth.ceil((float)((float)size / 2.0f));
        int x0 = blockpos.getX() - radius;
        int y0 = blockpos.getY() - radius;
        int z0 = blockpos.getZ() - radius;
        int width = size + 1;
        int length = size + 1;
        int height = size + 1;
        if (config.fluid().isSame(Fluids.EMPTY)) {
            return false;
        }
        int surfaceHeight = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, blockpos.getX(), blockpos.getZ());
        if (blockpos.getY() >= surfaceHeight) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess((LevelAccessor)level);){
            for (int x = 0; x < width; ++x) {
                float dx = (float)x * 2.0f / (float)width - 1.0f;
                if (dx * dx > 1.0f) continue;
                for (int y = 0; y < height; ++y) {
                    float dy = (float)y * 2.0f / (float)height - 1.0f;
                    if (dx * dx + dy * dy > 1.0f || level.isOutsideBuildHeight(y0 + y)) continue;
                    for (int z = 0; z < length; ++z) {
                        float dz = (float)z * 2.0f / (float)length - 1.0f;
                        if (dx * dx + dy * dy + dz * dz > 1.0f) continue;
                        int currentX = x0 + x;
                        int currentY = y0 + y;
                        int currentZ = z0 + z;
                        this.setBlock(mutablePos, currentX, currentY, currentZ, bulkSectionAccess, level, config, placedAmount);
                    }
                }
            }
            if (random.nextFloat() <= config.sproutChance()) {
                int currentX = blockpos.getX();
                int currentZ = blockpos.getZ();
                int springHeight = surfaceHeight + config.surfaceOffset().sample(random);
                for (int currentY = blockpos.getY(); currentY <= springHeight; ++currentY) {
                    this.setBlock(mutablePos, currentX, currentY, currentZ, bulkSectionAccess, level, config, placedAmount);
                    if (currentY > surfaceHeight) continue;
                    this.setBlock(mutablePos, currentX + 1, currentY, currentZ, bulkSectionAccess, level, config, placedAmount);
                    this.setBlock(mutablePos, currentX - 1, currentY, currentZ, bulkSectionAccess, level, config, placedAmount);
                    this.setBlock(mutablePos, currentX, currentY, currentZ + 1, bulkSectionAccess, level, config, placedAmount);
                    this.setBlock(mutablePos, currentX, currentY, currentZ - 1, bulkSectionAccess, level, config, placedAmount);
                }
            }
        }
        return placedAmount.intValue() > 0;
    }

    public void setBlock(BlockPos.MutableBlockPos mutablePos, int currentX, int currentY, int currentZ, BulkSectionAccess access, WorldGenLevel level, FluidSproutConfiguration config, MutableInt placedAmount) {
        mutablePos.set(currentX, currentY, currentZ);
        if (!level.ensureCanWrite((BlockPos)mutablePos)) {
            return;
        }
        LevelChunkSection levelchunksection = access.getSection((BlockPos)mutablePos);
        if (levelchunksection == null) {
            return;
        }
        int sectionX = SectionPos.sectionRelative((int)currentX);
        int sectionY = SectionPos.sectionRelative((int)currentY);
        int sectionZ = SectionPos.sectionRelative((int)currentZ);
        levelchunksection.setBlockState(sectionX, sectionY, sectionZ, config.fluid().defaultFluidState().createLegacyBlock(), false);
        level.getChunk((BlockPos)mutablePos).markPosForPostprocessing((BlockPos)mutablePos);
        placedAmount.add(1);
    }

    public boolean canPlaceFluid(BlockState state, Function<BlockPos, BlockState> adjacentStateAccessor, RandomSource random, RuleTest target, BlockPos.MutableBlockPos mutablePos) {
        if (!target.test(state, random)) {
            return false;
        }
        return !FluidSproutFeature.isAdjacentToAir(adjacentStateAccessor, (BlockPos)mutablePos);
    }
}

