/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.loot;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.LootPoolAccessor;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public final class ChestGenHooks {
    private static final Map<ResourceLocation, List<GTLootEntryItem>> lootEntryItems = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, NumberProvider> rollValues = new Object2ObjectOpenHashMap();
    private static final LootItemCondition[] NO_CONDITIONS = new LootItemCondition[0];
    private static final ItemStackHashStrategy HASH_STRATEGY = ItemStackHashStrategy.comparingAllButCount();

    private ChestGenHooks() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ChestGenHooks.class);
    }

    @SubscribeEvent
    public static void onWorldLoad(@NotNull LootTableLoadEvent event) {
        LootPool mainPool = event.getTable().getPool("main");
        if (mainPool == null) {
            return;
        }
        ResourceLocation name = event.getName();
        if (lootEntryItems.containsKey(name)) {
            List<GTLootEntryItem> entryItems = lootEntryItems.get(name);
            for (GTLootEntryItem entry : entryItems) {
                if (ConfigHolder.INSTANCE.dev.debug) {
                    GTCEu.LOGGER.info("adding {} to lootTable {}", (Object)entry, (Object)name);
                }
                try {
                    Object[] entries = ((LootPoolAccessor)mainPool).getEntries();
                    entries = (LootPoolEntryContainer[])ArrayUtils.add((Object[])entries, (Object)((Object)entry));
                    ((LootPoolAccessor)mainPool).setEntries((LootPoolEntryContainer[])entries);
                }
                catch (RuntimeException e) {
                    GTCEu.LOGGER.error("Couldn't add {} to lootTable {}: {}", (Object)entry, (Object)name, (Object)e.getMessage());
                }
            }
        }
        if (rollValues.containsKey(event.getName())) {
            NumberProvider rangeAdd = rollValues.get(event.getName());
            NumberProvider numberProvider = mainPool.getRolls();
        }
    }

    public static void addItem(@NotNull ResourceLocation lootTable, @NotNull ItemStack stack, int minAmount, int maxAmount, int weight) {
        RandomWeightLootFunction lootFunction = new RandomWeightLootFunction(stack, minAmount, maxAmount);
        String modid = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).getNamespace();
        String entryName = ChestGenHooks.createEntryName(stack, modid, weight, lootFunction);
        GTLootEntryItem itemEntry = new GTLootEntryItem(stack, weight, lootFunction, entryName);
        lootEntryItems.computeIfAbsent(lootTable, $ -> new ArrayList()).add(itemEntry);
    }

    public static void addRolls(ResourceLocation tableLocation, int minAdd, int maxAdd) {
        rollValues.put(tableLocation, (NumberProvider)UniformGenerator.between((float)minAdd, (float)maxAdd));
    }

    @NotNull
    private static String createEntryName(@NotNull ItemStack stack, @NotNull String modid, int weight, @NotNull RandomWeightLootFunction function) {
        int hashCode = GTMath.hashInts(HASH_STRATEGY.hashCode(stack), modid.hashCode(), weight, function.getMinAmount(), function.getMaxAmount());
        return String.format("#%s:loot_%s", modid, hashCode);
    }

    private static class GTLootEntryItem
    extends LootItem {
        private final ItemStack stack;
        private final String entryName;

        public GTLootEntryItem(@NotNull ItemStack stack, int weight, LootItemFunction lootFunction, @NotNull String entryName) {
            super(stack.getItem(), weight, 1, NO_CONDITIONS, new LootItemFunction[]{lootFunction});
            this.stack = stack;
            this.entryName = entryName;
        }

        public void createItemStack(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
            stackConsumer.accept(this.stack.copy());
        }

        @NotNull
        public String toString() {
            return "GTLootEntryItem{name=" + this.entryName + ", stack=" + this.stack.toString() + "}";
        }
    }

    public static class RandomWeightLootFunction
    extends LootItemConditionalFunction
    implements LootItemFunction {
        public static final LootItemFunctionType TYPE = GTRegistries.register(BuiltInRegistries.LOOT_FUNCTION_TYPE, GTCEu.id("random_weight"), new LootItemFunctionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer()));
        private final ItemStack stack;
        private final int minAmount;
        private final int maxAmount;

        public RandomWeightLootFunction(@NotNull ItemStack stack, int minAmount, int maxAmount) {
            super(NO_CONDITIONS);
            Preconditions.checkArgument((minAmount <= maxAmount ? 1 : 0) != 0, (Object)"minAmount must be <= maxAmount");
            this.stack = stack;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        public static void init() {
        }

        public LootItemFunctionType getType() {
            return TYPE;
        }

        protected ItemStack run(ItemStack itemStack, LootContext context) {
            CompoundTag tagCompound;
            if (this.stack.getDamageValue() != 0) {
                itemStack.setDamageValue(this.stack.getDamageValue());
            }
            if ((tagCompound = this.stack.getTag()) != null) {
                itemStack.setTag(tagCompound.copy());
            }
            if (this.minAmount == this.maxAmount) {
                itemStack.setCount(this.minAmount);
                return itemStack;
            }
            int count = Math.min(this.minAmount + context.getRandom().nextInt(this.maxAmount - this.minAmount + 1), this.stack.getMaxStackSize());
            itemStack.setCount(count);
            return itemStack;
        }

        @Generated
        public int getMinAmount() {
            return this.minAmount;
        }

        @Generated
        public int getMaxAmount() {
            return this.maxAmount;
        }

        public static class Serializer
        extends LootItemConditionalFunction.Serializer<RandomWeightLootFunction> {
            public void serialize(JsonObject json, RandomWeightLootFunction setItemCountFunction, JsonSerializationContext serializationContext) {
                super.serialize(json, (LootItemConditionalFunction)setItemCountFunction, serializationContext);
                json.add("min", serializationContext.serialize((Object)setItemCountFunction.minAmount));
                json.add("max", serializationContext.serialize((Object)setItemCountFunction.maxAmount));
                JsonObject stack = new JsonObject();
                stack.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)setItemCountFunction.stack.getItem()).toString());
                stack.addProperty("count", (Number)setItemCountFunction.stack.getCount());
                if (setItemCountFunction.stack.hasTag()) {
                    stack.addProperty("nbt", setItemCountFunction.stack.getTag().toString());
                }
                json.add("stack", (JsonElement)stack);
            }

            public RandomWeightLootFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
                ItemStack stack = CraftingHelper.getItemStack((JsonObject)object.getAsJsonObject("stack"), (boolean)true);
                int min = GsonHelper.getAsInt((JsonObject)object, (String)"min");
                int max = GsonHelper.getAsInt((JsonObject)object, (String)"max");
                return new RandomWeightLootFunction(stack, min, max);
            }
        }
    }
}

