/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.model.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.registry.registrate.provider.GTBlockstateProvider;
import com.gregtechceu.gtceu.client.model.machine.MachineModelLoader;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.core.mixins.forge.ConfiguredModelBuilderAccessor;
import com.gregtechceu.gtceu.core.mixins.forge.ConfiguredModelListAccessor;
import com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MachineModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private final MachineDefinition owner;
    private final List<DynamicRender<?, ?>> dynamicRenders = new ArrayList();
    private final Map<PartialState<T>, BlockStateProvider.ConfiguredModelList> models = new LinkedHashMap<PartialState<T>, BlockStateProvider.ConfiguredModelList>();
    private final List<PartBuilder> parts = new ArrayList<PartBuilder>();
    private final Set<MachineRenderState> coveredStates = new HashSet<MachineRenderState>();
    private final List<String> replaceableTextures = new ArrayList<String>();
    private final SortedMap<String, ResourceLocation> textureOverrides = new TreeMap<String, ResourceLocation>();

    public static <T extends ModelBuilder<T>> BiFunction<T, ExistingFileHelper, MachineModelBuilder<T>> begin(MachineDefinition owner) {
        return (parent, existingFileHelper) -> new MachineModelBuilder<ModelBuilder>((ModelBuilder)parent, (ExistingFileHelper)existingFileHelper, owner);
    }

    protected MachineModelBuilder(T parent, ExistingFileHelper existingFileHelper, MachineDefinition owner) {
        super(MachineModelLoader.ID, parent, existingFileHelper);
        this.owner = owner;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        json.addProperty("machine", this.owner.getId().toString());
        StateDefinition<MachineDefinition, MachineRenderState> stateDefinition = this.owner.getStateDefinition();
        if (this.getModels().isEmpty() && this.getParts().isEmpty()) {
            throw new IllegalStateException("A machine model must have a variant or multipart model!");
        }
        ArrayList<MachineRenderState> missingStates = new ArrayList<MachineRenderState>((Collection<MachineRenderState>)stateDefinition.getPossibleStates());
        missingStates.removeAll(this.coveredStates);
        if (!this.getParts().isEmpty()) {
            JsonArray parts = new JsonArray();
            for (PartBuilder partBuilder : this.getParts()) {
                missingStates.removeIf(partBuilder::matchesState);
                parts.add((JsonElement)partBuilder.toJson());
            }
            json.add("multipart", (JsonElement)parts);
        }
        if (!this.getModels().isEmpty()) {
            Preconditions.checkState((boolean)missingStates.isEmpty(), (String)"Render state for machine %s does not cover all states. Missing: %s", (Object)this.owner, missingStates);
            JsonObject variants = new JsonObject();
            this.getModels().entrySet().stream().sorted(Map.Entry.comparingByKey(PartialState.comparingByProperties())).forEach(entry -> variants.add(((PartialState)entry.getKey()).toString(), MachineModelBuilder.configuredModelListToJSON((BlockStateProvider.ConfiguredModelList)entry.getValue())));
            json.add("variants", (JsonElement)variants);
        }
        if (!this.dynamicRenders.isEmpty()) {
            JsonArray dynamicRenders = new JsonArray();
            for (DynamicRender dynamicRender : this.dynamicRenders) {
                JsonElement serialized = (JsonElement)DynamicRender.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)dynamicRender).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
                dynamicRenders.add(serialized);
            }
            json.add("dynamic_renders", (JsonElement)dynamicRenders);
        }
        if (!this.replaceableTextures.isEmpty()) {
            JsonArray replaceableTextures = new JsonArray();
            for (String string : this.replaceableTextures) {
                replaceableTextures.add(string);
            }
            json.add("replaceable_textures", (JsonElement)replaceableTextures);
        }
        if (!this.textureOverrides.isEmpty()) {
            JsonObject overrides = new JsonObject();
            for (Map.Entry entry2 : this.textureOverrides.entrySet()) {
                overrides.addProperty((String)entry2.getKey(), ((ResourceLocation)entry2.getValue()).toString());
            }
            json.add("texture_overrides", (JsonElement)overrides);
        }
        return json;
    }

    public static JsonElement modelToJson(ModelFile model) {
        if (model instanceof ModelBuilder) {
            ModelBuilder builder = (ModelBuilder)model;
            GTBlockstateProvider currentProvider = GTBlockstateProvider.getCurrentProvider();
            if (currentProvider != null && currentProvider.models().generatedModels.containsKey(builder.getLocation())) {
                return new JsonPrimitive(builder.getLocation().toString());
            }
            return builder.toJson();
        }
        return new JsonPrimitive(model.getLocation().toString());
    }

    public static JsonElement configuredModelListToJSON(BlockStateProvider.ConfiguredModelList list) {
        List<ConfiguredModel> models = ((ConfiguredModelListAccessor)list).gtceu$getModels();
        if (models.size() == 1) {
            return MachineModelBuilder.configuredModelToJSON(models.get(0), false);
        }
        JsonArray ret = new JsonArray();
        for (ConfiguredModel m : models) {
            ret.add((JsonElement)MachineModelBuilder.configuredModelToJSON(m, true));
        }
        return ret;
    }

    public static JsonObject configuredModelToJSON(ConfiguredModel model, boolean includeWeight) {
        JsonObject modelJson = new JsonObject();
        modelJson.add("model", MachineModelBuilder.modelToJson(model.model));
        if (model.rotationX != 0) {
            modelJson.addProperty("x", (Number)model.rotationX);
        }
        if (model.rotationY != 0) {
            modelJson.addProperty("y", (Number)model.rotationY);
        }
        if (model.uvLock) {
            modelJson.addProperty("uvlock", Boolean.valueOf(true));
        }
        if (includeWeight && model.weight != 1) {
            modelJson.addProperty("weight", (Number)model.weight);
        }
        return modelJson;
    }

    public MachineModelBuilder<T> addDynamicRenderer(Supplier<DynamicRender<?, ?>> render) {
        this.dynamicRenders.add(render.get());
        return this;
    }

    public MachineModelBuilder<T> addReplaceableTextures(String ... textureNames) {
        this.replaceableTextures.addAll(Arrays.asList(textureNames));
        return this;
    }

    public MachineModelBuilder<T> addTextureOverride(String material, ResourceLocation texture) {
        this.textureOverrides.put(material, texture);
        return this;
    }

    public MachineModelBuilder<T> replaceModels(PartialState<T> state, ConfiguredModel ... models) {
        Preconditions.checkNotNull(state, (Object)"state must not be null");
        Preconditions.checkArgument((models.length > 0 ? 1 : 0) != 0, (Object)"Cannot set models to empty array");
        Preconditions.checkArgument((state.getOwner() == this.owner ? 1 : 0) != 0, (String)"Cannot set models for a different block. Found: %s, Current: %s", (Object)state.getOwner(), (Object)this.owner);
        this.models.put(state, new BlockStateProvider.ConfiguredModelList(models));
        for (MachineRenderState fullState : this.owner.getStateDefinition().getPossibleStates()) {
            if (!state.test(fullState)) continue;
            this.coveredStates.add(fullState);
        }
        return this;
    }

    public MachineModelBuilder<T> addModels(PartialState<T> state, ConfiguredModel ... models) {
        Preconditions.checkArgument((boolean)this.disjointToAll(state), (Object)"Cannot set models for a state for which a partial match has already been configured");
        this.replaceModels(state, models);
        return this;
    }

    public MachineModelBuilder<T> setModels(PartialState<T> state, ConfiguredModel ... models) {
        Preconditions.checkArgument((!this.models.containsKey(state) ? 1 : 0) != 0, (String)"Cannot set models for a state that has already been configured: %s", state);
        this.addModels(state, models);
        return this;
    }

    private boolean disjointToAll(PartialState<T> newState) {
        return this.coveredStates.stream().noneMatch(newState);
    }

    public PartialState<T> partialState() {
        return new PartialState(this.owner, this);
    }

    public ConfiguredModel.Builder<PartBuilder> part() {
        return ConfiguredModelBuilderAccessor.builder(models -> {
            PartBuilder part = new PartBuilder(new BlockStateProvider.ConfiguredModelList(models));
            this.parts.add(part);
            return part;
        }, (List<ConfiguredModel>)ImmutableList.of());
    }

    public PartBuilder part(ModelFile model) {
        return (PartBuilder)this.part().modelFile(model).addModel();
    }

    public PartBuilder part(ResourceLocation model) {
        return this.part((ModelFile)new ModelFile.ExistingModelFile(model, this.existingFileHelper));
    }

    public MachineModelBuilder<T> forAllStatesModels(Function<MachineRenderState, ModelFile> mapper) {
        return this.forAllStates(mapper.andThen(m -> ConfiguredModel.builder().modelFile(m).build()));
    }

    public MachineModelBuilder<T> forAllStates(Function<MachineRenderState, ConfiguredModel[]> mapper) {
        return this.forAllStatesExcept(mapper, new Property[0]);
    }

    public MachineModelBuilder<T> forAllStatesExcept(Function<MachineRenderState, ConfiguredModel[]> mapper, Property<?> ... ignored) {
        HashSet seen = new HashSet();
        for (MachineRenderState fullState : this.owner.getStateDefinition().getPossibleStates()) {
            LinkedHashMap propertyValues = Maps.newLinkedHashMap((Map)fullState.getValues());
            for (Property<?> p : ignored) {
                propertyValues.remove(p);
            }
            PartialState partialState = new PartialState(this.owner, propertyValues, this);
            if (!seen.add(partialState)) continue;
            this.setModels(partialState, mapper.apply(fullState));
        }
        return this;
    }

    public MachineModelBuilder<T> replaceForAllStates(BiFunction<MachineRenderState, ConfiguredModel[], ConfiguredModel[]> mapper) {
        return this.replaceForAllStatesExcept(mapper, new Property[0]);
    }

    public MachineModelBuilder<T> replaceForAllStatesExcept(BiFunction<MachineRenderState, ConfiguredModel[], ConfiguredModel[]> mapper, Property<?> ... ignored) {
        HashSet seen = new HashSet();
        for (MachineRenderState fullState : this.owner.getStateDefinition().getPossibleStates()) {
            ConfiguredModelListAccessor old;
            LinkedHashMap propertyValues = Maps.newLinkedHashMap((Map)fullState.getValues());
            for (Property<?> p : ignored) {
                propertyValues.remove(p);
            }
            PartialState partialState = new PartialState(this.owner, propertyValues, this);
            if (!seen.add(partialState) || (old = (ConfiguredModelListAccessor)this.getModels().get(partialState)) == null) continue;
            ConfiguredModel[] oldModels = (ConfiguredModel[])old.gtceu$getModels().toArray(ConfiguredModel[]::new);
            this.replaceModels(partialState, mapper.apply(fullState, oldModels));
        }
        return this;
    }

    @Generated
    public MachineDefinition getOwner() {
        return this.owner;
    }

    @Generated
    public Map<PartialState<T>, BlockStateProvider.ConfiguredModelList> getModels() {
        return this.models;
    }

    @Generated
    public List<PartBuilder> getParts() {
        return this.parts;
    }

    @Generated
    public List<String> getReplaceableTextures() {
        return this.replaceableTextures;
    }

    @Generated
    public SortedMap<String, ResourceLocation> getTextureOverrides() {
        return this.textureOverrides;
    }

    public class PartBuilder {
        public BlockStateProvider.ConfiguredModelList models;
        public boolean useOr;
        public final Multimap<Property<?>, Comparable<?>> conditions = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        public final List<com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup> nestedConditionGroups = new ArrayList<com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup>();

        private PartBuilder(BlockStateProvider.ConfiguredModelList models) {
            this.models = models;
        }

        public PartBuilder useOr() {
            this.useOr = true;
            return this;
        }

        @SafeVarargs
        private final <T extends Comparable<T>> PartBuilder replaceWithCondition(Property<T> prop, T ... values) {
            Preconditions.checkNotNull(prop, (Object)"Property must not be null");
            Preconditions.checkNotNull(values, (Object)"Value list must not be null");
            Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Value list must not be empty");
            Preconditions.checkArgument((boolean)this.canApplyTo(MachineModelBuilder.this.owner), (String)"Property %s is not valid for machine %s", prop, (Object)MachineModelBuilder.this.owner);
            this.nestedConditionGroups.clear();
            this.conditions.putAll(prop, Arrays.asList(values));
            return this;
        }

        @SafeVarargs
        public final <T extends Comparable<T>> PartBuilder condition(Property<T> prop, T ... values) {
            Preconditions.checkArgument((!this.conditions.containsKey(prop) ? 1 : 0) != 0, (String)"Cannot set condition for property \"%s\" more than once", (Object)prop.getName());
            Preconditions.checkState((boolean)this.nestedConditionGroups.isEmpty(), (Object)"Can't have normal conditions if there are already nested condition groups");
            return this.replaceWithCondition((Property)prop, (Comparable[])values);
        }

        private final com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup replaceWithNestedGroup() {
            this.conditions.clear();
            ConditionGroup group = new ConditionGroup();
            this.nestedConditionGroups.add((com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup)group);
            return group;
        }

        public final com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup nestedGroup() {
            Preconditions.checkState((boolean)this.conditions.isEmpty(), (Object)"Can't have nested condition groups if there are already normal conditions");
            return this.replaceWithNestedGroup();
        }

        public MachineModelBuilder<T> end() {
            return MachineModelBuilder.this;
        }

        public JsonObject toJson() {
            JsonObject out = new JsonObject();
            if (!this.conditions.isEmpty()) {
                out.add("when", (JsonElement)this.conditionsToJson(this.conditions, this.useOr));
            } else if (!this.nestedConditionGroups.isEmpty()) {
                out.add("when", (JsonElement)this.groupsToJson(this.nestedConditionGroups, this.useOr));
            }
            out.add("apply", MachineModelBuilder.configuredModelListToJSON(this.models));
            return out;
        }

        public boolean canApplyTo(MachineDefinition b) {
            return b.getStateDefinition().getProperties().containsAll(this.conditions.keySet());
        }

        private JsonObject groupsToJson(List<com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup> conditions, boolean useOr) {
            JsonObject groupJson = new JsonObject();
            JsonArray innerGroupJson = new JsonArray();
            groupJson.add(useOr ? "OR" : "AND", (JsonElement)innerGroupJson);
            for (ConditionGroup conditionGroup : conditions) {
                innerGroupJson.add((JsonElement)conditionGroup.toJson());
            }
            return groupJson;
        }

        private JsonObject conditionsToJson(Multimap<Property<?>, Comparable<?>> conditions, boolean useOr) {
            JsonObject groupJson = new JsonObject();
            for (Map.Entry entry : conditions.asMap().entrySet()) {
                StringBuilder activeString = new StringBuilder();
                for (Comparable val : (Collection)entry.getValue()) {
                    if (!activeString.isEmpty()) {
                        activeString.append("|");
                    }
                    activeString.append(((Property)entry.getKey()).getName(val));
                }
                groupJson.addProperty(((Property)entry.getKey()).getName(), activeString.toString());
            }
            if (useOr) {
                JsonArray innerWhen = new JsonArray();
                for (Map.Entry entry : groupJson.entrySet()) {
                    JsonObject obj = new JsonObject();
                    obj.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    innerWhen.add((JsonElement)obj);
                }
                groupJson = new JsonObject();
                groupJson.add("OR", (JsonElement)innerWhen);
            }
            return groupJson;
        }

        protected boolean matchesState(MachineRenderState state) {
            return this.matchesState(state, this.useOr, this.conditions, this.nestedConditionGroups);
        }

        protected boolean matchesState(MachineRenderState state, boolean useOr, Multimap<Property<?>, Comparable<?>> conditions, List<com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup> nestedConditionGroups) {
            boolean matched;
            ImmutableMap stateValues = state.getValues();
            boolean bl = matched = !useOr;
            if (!conditions.isEmpty()) {
                for (Map.Entry entry : stateValues.entrySet()) {
                    Property property = (Property)entry.getKey();
                    Comparable value = (Comparable)entry.getValue();
                    boolean contains = conditions.containsEntry((Object)property, (Object)value);
                    if (useOr) {
                        matched |= contains;
                        continue;
                    }
                    matched &= contains;
                }
            } else if (!nestedConditionGroups.isEmpty()) {
                for (ConditionGroup conditionGroup : this.nestedConditionGroups) {
                    if (useOr) {
                        matched |= this.matchesState(state, conditionGroup.useOr, conditionGroup.conditions, conditionGroup.nestedConditionGroups);
                        continue;
                    }
                    matched &= this.matchesState(state, conditionGroup.useOr, conditionGroup.conditions, conditionGroup.nestedConditionGroups);
                }
            } else {
                return true;
            }
            return matched;
        }

        public class ConditionGroup {
            public final Multimap<Property<?>, Comparable<?>> conditions = MultimapBuilder.linkedHashKeys().arrayListValues().build();
            public final List<com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup> nestedConditionGroups = new ArrayList<com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup>();
            private com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup parent = null;
            public boolean useOr;

            @SafeVarargs
            private final <T extends Comparable<T>> com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup replaceWithCondition(Property<T> prop, T ... values) {
                Preconditions.checkNotNull(prop, (Object)"Property must not be null");
                Preconditions.checkNotNull(values, (Object)"Value list must not be null");
                Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Value list must not be empty");
                Preconditions.checkArgument((boolean)PartBuilder.this.canApplyTo(MachineModelBuilder.this.owner), (String)"Property %s is not valid for machine %s", prop, (Object)MachineModelBuilder.this.owner);
                this.nestedConditionGroups.clear();
                this.conditions.putAll(prop, Arrays.asList(values));
                return this;
            }

            @SafeVarargs
            public final <T extends Comparable<T>> com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup condition(Property<T> prop, T ... values) {
                Preconditions.checkArgument((!this.conditions.containsKey(prop) ? 1 : 0) != 0, (String)"Cannot set condition for property \"%s\" more than once", (Object)prop.getName());
                Preconditions.checkState((boolean)this.nestedConditionGroups.isEmpty(), (Object)"Can't have normal conditions if there are already nested condition groups");
                return this.replaceWithCondition((Property)prop, (Comparable[])values);
            }

            private com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup replaceWithNestedGroup() {
                this.conditions.clear();
                ConditionGroup group = new ConditionGroup();
                group.parent = this;
                this.nestedConditionGroups.add((com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup)group);
                return group;
            }

            public final com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup nestedGroup() {
                Preconditions.checkState((boolean)this.conditions.isEmpty(), (Object)"Can't have nested condition groups if there are already normal conditions");
                return this.replaceWithNestedGroup();
            }

            public com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup endNestedGroup() {
                if (this.parent == null) {
                    throw new IllegalStateException("This condition group is not nested, use end() instead");
                }
                return this.parent;
            }

            public PartBuilder end() {
                if (this.parent != null) {
                    throw new IllegalStateException("This is a nested condition group, use endNestedGroup() instead");
                }
                return PartBuilder.this;
            }

            public com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder$PartBuilder.ConditionGroup useOr() {
                this.useOr = true;
                return this;
            }

            public JsonObject toJson() {
                if (!this.conditions.isEmpty()) {
                    return PartBuilder.this.conditionsToJson(this.conditions, this.useOr);
                }
                if (!this.nestedConditionGroups.isEmpty()) {
                    return PartBuilder.this.groupsToJson(this.nestedConditionGroups, this.useOr);
                }
                return new JsonObject();
            }
        }
    }

    public static class PartialState<B extends ModelBuilder<B>>
    implements Predicate<MachineRenderState> {
        private final MachineDefinition owner;
        private final SortedMap<Property<?>, Comparable<?>> setStates;
        @Nullable
        private final MachineModelBuilder<B> outerBuilder;

        private PartialState(MachineDefinition owner, @Nullable MachineModelBuilder<B> outerBuilder) {
            this(owner, (Map<Property<?>, Comparable<?>>)ImmutableMap.of(), outerBuilder);
        }

        private PartialState(MachineDefinition owner, Map<Property<?>, Comparable<?>> setStates, @Nullable MachineModelBuilder<B> outerBuilder) {
            this.owner = owner;
            this.outerBuilder = outerBuilder;
            for (Map.Entry<Property<?>, Comparable<?>> entry : setStates.entrySet()) {
                Property<?> prop = entry.getKey();
                Comparable<?> value = entry.getValue();
                Preconditions.checkArgument((boolean)owner.getStateDefinition().getProperties().contains(prop), (String)"Property %s not found on machine %s", entry, (Object)this.owner);
                Preconditions.checkArgument((boolean)prop.getPossibleValues().contains(value), (String)"%s is not a valid value for %s", value, prop);
            }
            this.setStates = Maps.newTreeMap(Comparator.comparing(Property::getName));
            this.setStates.putAll(setStates);
        }

        public <T extends Comparable<T>> PartialState<B> with(Property<T> prop, T value) {
            Preconditions.checkArgument((!this.setStates.containsKey(prop) ? 1 : 0) != 0, (String)"Property %s has already been set", prop);
            HashMap newState = new HashMap(this.setStates);
            newState.put(prop, value);
            return new PartialState<B>(this.owner, newState, this.outerBuilder);
        }

        private void checkValidOwner() {
            Preconditions.checkNotNull(this.outerBuilder, (Object)"Partial MachineRenderState must have a valid owner to perform this action");
        }

        public PartialState<B> addModels(ConfiguredModel ... models) {
            this.checkValidOwner();
            this.outerBuilder.addModels(this, models);
            return this;
        }

        public MachineModelBuilder<B> setModels(ConfiguredModel ... models) {
            this.checkValidOwner();
            return this.outerBuilder.setModels(this, models);
        }

        public MachineModelBuilder<B> setModel(ModelFile model) {
            return this.setModels(ConfiguredModel.builder().modelFile(model).build());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartialState that = (PartialState)o;
            return this.owner.equals(that.owner) && this.setStates.equals(that.setStates);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.setStates);
        }

        @Override
        public boolean test(MachineRenderState state) {
            if (state.getDefinition() != this.getOwner()) {
                return false;
            }
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.setStates.entrySet()) {
                if (state.getValue(entry.getKey()) == entry.getValue()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.setStates.entrySet()) {
                if (!ret.isEmpty()) {
                    ret.append(',');
                }
                ret.append(entry.getKey().getName()).append('=').append(entry.getKey().getName(entry.getValue()));
            }
            return ret.toString();
        }

        public static Comparator<PartialState<?>> comparingByProperties() {
            return (s1, s2) -> {
                TreeSet propUniverse = new TreeSet(s1.getSetStates().comparator().reversed());
                propUniverse.addAll(s1.getSetStates().keySet());
                propUniverse.addAll(s2.getSetStates().keySet());
                int total = 0;
                for (Property property : propUniverse) {
                    Comparable val2;
                    Comparable val1 = (Comparable)s1.getSetStates().get(property);
                    if (val1 == (val2 = (Comparable)s2.getSetStates().get(property))) continue;
                    if (val1 == null) {
                        --total;
                        continue;
                    }
                    if (val2 == null) {
                        ++total;
                        continue;
                    }
                    total += val1.compareTo(val2);
                }
                return total;
            };
        }

        @Generated
        public MachineDefinition getOwner() {
            return this.owner;
        }

        @Generated
        public SortedMap<Property<?>, Comparable<?>> getSetStates() {
            return this.setStates;
        }
    }
}

