/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.pack;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class GTDynamicPackContents {
    private final Node root = new Node();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void addToData(ResourceLocation location, byte[] bytes) {
        this.addToData(location, (IoSupplier<InputStream>)((IoSupplier)() -> new ByteArrayInputStream(bytes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToData(ResourceLocation location, IoSupplier<InputStream> supplier) {
        String[] pathComponents = location.getPath().split("/");
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            Node node = this.root.getChildren().computeIfAbsent(location.getNamespace(), $ -> new Node());
            for (String component : pathComponents) {
                node = node.getChildren().computeIfAbsent(component, $ -> new Node());
            }
            node.contents = supplier;
        }
        finally {
            lock.unlock();
        }
    }

    public void clearData() {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.root.getChildren().clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSupplier<InputStream> getResource(ResourceLocation location) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            IoSupplier<InputStream> ioSupplier;
            IoSupplier<InputStream> pathComponents;
            Node node = this.root.getChild(location.getNamespace());
            for (String path : pathComponents = location.getPath().split("/")) {
                if (node == null) {
                    IoSupplier<InputStream> ioSupplier2 = null;
                    return ioSupplier2;
                }
                node = node.getChild(path);
            }
            if (node == null) {
                ioSupplier = null;
                return ioSupplier;
            }
            ioSupplier = node.createIoSupplier();
            return ioSupplier;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listResources(String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            Node base = this.root.getChild(namespace);
            if (base == null) {
                return;
            }
            base.collectResources(namespace, path.split("/"), 0, resourceOutput);
        }
        finally {
            lock.unlock();
        }
    }

    private static class Node {
        Object contents = new Object2ObjectOpenHashMap();

        private Node() {
        }

        void collectResources(String namespace, String[] pathComponents, int curIndex, PackResources.ResourceOutput output) {
            if (curIndex < pathComponents.length) {
                String component = pathComponents[curIndex];
                Node n = this.getChild(component);
                if (n != null) {
                    n.collectResources(namespace, pathComponents, curIndex + 1, output);
                }
            } else {
                this.outputResources(namespace, String.join((CharSequence)"/", pathComponents), output);
            }
        }

        private boolean isTerminalNode() {
            return this.contents instanceof IoSupplier;
        }

        private Map<String, Node> getChildren() {
            if (!(this.contents instanceof Map)) {
                throw new IllegalStateException("attempting to get children on a terminal node");
            }
            return (Map)this.contents;
        }

        void outputResources(String namespace, String path, PackResources.ResourceOutput output) {
            if (this.isTerminalNode()) {
                ResourceLocation location = new ResourceLocation(namespace, path);
                output.accept((Object)location, this.createIoSupplier());
            } else {
                for (Map.Entry<String, Node> entry : this.getChildren().entrySet()) {
                    entry.getValue().outputResources(namespace, path + "/" + entry.getKey(), output);
                }
            }
        }

        IoSupplier<InputStream> createIoSupplier() {
            if (!this.isTerminalNode()) {
                throw new IllegalStateException("Node has no data");
            }
            return (IoSupplier)this.contents;
        }

        @Nullable
        Node getChild(String name) {
            if (this.isTerminalNode()) {
                return null;
            }
            return this.getChildren().get(name);
        }
    }
}

