/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.ResearchRecipeBuilder;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.recipe.condition.AdjacentBlockCondition;
import com.gregtechceu.gtceu.common.recipe.condition.AdjacentFluidCondition;
import com.gregtechceu.gtceu.common.recipe.condition.BiomeCondition;
import com.gregtechceu.gtceu.common.recipe.condition.CleanroomCondition;
import com.gregtechceu.gtceu.common.recipe.condition.DaytimeCondition;
import com.gregtechceu.gtceu.common.recipe.condition.DimensionCondition;
import com.gregtechceu.gtceu.common.recipe.condition.EnvironmentalHazardCondition;
import com.gregtechceu.gtceu.common.recipe.condition.FTBQuestCondition;
import com.gregtechceu.gtceu.common.recipe.condition.GameStageCondition;
import com.gregtechceu.gtceu.common.recipe.condition.HeraclesQuestCondition;
import com.gregtechceu.gtceu.common.recipe.condition.PositionYCondition;
import com.gregtechceu.gtceu.common.recipe.condition.RainingCondition;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.common.recipe.condition.ThunderCondition;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GTRecipeBuilder {
    public final Map<RecipeCapability<?>, List<Content>> input = new IdentityHashMap();
    public final Map<RecipeCapability<?>, List<Content>> tickInput = new IdentityHashMap();
    public final Map<RecipeCapability<?>, List<Content>> output = new IdentityHashMap();
    public final Map<RecipeCapability<?>, List<Content>> tickOutput = new IdentityHashMap();
    public final Map<RecipeCapability<?>, ChanceLogic> inputChanceLogic = new IdentityHashMap();
    public final Map<RecipeCapability<?>, ChanceLogic> outputChanceLogic = new IdentityHashMap();
    public final Map<RecipeCapability<?>, ChanceLogic> tickInputChanceLogic = new IdentityHashMap();
    public final Map<RecipeCapability<?>, ChanceLogic> tickOutputChanceLogic = new IdentityHashMap();
    public final List<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
    @NotNull
    public CompoundTag data = new CompoundTag();
    public ResourceLocation id;
    public GTRecipeType recipeType;
    public int duration = 100;
    public boolean perTick;
    public int chance = ChanceLogic.getMaxChancedValue();
    public int maxChance = ChanceLogic.getMaxChancedValue();
    public int tierChanceBoost = 0;
    private boolean itemMaterialInfo = false;
    private boolean fluidMaterialInfo = false;
    private boolean removePreviousMatInfo = false;
    public GTRecipeCategory recipeCategory;
    @Nullable
    public BiConsumer<GTRecipeBuilder, Consumer<FinishedRecipe>> onSave;
    private final Collection<ResearchRecipeEntry> researchRecipeEntries = new ArrayList<ResearchRecipeEntry>();
    private boolean generatingRecipes = true;
    private List<ItemStack> tempItemStacks = new ArrayList<ItemStack>();
    private List<MaterialStack> tempItemMaterialStacks = new ArrayList<MaterialStack>();
    private List<MaterialStack> tempFluidStacks = new ArrayList<MaterialStack>();

    public GTRecipeBuilder(ResourceLocation id, GTRecipeType recipeType) {
        this.id = id;
        this.recipeType = recipeType;
        this.recipeCategory = recipeType.getCategory();
    }

    public GTRecipeBuilder(GTRecipe toCopy, GTRecipeType recipeType) {
        this.id = toCopy.id;
        this.recipeType = recipeType;
        toCopy.inputs.forEach((k, v) -> this.input.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.outputs.forEach((k, v) -> this.output.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.tickInputs.forEach((k, v) -> this.tickInput.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.tickOutputs.forEach((k, v) -> this.tickOutput.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.inputChanceLogic.putAll(toCopy.inputChanceLogics);
        this.outputChanceLogic.putAll(toCopy.outputChanceLogics);
        this.tickInputChanceLogic.putAll(toCopy.tickInputChanceLogics);
        this.tickOutputChanceLogic.putAll(toCopy.tickOutputChanceLogics);
        this.conditions.addAll(toCopy.conditions);
        this.data = toCopy.data.copy();
        this.duration = toCopy.duration;
        this.recipeCategory = toCopy.recipeCategory;
    }

    public static GTRecipeBuilder of(ResourceLocation id, GTRecipeType recipeType) {
        return new GTRecipeBuilder(id, recipeType);
    }

    public static GTRecipeBuilder ofRaw() {
        return new GTRecipeBuilder(GTCEu.id("raw"), GTRecipeTypes.DUMMY_RECIPES);
    }

    public GTRecipeBuilder copy(String id) {
        return this.copy(GTCEu.id(id));
    }

    public GTRecipeBuilder copy(ResourceLocation id) {
        GTRecipeBuilder copy = new GTRecipeBuilder(id, this.recipeType);
        this.input.forEach((k, v) -> copy.input.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.output.forEach((k, v) -> copy.output.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.tickInput.forEach((k, v) -> copy.tickInput.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.tickOutput.forEach((k, v) -> copy.tickOutput.put((RecipeCapability<?>)k, new ArrayList(v)));
        copy.inputChanceLogic.putAll(this.inputChanceLogic);
        copy.outputChanceLogic.putAll(this.outputChanceLogic);
        copy.tickInputChanceLogic.putAll(this.tickInputChanceLogic);
        copy.tickOutputChanceLogic.putAll(this.tickOutputChanceLogic);
        copy.conditions.addAll(this.conditions);
        copy.data = this.data.copy();
        copy.duration = this.duration;
        copy.chance = this.chance;
        copy.perTick = this.perTick;
        copy.recipeCategory = this.recipeCategory;
        copy.onSave = this.onSave;
        return copy;
    }

    public GTRecipeBuilder copyFrom(GTRecipeBuilder builder) {
        this.recipeType.setMinRecipeConditions(builder.conditions.size());
        return builder.copy(builder.id).onSave(null).recipeType(this.recipeType).category(this.recipeCategory);
    }

    protected Content makeContent(Object o) {
        return new Content(o, this.chance, this.maxChance, this.tierChanceBoost);
    }

    public <T> GTRecipeBuilder input(RecipeCapability<T> capability, T obj) {
        Map<RecipeCapability<?>, List<Content>> t = this.perTick ? this.tickInput : this.input;
        this.warnTooManyIngredients(capability, true, t, 1);
        t.computeIfAbsent(capability, c -> new ArrayList()).add(this.makeContent(capability.of(obj)));
        return this;
    }

    public <T> GTRecipeBuilder input(RecipeCapability<T> capability, T ... obj) {
        Map<RecipeCapability<?>, List<Content>> t = this.perTick ? this.tickInput : this.input;
        this.warnTooManyIngredients(capability, true, t, obj.length);
        t.computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(this::makeContent).toList());
        return this;
    }

    public <T> GTRecipeBuilder output(RecipeCapability<T> capability, T obj) {
        Map<RecipeCapability<?>, List<Content>> t = this.perTick ? this.tickOutput : this.output;
        this.warnTooManyIngredients(capability, false, t, 1);
        t.computeIfAbsent(capability, c -> new ArrayList()).add(this.makeContent(capability.of(obj)));
        return this;
    }

    public <T> GTRecipeBuilder output(RecipeCapability<T> capability, T ... obj) {
        Map<RecipeCapability<?>, List<Content>> t = this.perTick ? this.tickOutput : this.output;
        this.warnTooManyIngredients(capability, false, t, obj.length);
        t.computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(this::makeContent).toList());
        return this;
    }

    public GTRecipeBuilder addCondition(RecipeCondition condition) {
        this.conditions.add(condition);
        this.recipeType.setMinRecipeConditions(this.conditions.size());
        return this;
    }

    public GTRecipeBuilder duration(int duration) {
        if (duration < 0) {
            GTCEu.LOGGER.error("Recipe duration must be non negative, id: {}", (Object)this.id);
        }
        this.duration = Math.max(duration, 0);
        return this;
    }

    public GTRecipeBuilder inputEU(long eu) {
        return this.inputEU(eu, 1L);
    }

    public GTRecipeBuilder inputEU(long voltage, long amperage) {
        return this.input((RecipeCapability<T>)EURecipeCapability.CAP, (T)new EnergyStack(voltage, amperage));
    }

    public GTRecipeBuilder EUt(long eu) {
        return this.EUt(eu, 1L);
    }

    public GTRecipeBuilder EUt(long voltage, long amperage) {
        if (voltage == 0L) {
            GTCEu.LOGGER.error("EUt can't be explicitly set to 0, id: {}", (Object)this.id);
        }
        if (amperage < 1L) {
            GTCEu.LOGGER.error("Amperage must be a positive integer, id: {}", (Object)this.id);
        }
        boolean lastPerTick = this.perTick;
        this.perTick = true;
        if (voltage > 0L) {
            this.tickInput.remove(EURecipeCapability.CAP);
            this.inputEU(voltage, amperage);
        } else if (voltage < 0L) {
            this.tickOutput.remove(EURecipeCapability.CAP);
            this.outputEU(-voltage, amperage);
        }
        this.perTick = lastPerTick;
        return this;
    }

    public GTRecipeBuilder outputEU(long eu) {
        return this.outputEU(eu, 1L);
    }

    public GTRecipeBuilder outputEU(long voltage, long amperage) {
        return this.output((RecipeCapability<T>)EURecipeCapability.CAP, (T)new EnergyStack(voltage, amperage));
    }

    public GTRecipeBuilder inputCWU(int cwu) {
        return this.input((RecipeCapability<T>)CWURecipeCapability.CAP, (T)cwu);
    }

    public GTRecipeBuilder CWUt(int cwu) {
        if (cwu == 0) {
            GTCEu.LOGGER.error("CWUt can't be explicitly set to 0, id: {}", (Object)this.id);
        }
        boolean lastPerTick = this.perTick;
        this.perTick = true;
        if (cwu > 0) {
            this.tickInput.remove(CWURecipeCapability.CAP);
            this.inputCWU(cwu);
        } else if (cwu < 0) {
            this.tickOutput.remove(CWURecipeCapability.CAP);
            this.outputCWU(-cwu);
        }
        this.perTick = lastPerTick;
        return this;
    }

    public GTRecipeBuilder totalCWU(int cwu) {
        this.durationIsTotalCWU(true);
        this.hideDuration(true);
        this.duration(cwu);
        return this;
    }

    public GTRecipeBuilder outputCWU(int cwu) {
        return this.output((RecipeCapability<T>)CWURecipeCapability.CAP, (T)cwu);
    }

    public GTRecipeBuilder inputItems(Object input) {
        Supplier supplier;
        Object t;
        if (input instanceof Item) {
            Item item = (Item)input;
            return this.inputItems(item);
        }
        if (input instanceof Supplier && (t = (supplier = (Supplier)input).get()) instanceof ItemLike) {
            ItemLike item = (ItemLike)t;
            return this.inputItems(item.asItem());
        }
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            return this.inputItems(stack);
        }
        if (input instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)input;
            return this.inputItems(ingredient);
        }
        if (input instanceof MaterialEntry) {
            MaterialEntry entry = (MaterialEntry)input;
            return this.inputItems(entry);
        }
        if (input instanceof TagKey) {
            TagKey tag = (TagKey)input;
            return this.inputItems((TagKey<Item>)tag);
        }
        if (input instanceof MachineDefinition) {
            MachineDefinition machine = (MachineDefinition)input;
            return this.inputItems(machine);
        }
        GTCEu.LOGGER.error("Input item is not one of:\nItem, Supplier<Item>, ItemStack, Ingredient, MaterialEntry, TagKey<Item>, MachineDefinition\nid: {}", (Object)this.id);
        return this;
    }

    public GTRecipeBuilder inputItems(Object input, int count) {
        Supplier supplier;
        Object t;
        if (input instanceof Item) {
            Item item = (Item)input;
            return this.inputItems(item, count);
        }
        if (input instanceof Supplier && (t = (supplier = (Supplier)input).get()) instanceof ItemLike) {
            ItemLike item = (ItemLike)t;
            return this.inputItems(item.asItem(), count);
        }
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            return this.inputItems(stack.copyWithCount(count));
        }
        if (input instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)input;
            return this.inputItems(ingredient, count);
        }
        if (input instanceof MaterialEntry) {
            MaterialEntry entry = (MaterialEntry)input;
            return this.inputItems(entry, count);
        }
        if (input instanceof TagKey) {
            TagKey tag = (TagKey)input;
            return this.inputItems((TagKey<Item>)tag, count);
        }
        if (input instanceof MachineDefinition) {
            MachineDefinition machine = (MachineDefinition)input;
            return this.inputItems(machine, count);
        }
        GTCEu.LOGGER.error("Input item is not one of:\nItem, Supplier<Item>, ItemStack, Ingredient, MaterialEntry, TagKey<Item>, MachineDefinition\nid: {}", (Object)this.id);
        return this;
    }

    public GTRecipeBuilder inputItems(Ingredient inputs) {
        if (this.missingIngredientError(0, true, ItemRecipeCapability.CAP, () -> ((Ingredient)inputs).isEmpty())) {
            return this;
        }
        return this.input((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)inputs);
    }

    public GTRecipeBuilder inputItems(Ingredient ... inputs) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (int i = 0; i < inputs.length; ++i) {
            Ingredient ingredient = inputs[i];
            if (this.missingIngredientError(i, true, ItemRecipeCapability.CAP, () -> ((Ingredient)ingredient).isEmpty())) {
                return this;
            }
            ingredients.add(ingredient);
        }
        return this.input((RecipeCapability)ItemRecipeCapability.CAP, (T[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
    }

    public GTRecipeBuilder inputItems(Ingredient inputs, int count) {
        if (this.missingIngredientError(0, true, ItemRecipeCapability.CAP, () -> ((Ingredient)inputs).isEmpty())) {
            return this;
        }
        return this.input((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)((Object)SizedIngredient.create(inputs, count)));
    }

    public GTRecipeBuilder inputItems(ItemStack input) {
        if (this.missingIngredientError(0, true, ItemRecipeCapability.CAP, () -> ((ItemStack)input).isEmpty())) {
            return this;
        }
        ItemMaterialInfo matInfo = ItemMaterialData.getMaterialInfo((ItemLike)input.getItem());
        List<ItemStack> unresolvedMatInfo = ItemMaterialData.UNRESOLVED_ITEM_MATERIAL_INFO.get(input);
        if (this.chance == this.maxChance && this.chance != 0) {
            if (unresolvedMatInfo != null) {
                this.tempItemStacks.add(input);
            }
            if (matInfo != null) {
                for (MaterialStack matStack : matInfo.getMaterials()) {
                    this.tempItemMaterialStacks.add(matStack.multiply(input.getCount()));
                }
            } else if (unresolvedMatInfo == null) {
                this.tempItemStacks.add(input);
            }
        }
        return this.input((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)((Object)SizedIngredient.create(input)));
    }

    public GTRecipeBuilder inputItems(ItemStack ... inputs) {
        ArrayList<SizedIngredient> ingredients = new ArrayList<SizedIngredient>();
        for (int i = 0; i < inputs.length; ++i) {
            ItemStack itemStack = inputs[i];
            if (this.missingIngredientError(i, true, ItemRecipeCapability.CAP, () -> ((ItemStack)itemStack).isEmpty())) {
                return this;
            }
            ItemMaterialInfo matInfo = ItemMaterialData.getMaterialInfo((ItemLike)itemStack.getItem());
            if (this.chance == this.maxChance && this.chance != 0) {
                if (matInfo != null) {
                    for (MaterialStack matStack : matInfo.getMaterials()) {
                        this.tempItemMaterialStacks.add(matStack.multiply(itemStack.getCount()));
                    }
                } else {
                    this.tempItemStacks.add(itemStack);
                }
            }
            ingredients.add(SizedIngredient.create(itemStack));
        }
        return this.input((RecipeCapability)ItemRecipeCapability.CAP, (T[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
    }

    public GTRecipeBuilder inputItems(TagKey<Item> tag, int amount) {
        return this.inputItems((Ingredient)SizedIngredient.create(tag, amount));
    }

    public GTRecipeBuilder inputItems(TagKey<Item> tag) {
        return this.inputItems(tag, 1);
    }

    public GTRecipeBuilder inputItems(Item input, int amount) {
        return this.inputItems(new ItemStack((ItemLike)input, amount));
    }

    public GTRecipeBuilder inputItems(Item input) {
        return this.inputItems(input, 1);
    }

    public GTRecipeBuilder inputItems(Supplier<? extends Item> input) {
        return this.inputItems(input.get());
    }

    public GTRecipeBuilder inputItems(Supplier<? extends Item> input, int amount) {
        return this.inputItems(input.get(), amount);
    }

    public GTRecipeBuilder inputItems(TagPrefix orePrefix, Material material) {
        return this.inputItems(orePrefix, material, 1);
    }

    public GTRecipeBuilder inputItems(MaterialEntry input) {
        return this.inputItems(input, 1);
    }

    public GTRecipeBuilder inputItems(MaterialEntry input, int count) {
        return this.inputItems(input.tagPrefix(), input.material(), count);
    }

    public GTRecipeBuilder inputItems(TagPrefix tagPrefix, @NotNull Material material, int count) {
        if (tagPrefix.isEmpty() || material.isNull()) {
            GTCEu.LOGGER.error("Tried to set input item stack that doesn't exist, id: {}, TagPrefix: {}, Material: {}, Count: {}", (Object)this.id, (Object)tagPrefix, (Object)material, (Object)count);
            return this;
        }
        this.tempItemMaterialStacks.add(new MaterialStack(material, tagPrefix.getMaterialAmount(material) * (long)count));
        tagPrefix.secondaryMaterials().forEach(mat -> this.tempItemMaterialStacks.add(mat.multiply(count)));
        TagKey<Item> tag = ChemicalHelper.getTag(tagPrefix, material);
        if (tag != null) {
            return this.inputItems(tag, count);
        }
        ItemStack item = ChemicalHelper.get(tagPrefix, material, count);
        if (item.isEmpty()) {
            GTCEu.LOGGER.error("Tried to set input item stack that doesn't exist, id: {}, TagPrefix: {}, Material: {}, Count: {}", (Object)this.id, (Object)tagPrefix, (Object)material, (Object)count);
        }
        return this.input((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)((Object)SizedIngredient.create(item)));
    }

    public GTRecipeBuilder inputItems(MachineDefinition machine) {
        return this.inputItems(machine, 1);
    }

    public GTRecipeBuilder inputItems(MachineDefinition machine, int count) {
        return this.inputItems(machine.asStack(count));
    }

    public GTRecipeBuilder inputItemsRanged(ItemStack input, IntProvider intProvider) {
        return this.inputItems((Ingredient)IntProviderIngredient.of(input, intProvider));
    }

    public GTRecipeBuilder inputItemsRanged(Item input, IntProvider intProvider) {
        return this.inputItemsRanged(new ItemStack((ItemLike)input), intProvider);
    }

    public GTRecipeBuilder inputItemsRanged(Supplier<? extends ItemLike> input, IntProvider intProvider) {
        return this.inputItemsRanged(new ItemStack((ItemLike)input.get().asItem()), intProvider);
    }

    public GTRecipeBuilder inputItemsRanged(TagPrefix orePrefix, Material material, IntProvider intProvider) {
        ItemStack item = ChemicalHelper.get(orePrefix, material, 1);
        if (item.isEmpty()) {
            GTCEu.LOGGER.error("Tried to set input ranged item stack that doesn't exist, TagPrefix: {}, Material: {}", (Object)orePrefix, (Object)material);
        }
        return this.inputItemsRanged(item, intProvider);
    }

    public GTRecipeBuilder inputItemsRanged(MachineDefinition machine, IntProvider intProvider) {
        return this.inputItemsRanged(machine.asStack(), intProvider);
    }

    public GTRecipeBuilder outputItems(Object output) {
        Supplier supplier;
        Object t;
        if (output instanceof Item) {
            Item item = (Item)output;
            return this.outputItems(item);
        }
        if (output instanceof Supplier && (t = (supplier = (Supplier)output).get()) instanceof ItemLike) {
            ItemLike item = (ItemLike)t;
            return this.outputItems(item.asItem());
        }
        if (output instanceof ItemStack) {
            ItemStack stack = (ItemStack)output;
            return this.outputItems(stack);
        }
        if (output instanceof MaterialEntry) {
            MaterialEntry entry = (MaterialEntry)output;
            return this.outputItems(entry);
        }
        if (output instanceof MachineDefinition) {
            MachineDefinition machine = (MachineDefinition)output;
            return this.outputItems(machine);
        }
        GTCEu.LOGGER.error("Output item is not one of:\nItem, Supplier<Item>, ItemStack, MaterialEntry, MachineDefinition\nid: {}", (Object)this.id);
        return this;
    }

    public GTRecipeBuilder outputItems(Object output, int count) {
        Supplier supplier;
        Object t;
        if (output instanceof Item) {
            Item item = (Item)output;
            return this.outputItems(item, count);
        }
        if (output instanceof Supplier && (t = (supplier = (Supplier)output).get()) instanceof ItemLike) {
            ItemLike item = (ItemLike)t;
            return this.outputItems(item.asItem(), count);
        }
        if (output instanceof ItemStack) {
            ItemStack stack = (ItemStack)output;
            return this.outputItems(stack.copyWithCount(count));
        }
        if (output instanceof MaterialEntry) {
            MaterialEntry entry = (MaterialEntry)output;
            return this.outputItems(entry, count);
        }
        if (output instanceof MachineDefinition) {
            MachineDefinition machine = (MachineDefinition)output;
            return this.outputItems(machine, count);
        }
        GTCEu.LOGGER.error("Output item is not one of:\nItem, Supplier<Item>, ItemStack, MaterialEntry, MachineDefinition\nid: {}", (Object)this.id);
        return this;
    }

    public GTRecipeBuilder outputItems(ItemStack output) {
        if (this.missingIngredientError(0, false, ItemRecipeCapability.CAP, () -> ((ItemStack)output).isEmpty())) {
            return this;
        }
        return this.output((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)((Object)SizedIngredient.create(output)));
    }

    public GTRecipeBuilder outputItems(ItemStack ... outputs) {
        ArrayList<SizedIngredient> ingredients = new ArrayList<SizedIngredient>();
        for (int i = 0; i < outputs.length; ++i) {
            ItemStack itemStack = outputs[i];
            if (this.missingIngredientError(i, false, ItemRecipeCapability.CAP, () -> ((ItemStack)itemStack).isEmpty())) {
                return this;
            }
            ingredients.add(SizedIngredient.create(itemStack));
        }
        return this.output((RecipeCapability)ItemRecipeCapability.CAP, (T[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
    }

    public GTRecipeBuilder outputItems(Item output, int amount) {
        return this.outputItems(new ItemStack((ItemLike)output, amount));
    }

    public GTRecipeBuilder outputItems(Item output) {
        return this.outputItems(new ItemStack((ItemLike)output));
    }

    public GTRecipeBuilder outputItems(Supplier<? extends ItemLike> input) {
        return this.outputItems(new ItemStack((ItemLike)input.get().asItem()));
    }

    public GTRecipeBuilder outputItems(Supplier<? extends ItemLike> input, int amount) {
        return this.outputItems(new ItemStack((ItemLike)input.get().asItem(), amount));
    }

    public GTRecipeBuilder outputItems(TagPrefix orePrefix, Material material) {
        return this.outputItems(orePrefix, material, 1);
    }

    public GTRecipeBuilder outputItems(TagPrefix orePrefix, @NotNull Material material, int count) {
        if (orePrefix.isEmpty() || material.isNull()) {
            GTCEu.LOGGER.error("Tried to set output item stack that doesn't exist, id: {}, TagPrefix: {}, Material: {}, Count: {}", (Object)this.id, (Object)orePrefix, (Object)material, (Object)count);
            return this;
        }
        ItemStack item = ChemicalHelper.get(orePrefix, material, count);
        if (item.isEmpty()) {
            GTCEu.LOGGER.error("Tried to set output item stack that doesn't exist, id: {}, TagPrefix: {}, Material: {}, Count: {}", (Object)this.id, (Object)orePrefix, (Object)material, (Object)count);
            return this;
        }
        return this.outputItems(item);
    }

    public GTRecipeBuilder outputItems(MaterialEntry entry) {
        return this.outputItems(entry.tagPrefix(), entry.material());
    }

    public GTRecipeBuilder outputItems(MaterialEntry entry, int count) {
        return this.outputItems(entry.tagPrefix(), entry.material(), count);
    }

    public GTRecipeBuilder outputItems(MachineDefinition machine) {
        return this.outputItems(machine, 1);
    }

    public GTRecipeBuilder outputItems(MachineDefinition machine, int count) {
        return this.outputItems(machine.asStack(count));
    }

    protected GTRecipeBuilder outputItems(Ingredient ingredient) {
        return this.output((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)ingredient);
    }

    public GTRecipeBuilder outputItemsRanged(ItemStack output, IntProvider intProvider) {
        return this.outputItems(IntProviderIngredient.of(output, intProvider));
    }

    public GTRecipeBuilder outputItemsRanged(Item input, IntProvider intProvider) {
        return this.outputItemsRanged(new ItemStack((ItemLike)input), intProvider);
    }

    public GTRecipeBuilder outputItemsRanged(Supplier<? extends ItemLike> output, IntProvider intProvider) {
        return this.outputItemsRanged(new ItemStack((ItemLike)output.get().asItem()), intProvider);
    }

    public GTRecipeBuilder outputItemsRanged(TagPrefix orePrefix, Material material, IntProvider intProvider) {
        ItemStack item = ChemicalHelper.get(orePrefix, material, 1);
        if (item.isEmpty()) {
            GTCEu.LOGGER.error("Tried to set output ranged item stack that doesn't exist, TagPrefix: {}, Material: {}", (Object)orePrefix, (Object)material);
        }
        return this.outputItemsRanged(item, intProvider);
    }

    public GTRecipeBuilder outputItemsRanged(MachineDefinition machine, IntProvider intProvider) {
        return this.outputItemsRanged(machine.asStack(), intProvider);
    }

    public GTRecipeBuilder notConsumable(ItemStack itemStack) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(itemStack);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(Ingredient ingredient) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(ingredient);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(Item item) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(item);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(Supplier<? extends Item> item) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(item);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(TagPrefix orePrefix, Material material) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(orePrefix, material);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(TagPrefix orePrefix, Material material, int count) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(orePrefix, material, count);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumableFluid(FluidStack fluid) {
        return this.notConsumableFluid(FluidIngredient.of(TagUtil.createFluidTag(BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid()).getPath()), fluid.getAmount()));
    }

    public GTRecipeBuilder notConsumableFluid(FluidIngredient ingredient) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputFluids(ingredient);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder circuitMeta(int configuration) {
        if (configuration < 0 || configuration > 32) {
            GTCEu.LOGGER.error("Circuit configuration must be in the bounds 0 - 32");
        }
        return this.notConsumable((Ingredient)IntCircuitIngredient.of(configuration));
    }

    public GTRecipeBuilder chancedInput(ItemStack stack, int chance, int tierChanceBoost) {
        if (this.checkChanceAndPrintError(chance)) {
            return this;
        }
        int lastChance = this.chance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.inputItems(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedInput(FluidStack stack, int chance, int tierChanceBoost) {
        if (this.checkChanceAndPrintError(chance)) {
            return this;
        }
        int lastChance = this.chance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.inputFluids(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(ItemStack stack, int chance, int tierChanceBoost) {
        if (this.checkChanceAndPrintError(chance)) {
            return this;
        }
        int lastChance = this.chance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.outputItems(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(FluidStack stack, int chance, int tierChanceBoost) {
        if (this.checkChanceAndPrintError(chance)) {
            return this;
        }
        int lastChance = this.chance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.outputFluids(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(TagPrefix tag, Material mat, int chance, int tierChanceBoost) {
        return this.chancedOutput(ChemicalHelper.get(tag, mat), chance, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(TagPrefix tag, Material mat, int count, int chance, int tierChanceBoost) {
        return this.chancedOutput(ChemicalHelper.get(tag, mat, count), chance, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(ItemStack stack, String fraction, int tierChanceBoost) {
        int maxChance;
        int chance;
        if (stack.isEmpty()) {
            return this;
        }
        String[] split = fraction.split("/");
        if (split.length != 2) {
            GTCEu.LOGGER.error("Fraction was not parsed correctly! Expected format is \"1/3\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
            return this;
        }
        try {
            chance = Integer.parseInt(split[0]);
            maxChance = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            GTCEu.LOGGER.error("Fraction was not parsed correctly! Expected format is \"1/3\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
            return this;
        }
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", (Object)ChanceLogic.getMaxChancedValue(), (Object)chance, (Object)new Throwable());
            return this;
        }
        if (chance >= maxChance || maxChance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Max Chance cannot be less or equal to Chance or more than {}. Actual: {}.", (Object)ChanceLogic.getMaxChancedValue(), (Object)maxChance, (Object)new Throwable());
            return this;
        }
        int scalar = Math.floorDiv(ChanceLogic.getMaxChancedValue(), maxChance);
        int lastChance = this.chance;
        int lastMaxChance = this.maxChance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance *= scalar;
        this.maxChance = maxChance *= scalar;
        this.tierChanceBoost = tierChanceBoost;
        this.outputItems(stack);
        this.chance = lastChance;
        this.maxChance = lastMaxChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(TagPrefix prefix, Material material, int count, String fraction, int tierChanceBoost) {
        return this.chancedOutput(ChemicalHelper.get(prefix, material, count), fraction, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(TagPrefix prefix, Material material, String fraction, int tierChanceBoost) {
        return this.chancedOutput(prefix, material, 1, fraction, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(Item item, int count, String fraction, int tierChanceBoost) {
        return this.chancedOutput(new ItemStack((ItemLike)item, count), fraction, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(Item item, String fraction, int tierChanceBoost) {
        return this.chancedOutput(item, 1, fraction, tierChanceBoost);
    }

    public GTRecipeBuilder chancedFluidOutput(FluidStack stack, String fraction, int tierChanceBoost) {
        int maxChance;
        int chance;
        if (stack.isEmpty()) {
            return this;
        }
        String[] split = fraction.split("/");
        if (split.length != 2) {
            GTCEu.LOGGER.error("Fraction was not parsed correctly! Expected format is \"1/3\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
            return this;
        }
        try {
            chance = Integer.parseInt(split[0]);
            maxChance = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            GTCEu.LOGGER.error("Fraction was not parsed correctly! Expected format is \"1/3\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
            return this;
        }
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", (Object)ChanceLogic.getMaxChancedValue(), (Object)chance, (Object)new Throwable());
            return this;
        }
        if (chance >= maxChance || maxChance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Max Chance cannot be less or equal to Chance or more than {}. Actual: {}.", (Object)ChanceLogic.getMaxChancedValue(), (Object)maxChance, (Object)new Throwable());
            return this;
        }
        int scalar = Math.floorDiv(ChanceLogic.getMaxChancedValue(), maxChance);
        int lastChance = this.chance;
        int lastMaxChance = this.maxChance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance *= scalar;
        this.maxChance = maxChance *= scalar;
        this.tierChanceBoost = tierChanceBoost;
        this.outputFluids(stack);
        this.chance = lastChance;
        this.maxChance = lastMaxChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
        this.outputChanceLogic.put(cap, logic);
        return this;
    }

    public GTRecipeBuilder chancedItemOutputLogic(ChanceLogic logic) {
        return this.chancedOutputLogic(ItemRecipeCapability.CAP, logic);
    }

    public GTRecipeBuilder chancedFluidOutputLogic(ChanceLogic logic) {
        return this.chancedOutputLogic(FluidRecipeCapability.CAP, logic);
    }

    public GTRecipeBuilder chancedInputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
        this.inputChanceLogic.put(cap, logic);
        return this;
    }

    public GTRecipeBuilder chancedItemInputLogic(ChanceLogic logic) {
        return this.chancedInputLogic(ItemRecipeCapability.CAP, logic);
    }

    public GTRecipeBuilder chancedFluidInputLogic(ChanceLogic logic) {
        return this.chancedInputLogic(FluidRecipeCapability.CAP, logic);
    }

    public GTRecipeBuilder chancedTickOutputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
        this.tickOutputChanceLogic.put(cap, logic);
        return this;
    }

    public GTRecipeBuilder chancedTickInputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
        this.tickInputChanceLogic.put(cap, logic);
        return this;
    }

    public GTRecipeBuilder inputFluids(@NotNull Material material, int amount) {
        return this.inputFluids(material.getFluid(amount));
    }

    public GTRecipeBuilder inputFluids(FluidStack input) {
        if (this.missingIngredientError(0, true, FluidRecipeCapability.CAP, () -> ((FluidStack)input).isEmpty())) {
            return this;
        }
        Material matStack = ChemicalHelper.getMaterial(input.getFluid());
        if (!matStack.isNull() && this.chance != 0 && this.chance == this.maxChance) {
            this.tempFluidStacks.add(new MaterialStack(matStack, (long)input.getAmount() * 3628800L / 144L));
        }
        return this.input((RecipeCapability<T>)FluidRecipeCapability.CAP, (T)FluidIngredient.of(TagUtil.createFluidTag(BuiltInRegistries.FLUID.getKey((Object)input.getFluid()).getPath()), input.getAmount(), input.getTag()));
    }

    public GTRecipeBuilder inputFluids(FluidStack ... inputs) {
        ArrayList<FluidIngredient> ingredients = new ArrayList<FluidIngredient>();
        for (int i = 0; i < inputs.length; ++i) {
            FluidStack fluid = inputs[i];
            if (this.missingIngredientError(i, true, FluidRecipeCapability.CAP, () -> ((FluidStack)fluid).isEmpty())) {
                return this;
            }
            Material matStack = ChemicalHelper.getMaterial(fluid.getFluid());
            if (!matStack.isNull() && this.chance == this.maxChance && this.chance != 0) {
                this.tempFluidStacks.add(new MaterialStack(matStack, (long)fluid.getAmount() * 3628800L / 144L));
            }
            TagKey<Fluid> tag = TagUtil.createFluidTag(BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid()).getPath());
            ingredients.add(FluidIngredient.of(tag, fluid.getAmount(), fluid.getTag()));
        }
        return this.input((RecipeCapability)FluidRecipeCapability.CAP, (T[])((FluidIngredient[])ingredients.toArray(FluidIngredient[]::new)));
    }

    public GTRecipeBuilder inputFluidsRanged(FluidStack input, IntProvider intProvider) {
        return this.inputFluidsRanged(FluidIngredient.of(input), intProvider);
    }

    protected GTRecipeBuilder inputFluidsRanged(FluidIngredient input, IntProvider intProvider) {
        return this.inputFluids(IntProviderFluidIngredient.of(input, intProvider));
    }

    public GTRecipeBuilder inputFluids(FluidIngredient ... inputs) {
        return this.input((RecipeCapability)FluidRecipeCapability.CAP, (T[])inputs);
    }

    public GTRecipeBuilder outputFluids(FluidStack output) {
        return this.output((RecipeCapability<T>)FluidRecipeCapability.CAP, (T)FluidIngredient.of(output));
    }

    public GTRecipeBuilder outputFluids(FluidStack ... outputs) {
        return this.output((RecipeCapability)FluidRecipeCapability.CAP, (T[])((FluidIngredient[])Arrays.stream(outputs).map(FluidIngredient::of).toArray(FluidIngredient[]::new)));
    }

    public GTRecipeBuilder outputFluids(FluidIngredient ... outputs) {
        return this.output((RecipeCapability)FluidRecipeCapability.CAP, (T[])outputs);
    }

    public GTRecipeBuilder outputFluidsRanged(FluidStack output, IntProvider intProvider) {
        return this.outputFluidsRanged(FluidIngredient.of(output), intProvider);
    }

    protected GTRecipeBuilder outputFluidsRanged(FluidIngredient output, IntProvider intProvider) {
        return this.outputFluids(IntProviderFluidIngredient.of(output, intProvider));
    }

    public GTRecipeBuilder addData(String key, Tag data) {
        this.data.put(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, int data) {
        this.data.putInt(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, long data) {
        this.data.putLong(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, String data) {
        this.data.putString(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, float data) {
        this.data.putFloat(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, boolean data) {
        this.data.putBoolean(key, data);
        return this;
    }

    public GTRecipeBuilder blastFurnaceTemp(int blastTemp) {
        return this.addData("ebf_temp", blastTemp);
    }

    public GTRecipeBuilder explosivesAmount(int explosivesAmount) {
        return this.inputItems(new ItemStack((ItemLike)Blocks.TNT, explosivesAmount));
    }

    public GTRecipeBuilder explosivesType(ItemStack explosivesType) {
        return this.inputItems(explosivesType);
    }

    public GTRecipeBuilder solderMultiplier(int multiplier) {
        return this.addData("solder_multiplier", multiplier);
    }

    public GTRecipeBuilder disableDistilleryRecipes(boolean flag) {
        return this.addData("disable_distillery", flag);
    }

    public GTRecipeBuilder fusionStartEU(long eu) {
        return this.addData("eu_to_start", eu);
    }

    public GTRecipeBuilder researchScan(boolean isScan) {
        return this.addData("scan_for_research", isScan);
    }

    public GTRecipeBuilder durationIsTotalCWU(boolean durationIsTotalCWU) {
        return this.addData("duration_is_total_cwu", durationIsTotalCWU);
    }

    public GTRecipeBuilder hideDuration(boolean hideDuration) {
        return this.addData("hide_duration", hideDuration);
    }

    public GTRecipeBuilder cleanroom(CleanroomType cleanroomType) {
        return this.addCondition(new CleanroomCondition(cleanroomType));
    }

    public GTRecipeBuilder dimension(ResourceLocation dimension, boolean reverse) {
        return this.addCondition(new DimensionCondition(dimension).setReverse(reverse));
    }

    public GTRecipeBuilder dimension(ResourceLocation dimension) {
        return this.dimension(dimension, false);
    }

    public GTRecipeBuilder biome(ResourceLocation biome, boolean reverse) {
        return this.biome((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome), reverse);
    }

    public GTRecipeBuilder biome(ResourceLocation biome) {
        return this.biome(biome, false);
    }

    public GTRecipeBuilder biome(ResourceKey<Biome> biome, boolean reverse) {
        return this.addCondition(new BiomeCondition(biome).setReverse(reverse));
    }

    public GTRecipeBuilder biome(ResourceKey<Biome> biome) {
        return this.biome(biome, false);
    }

    public GTRecipeBuilder rain(float level, boolean reverse) {
        return this.addCondition(new RainingCondition(level).setReverse(reverse));
    }

    public GTRecipeBuilder rain(float level) {
        return this.rain(level, false);
    }

    public GTRecipeBuilder thunder(float level, boolean reverse) {
        return this.addCondition(new ThunderCondition(level).setReverse(reverse));
    }

    public GTRecipeBuilder thunder(float level) {
        return this.thunder(level, false);
    }

    public GTRecipeBuilder posY(int min, int max, boolean reverse) {
        return this.addCondition(new PositionYCondition(min, max).setReverse(reverse));
    }

    public GTRecipeBuilder posY(int min, int max) {
        return this.posY(min, max, false);
    }

    public GTRecipeBuilder environmentalHazard(MedicalCondition condition, boolean reverse) {
        return this.addCondition(new EnvironmentalHazardCondition(condition).setReverse(reverse));
    }

    public GTRecipeBuilder environmentalHazard(MedicalCondition condition) {
        return this.environmentalHazard(condition, false);
    }

    public final GTRecipeBuilder adjacentFluids(Fluid ... fluids) {
        return this.adjacentFluids(false, fluids);
    }

    public final GTRecipeBuilder adjacentFluids(boolean isReverse, Fluid ... fluids) {
        if (fluids.length > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many fluids, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(AdjacentFluidCondition.fromFluids(fluids).setReverse(isReverse));
    }

    public final GTRecipeBuilder adjacentFluid(Fluid ... fluids) {
        return this.adjacentFluid(false, fluids);
    }

    public final GTRecipeBuilder adjacentFluid(boolean isReverse, Fluid ... fluids) {
        if (fluids.length > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many fluids, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(AdjacentFluidCondition.fromFluids(fluids).setReverse(isReverse));
    }

    @SafeVarargs
    public final GTRecipeBuilder adjacentFluidTag(TagKey<Fluid> ... tags) {
        return this.adjacentFluidTag(false, tags);
    }

    @SafeVarargs
    public final GTRecipeBuilder adjacentFluidTag(boolean isReverse, TagKey<Fluid> ... tags) {
        if (tags.length > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many fluids, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(AdjacentFluidCondition.fromTags(tags).setReverse(isReverse));
    }

    @SafeVarargs
    public final GTRecipeBuilder adjacentFluid(TagKey<Fluid> ... tags) {
        return this.adjacentFluid(false, tags);
    }

    @SafeVarargs
    public final GTRecipeBuilder adjacentFluid(boolean isReverse, TagKey<Fluid> ... tags) {
        if (tags.length > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many fluids, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(AdjacentFluidCondition.fromTags(tags).setReverse(isReverse));
    }

    public GTRecipeBuilder adjacentFluid(Collection<HolderSet<Fluid>> fluids) {
        return this.adjacentFluid(fluids, false);
    }

    public GTRecipeBuilder adjacentFluid(Collection<HolderSet<Fluid>> fluids, boolean isReverse) {
        if (fluids.size() > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many fluids, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(new AdjacentFluidCondition(isReverse, new ArrayList<HolderSet<Fluid>>(fluids)));
    }

    public GTRecipeBuilder adjacentBlocks(Block ... blocks) {
        return this.adjacentBlocks(false, blocks);
    }

    public GTRecipeBuilder adjacentBlocks(boolean isReverse, Block ... blocks) {
        if (blocks.length > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many blocks, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(AdjacentBlockCondition.fromBlocks(blocks).setReverse(isReverse));
    }

    public GTRecipeBuilder adjacentBlock(Block ... blocks) {
        return this.adjacentBlock(false, blocks);
    }

    public GTRecipeBuilder adjacentBlock(boolean isReverse, Block ... blocks) {
        if (blocks.length > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many blocks, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(AdjacentBlockCondition.fromBlocks(blocks).setReverse(isReverse));
    }

    @SafeVarargs
    public final GTRecipeBuilder adjacentBlock(TagKey<Block> ... tags) {
        return this.adjacentBlock(false, tags);
    }

    @SafeVarargs
    public final GTRecipeBuilder adjacentBlock(boolean isReverse, TagKey<Block> ... tags) {
        if (tags.length > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many blocks, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(AdjacentBlockCondition.fromTags(tags).setReverse(isReverse));
    }

    @SafeVarargs
    public final GTRecipeBuilder adjacentBlockTag(TagKey<Block> ... tags) {
        return this.adjacentBlockTag(false, tags);
    }

    @SafeVarargs
    public final GTRecipeBuilder adjacentBlockTag(boolean isReverse, TagKey<Block> ... tags) {
        if (tags.length > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many blocks, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(AdjacentBlockCondition.fromTags(tags).setReverse(isReverse));
    }

    public GTRecipeBuilder adjacentBlock(Collection<HolderSet<Block>> blocks) {
        return this.adjacentBlock(blocks, false);
    }

    public GTRecipeBuilder adjacentBlock(Collection<HolderSet<Block>> blocks, boolean isReverse) {
        if (blocks.size() > GTUtil.NON_CORNER_NEIGHBOURS.size()) {
            GTCEu.LOGGER.error("Has too many blocks, not adding to recipe, id: {}", (Object)this.id);
            return this;
        }
        return this.addCondition(new AdjacentBlockCondition(isReverse, new ArrayList<HolderSet<Block>>(blocks)));
    }

    public GTRecipeBuilder daytime(boolean isNight) {
        return this.addCondition(new DaytimeCondition().setReverse(isNight));
    }

    public GTRecipeBuilder daytime() {
        return this.daytime(false);
    }

    public GTRecipeBuilder heraclesQuest(String questId, boolean isReverse) {
        if (!GTCEu.Mods.isHeraclesLoaded()) {
            GTCEu.LOGGER.error("Heracles not loaded!");
            return this;
        }
        if (questId.isEmpty()) {
            GTCEu.LOGGER.error("Quest ID cannot be empty for recipe {}", (Object)this.id);
            return this;
        }
        return this.addCondition(new HeraclesQuestCondition(isReverse, questId));
    }

    public GTRecipeBuilder heraclesQuest(String questId) {
        return this.heraclesQuest(questId, false);
    }

    public GTRecipeBuilder gameStage(String stageName) {
        return this.gameStage(stageName, false);
    }

    public GTRecipeBuilder gameStage(String stageName, boolean isReverse) {
        if (!GTCEu.Mods.isGameStagesLoaded()) {
            GTCEu.LOGGER.warn("GameStages is not loaded, ignoring recipe condition");
            return this;
        }
        return this.addCondition(new GameStageCondition(isReverse, stageName));
    }

    public GTRecipeBuilder ftbQuest(String questId, boolean isReverse) {
        if (!GTCEu.Mods.isFTBQuestsLoaded()) {
            GTCEu.LOGGER.error("FTBQuests is not loaded!");
            return this;
        }
        if (questId.isEmpty()) {
            GTCEu.LOGGER.error("Quest ID cannot be empty for recipe {}", (Object)this.id);
            return this;
        }
        long qID = QuestObjectBase.parseCodeString((String)questId);
        if (qID == 0L) {
            GTCEu.LOGGER.error("Quest {} not found for recipe {}", (Object)questId, (Object)this.id);
            return this;
        }
        return this.addCondition(new FTBQuestCondition(isReverse, qID));
    }

    public GTRecipeBuilder ftbQuest(String questId) {
        return this.ftbQuest(questId, false);
    }

    private boolean applyResearchProperty(ResearchData.ResearchEntry researchEntry) {
        if (!ConfigHolder.INSTANCE.machines.enableResearch) {
            return false;
        }
        if (researchEntry == null) {
            GTCEu.LOGGER.error("Research Entry cannot be empty.", (Throwable)new IllegalArgumentException());
            return false;
        }
        if (!this.generatingRecipes) {
            GTCEu.LOGGER.error("Cannot generate recipes when using researchWithoutRecipe()", (Throwable)new IllegalArgumentException());
            return false;
        }
        ResearchCondition condition = this.conditions.stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
        if (condition != null) {
            condition.data.add(researchEntry);
        } else {
            condition = new ResearchCondition();
            condition.data.add(researchEntry);
            this.addCondition(condition);
        }
        return true;
    }

    public GTRecipeBuilder researchWithoutRecipe(@NotNull String researchId) {
        return this.researchWithoutRecipe(researchId, ResearchManager.getDefaultScannerItem());
    }

    public GTRecipeBuilder researchWithoutRecipe(@NotNull String researchId, @NotNull ItemStack dataStack) {
        this.applyResearchProperty(new ResearchData.ResearchEntry(researchId, dataStack));
        this.generatingRecipes = false;
        return this;
    }

    public GTRecipeBuilder scannerResearch(UnaryOperator<ResearchRecipeBuilder.ScannerRecipeBuilder> research) {
        ResearchRecipeEntry entry = ((ResearchRecipeBuilder.ScannerRecipeBuilder)research.apply(new ResearchRecipeBuilder.ScannerRecipeBuilder())).build(this.id);
        if (this.applyResearchProperty(new ResearchData.ResearchEntry(entry.researchId, entry.dataStack))) {
            this.researchRecipeEntries.add(entry);
        }
        return this;
    }

    public GTRecipeBuilder scannerResearch(@NotNull ItemStack researchStack) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(researchStack));
    }

    public GTRecipeBuilder stationResearch(UnaryOperator<ResearchRecipeBuilder.StationRecipeBuilder> research) {
        ResearchRecipeEntry entry = ((ResearchRecipeBuilder.StationRecipeBuilder)research.apply(new ResearchRecipeBuilder.StationRecipeBuilder())).build(this.id);
        if (this.applyResearchProperty(new ResearchData.ResearchEntry(entry.researchId, entry.dataStack))) {
            this.researchRecipeEntries.add(entry);
        }
        return this;
    }

    public GTRecipeBuilder category(@NotNull GTRecipeCategory category) {
        this.recipeCategory = category;
        return this;
    }

    public GTRecipeBuilder addMaterialInfo(boolean item) {
        this.itemMaterialInfo = item;
        return this;
    }

    public GTRecipeBuilder addMaterialInfo(boolean item, boolean fluid) {
        this.itemMaterialInfo = item;
        this.fluidMaterialInfo = fluid;
        return this;
    }

    public GTRecipeBuilder removePreviousMaterialInfo() {
        this.removePreviousMatInfo = true;
        return this;
    }

    public GTRecipeBuilder setTempItemMaterialStacks(List<MaterialStack> stacks) {
        this.tempItemMaterialStacks = stacks;
        return this;
    }

    public GTRecipeBuilder setTempFluidMaterialStacks(List<MaterialStack> stacks) {
        this.tempFluidStacks = stacks;
        return this;
    }

    public GTRecipeBuilder setTempItemStacks(List<ItemStack> stacks) {
        this.tempItemStacks = stacks;
        return this;
    }

    public void toJson(JsonObject json) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        JsonObject serialized = ((JsonElement)GTRecipeSerializer.CODEC.encodeStart((DynamicOps)ops, (Object)this.buildRawRecipe()).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0))).getAsJsonObject();
        for (String key : serialized.keySet()) {
            json.add(key, serialized.get(key));
        }
    }

    public JsonObject capabilitiesToJson(Map<RecipeCapability<?>, List<Content>> contents) {
        JsonObject jsonObject = new JsonObject();
        contents.forEach((cap, list) -> {
            JsonArray contentsJson = new JsonArray();
            for (Content content : list) {
                contentsJson.add(cap.serializer.toJsonContent(content));
            }
            jsonObject.add((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap), (JsonElement)contentsJson);
        });
        return jsonObject;
    }

    public JsonObject chanceLogicsToJson(Map<RecipeCapability<?>, ChanceLogic> chanceLogics) {
        JsonObject jsonObject = new JsonObject();
        chanceLogics.forEach((cap, logic) -> {
            String capId = (String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap);
            String logicId = (String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic);
            jsonObject.addProperty(capId, logicId);
        });
        return jsonObject;
    }

    public FinishedRecipe build() {
        return new FinishedRecipe(){

            public void serializeRecipeData(JsonObject pJson) {
                GTRecipeBuilder.this.toJson(pJson);
            }

            public ResourceLocation getId() {
                return new ResourceLocation(GTRecipeBuilder.this.id.getNamespace(), GTRecipeBuilder.this.recipeType.registryName.getPath() + "/" + GTRecipeBuilder.this.id.getPath());
            }

            public RecipeSerializer<?> getType() {
                return GTRecipeSerializer.SERIALIZER;
            }

            @Nullable
            public JsonObject serializeAdvancement() {
                return null;
            }

            @Nullable
            public ResourceLocation getAdvancementId() {
                return null;
            }
        };
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        if (this.onSave != null) {
            this.onSave.accept(this, consumer);
        }
        ResearchCondition condition = this.conditions.stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
        if (condition != null) {
            for (ResearchData.ResearchEntry entry : condition.data) {
                this.recipeType.addDataStickEntry(entry.getResearchId(), this.buildRawRecipe());
            }
        }
        if (this.recipeType != null) {
            if (this.recipeCategory == null) {
                GTCEu.LOGGER.error("Recipes must have a category", (Throwable)new IllegalArgumentException());
            } else if (this.recipeCategory != GTRecipeCategory.DEFAULT && this.recipeCategory.getRecipeType() != this.recipeType) {
                GTCEu.LOGGER.error("Cannot apply Category with incompatible RecipeType", (Throwable)new IllegalArgumentException());
            }
        }
        if (this.removePreviousMatInfo) {
            this.removeExistingMaterialInfo();
        }
        if (this.itemMaterialInfo || this.fluidMaterialInfo) {
            this.addOutputMaterialInfo();
        }
        this.tempItemStacks = null;
        this.tempItemMaterialStacks = null;
        this.tempFluidStacks = null;
        consumer.accept(this.build());
    }

    private void addOutputMaterialInfo() {
        List itemOutputs = this.output.getOrDefault(ItemRecipeCapability.CAP, new ArrayList());
        List itemInputs = this.input.getOrDefault(ItemRecipeCapability.CAP, new ArrayList());
        if (!(itemOutputs.size() != 1 || itemInputs.isEmpty() && this.tempFluidStacks.isEmpty())) {
            long am;
            ItemStack[] items;
            Ingredient currOutput = (Ingredient)ItemRecipeCapability.CAP.of(((Content)itemOutputs.get((int)0)).content);
            Item out = null;
            int outputCount = 0;
            if (currOutput instanceof IntProviderIngredient) {
                IntProviderIngredient intProvider = (IntProviderIngredient)currOutput;
                items = intProvider.getInner().getItems();
                if (items.length > 0) {
                    out = items[0].getItem();
                    outputCount = intProvider.getCountProvider().getMaxValue();
                }
            } else if (!currOutput.isEmpty() && (items = currOutput.getItems()).length > 0) {
                out = items[0].getItem();
                outputCount = items[0].getCount();
            }
            if (out == null || out == Items.AIR) {
                return;
            }
            Reference2LongOpenHashMap matStacks = new Reference2LongOpenHashMap();
            if (this.itemMaterialInfo) {
                for (MaterialStack input : this.tempItemMaterialStacks) {
                    am = input.amount() / (long)outputCount;
                    matStacks.addTo((Object)input.material(), am);
                }
            }
            if (this.fluidMaterialInfo) {
                for (MaterialStack input : this.tempFluidStacks) {
                    am = input.amount() / (long)outputCount;
                    matStacks.addTo((Object)input.material(), am);
                }
            }
            if (outputCount != 0 && !this.tempItemStacks.isEmpty()) {
                ItemMaterialData.UNRESOLVED_ITEM_MATERIAL_INFO.put(new ItemStack((ItemLike)out, outputCount), this.tempItemStacks);
            }
            if (!matStacks.isEmpty()) {
                ItemMaterialData.registerMaterialInfo((ItemLike)out, new ItemMaterialInfo((Reference2LongMap<Material>)matStacks));
            }
        }
    }

    private void removeExistingMaterialInfo() {
        List<Content> itemOutputs = this.output.get(ItemRecipeCapability.CAP);
        if (itemOutputs.size() == 1) {
            ItemMaterialInfo existingItemInfo;
            ItemStack[] items;
            Ingredient currOutput = (Ingredient)ItemRecipeCapability.CAP.of(itemOutputs.get((int)0).content);
            Item out = null;
            int outputCount = 0;
            if (currOutput instanceof IntProviderIngredient) {
                IntProviderIngredient intProvider = (IntProviderIngredient)currOutput;
                ItemStack[] items2 = intProvider.getInner().getItems();
                if (items2.length > 0) {
                    out = items2[0].getItem();
                    outputCount = intProvider.getCountProvider().getMaxValue();
                }
            } else if (!currOutput.isEmpty() && (items = currOutput.getItems()).length > 0) {
                out = items[0].getItem();
                outputCount = items[0].getCount();
            }
            if (out == null || out == Items.AIR) {
                return;
            }
            if (outputCount != 0) {
                ItemMaterialData.UNRESOLVED_ITEM_MATERIAL_INFO.remove(new ItemStack((ItemLike)out, outputCount));
            }
            if ((existingItemInfo = ItemMaterialData.getMaterialInfo(out)) != null) {
                ItemMaterialData.clearMaterialInfo((ItemLike)out);
            }
        }
    }

    public GTRecipe buildRawRecipe() {
        return new GTRecipe(this.recipeType, this.id.withPrefix(this.recipeType.registryName.getPath() + "/"), this.input, this.output, this.tickInput, this.tickOutput, this.inputChanceLogic, this.outputChanceLogic, this.tickInputChanceLogic, this.tickOutputChanceLogic, this.conditions, List.of(), this.data, this.duration, this.recipeCategory);
    }

    protected void warnTooManyIngredients(RecipeCapability<?> capability, boolean isInput, Map<RecipeCapability<?>, List<Content>> table, int addedEntries) {
        Object2IntSortedMap<RecipeCapability<?>> recipeCapabilityMax;
        Object2IntSortedMap<RecipeCapability<?>> object2IntSortedMap = recipeCapabilityMax = isInput ? this.recipeType.maxInputs : this.recipeType.maxOutputs;
        if (!recipeCapabilityMax.containsKey(capability)) {
            return;
        }
        int max = recipeCapabilityMax.getInt(capability);
        if (table.getOrDefault(capability, List.of()).size() + addedEntries > max) {
            String io = isInput ? "inputs" : "outputs";
            GTCEu.LOGGER.warn("Recipe {} is trying to add more {} than its recipe type can support, Max {} {}: {}", (Object)this.id, (Object)io, (Object)capability.name, (Object)io, (Object)max);
        }
    }

    protected boolean missingIngredientError(int index, boolean isInput, RecipeCapability<?> cap, BooleanSupplier empty) {
        if (empty.getAsBoolean()) {
            Object io;
            Object object = io = isInput ? "Input" : "Output";
            if (this.perTick) {
                io = "Tick " + ((String)io).toLowerCase(Locale.ROOT);
            }
            int size = (this.perTick ? this.tickOutput : this.output).getOrDefault(cap, List.of()).size();
            GTCEu.LOGGER.error("{} {} {} of recipe {} is empty", io, (Object)cap.name, (Object)(size + index), (Object)this.id);
            return true;
        }
        return false;
    }

    protected boolean checkChanceAndPrintError(int chance) {
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", (Object)ChanceLogic.getMaxChancedValue(), (Object)chance, (Object)new Throwable());
            return true;
        }
        return false;
    }

    public EnergyStack EUt() {
        if (!this.tickInput.containsKey(EURecipeCapability.CAP)) {
            return EnergyStack.EMPTY;
        }
        if (this.tickInput.get(EURecipeCapability.CAP).isEmpty()) {
            return EnergyStack.EMPTY;
        }
        return (EnergyStack)EURecipeCapability.CAP.of(this.tickInput.get((Object)EURecipeCapability.CAP).get((int)0).content);
    }

    public int getSolderMultiplier() {
        if (this.data.contains("solderMultiplier")) {
            return Math.max(1, this.data.getInt("solderMultiplier"));
        }
        return Math.max(1, this.data.getInt("solder_multiplier"));
    }

    @NotNull
    @Generated
    public GTRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Generated
    public GTRecipeBuilder recipeType(GTRecipeType recipeType) {
        this.recipeType = recipeType;
        return this;
    }

    @NotNull
    @Generated
    public GTRecipeBuilder perTick(boolean perTick) {
        this.perTick = perTick;
        return this;
    }

    @NotNull
    @Generated
    public GTRecipeBuilder chance(int chance) {
        this.chance = chance;
        return this;
    }

    @NotNull
    @Generated
    public GTRecipeBuilder maxChance(int maxChance) {
        this.maxChance = maxChance;
        return this;
    }

    @NotNull
    @Generated
    public GTRecipeBuilder tierChanceBoost(int tierChanceBoost) {
        this.tierChanceBoost = tierChanceBoost;
        return this;
    }

    @NotNull
    @Generated
    public GTRecipeBuilder onSave(@Nullable BiConsumer<GTRecipeBuilder, Consumer<FinishedRecipe>> onSave) {
        this.onSave = onSave;
        return this;
    }

    @Generated
    public Collection<ResearchRecipeEntry> researchRecipeEntries() {
        return this.researchRecipeEntries;
    }

    public record ResearchRecipeEntry(@NotNull String researchId, @NotNull ItemStack researchItem, @NotNull FluidStack researchFluid, @NotNull ItemStack dataStack, int duration, EnergyStack EUt, int CWUt) {
    }
}

