/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.ShapedEnergyTransferRecipe;
import com.lowdragmc.lowdraglib.utils.Builder;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.jetbrains.annotations.Nullable;

public class ShapedEnergyTransferRecipeBuilder
extends Builder<Ingredient, ShapedEnergyTransferRecipeBuilder> {
    protected ItemStack output = ItemStack.EMPTY;
    protected Ingredient chargeIngredient = Ingredient.EMPTY;
    protected ResourceLocation id;
    protected String group;
    protected boolean transferMaxCharge;
    protected boolean overrideCharge;

    public ShapedEnergyTransferRecipeBuilder(@Nullable ResourceLocation id) {
        this.id = id;
    }

    public ShapedEnergyTransferRecipeBuilder() {
        this(null);
    }

    public ShapedEnergyTransferRecipeBuilder pattern(String slice) {
        return (ShapedEnergyTransferRecipeBuilder)this.aisle(new String[]{slice});
    }

    public ShapedEnergyTransferRecipeBuilder define(char cha, TagKey<Item> itemStack) {
        return (ShapedEnergyTransferRecipeBuilder)this.where(cha, Ingredient.of(itemStack));
    }

    public ShapedEnergyTransferRecipeBuilder define(char cha, ItemStack itemStack) {
        return (ShapedEnergyTransferRecipeBuilder)this.where(cha, itemStack.hasTag() ? StrictNBTIngredient.of((ItemStack)itemStack) : Ingredient.of((ItemStack[])new ItemStack[]{itemStack}));
    }

    public ShapedEnergyTransferRecipeBuilder define(char cha, ItemLike itemLike) {
        return (ShapedEnergyTransferRecipeBuilder)this.where(cha, Ingredient.of((ItemLike[])new ItemLike[]{itemLike}));
    }

    public ShapedEnergyTransferRecipeBuilder define(char cha, Ingredient ingredient) {
        return (ShapedEnergyTransferRecipeBuilder)this.where(cha, ingredient);
    }

    public ShapedEnergyTransferRecipeBuilder chargeIngredient(Ingredient chargeIngredient) {
        this.chargeIngredient = chargeIngredient;
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder overrideCharge(boolean overrideCharge) {
        this.overrideCharge = overrideCharge;
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder transferMaxCharge(boolean transferMaxCharge) {
        this.transferMaxCharge = transferMaxCharge;
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder output(ItemStack itemStack) {
        this.output = itemStack.copy();
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder output(ItemStack itemStack, int count) {
        this.output = itemStack.copy();
        this.output.setCount(count);
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder output(ItemStack itemStack, int count, CompoundTag nbt) {
        this.output = itemStack.copy();
        this.output.setCount(count);
        this.output.setTag(nbt);
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder id(String id) {
        this.id = new ResourceLocation(id);
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public ShapedEnergyTransferRecipeBuilder shallowCopy() {
        ShapedEnergyTransferRecipeBuilder builder = (ShapedEnergyTransferRecipeBuilder)super.shallowCopy();
        builder.output = this.output.copy();
        return builder;
    }

    public void toJson(JsonObject json) {
        if (this.group != null) {
            json.addProperty("group", this.group);
        }
        if (!this.shape.isEmpty()) {
            JsonArray pattern = new JsonArray();
            Iterator iterator = this.shape.iterator();
            while (iterator.hasNext()) {
                String[] strings;
                for (String string : strings = (String[])iterator.next()) {
                    pattern.add(string);
                }
            }
            json.add("pattern", (JsonElement)pattern);
        }
        if (!this.symbolMap.isEmpty()) {
            JsonObject key = new JsonObject();
            this.symbolMap.forEach((k, v) -> key.add(k.toString(), v.toJson()));
            json.add("key", (JsonElement)key);
        }
        json.addProperty("overrideCharge", Boolean.valueOf(this.overrideCharge));
        json.addProperty("transferMaxCharge", Boolean.valueOf(this.transferMaxCharge));
        if (this.chargeIngredient.isEmpty()) {
            GTCEu.LOGGER.error("shaped energy transfer recipe {} chargeIngredient is empty", (Object)this.id);
            throw new IllegalArgumentException(String.valueOf(this.id) + ": chargeIngredient is empty");
        }
        json.add("chargeIngredient", this.chargeIngredient.toJson());
        if (this.output.isEmpty()) {
            GTCEu.LOGGER.error("shaped energy transfer recipe {} output is empty", (Object)this.id);
            throw new IllegalArgumentException(String.valueOf(this.id) + ": output items is empty");
        }
        JsonObject result = new JsonObject();
        result.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)this.output.getItem()).toString());
        if (this.output.getCount() > 1) {
            result.addProperty("count", (Number)this.output.getCount());
        }
        if (this.output.hasTag() && this.output.getTag() != null) {
            result.add("nbt", NBTToJsonConverter.getObject((Tag)this.output.getTag()));
        }
        json.add("result", (JsonElement)result);
    }

    protected ResourceLocation defaultId() {
        return BuiltInRegistries.ITEM.getKey((Object)this.output.getItem());
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(){

            public void serializeRecipeData(JsonObject pJson) {
                ShapedEnergyTransferRecipeBuilder.this.toJson(pJson);
            }

            public ResourceLocation getId() {
                ResourceLocation ID = ShapedEnergyTransferRecipeBuilder.this.id == null ? ShapedEnergyTransferRecipeBuilder.this.defaultId() : ShapedEnergyTransferRecipeBuilder.this.id;
                return new ResourceLocation(ID.getNamespace(), "shaped/" + ID.getPath());
            }

            public RecipeSerializer<?> getType() {
                return ShapedEnergyTransferRecipe.SERIALIZER;
            }

            @Nullable
            public JsonObject serializeAdvancement() {
                return null;
            }

            @Nullable
            public ResourceLocation getAdvancementId() {
                return null;
            }
        });
    }
}

