/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmokingRecipeBuilder {
    private Ingredient input;
    protected String group;
    private ItemStack output = ItemStack.EMPTY;
    private float experience;
    private int cookingTime;
    protected ResourceLocation id;

    public SmokingRecipeBuilder(@Nullable ResourceLocation id) {
        this.id = id;
    }

    public SmokingRecipeBuilder input(TagKey<Item> itemStack) {
        return this.input(Ingredient.of(itemStack));
    }

    public SmokingRecipeBuilder input(ItemStack itemStack) {
        this.input = itemStack.hasTag() ? StrictNBTIngredient.of((ItemStack)itemStack) : Ingredient.of((ItemStack[])new ItemStack[]{itemStack});
        return this;
    }

    public SmokingRecipeBuilder input(ItemLike itemLike) {
        return this.input(Ingredient.of((ItemLike[])new ItemLike[]{itemLike}));
    }

    public SmokingRecipeBuilder input(Ingredient ingredient) {
        this.input = ingredient;
        return this;
    }

    public SmokingRecipeBuilder output(ItemStack itemStack) {
        this.output = itemStack.copy();
        return this;
    }

    public SmokingRecipeBuilder output(ItemStack itemStack, int count) {
        this.output = itemStack.copy();
        this.output.setCount(count);
        return this;
    }

    public SmokingRecipeBuilder output(ItemStack itemStack, int count, CompoundTag nbt) {
        this.output = itemStack.copy();
        this.output.setCount(count);
        this.output.setTag(nbt);
        return this;
    }

    protected ResourceLocation defaultId() {
        return BuiltInRegistries.ITEM.getKey((Object)this.output.getItem());
    }

    public void toJson(JsonObject json) {
        if (this.group != null) {
            json.addProperty("group", this.group);
        }
        if (!this.input.isEmpty()) {
            json.add("ingredient", this.input.toJson());
        }
        if (this.output.isEmpty()) {
            GTCEu.LOGGER.error("shapeless recipe {} output is empty", (Object)this.id);
            throw new IllegalArgumentException(String.valueOf(this.id) + ": output items is empty");
        }
        JsonObject result = new JsonObject();
        result.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)this.output.getItem()).toString());
        if (this.output.getCount() > 1) {
            result.addProperty("count", (Number)this.output.getCount());
        }
        if (this.output.hasTag() && this.output.getTag() != null) {
            result.add("nbt", NBTToJsonConverter.getObject((Tag)this.output.getTag()));
        }
        json.add("result", (JsonElement)result);
        json.addProperty("experience", (Number)Float.valueOf(this.experience));
        json.addProperty("cookingtime", (Number)this.cookingTime);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(){

            public void serializeRecipeData(JsonObject pJson) {
                SmokingRecipeBuilder.this.toJson(pJson);
            }

            public ResourceLocation getId() {
                ResourceLocation ID = SmokingRecipeBuilder.this.id == null ? SmokingRecipeBuilder.this.defaultId() : SmokingRecipeBuilder.this.id;
                return new ResourceLocation(ID.getNamespace(), "smoking/" + ID.getPath());
            }

            public RecipeSerializer<?> getType() {
                return RecipeSerializer.SMOKING_RECIPE;
            }

            @Nullable
            public JsonObject serializeAdvancement() {
                return null;
            }

            @Nullable
            public ResourceLocation getAdvancementId() {
                return null;
            }
        });
    }

    @NotNull
    @Generated
    public SmokingRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    @NotNull
    @Generated
    public SmokingRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    @NotNull
    @Generated
    public SmokingRecipeBuilder cookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    @NotNull
    @Generated
    public SmokingRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }
}

