/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.configurable;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidContainerIngredient;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class RecipeAddition {
    public static void init(Consumer<FinishedRecipe> provider) {
        RecipeAddition.hardMiscRecipes(provider);
        RecipeAddition.hardRedstoneRecipes(provider);
        RecipeAddition.disableManualCompression(provider);
        RecipeAddition.hardToolArmorRecipes(provider);
        RecipeAddition.harderRods(provider);
        RecipeAddition.harderBrickRecipes(provider);
        RecipeAddition.steelSteamMultiblocks(provider);
        if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
            RecipeAddition.hardWoodRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardIronRecipes) {
            RecipeAddition.hardIronRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardGlassRecipes) {
            RecipeAddition.hardGlassRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.nerfPaperCrafting) {
            RecipeAddition.nerfPaperCrafting(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardAdvancedIronRecipes) {
            RecipeAddition.hardAdvancedIronRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.flintAndSteelRequireSteel) {
            RecipeAddition.flintAndSteelRequireSteel(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
            RecipeAddition.vanillaBlockRecipes(provider);
        }
    }

    private static void steelSteamMultiblocks(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.machines.steelSteamMultiblocks) {
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_oven", GTMultiMachines.STEAM_OVEN.asStack(), "CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_STEEL.asStack(), Character.valueOf('C'), GTBlocks.CASING_STEEL_SOLID.asStack(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.right()).asStack(), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Invar));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_grinder", GTMultiMachines.STEAM_GRINDER.asStack(), "CGC", "CFC", "CGC", Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.right()).asStack(), Character.valueOf('C'), GTBlocks.CASING_STEEL_SOLID.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_hatch", GTMachines.STEAM_HATCH.asStack(), "BPB", "BTB", "BPB", Character.valueOf('B'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('P'), new MaterialEntry(TagPrefix.pipeNormalFluid, GTMaterials.Steel), Character.valueOf('T'), GTMachines.STEEL_DRUM.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_input_bus", GTMachines.STEAM_IMPORT_BUS.asStack(), "C", "H", Character.valueOf('H'), GTBlocks.STEEL_HULL.asStack(), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN);
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_output_bus", GTMachines.STEAM_EXPORT_BUS.asStack(), "H", "C", Character.valueOf('H'), GTBlocks.STEEL_HULL.asStack(), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_oven_from_lp", GTMultiMachines.STEAM_OVEN.asStack(), "CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_BRONZE.asStack(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.asStack(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.left()).asStack(), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Invar));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_oven_from_hp", GTMultiMachines.STEAM_OVEN.asStack(), "CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_BRONZE.asStack(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.asStack(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.right()).asStack(), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Invar));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_grinder_from_lp", GTMultiMachines.STEAM_GRINDER.asStack(), "CGC", "CFC", "CGC", Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.left()).asStack(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_grinder_from_hp", GTMultiMachines.STEAM_GRINDER.asStack(), "CGC", "CFC", "CGC", Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.right()).asStack(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_hatch", GTMachines.STEAM_HATCH.asStack(), "BPB", "BTB", "BPB", Character.valueOf('B'), new MaterialEntry(TagPrefix.plate, GTMaterials.Bronze), Character.valueOf('P'), new MaterialEntry(TagPrefix.pipeNormalFluid, GTMaterials.Bronze), Character.valueOf('T'), GTMachines.BRONZE_DRUM.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_input_bus", GTMachines.STEAM_IMPORT_BUS.asStack(), "C", "H", Character.valueOf('H'), GTBlocks.BRONZE_HULL.asStack(), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN);
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_output_bus", GTMachines.STEAM_EXPORT_BUS.asStack(), "H", "C", Character.valueOf('H'), GTBlocks.BRONZE_HULL.asStack(), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN);
        }
    }

    private static void disableManualCompression(Consumer<FinishedRecipe> provider) {
        if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
            VanillaRecipeHelper.addShapelessRecipe(provider, "nether_quartz_block_to_nether_quartz", new ItemStack((ItemLike)Items.QUARTZ, 4), Blocks.QUARTZ_BLOCK);
        }
    }

    private static void harderBrickRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.harderBrickRecipes) {
            VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, "brick_from_water", new ItemStack((ItemLike)Blocks.BRICKS, 2), new Object[]{"BBB", "BWB", "BBB", Character.valueOf('B'), new ItemStack((ItemLike)Items.BRICK), Character.valueOf('W'), new FluidContainerIngredient(GTMaterials.Water.getFluidTag(), 1000)});
            VanillaRecipeHelper.addShapedRecipe(provider, "bucket_of_concrete", new ItemStack((ItemLike)GTMaterials.Concrete.getBucket()), "CBS", "CWQ", " L ", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Calcite), Character.valueOf('S'), new MaterialEntry(TagPrefix.dust, GTMaterials.Stone), Character.valueOf('W'), new ItemStack((ItemLike)Items.WATER_BUCKET), Character.valueOf('Q'), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), Character.valueOf('L'), new MaterialEntry(TagPrefix.dust, GTMaterials.Clay), Character.valueOf('B'), new ItemStack((ItemLike)Items.BUCKET));
            VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, true, "casing_primitive_bricks", GTBlocks.CASING_PRIMITIVE_BRICKS.asStack(), new Object[]{"BGB", "BCB", "BGB", Character.valueOf('B'), GTItems.FIRECLAY_BRICK.asStack(), Character.valueOf('G'), new MaterialEntry(TagPrefix.dust, GTMaterials.Gypsum), Character.valueOf('C'), new FluidContainerIngredient(GTMaterials.Concrete.getFluidTag(), 1000)});
            VanillaRecipeHelper.addShapelessRecipe(provider, "compressed_clay", GTItems.COMPRESSED_CLAY.asStack(), GTItems.WOODEN_FORM_BRICK.asStack(), new ItemStack((ItemLike)Items.CLAY_BALL));
            VanillaRecipeHelper.addSmeltingRecipe(provider, "brick_from_compressed_clay", GTItems.COMPRESSED_CLAY.asStack(), new ItemStack((ItemLike)Items.BRICK), 0.3f);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, true, "casing_primitive_bricks", GTBlocks.CASING_PRIMITIVE_BRICKS.asStack(), "XX", "XX", Character.valueOf('X'), GTItems.FIRECLAY_BRICK);
        }
    }

    private static void hardWoodRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "ladder", new ItemStack((ItemLike)Blocks.LADDER, 2), "SrS", "SRS", "ShS", Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('R'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood));
        VanillaRecipeHelper.addShapedRecipe(provider, "bowl", new ItemStack((ItemLike)Items.BOWL), "k", "X", Character.valueOf('X'), ItemTags.PLANKS);
        VanillaRecipeHelper.addShapedRecipe(provider, "chest", new ItemStack((ItemLike)Blocks.CHEST), "LPL", "PFP", "LPL", Character.valueOf('L'), ItemTags.LOGS, Character.valueOf('P'), ItemTags.PLANKS, Character.valueOf('F'), new ItemStack((ItemLike)Items.FLINT));
        VanillaRecipeHelper.addShapedRecipe(provider, "barrel", new ItemStack((ItemLike)Blocks.BARREL), "PSP", "PsP", "PSP", Character.valueOf('P'), ItemTags.PLANKS, Character.valueOf('S'), ItemTags.WOODEN_SLABS);
    }

    private static void hardIronRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "cauldron", new ItemStack((ItemLike)Items.CAULDRON), "X X", "XhX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "hopper", new ItemStack((ItemLike)Blocks.HOPPER), "XCX", "XGX", "wXh", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN, Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_bars", new ItemStack((ItemLike)Blocks.IRON_BARS, 8), " h ", "XXX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_bucket", new ItemStack((ItemLike)Items.BUCKET), "XhX", " X ", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "chain_iron", new ItemStack((ItemLike)Items.CHAIN), " R ", "wR ", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chain_iron").inputItems(TagPrefix.ring, GTMaterials.Iron, 3).outputItems(new ItemStack((ItemLike)Items.CHAIN, 2)).circuitMeta(1).duration(40).EUt(10L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "chain_wrought_iron", new ItemStack((ItemLike)Items.CHAIN, 2), " R ", "wR ", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.WroughtIron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chain_wrought_iron").inputItems(TagPrefix.ring, GTMaterials.WroughtIron, 3).outputItems(new ItemStack((ItemLike)Items.CHAIN, 3)).circuitMeta(1).duration(40).EUt(10L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "chain_steel", new ItemStack((ItemLike)Items.CHAIN, 3), " R ", "wR ", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Steel));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chain_steel").inputItems(TagPrefix.ring, GTMaterials.Steel, 3).outputItems(new ItemStack((ItemLike)Items.CHAIN, 6)).circuitMeta(1).duration(40).EUt(10L).save(provider);
    }

    private static void hardRedstoneRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "dispenser", new ItemStack((ItemLike)Blocks.DISPENSER), "CRC", "STS", "GAG", Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('A'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dispenser").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 2).inputItems(TagPrefix.ring, GTMaterials.Iron).inputItems(TagPrefix.spring, GTMaterials.Iron, 2).inputItems(TagPrefix.gearSmall, GTMaterials.Iron, 2).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Items.STRING)).outputItems(new ItemStack((ItemLike)Blocks.DISPENSER)).addMaterialInfo(true).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "sticky_piston", new ItemStack((ItemLike)Blocks.STICKY_PISTON), "h", "R", "P", Character.valueOf('R'), new ItemStack((ItemLike)Items.SLIME_BALL), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.PISTON));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_iron", new ItemStack((ItemLike)Blocks.PISTON), "WWW", "GFG", "CRC", Character.valueOf('W'), ItemTags.PLANKS, Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('R'), new MaterialEntry(TagPrefix.plate, GTMaterials.RedAlloy), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('F'), ItemTags.WOODEN_FENCES);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_iron").inputItems(TagPrefix.rod, GTMaterials.Iron).inputItems(TagPrefix.gearSmall, GTMaterials.Iron).inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS).inputFluids(GTMaterials.RedAlloy.getFluid(144)).outputItems(new ItemStack((ItemLike)Blocks.PISTON)).duration(240).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_steel").inputItems(TagPrefix.rod, GTMaterials.Steel).inputItems(TagPrefix.gearSmall, GTMaterials.Steel).inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS, 2).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 2).inputFluids(GTMaterials.RedAlloy.getFluid(288)).outputItems(new ItemStack((ItemLike)Blocks.PISTON, 2)).duration(240).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_aluminium").inputItems(TagPrefix.rod, GTMaterials.Aluminium).inputItems(TagPrefix.gearSmall, GTMaterials.Aluminium).inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS, 4).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 4).inputFluids(GTMaterials.RedAlloy.getFluid(432)).outputItems(new ItemStack((ItemLike)Blocks.PISTON, 4)).duration(240).EUt(GTValues.VA[1]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_stainless_steel").inputItems(TagPrefix.rod, GTMaterials.StainlessSteel).inputItems(TagPrefix.gearSmall, GTMaterials.StainlessSteel).inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS, 8).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 8).inputFluids(GTMaterials.RedAlloy.getFluid(576)).outputItems(new ItemStack((ItemLike)Blocks.PISTON, 8)).duration(600).EUt(GTValues.VA[1]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_titanium").inputItems(TagPrefix.rod, GTMaterials.Titanium).inputItems(TagPrefix.gearSmall, GTMaterials.Titanium).inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS, 16).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 16).inputFluids(GTMaterials.RedAlloy.getFluid(1152)).outputItems(new ItemStack((ItemLike)Blocks.PISTON, 16)).duration(800).EUt(GTValues.VA[1]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "stone_pressure_plate", new ItemStack((ItemLike)Blocks.STONE_PRESSURE_PLATE, 2), "ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), new ItemStack((ItemLike)Blocks.STONE_SLAB), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "polished_blackstone_pressure_plate", new ItemStack((ItemLike)Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE, 2), "ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), new ItemStack((ItemLike)Blocks.POLISHED_BLACKSTONE_SLAB), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "heavy_weighted_pressure_plate", new ItemStack((ItemLike)Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE), "ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Steel));
            VanillaRecipeHelper.addShapedRecipe(provider, "light_weighted_pressure_plate", new ItemStack((ItemLike)Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE), "ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Steel));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("light_weighted_pressure_plate").inputItems(TagPrefix.spring, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Gold).outputItems(new ItemStack((ItemLike)Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heavy_weighted_pressure_plate").inputItems(TagPrefix.spring, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Iron).outputItems(new ItemStack((ItemLike)Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("stone_button").inputItems(new ItemStack((ItemLike)Blocks.STONE_PRESSURE_PLATE)).outputItems(new ItemStack((ItemLike)Blocks.STONE_BUTTON, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("blackstone_button").inputItems(new ItemStack((ItemLike)Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE)).outputItems(new ItemStack((ItemLike)Blocks.POLISHED_BLACKSTONE_BUTTON, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lever", new ItemStack((ItemLike)Blocks.LEVER), "B", "S", Character.valueOf('B'), new ItemStack((ItemLike)Blocks.STONE_BUTTON), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector", new ItemStack((ItemLike)Blocks.DAYLIGHT_DETECTOR), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('S'), ItemTags.WOODEN_SLABS, Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_certus", new ItemStack((ItemLike)Blocks.DAYLIGHT_DETECTOR), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('S'), ItemTags.WOODEN_SLABS, Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_quartzite", new ItemStack((ItemLike)Blocks.DAYLIGHT_DETECTOR), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS, 1), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('S'), ItemTags.WOODEN_SLABS, Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector").inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Blocks.GLASS, 3)).inputItems(TagPrefix.gem, GTMaterials.NetherQuartz, 3).inputItems((TagKey<Item>)ItemTags.PLANKS).outputItems(new ItemStack((ItemLike)Blocks.DAYLIGHT_DETECTOR)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector_certus").inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Blocks.GLASS, 3)).inputItems(TagPrefix.gem, GTMaterials.CertusQuartz, 3).inputItems((TagKey<Item>)ItemTags.PLANKS).outputItems(new ItemStack((ItemLike)Blocks.DAYLIGHT_DETECTOR)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector_quartzite").inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Blocks.GLASS, 3)).inputItems(TagPrefix.gem, GTMaterials.Quartzite, 3).inputItems((TagKey<Item>)ItemTags.PLANKS).outputItems(new ItemStack((ItemLike)Blocks.DAYLIGHT_DETECTOR)).duration(200).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, true, "redstone_lamp", new ItemStack((ItemLike)Blocks.REDSTONE_LAMP), "PPP", "PGP", "PRP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.GLASS_PANE), Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLOWSTONE), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "tripwire_hook", new ItemStack((ItemLike)Blocks.TRIPWIRE_HOOK), "IRI", "SRS", " S ", Character.valueOf('I'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "dropper", new ItemStack((ItemLike)Blocks.DROPPER), "CRC", "STS", "GAG", Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.springSmall, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('A'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "observer", new ItemStack((ItemLike)Blocks.OBSERVER), "RCR", "CQC", "GSG", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "observer_certus", new ItemStack((ItemLike)Blocks.OBSERVER), "RCR", "CQC", "GSG", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "observer_quartzite", new ItemStack((ItemLike)Blocks.OBSERVER), "RCR", "CQC", "GSG", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "repeater", new ItemStack((ItemLike)Items.REPEATER), "S S", "TdT", "PRP", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.STONE_PRESSURE_PLATE), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator", new ItemStack((ItemLike)Items.COMPARATOR), "STS", "TQT", "PdP", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.STONE_PRESSURE_PLATE));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_certus", new ItemStack((ItemLike)Items.COMPARATOR), "STS", "TQT", "PdP", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.STONE_PRESSURE_PLATE));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_quartzite", new ItemStack((ItemLike)Items.COMPARATOR), "STS", "TQT", "PdP", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.STONE_PRESSURE_PLATE));
            VanillaRecipeHelper.addShapedRecipe(provider, "powered_rail", new ItemStack((ItemLike)Blocks.POWERED_RAIL, 6), "SPS", "IWI", "GdG", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.RedAlloy), Character.valueOf('I'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('G'), new MaterialEntry(TagPrefix.rod, GTMaterials.Gold));
            VanillaRecipeHelper.addShapedRecipe(provider, "detector_rail", new ItemStack((ItemLike)Blocks.DETECTOR_RAIL, 6), "SPS", "IWI", "IdI", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE), Character.valueOf('I'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "rail", new ItemStack((ItemLike)Blocks.RAIL, 8), "ShS", "IWI", "IdI", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('I'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "activator_rail", new ItemStack((ItemLike)Blocks.ACTIVATOR_RAIL, 6), "SPS", "IWI", "IdI", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), Character.valueOf('I'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), Tags.Items.RODS_WOODEN);
            VanillaRecipeHelper.addShapedRecipe(provider, "redstone_torch", new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), "R", "T", Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.TORCH));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("calibrated_sculk_sensor").inputItems(new ItemStack((ItemLike)Blocks.SCULK_SENSOR)).inputItems(TagPrefix.gem, GTMaterials.Amethyst).inputItems(TagPrefix.plate, GTMaterials.Amethyst).outputItems(new ItemStack((ItemLike)Blocks.CALIBRATED_SCULK_SENSOR)).duration(200).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "target", new ItemStack((ItemLike)Items.TARGET), "RBR", "PHP", "RPR", Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('P'), new ItemStack((ItemLike)Items.PAPER), Character.valueOf('H'), new ItemStack((ItemLike)Items.HAY_BLOCK), Character.valueOf('B'), ItemTags.WOODEN_BUTTONS);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("target").inputItems(TagPrefix.dust, GTMaterials.Redstone, 4).inputItems((TagKey<Item>)ItemTags.WOODEN_BUTTONS).inputItems((Object)new ItemStack((ItemLike)Items.PAPER), 3).inputItems(new ItemStack((ItemLike)Items.HAY_BLOCK)).outputItems(new ItemStack((ItemLike)Items.TARGET)).duration(200).EUt(120L).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_bronze", new ItemStack((ItemLike)Blocks.PISTON, 1), "WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.PLANKS, Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new MaterialEntry(TagPrefix.ingot, GTMaterials.Bronze));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_steel", new ItemStack((ItemLike)Blocks.PISTON, 2), "WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.PLANKS, Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new MaterialEntry(TagPrefix.ingot, GTMaterials.Steel));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_aluminium", new ItemStack((ItemLike)Blocks.PISTON, 4), "WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.PLANKS, Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new MaterialEntry(TagPrefix.ingot, GTMaterials.Aluminium));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_titanium", new ItemStack((ItemLike)Blocks.PISTON, 8), "WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.PLANKS, Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS, Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new MaterialEntry(TagPrefix.ingot, GTMaterials.Titanium));
            VanillaRecipeHelper.addShapedRecipe(provider, "sticky_piston_resin", new ItemStack((ItemLike)Blocks.STICKY_PISTON), "h", "R", "P", Character.valueOf('R'), GTItems.STICKY_RESIN.asStack(), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.PISTON));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_iron").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Iron).inputItems((TagKey<Item>)ItemTags.PLANKS, 3).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.PISTON)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_bronze").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Bronze).inputItems((TagKey<Item>)ItemTags.PLANKS, 3).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.PISTON)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_steel").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel).inputItems((TagKey<Item>)ItemTags.PLANKS, 3).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.PISTON, 2)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_aluminium").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium).inputItems((TagKey<Item>)ItemTags.PLANKS, 3).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.PISTON, 4)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_titanium").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium).inputItems((TagKey<Item>)ItemTags.PLANKS, 3).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.PISTON, 8)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("light_weighted_pressure_plate").inputItems(TagPrefix.plate, GTMaterials.Gold, 2).outputItems(new ItemStack((ItemLike)Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE)).circuitMeta(3).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heavy_weighted_pressure_plate").inputItems(TagPrefix.plate, GTMaterials.Iron, 2).outputItems(new ItemStack((ItemLike)Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE)).circuitMeta(2).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_certus", new ItemStack((ItemLike)Items.COMPARATOR), " T ", "TQT", "SSS", Character.valueOf('T'), new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), Character.valueOf('Q'), new MaterialEntry(TagPrefix.gem, GTMaterials.CertusQuartz), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.STONE));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_quartzite", new ItemStack((ItemLike)Items.COMPARATOR), " T ", "TQT", "SSS", Character.valueOf('T'), new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), Character.valueOf('Q'), new MaterialEntry(TagPrefix.gem, GTMaterials.Quartzite), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.STONE));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_certus", new ItemStack((ItemLike)Blocks.DAYLIGHT_DETECTOR), "GGG", "CCC", "PPP", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS), Character.valueOf('C'), new MaterialEntry(TagPrefix.gem, GTMaterials.CertusQuartz), Character.valueOf('P'), ItemTags.WOODEN_SLABS);
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_quartzite", new ItemStack((ItemLike)Blocks.DAYLIGHT_DETECTOR), "GGG", "CCC", "PPP", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS), Character.valueOf('C'), new MaterialEntry(TagPrefix.gem, GTMaterials.Quartzite), Character.valueOf('P'), ItemTags.WOODEN_SLABS);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("note_block").duration(100).EUt(16L).inputItems((TagKey<Item>)ItemTags.PLANKS, 8).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(1).outputItems(new ItemStack((ItemLike)Blocks.NOTE_BLOCK)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jukebox").duration(100).EUt(16L).inputItems((TagKey<Item>)ItemTags.PLANKS, 8).inputItems(TagPrefix.gem, GTMaterials.Diamond).outputItems(new ItemStack((ItemLike)Blocks.JUKEBOX)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("target").duration(100).EUt(16L).inputItems(Items.REDSTONE, 4).inputItems(Items.HAY_BLOCK).outputItems(new ItemStack((ItemLike)Blocks.TARGET)).save(provider);
        }
    }

    private static void hardToolArmorRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardToolArmorRecipes) {
            RecipeAddition.createShovelRecipe(provider, "iron_shovel", new ItemStack((ItemLike)Items.IRON_SHOVEL), GTMaterials.Iron);
            RecipeAddition.createPickaxeRecipe(provider, "iron_pickaxe", new ItemStack((ItemLike)Items.IRON_PICKAXE), GTMaterials.Iron);
            RecipeAddition.createAxeRecipe(provider, "iron_axe", new ItemStack((ItemLike)Items.IRON_AXE), GTMaterials.Iron);
            RecipeAddition.createSwordRecipe(provider, "iron_sword", new ItemStack((ItemLike)Items.IRON_SWORD), GTMaterials.Iron);
            RecipeAddition.createHoeRecipe(provider, "iron_hoe", new ItemStack((ItemLike)Items.IRON_HOE), GTMaterials.Iron);
            RecipeAddition.createHelmetRecipe(provider, "iron_helmet", new ItemStack((ItemLike)Items.IRON_HELMET), GTMaterials.Iron);
            RecipeAddition.createChestplateRecipe(provider, "iron_chestplate", new ItemStack((ItemLike)Items.IRON_CHESTPLATE), GTMaterials.Iron);
            RecipeAddition.createLeggingsRecipe(provider, "iron_leggings", new ItemStack((ItemLike)Items.IRON_LEGGINGS), GTMaterials.Iron);
            RecipeAddition.createBootsRecipe(provider, "iron_boots", new ItemStack((ItemLike)Items.IRON_BOOTS), GTMaterials.Iron);
            RecipeAddition.createShovelRecipe(provider, "golden_shovel", new ItemStack((ItemLike)Items.GOLDEN_SHOVEL), GTMaterials.Gold);
            RecipeAddition.createPickaxeRecipe(provider, "golden_pickaxe", new ItemStack((ItemLike)Items.GOLDEN_PICKAXE), GTMaterials.Gold);
            RecipeAddition.createAxeRecipe(provider, "golden_axe", new ItemStack((ItemLike)Items.GOLDEN_AXE), GTMaterials.Gold);
            RecipeAddition.createSwordRecipe(provider, "golden_sword", new ItemStack((ItemLike)Items.GOLDEN_SWORD), GTMaterials.Gold);
            RecipeAddition.createHoeRecipe(provider, "golden_hoe", new ItemStack((ItemLike)Items.GOLDEN_HOE), GTMaterials.Gold);
            RecipeAddition.createHelmetRecipe(provider, "golden_helmet", new ItemStack((ItemLike)Items.GOLDEN_HELMET), GTMaterials.Gold);
            RecipeAddition.createChestplateRecipe(provider, "golden_chestplate", new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE), GTMaterials.Gold);
            RecipeAddition.createLeggingsRecipe(provider, "golden_leggings", new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS), GTMaterials.Gold);
            RecipeAddition.createBootsRecipe(provider, "golden_boots", new ItemStack((ItemLike)Items.GOLDEN_BOOTS), GTMaterials.Gold);
            RecipeAddition.createShovelRecipe(provider, "diamond_shovel", new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), GTMaterials.Diamond);
            RecipeAddition.createPickaxeRecipe(provider, "diamond_pickaxe", new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), GTMaterials.Diamond);
            RecipeAddition.createAxeRecipe(provider, "diamond_axe", new ItemStack((ItemLike)Items.DIAMOND_AXE), GTMaterials.Diamond);
            RecipeAddition.createSwordRecipe(provider, "diamond_sword", new ItemStack((ItemLike)Items.DIAMOND_SWORD), GTMaterials.Diamond);
            RecipeAddition.createHoeRecipe(provider, "diamond_hoe", new ItemStack((ItemLike)Items.DIAMOND_HOE), GTMaterials.Diamond);
            RecipeAddition.createHelmetRecipe(provider, "diamond_helmet", new ItemStack((ItemLike)Items.DIAMOND_HELMET), GTMaterials.Diamond);
            RecipeAddition.createChestplateRecipe(provider, "diamond_chestplate", new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), GTMaterials.Diamond);
            RecipeAddition.createLeggingsRecipe(provider, "diamond_leggings", new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), GTMaterials.Diamond);
            RecipeAddition.createBootsRecipe(provider, "diamond_boots", new ItemStack((ItemLike)Items.DIAMOND_BOOTS), GTMaterials.Diamond);
            VanillaRecipeHelper.addShapedRecipe(provider, "compass", new ItemStack((ItemLike)Items.COMPASS), "SGB", "RPR", "AdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS_PANE), Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.IronMagnetic), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Zinc), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('A'), new MaterialEntry(TagPrefix.bolt, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("compass").inputItems(TagPrefix.plate, GTMaterials.Iron).inputItems(TagPrefix.ring, GTMaterials.Zinc).inputItems(TagPrefix.bolt, GTMaterials.RedAlloy).inputItems(TagPrefix.bolt, GTMaterials.IronMagnetic).inputItems(TagPrefix.screw, GTMaterials.Iron, 2).outputItems(new ItemStack((ItemLike)Items.COMPASS)).duration(100).EUt(16L).addMaterialInfo(true).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "fishing_rod", new ItemStack((ItemLike)Items.FISHING_ROD), "  S", " SL", "SxR", Character.valueOf('S'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('L'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "clock", new ItemStack((ItemLike)Items.CLOCK), "RPR", "BCB", "dSw", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Gold), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Gold), Character.valueOf('C'), new ItemStack((ItemLike)Items.COMPARATOR), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Gold));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("clock").inputItems(TagPrefix.plate, GTMaterials.Gold).inputItems(TagPrefix.ring, GTMaterials.Gold).inputItems(TagPrefix.bolt, GTMaterials.Gold, 2).inputItems(TagPrefix.screw, GTMaterials.Gold).inputItems(new ItemStack((ItemLike)Items.COMPARATOR)).outputItems(new ItemStack((ItemLike)Items.CLOCK)).duration(100).EUt(16L).addMaterialInfo(true).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "shears", new ItemStack((ItemLike)Items.SHEARS), "PSP", "hRf", "TdT", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "shield", new ItemStack((ItemLike)Items.SHIELD), "BRB", "LPL", "BRB", Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('L'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "bow", new ItemStack((ItemLike)Items.BOW), "hLS", "LRS", "fLS", Character.valueOf('L'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "crossbow", new ItemStack((ItemLike)Items.CROSSBOW), "RIR", "STS", "sRf", Character.valueOf('R'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('T'), new ItemStack((ItemLike)Items.TRIPWIRE_HOOK), Character.valueOf('I'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron));
        } else {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("compass").inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(1).outputItems(new ItemStack((ItemLike)Items.COMPASS)).duration(100).EUt(4L).addMaterialInfo(true).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("clock").inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(TagPrefix.plate, GTMaterials.Gold, 4).outputItems(new ItemStack((ItemLike)Items.CLOCK)).duration(100).EUt(4L).addMaterialInfo(true).save(provider);
        }
    }

    private static void harderRods(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.harderRods) {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_cobblestone").inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS).outputItems(TagPrefix.rod, GTMaterials.Stone, 1).outputItems(TagPrefix.dustSmall, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_stone").inputItems(new ItemStack((ItemLike)Blocks.STONE)).outputItems(TagPrefix.rod, GTMaterials.Stone, 1).outputItems(TagPrefix.dustSmall, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
        } else {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_cobblestone").inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS).outputItems(TagPrefix.rod, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_stone").inputItems(new ItemStack((ItemLike)Blocks.STONE)).outputItems(TagPrefix.rod, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
        }
    }

    private static void hardMiscRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardMiscRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, true, "beacon", new ItemStack((ItemLike)Blocks.BEACON), "GLG", "GSG", "OOO", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS), Character.valueOf('L'), new MaterialEntry(TagPrefix.lens, GTMaterials.NetherStar), Character.valueOf('S'), new ItemStack((ItemLike)Items.NETHER_STAR), Character.valueOf('O'), new MaterialEntry(TagPrefix.plate, GTMaterials.Obsidian));
            VanillaRecipeHelper.addShapedRecipe(provider, "jack_o_lantern", new ItemStack((ItemLike)Blocks.JACK_O_LANTERN), "PT", "k ", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.PUMPKIN), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.TORCH));
            VanillaRecipeHelper.addShapedRecipe(provider, "book", new ItemStack((ItemLike)Items.BOOK), "SPL", "SPG", "SPL", Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('P'), new ItemStack((ItemLike)Items.PAPER), Character.valueOf('L'), new ItemStack((ItemLike)Items.LEATHER), Character.valueOf('G'), GTItems.STICKY_RESIN.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "brewing_stand", new ItemStack((ItemLike)Items.BREWING_STAND), "RBR", "ABA", "SCS", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Aluminium), Character.valueOf('B'), new MaterialEntry(TagPrefix.rod, GTMaterials.Blaze), Character.valueOf('A'), new MaterialEntry(TagPrefix.rod, GTMaterials.Aluminium), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Aluminium), Character.valueOf('C'), new ItemStack((ItemLike)Items.CAULDRON));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "enchanting_table", new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE), "DCD", "PBP", "DPD", Character.valueOf('D'), new MaterialEntry(TagPrefix.gem, GTMaterials.Diamond), Character.valueOf('C'), new ItemStack((ItemLike)Blocks.RED_CARPET), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Obsidian), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.BOOKSHELF));
            VanillaRecipeHelper.addShapedRecipe(provider, "jukebox", new ItemStack((ItemLike)Blocks.JUKEBOX), "LBL", "NRN", "LGL", Character.valueOf('L'), ItemTags.LOGS, Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Diamond), Character.valueOf('N'), new ItemStack((ItemLike)Blocks.NOTE_BLOCK), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jukebox").inputItems(TagPrefix.bolt, GTMaterials.Diamond).inputItems(TagPrefix.gear, GTMaterials.Iron).inputItems(TagPrefix.ring, GTMaterials.Iron).inputItems(TagPrefix.plate, GTMaterials.Wood, 4).inputItems(new ItemStack((ItemLike)Blocks.NOTE_BLOCK, 2)).outputItems(new ItemStack((ItemLike)Blocks.JUKEBOX)).duration(100).EUt(16L).addMaterialInfo(true).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "note_block", new ItemStack((ItemLike)Blocks.NOTE_BLOCK), "PPP", "BGB", "PRP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.IRON_BARS), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Wood), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("note_block").inputItems(TagPrefix.plate, GTMaterials.Wood, 4).inputItems(TagPrefix.gear, GTMaterials.Wood).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Blocks.IRON_BARS, 2)).outputItems(new ItemStack((ItemLike)Blocks.NOTE_BLOCK)).duration(100).EUt(16L).addMaterialInfo(true).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "furnace", new ItemStack((ItemLike)Blocks.FURNACE), "CCC", "FFF", "CCC", Character.valueOf('F'), new ItemStack((ItemLike)Items.FLINT), Character.valueOf('C'), ItemTags.STONE_CRAFTING_MATERIALS);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace").circuitMeta(8).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 8).inputItems(new ItemStack((ItemLike)Items.FLINT)).outputItems(new ItemStack((ItemLike)Blocks.FURNACE)).duration(100).EUt(GTValues.VA[0]).addMaterialInfo(true).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "crafting_table", new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), "FF", "WW", Character.valueOf('F'), new ItemStack((ItemLike)Items.FLINT), Character.valueOf('W'), ItemTags.LOGS);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crafting_table").duration(80).EUt(6L).inputItems((TagKey<Item>)ItemTags.LOGS).inputItems(new ItemStack((ItemLike)Items.FLINT)).outputItems(new ItemStack((ItemLike)Blocks.CRAFTING_TABLE)).addMaterialInfo(true).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lead", new ItemStack((ItemLike)Items.LEAD), "SSS", "SBS", "SSS", Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('B'), new ItemStack((ItemLike)Items.SLIME_BALL));
            VanillaRecipeHelper.addShapedRecipe(provider, "item_frame", new ItemStack((ItemLike)Items.ITEM_FRAME), "SRS", "TLT", "TTT", Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('L'), new ItemStack((ItemLike)Items.LEATHER));
            VanillaRecipeHelper.addShapedRecipe(provider, "painting", new ItemStack((ItemLike)Items.PAINTING), "SRS", "TCT", "TTT", Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('C'), ItemTags.WOOL_CARPETS);
            VanillaRecipeHelper.addShapedRecipe(provider, "chest_minecart", new ItemStack((ItemLike)Items.CHEST_MINECART), "hIw", " M ", " d ", Character.valueOf('I'), Tags.Items.CHESTS_WOODEN, Character.valueOf('M'), new ItemStack((ItemLike)Items.MINECART));
            VanillaRecipeHelper.addShapedRecipe(provider, "furnace_minecart", new ItemStack((ItemLike)Items.FURNACE_MINECART), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.FURNACE), Character.valueOf('M'), new ItemStack((ItemLike)Items.MINECART));
            VanillaRecipeHelper.addShapedRecipe(provider, "tnt_minecart", new ItemStack((ItemLike)Items.TNT_MINECART), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.TNT), Character.valueOf('M'), new ItemStack((ItemLike)Items.MINECART));
            VanillaRecipeHelper.addShapedRecipe(provider, "hopper_minecart", new ItemStack((ItemLike)Items.HOPPER_MINECART), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.HOPPER), Character.valueOf('M'), new ItemStack((ItemLike)Items.MINECART));
            VanillaRecipeHelper.addShapedRecipe(provider, "flower_pot", new ItemStack((ItemLike)Items.FLOWER_POT), "BfB", " B ", Character.valueOf('B'), new ItemStack((ItemLike)Items.BRICK));
            VanillaRecipeHelper.addShapedRecipe(provider, "armor_stand", new ItemStack((ItemLike)Items.ARMOR_STAND), "BSB", "hSs", "IPI", Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('I'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.STONE_PRESSURE_PLATE));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("armor_stand").inputItems(Blocks.STONE_PRESSURE_PLATE.asItem()).inputItems(TagPrefix.plate, GTMaterials.Iron, 2).inputItems(TagPrefix.rod, GTMaterials.Wood, 2).outputItems(Items.ARMOR_STAND).duration(100).EUt(GTValues.VA[0]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, true, "trapped_chest", new ItemStack((ItemLike)Blocks.TRAPPED_CHEST), " H ", "SCS", " d ", Character.valueOf('H'), new ItemStack((ItemLike)Blocks.TRIPWIRE_HOOK), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('C'), new ItemStack((ItemLike)Blocks.CHEST));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("ender_chest").inputItems((TagKey<Item>)Tags.Items.CHESTS_WOODEN).inputItems(TagPrefix.plateDense, GTMaterials.Obsidian, 6).inputItems(TagPrefix.plate, GTMaterials.EnderEye).outputItems(Blocks.ENDER_CHEST.asItem()).duration(200).EUt(GTValues.VA[2]).addMaterialInfo(true).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lantern", new ItemStack((ItemLike)Blocks.LANTERN), "hRf", "RFR", " R ", Character.valueOf('F'), new ItemStack((ItemLike)Blocks.TORCH), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lantern").inputItems(new ItemStack((ItemLike)Blocks.TORCH)).inputItems(TagPrefix.ring, GTMaterials.Iron, 4).outputItems(new ItemStack((ItemLike)Blocks.LANTERN)).duration(100).EUt(1L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "soul_lantern", new ItemStack((ItemLike)Blocks.SOUL_LANTERN), "hRf", "RFR", " R ", Character.valueOf('F'), new ItemStack((ItemLike)Blocks.SOUL_TORCH), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_lantern").inputItems(new ItemStack((ItemLike)Blocks.SOUL_TORCH)).inputItems(TagPrefix.ring, GTMaterials.Iron, 4).outputItems(new ItemStack((ItemLike)Blocks.SOUL_LANTERN)).duration(100).EUt(1L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "stonecutter", new ItemStack((ItemLike)Blocks.STONECUTTER), "f d", "SBS", "XXX", Character.valueOf('X'), new ItemStack((ItemLike)Blocks.STONE_SLAB), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('B'), new MaterialEntry(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stonecutter").inputItems(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.STONE_SLAB)).outputItems(new ItemStack((ItemLike)Blocks.STONECUTTER)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "cartography_table", new ItemStack((ItemLike)Blocks.CARTOGRAPHY_TABLE), "sPd", "WWW", "SLS", Character.valueOf('P'), new ItemStack((ItemLike)Items.PAPER), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.plate, GTMaterials.TreatedWood), Character.valueOf('L'), ItemTags.LOGS);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cartography_table").inputItems(new ItemStack((ItemLike)Items.PAPER)).inputItems((TagKey<Item>)ItemTags.LOGS).outputItems(new ItemStack((ItemLike)Blocks.CARTOGRAPHY_TABLE)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "fletching_table", new ItemStack((ItemLike)Blocks.FLETCHING_TABLE), "sPd", "WWW", "SLS", Character.valueOf('P'), new ItemStack((ItemLike)Items.FEATHER), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('L'), ItemTags.LOGS);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fletching_table").inputItems(new ItemStack((ItemLike)Items.FEATHER)).inputItems((TagKey<Item>)ItemTags.LOGS).outputItems(new ItemStack((ItemLike)Blocks.FLETCHING_TABLE)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "smithing_table", new ItemStack((ItemLike)Blocks.SMITHING_TABLE), "h d", "WWW", "SLS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.WroughtIron), Character.valueOf('W'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('L'), ItemTags.LOGS);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smithing_table").inputItems(TagPrefix.screw, GTMaterials.WroughtIron, 2).inputItems((TagKey<Item>)ItemTags.LOGS).inputItems(TagPrefix.plate, GTMaterials.Steel, 3).outputItems(new ItemStack((ItemLike)Blocks.SMITHING_TABLE)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "grindstone", new ItemStack((ItemLike)Blocks.GRINDSTONE), "hBd", "IXI", "WfW", Character.valueOf('X'), new ItemStack((ItemLike)Blocks.STONE_SLAB), Character.valueOf('B'), new MaterialEntry(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron), Character.valueOf('I'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Wood));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("grindstone").inputItems(new ItemStack((ItemLike)Blocks.STONE_SLAB)).inputItems(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron).inputItems(TagPrefix.rodLong, GTMaterials.Wood, 2).outputItems(new ItemStack((ItemLike)Blocks.GRINDSTONE)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "loom", new ItemStack((ItemLike)Blocks.LOOM), "SSS", "PdP", "XYX", Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('X'), new MaterialEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('Y'), ItemTags.PLANKS);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("loom").inputItems(new ItemStack((ItemLike)Items.STRING, 3)).inputItems(TagPrefix.plate, GTMaterials.Wood, 2).inputItems((TagKey<Item>)ItemTags.PLANKS).outputItems(new ItemStack((ItemLike)Blocks.LOOM)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "smoker", new ItemStack((ItemLike)Blocks.SMOKER), "wId", "PFP", "XPX", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.IRON_BARS), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.TreatedWood), Character.valueOf('X'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('F'), new ItemStack((ItemLike)Blocks.FURNACE));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smoker").inputItems(new ItemStack((ItemLike)Blocks.IRON_BARS)).inputItems((TagKey<Item>)ItemTags.PLANKS, 3).inputItems(new ItemStack((ItemLike)Blocks.FURNACE)).outputItems(new ItemStack((ItemLike)Blocks.SMOKER)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "blast_furnace", new ItemStack((ItemLike)Blocks.BLAST_FURNACE), "wfd", "PFP", "XPX", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('X'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('F'), new ItemStack((ItemLike)Blocks.FURNACE));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("blast_furnace").inputItems(TagPrefix.plate, GTMaterials.Iron, 3).inputItems(new ItemStack((ItemLike)Blocks.FURNACE)).outputItems(new ItemStack((ItemLike)Blocks.BLAST_FURNACE)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "composter", new ItemStack((ItemLike)Blocks.COMPOSTER), "PsP", "P P", "XPX", Character.valueOf('P'), ItemTags.PLANKS, Character.valueOf('X'), new MaterialEntry(TagPrefix.screw, GTMaterials.Wood));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("composter").inputItems((TagKey<Item>)ItemTags.PLANKS, 4).circuitMeta(23).outputItems(new ItemStack((ItemLike)Blocks.COMPOSTER)).duration(80).EUt(6L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bell").inputItems(new ItemStack((ItemLike)Items.STICK)).inputItems(TagPrefix.rod, GTMaterials.Stone, 2).inputItems(TagPrefix.bolt, GTMaterials.Iron, 2).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems(new ItemStack((ItemLike)Blocks.BELL)).duration(200).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "candle", new ItemStack((ItemLike)Blocks.CANDLE), "r", "S", "W", Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('W'), new ItemStack((ItemLike)Items.HONEYCOMB));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lodestone").inputItems(TagPrefix.plateDense, GTMaterials.SteelMagnetic).inputItems(TagPrefix.screw, GTMaterials.Iron, 4).inputItems(TagPrefix.plate, GTMaterials.Stone, 4).outputItems(new ItemStack((ItemLike)Blocks.LODESTONE)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("music_disc_5").inputItems(new ItemStack((ItemLike)Items.DISC_FRAGMENT_5, 9)).outputItems(new ItemStack((ItemLike)Items.MUSIC_DISC_5)).duration(100).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "turtle_helmet", new ItemStack((ItemLike)Items.TURTLE_HELMET), "SSS", "SrS", Character.valueOf('S'), new ItemStack((ItemLike)Items.SCUTE));
            VanillaRecipeHelper.addShapedRecipe(provider, "scaffolding", new ItemStack((ItemLike)Blocks.SCAFFOLDING, 3), "BSB", "BWB", "BrB", Character.valueOf('B'), new ItemStack((ItemLike)Items.BAMBOO), Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING), Character.valueOf('W'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("scaffolding").inputItems(new ItemStack((ItemLike)Items.BAMBOO, 6)).inputItems(new ItemStack((ItemLike)Items.STRING)).outputItems(new ItemStack((ItemLike)Blocks.SCAFFOLDING, 4)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "beehive", new ItemStack((ItemLike)Blocks.BEEHIVE, 1), "PsP", "WXW", "PdP", Character.valueOf('P'), ItemTags.PLANKS, Character.valueOf('W'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('X'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("beehive").inputItems(TagPrefix.screw, GTMaterials.Wood, 2).inputItems((TagKey<Item>)ItemTags.PLANKS, 5).circuitMeta(2).outputItems(new ItemStack((ItemLike)Blocks.BEEHIVE)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lightning_rod", new ItemStack((ItemLike)Blocks.LIGHTNING_ROD), " B ", "fRh", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.Copper), Character.valueOf('B'), new MaterialEntry(TagPrefix.plateDouble, GTMaterials.Copper));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lightning_rod").inputItems(TagPrefix.rod, GTMaterials.Copper, 2).inputItems(TagPrefix.plateDouble, GTMaterials.Copper).outputItems(new ItemStack((ItemLike)Blocks.LIGHTNING_ROD)).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chiseled_bookshelf").inputItems((TagKey<Item>)ItemTags.PLANKS, 6).circuitMeta(4).outputItems(new ItemStack((ItemLike)Blocks.CHISELED_BOOKSHELF)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lectern", new ItemStack((ItemLike)Blocks.LECTERN), "SSS", "WBW", "dSs", Character.valueOf('S'), ItemTags.WOODEN_SLABS, Character.valueOf('W'), new MaterialEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.BOOKSHELF));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lectern").inputItems((TagKey<Item>)ItemTags.PLANKS, 2).inputItems(TagPrefix.screw, GTMaterials.Wood, 2).inputItems(new ItemStack((ItemLike)Blocks.BOOKSHELF)).outputItems(new ItemStack((ItemLike)Blocks.LECTERN)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "brush", new ItemStack((ItemLike)Items.BRUSH), " F ", "fRr", " S ", Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Copper), Character.valueOf('F'), new ItemStack((ItemLike)Items.FEATHER));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("brush").inputItems(TagPrefix.rodLong, GTMaterials.Wood).inputItems(TagPrefix.ring, GTMaterials.Copper).inputItems(new ItemStack((ItemLike)Items.FEATHER)).outputItems(new ItemStack((ItemLike)Items.BRUSH)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "spyglass", new ItemStack((ItemLike)Items.SPYGLASS), "hGd", "LRS", "fP ", Character.valueOf('L'), new ItemStack((ItemLike)Items.LEATHER), Character.valueOf('G'), new MaterialEntry(TagPrefix.lens, GTMaterials.Glass), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Gold), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Copper));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("spyglass").inputItems(TagPrefix.lens, GTMaterials.Glass).inputItems(TagPrefix.ring, GTMaterials.Gold).inputItems(TagPrefix.plate, GTMaterials.Copper).inputItems(new ItemStack((ItemLike)Items.LEATHER)).outputItems(new ItemStack((ItemLike)Items.SPYGLASS)).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("recovery_compass").inputItems(new ItemStack((ItemLike)Items.COMPASS)).inputItems(TagPrefix.plate, GTMaterials.EchoShard, 8).inputItems(TagPrefix.rod, GTMaterials.EchoShard).outputItems(new ItemStack((ItemLike)Items.RECOVERY_COMPASS)).duration(400).EUt(30L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "respawn_anchor", new ItemStack((ItemLike)Items.RESPAWN_ANCHOR), "CCC", "GGG", "CCC", Character.valueOf('C'), new ItemStack((ItemLike)Items.CRYING_OBSIDIAN), Character.valueOf('G'), new MaterialEntry(TagPrefix.plate, GTMaterials.Glowstone));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("respawn_anchor").inputItems(new ItemStack((ItemLike)Items.CRYING_OBSIDIAN, 6)).inputItems(TagPrefix.plate, GTMaterials.Glowstone, 3).outputItems(new ItemStack((ItemLike)Items.RESPAWN_ANCHOR)).duration(200).EUt(120L).save(provider);
            for (DyeColor color : DyeColor.values()) {
                RecipeAddition.addBedRecipe(provider, color);
                RecipeAddition.addCarpetRecipe(provider, color);
            }
        } else {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crafting_table").duration(80).EUt(6L).circuitMeta(4).inputItems((TagKey<Item>)ItemTags.PLANKS, 4).outputItems(new ItemStack((ItemLike)Blocks.CRAFTING_TABLE)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace").circuitMeta(8).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 8).outputItems(new ItemStack((ItemLike)Blocks.FURNACE)).duration(100).EUt(GTValues.VA[0]).addMaterialInfo(true).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("enchanting_table").inputItems(new ItemStack((ItemLike)Blocks.OBSIDIAN, 4)).inputItems(TagPrefix.gem, GTMaterials.Diamond, 2).inputItems(new ItemStack((ItemLike)Items.BOOK)).outputItems(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE)).duration(100).EUt(GTValues.VA[0]).addMaterialInfo(true).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dispenser").duration(100).EUt(GTValues.VA[1]).circuitMeta(1).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 7).inputItems(new ItemStack((ItemLike)Items.BOW)).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.DISPENSER)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dropper").duration(100).EUt(GTValues.VA[1]).circuitMeta(2).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 7).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.DROPPER)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_nether_quartz").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.NetherQuartz).outputItems(new ItemStack((ItemLike)Blocks.OBSERVER)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_certus_quartz").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.CertusQuartz).outputItems(new ItemStack((ItemLike)Blocks.OBSERVER)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_quartzite").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.Quartzite).outputItems(new ItemStack((ItemLike)Blocks.OBSERVER)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lantern").duration(100).EUt(GTValues.VA[1]).inputItems(Items.TORCH).inputFluids(GTMaterials.Iron.getFluid(128)).outputItems(new ItemStack((ItemLike)Blocks.LANTERN)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tinted_glass").duration(100).EUt(GTValues.VA[1]).inputItems(Items.AMETHYST_SHARD, 2).inputItems(Items.GLASS).outputItems(new ItemStack((ItemLike)Blocks.TINTED_GLASS)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stonecutter").duration(100).EUt(GTValues.VA[1]).inputItems(Items.STONE, 3).inputFluids(GTMaterials.Iron.getFluid(144)).outputItems(new ItemStack((ItemLike)Blocks.STONECUTTER)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cartography_table").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.PLANKS, 4).inputItems(Items.PAPER, 2).outputItems(new ItemStack((ItemLike)Blocks.CARTOGRAPHY_TABLE)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fletching_table").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.PLANKS, 4).inputItems(Items.FLINT, 2).outputItems(new ItemStack((ItemLike)Blocks.FLETCHING_TABLE)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smithing_table").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.PLANKS, 4).inputFluids(GTMaterials.Iron.getFluid(288)).outputItems(new ItemStack((ItemLike)Blocks.SMITHING_TABLE)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("grindstone").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)Tags.Items.RODS_WOODEN, 2).inputItems(Items.STONE_SLAB).inputItems((TagKey<Item>)ItemTags.PLANKS, 2).outputItems(new ItemStack((ItemLike)Blocks.GRINDSTONE)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("loom").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.PLANKS, 2).inputItems(Items.STRING, 2).outputItems(new ItemStack((ItemLike)Blocks.LOOM)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smoker").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.LOGS, 4).inputItems(Items.FURNACE).outputItems(new ItemStack((ItemLike)Blocks.SMOKER)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("blast_furnace").duration(100).EUt(GTValues.VA[1]).inputItems(Items.SMOOTH_STONE, 3).inputItems(Items.FURNACE).inputFluids(GTMaterials.Iron.getFluid(720)).outputItems(new ItemStack((ItemLike)Blocks.BLAST_FURNACE)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("composter").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS, 7).outputItems(new ItemStack((ItemLike)Blocks.COMPOSTER)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lodestone").duration(100).EUt(GTValues.VA[1]).inputItems(Items.CHISELED_STONE_BRICKS, 8).inputItems(Items.NETHERITE_INGOT).outputItems(new ItemStack((ItemLike)Blocks.LODESTONE)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("scaffolding").duration(100).EUt(GTValues.VA[1]).inputItems(Items.BAMBOO, 6).inputItems(Items.STRING).outputItems(new ItemStack((ItemLike)Blocks.SCAFFOLDING, 6)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("beehive").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.PLANKS, 6).inputItems(Items.HONEYCOMB, 3).outputItems(new ItemStack((ItemLike)Blocks.BEEHIVE)).circuitMeta(7).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chiseled_bookshelf").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.PLANKS, 6).inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS, 3).outputItems(new ItemStack((ItemLike)Blocks.CHISELED_BOOKSHELF)).circuitMeta(9).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lectern").duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS, 4).inputItems(Items.BOOKSHELF).outputItems(new ItemStack((ItemLike)Blocks.LECTERN)).circuitMeta(10).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("respawn_anchor").duration(100).EUt(GTValues.VA[1]).inputItems(Items.CRYING_OBSIDIAN, 6).inputItems(Items.GLOWSTONE, 3).outputItems(new ItemStack((ItemLike)Blocks.RESPAWN_ANCHOR)).save(provider);
        }
    }

    private static void vanillaBlockRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("mud_bricks").inputItems(Items.PACKED_MUD, 1).outputItems(Items.MUD_BRICKS, 1).duration(200).EUt(4L).save(provider);
    }

    private static void addBedRecipe(Consumer<FinishedRecipe> provider, DyeColor color) {
        String colorName = color.getName();
        VanillaRecipeHelper.addShapedRecipe(provider, colorName + "_bed", new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(colorName + "_bed"))), "WWW", "PPP", "FrF", Character.valueOf('W'), BuiltInRegistries.ITEM.get(new ResourceLocation(colorName + "_carpet")), Character.valueOf('P'), ItemTags.PLANKS, Character.valueOf('F'), ItemTags.WOODEN_FENCES);
    }

    private static void addCarpetRecipe(Consumer<FinishedRecipe> provider, DyeColor color) {
        String colorName = color.getName();
        VanillaRecipeHelper.addShapedRecipe(provider, colorName + "_carpet", new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(colorName + "_carpet"))), "WW", Character.valueOf('W'), BuiltInRegistries.ITEM.get(new ResourceLocation(colorName + "_wool")));
    }

    private static void hardGlassRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "glass_pane", new ItemStack((ItemLike)Blocks.GLASS_PANE, 2), "sG", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS));
        for (DyeColor color : DyeColor.values()) {
            String dyeName = color.getName();
            VanillaRecipeHelper.addShapedRecipe(provider, dyeName + "_glass_pane", new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_stained_glass_pane")), 2), "sG", Character.valueOf('G'), BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_stained_glass")));
        }
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("tinted_glass").inputItems(new ItemStack((ItemLike)Blocks.GLASS)).inputItems(new ItemStack((ItemLike)Items.AMETHYST_SHARD, 4)).outputItems(new ItemStack((ItemLike)Blocks.TINTED_GLASS, 2)).duration(80).EUt(6L).save(provider);
    }

    private static void nerfPaperCrafting(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "paper_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Paper, 2), "SSS", " m ", Character.valueOf('S'), new ItemStack((ItemLike)Items.SUGAR_CANE));
        VanillaRecipeHelper.addShapedRecipe(provider, "sugar", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Sugar, 1), "Sm ", Character.valueOf('S'), new ItemStack((ItemLike)Items.SUGAR_CANE));
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, "paper", new ItemStack((ItemLike)Items.PAPER, 2), new Object[]{" r ", "SSS", " B ", Character.valueOf('S'), new MaterialEntry(TagPrefix.dust, GTMaterials.Paper), Character.valueOf('B'), new FluidContainerIngredient(GTMaterials.Water.getFluidTag(), 1000)});
    }

    private static void hardAdvancedIronRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_door", new ItemStack((ItemLike)Items.IRON_DOOR), "PTh", "PRS", "PPd", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.IRON_BARS), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Steel), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_door").inputItems(TagPrefix.plate, GTMaterials.Iron, 4).inputItems(new ItemStack((ItemLike)Blocks.IRON_BARS)).inputFluids(GTMaterials.Steel.getFluid(16)).outputItems(new ItemStack((ItemLike)Items.IRON_DOOR)).duration(400).EUt(GTValues.VA[0]).addMaterialInfo(true).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "anvil", new ItemStack((ItemLike)Blocks.ANVIL), "BBB", "SBS", "PBP", Character.valueOf('B'), new MaterialEntry(TagPrefix.block, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_trapdoor", new ItemStack((ItemLike)Blocks.IRON_TRAPDOOR), "SPS", "PTP", "sPd", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('T'), ItemTags.WOODEN_TRAPDOORS);
        VanillaRecipeHelper.addShapedRecipe(provider, "minecart_iron", new ItemStack((ItemLike)Items.MINECART), " h ", "PwP", "WPW", Character.valueOf('W'), GTItems.IRON_MINECART_WHEELS.asStack(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "minecart_steel", new ItemStack((ItemLike)Items.MINECART), " h ", "PwP", "WPW", Character.valueOf('W'), GTItems.STEEL_MINECART_WHEELS.asStack(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel));
    }

    private static void flintAndSteelRequireSteel(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, "flint_and_steel", new ItemStack((ItemLike)Items.FLINT_AND_STEEL), "G", "F", "S", Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Steel), Character.valueOf('F'), new ItemStack((ItemLike)Items.FLINT), Character.valueOf('S'), new MaterialEntry(TagPrefix.springSmall, GTMaterials.Steel));
    }

    private static void createShovelRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, "hPf", " S ", " S ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createPickaxeRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, "PII", "hSf", " S ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('I'), new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createAxeRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, "PIf", "PS ", "hS ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('I'), new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createSwordRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, " P ", "hPf", " S ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createHoeRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, "PIf", "hS ", " S ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('I'), new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createHelmetRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, "PPP", "PhP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material));
    }

    private static void createChestplateRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, "PhP", "PPP", "PPP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material));
    }

    private static void createLeggingsRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, "PPP", "PhP", "P P", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material));
    }

    private static void createBootsRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, regName, output, "P P", "PhP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material));
    }
}

