/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeType;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class PipeRecipeHandler {
    private PipeRecipeHandler() {
    }

    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        PipeRecipeHandler.processPipeTiny(provider, PropertyKey.FLUID_PIPE, TagPrefix.pipeTinyFluid, material);
        PipeRecipeHandler.processPipeSmall(provider, PropertyKey.FLUID_PIPE, TagPrefix.pipeSmallFluid, material);
        PipeRecipeHandler.processPipeNormal(provider, PropertyKey.FLUID_PIPE, TagPrefix.pipeNormalFluid, material);
        PipeRecipeHandler.processPipeLarge(provider, PropertyKey.FLUID_PIPE, TagPrefix.pipeLargeFluid, material);
        PipeRecipeHandler.processPipeHuge(provider, PropertyKey.FLUID_PIPE, TagPrefix.pipeHugeFluid, material);
        PipeRecipeHandler.processPipeQuadruple(provider, PropertyKey.FLUID_PIPE, TagPrefix.pipeQuadrupleFluid, material);
        PipeRecipeHandler.processPipeNonuple(provider, PropertyKey.FLUID_PIPE, TagPrefix.pipeNonupleFluid, material);
        PipeRecipeHandler.processPipeSmall(provider, PropertyKey.ITEM_PIPE, TagPrefix.pipeSmallItem, material);
        PipeRecipeHandler.processPipeNormal(provider, PropertyKey.ITEM_PIPE, TagPrefix.pipeNormalItem, material);
        PipeRecipeHandler.processPipeLarge(provider, PropertyKey.ITEM_PIPE, TagPrefix.pipeLargeItem, material);
        PipeRecipeHandler.processPipeHuge(provider, PropertyKey.ITEM_PIPE, TagPrefix.pipeHugeItem, material);
        PipeRecipeHandler.processRestrictivePipe(provider, PropertyKey.ITEM_PIPE, TagPrefix.pipeSmallRestrictive, TagPrefix.pipeSmallItem, material);
        PipeRecipeHandler.processRestrictivePipe(provider, PropertyKey.ITEM_PIPE, TagPrefix.pipeNormalRestrictive, TagPrefix.pipeNormalItem, material);
        PipeRecipeHandler.processRestrictivePipe(provider, PropertyKey.ITEM_PIPE, TagPrefix.pipeLargeRestrictive, TagPrefix.pipeLargeItem, material);
        PipeRecipeHandler.processRestrictivePipe(provider, PropertyKey.ITEM_PIPE, TagPrefix.pipeHugeRestrictive, TagPrefix.pipeHugeItem, material);
        PipeRecipeHandler.addDuctRecipes(provider, GTMaterials.Steel, 2);
        PipeRecipeHandler.addDuctRecipes(provider, GTMaterials.StainlessSteel, 4);
        PipeRecipeHandler.addDuctRecipes(provider, GTMaterials.TungstenSteel, 8);
    }

    private static void processRestrictivePipe(@NotNull Consumer<FinishedRecipe> provider, @NotNull PropertyKey<?> propertyKey, @NotNull TagPrefix prefix, @NotNull TagPrefix unrestrictive, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(propertyKey)) {
            return;
        }
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_" + prefix.name).inputItems(unrestrictive, material).inputItems(TagPrefix.ring, GTMaterials.Iron, 2).outputItems(prefix, material).duration(20).EUt(GTValues.VA[0]).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, FormattingUtil.toLowerCaseUnderscore(String.valueOf(prefix) + "_" + material.getName()), ChemicalHelper.get(prefix, material), "PR", "Rh", Character.valueOf('P'), new MaterialEntry(unrestrictive, material), Character.valueOf('R'), ChemicalHelper.get(TagPrefix.ring, GTMaterials.Iron));
    }

    private static void processPipeTiny(@NotNull Consumer<FinishedRecipe> provider, @NotNull PropertyKey<?> propertyKey, @NotNull TagPrefix prefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(propertyKey)) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(prefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_tiny_pipe").inputItems(TagPrefix.ingot, material, 1).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_TINY).outputItems(pipeStack.copyWithCount(2)).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_tiny_pipe").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_TINY_PIPE).inputFluids(material.getFluid(72)).outputItems(pipeStack).duration((int)material.getMass() / 2).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_tiny_pipe_dust").inputItems(TagPrefix.dust, material, 1).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_TINY).outputItems(pipeStack.copyWithCount(2)).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("tiny_%s_pipe", material.getName()), pipeStack.copyWithCount(2), " s ", "hXw", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material));
        }
    }

    private static void processPipeSmall(@NotNull Consumer<FinishedRecipe> provider, @NotNull PropertyKey<?> propertyKey, @NotNull TagPrefix prefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(propertyKey)) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(prefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_small_pipe").inputItems(TagPrefix.ingot, material, 1).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_SMALL).outputItems(pipeStack).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_small_pipe").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_SMALL_PIPE).inputFluids(material.getFluid(144)).outputItems(pipeStack).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_small_pipe_dust").inputItems(TagPrefix.dust, material, 1).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_SMALL).outputItems(pipeStack).duration((int)material.getMass()).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("small_%s_pipe", material.getName()), pipeStack, "wXh", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material));
        }
    }

    private static void processPipeNormal(@NotNull Consumer<FinishedRecipe> provider, @NotNull PropertyKey<?> propertyKey, @NotNull TagPrefix prefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(propertyKey)) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(prefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_pipe").inputItems(TagPrefix.ingot, material, 3).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_NORMAL).outputItems(pipeStack).duration((int)material.getMass() * 3).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_normal_pipe").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_NORMAL_PIPE).inputFluids(material.getFluid(432)).outputItems(pipeStack).duration((int)material.getMass() * 3).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_pipe_dust").inputItems(TagPrefix.dust, material, 3).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_NORMAL).outputItems(pipeStack).duration((int)material.getMass() * 3).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("medium_%s_pipe", material.getName()), pipeStack, "XXX", "w h", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material));
        }
    }

    private static void processPipeLarge(@NotNull Consumer<FinishedRecipe> provider, @NotNull PropertyKey<?> propertyKey, @NotNull TagPrefix prefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(propertyKey)) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(prefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_large_pipe").inputItems(TagPrefix.ingot, material, 6).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_LARGE).outputItems(pipeStack).duration((int)material.getMass() * 6).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_large_pipe").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_LARGE_PIPE).inputFluids(material.getFluid(864)).outputItems(pipeStack).duration((int)material.getMass() * 6).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_large_pipe_dust").inputItems(TagPrefix.dust, material, 6).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_LARGE).outputItems(pipeStack).duration((int)material.getMass() * 6).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("large_%s_pipe", material.getName()), pipeStack, "XXX", "w h", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material));
        }
    }

    private static void processPipeHuge(@NotNull Consumer<FinishedRecipe> provider, @NotNull PropertyKey<?> propertyKey, @NotNull TagPrefix prefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(propertyKey)) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack pipeStack = ChemicalHelper.get(prefix, material);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_huge_pipe").inputItems(TagPrefix.ingot, material, 12).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_HUGE).outputItems(pipeStack).duration((int)material.getMass() * 24).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_huge_pipe").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_HUGE_PIPE).inputFluids(material.getFluid(1728)).outputItems(pipeStack).duration((int)material.getMass() * 24).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_huge_pipe_dust").inputItems(TagPrefix.dust, material, 12).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PIPE_HUGE).outputItems(pipeStack).duration((int)material.getMass() * 24).EUt(6L * (long)PipeRecipeHandler.getVoltageMultiplier(material)).save(provider);
        } else if (TagPrefix.plateDouble.doGenerateItem(material)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("huge_%s_pipe", material.getName()), pipeStack, "XXX", "w h", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.plateDouble, material));
        }
    }

    private static void processPipeQuadruple(@NotNull Consumer<FinishedRecipe> provider, @NotNull PropertyKey<?> propertyKey, @NotNull TagPrefix prefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(propertyKey)) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack smallPipe = ChemicalHelper.get(TagPrefix.pipeSmallFluid, material);
        ItemStack quadPipe = ChemicalHelper.get(prefix, material);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("quadruple_%s_pipe", material.getName()), quadPipe, "XX", "XX", Character.valueOf('X'), smallPipe);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_quadruple_pipe").inputItems(smallPipe.copyWithCount(4)).circuitMeta(4).outputItems(quadPipe).duration(30).EUt(GTValues.VA[0]).save(provider);
    }

    private static void processPipeNonuple(@NotNull Consumer<FinishedRecipe> provider, @NotNull PropertyKey<?> propertyKey, @NotNull TagPrefix prefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(propertyKey)) {
            return;
        }
        if (material.hasProperty(PropertyKey.WOOD)) {
            return;
        }
        ItemStack smallPipe = ChemicalHelper.get(TagPrefix.pipeSmallFluid, material);
        ItemStack nonuplePipe = ChemicalHelper.get(prefix, material);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("nonuple_%s_pipe", material.getName()), nonuplePipe, "XXX", "XXX", "XXX", Character.valueOf('X'), smallPipe);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_nonuple_pipe").inputItems(smallPipe.copyWithCount(9)).circuitMeta(9).outputItems(nonuplePipe).duration(40).EUt(GTValues.VA[0]).save(provider);
    }

    private static void addDuctRecipes(Consumer<FinishedRecipe> provider, Material material, int outputAmount) {
        VanillaRecipeHelper.addShapedRecipe(provider, "small_duct_%s".formatted(material.getName()), GTBlocks.DUCT_PIPES[DuctPipeType.SMALL.ordinal()].asStack(outputAmount * 2), "w", "X", "h", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material));
        VanillaRecipeHelper.addShapedRecipe(provider, "medium_duct_%s".formatted(material.getName()), GTBlocks.DUCT_PIPES[DuctPipeType.NORMAL.ordinal()].asStack(outputAmount), " X ", "wXh", " X ", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material));
        VanillaRecipeHelper.addShapedRecipe(provider, "large_duct_%s".formatted(material.getName()), GTBlocks.DUCT_PIPES[DuctPipeType.LARGE.ordinal()].asStack(outputAmount), "XwX", "X X", "XhX", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material));
        VanillaRecipeHelper.addShapedRecipe(provider, "huge_duct_%s".formatted(material.getName()), GTBlocks.DUCT_PIPES[DuctPipeType.HUGE.ordinal()].asStack(outputAmount), "XwX", "X X", "XhX", Character.valueOf('X'), new MaterialEntry(TagPrefix.plateDouble, material));
    }

    private static int getVoltageMultiplier(Material material) {
        if (material.hasProperty(PropertyKey.POLYMER)) {
            return 4;
        }
        return material.getBlastTemperature() >= 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

