/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class PolarizingRecipeHandler {
    private static final TagPrefix[] POLARIZING_PREFIXES = new TagPrefix[]{TagPrefix.rod, TagPrefix.rodLong, TagPrefix.plate, TagPrefix.ingot, TagPrefix.plateDense, TagPrefix.plateDouble, TagPrefix.rotor, TagPrefix.bolt, TagPrefix.screw, TagPrefix.wireFine, TagPrefix.foil, TagPrefix.ring, TagPrefix.dust, TagPrefix.nugget, TagPrefix.block, TagPrefix.dustTiny, TagPrefix.dustSmall};

    private PolarizingRecipeHandler() {
    }

    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        IngotProperty property = material.getProperty(PropertyKey.INGOT);
        if (property == null) {
            return;
        }
        for (TagPrefix prefix : POLARIZING_PREFIXES) {
            PolarizingRecipeHandler.processPolarizing(provider, property, prefix, material);
        }
    }

    private static void processPolarizing(@NotNull Consumer<FinishedRecipe> provider, @NotNull IngotProperty property, @NotNull TagPrefix prefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material magneticMaterial = property.getMagneticMaterial();
        if (!magneticMaterial.isNull() && (prefix.doGenerateBlock(magneticMaterial) || prefix.doGenerateItem(magneticMaterial))) {
            ItemStack magneticStack = ChemicalHelper.get(prefix, magneticMaterial);
            GTRecipeTypes.POLARIZER_RECIPES.recipeBuilder("polarize_" + material.getName() + "_" + prefix.name).inputItems(prefix, material).outputItems(magneticStack).duration((int)((long)((int)material.getMass()) * prefix.getMaterialAmount(material) / 3628800L)).EUt(PolarizingRecipeHandler.getVoltageMultiplier(material)).save(provider);
            VanillaRecipeHelper.addSmeltingRecipe(provider, "demagnetize_" + magneticMaterial.getName() + "_" + String.valueOf(prefix), ChemicalHelper.getTag(prefix, magneticMaterial), ChemicalHelper.get(prefix, material));
        }
    }

    private static int getVoltageMultiplier(@NotNull Material material) {
        if (material == GTMaterials.Steel || material == GTMaterials.Iron) {
            return GTValues.VH[1];
        }
        if (material == GTMaterials.Neodymium) {
            return GTValues.VH[3];
        }
        if (material == GTMaterials.Samarium) {
            return GTValues.VH[5];
        }
        return material.getBlastTemperature() >= 1200 ? GTValues.VA[1] : 2;
    }
}

