/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public final class ToolRecipeHandler {
    public static final Int2ReferenceMap<ItemEntry<? extends Item>> powerUnitItems = new Int2ReferenceArrayMap(GTValues.tiersBetween(1, 5), (Object[])new ItemEntry[]{GTItems.POWER_UNIT_LV, GTItems.POWER_UNIT_MV, GTItems.POWER_UNIT_HV, GTItems.POWER_UNIT_EV, GTItems.POWER_UNIT_IV});
    public static final Material[] softMaterials = new Material[]{GTMaterials.Wood, GTMaterials.Rubber, GTMaterials.Polyethylene, GTMaterials.Polytetrafluoroethylene, GTMaterials.Polybenzimidazole, GTMaterials.SiliconeRubber, GTMaterials.StyreneButadieneRubber};

    private ToolRecipeHandler() {
    }

    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        ToolProperty property = material.getProperty(PropertyKey.TOOL);
        if (property == null) {
            return;
        }
        ToolRecipeHandler.processTool(provider, material);
        ToolRecipeHandler.processElectricTool(provider, property, material);
    }

    private static void processTool(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.plate)) {
            return;
        }
        ItemStack stick = new ItemStack((ItemLike)Items.STICK);
        MaterialEntry plate = new MaterialEntry(TagPrefix.plate, material);
        MaterialEntry ingot = new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material);
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.MINING_HAMMER, true, "PPf", "PPS", "PPh", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SPADE, false, "fPh", "PSP", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SAW, false, "PPS", "fhS", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.AXE, false, "PIh", "PS ", "fS ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.HOE, false, "PIh", "fS ", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.PICKAXE, false, "PII", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SCYTHE, false, "PPI", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SHOVEL, false, "fPh", " S ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SWORD, false, " P ", "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.HARD_HAMMER, true, "II ", "IIS", "II ", Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.FILE, true, " P ", " P ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.KNIFE, false, "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.WRENCH, false, "PhP", " P ", " P ", Character.valueOf('P'), plate);
            ToolRecipeHandler.addArmorRecipe(provider, material, ArmorItem.Type.HELMET, "PPP", "PhP", Character.valueOf('P'), plate);
            ToolRecipeHandler.addArmorRecipe(provider, material, ArmorItem.Type.CHESTPLATE, "PhP", "PPP", "PPP", Character.valueOf('P'), plate);
            ToolRecipeHandler.addArmorRecipe(provider, material, ArmorItem.Type.LEGGINGS, "PPP", "PhP", "P P", Character.valueOf('P'), plate);
            ToolRecipeHandler.addArmorRecipe(provider, material, ArmorItem.Type.BOOTS, "P P", "PhP", Character.valueOf('P'), plate);
        } else {
            GTCEu.LOGGER.info("Did not find plate for {}, skipping mining hammer, spade, saw, axe, hoe, pickaxe, scythe, shovel, sword, hammer, file, knife, wrench recipes", (Object)material.getName());
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            MaterialEntry rod = new MaterialEntry(TagPrefix.rod, material);
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
                ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.BUTCHERY_KNIFE, false, "PPf", "PP ", "Sh ", Character.valueOf('P'), plate, Character.valueOf('S'), rod);
                if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
                    ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.WIRE_CUTTER, false, "PfP", "hPd", "STS", Character.valueOf('P'), plate, Character.valueOf('T'), new MaterialEntry(TagPrefix.screw, material), Character.valueOf('S'), rod);
                } else if (!ArrayUtils.contains((Object[])softMaterials, (Object)material)) {
                    GTCEu.LOGGER.info("Did not find bolt for {}, skipping wirecutter recipe", (Object)material.getName());
                }
            } else {
                GTCEu.LOGGER.info("Did not find plate for {}, skipping wirecutter, butchery knife recipes", (Object)material.getName());
            }
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SCREWDRIVER, true, " fS", " Sh", "W  ", Character.valueOf('S'), rod, Character.valueOf('W'), stick);
            ToolRecipeHandler.addDyeableToolRecipe(provider, material, GTToolType.CROWBAR, true, "hDS", "DSD", "SDf", Character.valueOf('S'), rod);
        } else if (!ArrayUtils.contains((Object[])softMaterials, (Object)material)) {
            GTCEu.LOGGER.warn("Did not find rod for " + material.getName() + ", skipping wirecutter, butchery knife, screwdriver, crowbar recipes");
        }
    }

    private static void processElectricTool(@NotNull Consumer<FinishedRecipe> provider, @NotNull ToolProperty property, @NotNull Material material) {
        TagPrefix toolPrefix;
        int voltageMultiplier;
        if (!material.shouldGenerateRecipesFor(TagPrefix.plate)) {
            return;
        }
        int n = voltageMultiplier = material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            MaterialEntry plate = new MaterialEntry(TagPrefix.plate, material);
            MaterialEntry steelPlate = new MaterialEntry(TagPrefix.plate, GTMaterials.Steel);
            MaterialEntry steelRing = new MaterialEntry(TagPrefix.ring, GTMaterials.Steel);
            if (property.hasType(GTToolType.DRILL_LV)) {
                toolPrefix = TagPrefix.toolHeadDrill;
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("drill_head_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "XSX", "XSX", "ShS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate);
                ToolRecipeHandler.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{GTToolType.DRILL_LV, GTToolType.DRILL_MV, GTToolType.DRILL_HV, GTToolType.DRILL_EV, GTToolType.DRILL_IV}, material);
            }
            if (property.hasType(GTToolType.CHAINSAW_LV)) {
                toolPrefix = TagPrefix.toolHeadChainsaw;
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("chainsaw_head_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "SRS", "XhX", "SRS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate, Character.valueOf('R'), steelRing);
                ToolRecipeHandler.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{GTToolType.CHAINSAW_LV}, material);
            }
            if (property.hasType(GTToolType.WRENCH_LV)) {
                toolPrefix = TagPrefix.toolHeadWrench;
                ToolRecipeHandler.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{GTToolType.WRENCH_LV, GTToolType.WRENCH_HV, GTToolType.WRENCH_IV}, material);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("wrench_head_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "hXW", "XRX", "WXd", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('W'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel));
            }
            if (property.hasType(GTToolType.WIRE_CUTTER_LV)) {
                toolPrefix = TagPrefix.toolHeadWireCutter;
                ToolRecipeHandler.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{GTToolType.WIRE_CUTTER_LV, GTToolType.WIRE_CUTTER_HV, GTToolType.WIRE_CUTTER_IV}, material);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("wirecutter_head_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "XfX", "X X", "SRS", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel));
            }
            if (property.hasType(GTToolType.BUZZSAW)) {
                toolPrefix = TagPrefix.toolHeadBuzzSaw;
                ToolRecipeHandler.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{GTToolType.BUZZSAW}, material);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("buzzsaw_blade_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "sXh", "X X", "fXx", Character.valueOf('X'), plate);
                if (material.hasFlag(MaterialFlags.GENERATE_GEAR)) {
                    GTRecipeTypes.LATHE_RECIPES.recipeBuilder("buzzsaw_gear_" + material.getName()).inputItems(TagPrefix.gear, material).outputItems(toolPrefix, material).duration((int)material.getMass() * 4).EUt(8L * (long)voltageMultiplier).save(provider);
                } else {
                    GTCEu.LOGGER.warn("Did not find gear for " + material.getName() + ", skipping gear -> buzzsaw blade recipe");
                }
            }
        } else {
            GTCEu.LOGGER.warn("Did not find plate for " + material.getName() + ", skipping electric drill, chainsaw, wrench, wirecutter, buzzsaw recipe");
        }
        if (property.hasType(GTToolType.SCREWDRIVER_LV)) {
            if (material.hasFlag(MaterialFlags.GENERATE_LONG_ROD)) {
                toolPrefix = TagPrefix.toolHeadScrewdriver;
                ToolRecipeHandler.addElectricToolRecipe(provider, toolPrefix, new GTToolType[]{GTToolType.SCREWDRIVER_LV}, material);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("screwdriver_tip_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "fR", " h", Character.valueOf('R'), new MaterialEntry(TagPrefix.rodLong, material));
            } else {
                GTCEu.LOGGER.warn("Did not find long rod for " + material.getName() + ", skipping electric screwdriver recipe");
            }
        }
    }

    private static void addElectricToolRecipe(@NotNull Consumer<FinishedRecipe> provider, @NotNull TagPrefix toolHead, @NotNull @NotNull GTToolType @NotNull [] toolItems, @NotNull Material material) {
        for (GTToolType toolType : toolItems) {
            if (!material.getProperty(PropertyKey.TOOL).hasType(toolType)) continue;
            int tier = toolType.electricTier;
            ItemStack powerUnitStack = ((ItemEntry)powerUnitItems.get(tier)).asStack();
            IElectricItem powerUnit = GTCapabilityHelper.getElectricItem(powerUnitStack);
            ItemStack tool = ((IGTTool)((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)material, (Object)toolType)).get()).get(0L, powerUnit.getMaxCharge());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, true, true, String.format("%s_%s", material.getName(), toolType.name), Ingredient.of((ItemStack[])new ItemStack[]{powerUnitStack}), tool, "wHd", " U ", Character.valueOf('H'), new MaterialEntry(toolHead, material), Character.valueOf('U'), powerUnitStack);
        }
    }

    public static void addToolRecipe(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material, @NotNull GTToolType tool, boolean mirrored, Object ... recipe) {
        ItemStack toolStack = ToolHelper.get(tool, material);
        if (toolStack.isEmpty()) {
            return;
        }
        if (mirrored) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", tool.name, material.getName()), toolStack, recipe);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", tool.name, material.getName()), toolStack, recipe);
        }
    }

    public static void addArmorRecipe(Consumer<FinishedRecipe> provider, @NotNull Material material, @NotNull ArmorItem.Type armor, Object ... recipe) {
        ItemStack armorStack = ToolHelper.getArmor(armor, material);
        if (armorStack.isEmpty()) {
            return;
        }
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", armor.getName(), material.getName()), armorStack, recipe);
    }

    public static void addDyeableToolRecipe(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material, @NotNull GTToolType tool, boolean mirrored, Object ... recipe) {
        ItemStack toolStack = ToolHelper.get(tool, material);
        if (toolStack.isEmpty()) {
            return;
        }
        for (Map.Entry color : MarkerMaterials.Color.COLORS.entrySet()) {
            ToolHelper.getToolTag(toolStack).putInt("TintColor", ((DyeColor)color.getKey()).getTextColor());
            Object[] recipeWithDye = ArrayUtils.addAll((Object[])recipe, (Object[])new Object[]{Character.valueOf('D'), new MaterialEntry(TagPrefix.dye, (Material)color.getValue())});
            if (mirrored) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s_%s", tool.name, material.getName(), ((DyeColor)color.getKey()).getSerializedName()), toolStack, recipeWithDye);
                continue;
            }
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s_%s", tool.name, material.getName(), ((DyeColor)color.getKey()).getSerializedName()), toolStack, recipeWithDye);
        }
    }
}

