/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class FuelRecipes {
    public static void init(Consumer<FinishedRecipe> provider) {
        HashSet<Item> addedItems = new HashSet<Item>();
        for (Map.Entry fuelEntry : FurnaceBlockEntity.getFuel().entrySet()) {
            addedItems.add((Item)fuelEntry.getKey());
            ResourceLocation resLoc = BuiltInRegistries.ITEM.getKey((Object)((Item)fuelEntry.getKey()));
            GTRecipeTypes.STEAM_BOILER_RECIPES.recipeBuilder(GTCEu.id(resLoc.getNamespace() + "_" + resLoc.getPath())).inputItems((Item)fuelEntry.getKey()).duration((Integer)fuelEntry.getValue() * 12).save(provider);
        }
        for (Item item : BuiltInRegistries.ITEM) {
            int burnTime = GTUtil.getItemBurnTime(item);
            if (burnTime <= 0 || addedItems.contains(item)) continue;
            ResourceLocation resLoc = BuiltInRegistries.ITEM.getKey((Object)item);
            GTRecipeTypes.STEAM_BOILER_RECIPES.recipeBuilder(GTCEu.id(resLoc.getNamespace() + "_" + resLoc.getPath())).inputItems(item).duration(burnTime * 12).save(provider);
        }
        GTRecipeTypes.STEAM_BOILER_RECIPES.recipeBuilder("lava").inputFluids(new FluidStack((Fluid)Fluids.LAVA, 100)).duration(1200).save(provider);
        GTRecipeTypes.STEAM_BOILER_RECIPES.recipeBuilder("creosote").inputFluids(GTMaterials.Creosote.getFluid(250)).duration(3000).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("creosote").inputFluids(GTMaterials.Creosote.getFluid(160)).duration(10).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("biomass").inputFluids(GTMaterials.Biomass.getFluid(40)).duration(10).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("oil").inputFluids(GTMaterials.Oil.getFluid(200)).duration(10).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("oil_heavy").inputFluids(GTMaterials.OilHeavy.getFluid(32)).duration(10).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("sulfuric_heavy_fuel").inputFluids(GTMaterials.SulfuricHeavyFuel.getFluid(32)).duration(10).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("heavy_fuel").inputFluids(GTMaterials.HeavyFuel.getFluid(16)).duration(30).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("fish_oil").inputFluids(GTMaterials.FishOil.getFluid(160)).duration(10).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("naphtha").inputFluids(GTMaterials.Naphtha.getFluid(1)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("sulfuric_light_fuel").inputFluids(GTMaterials.SulfuricLightFuel.getFluid(4)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("methanol").inputFluids(GTMaterials.Methanol.getFluid(4)).duration(8).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("ethanol").inputFluids(GTMaterials.Ethanol.getFluid(1)).duration(6).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("octane").inputFluids(GTMaterials.Octane.getFluid(2)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("biodiesel").inputFluids(GTMaterials.BioDiesel.getFluid(1)).duration(8).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("light_fuel").inputFluids(GTMaterials.LightFuel.getFluid(1)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("diesel").inputFluids(GTMaterials.Diesel.getFluid(1)).duration(15).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("cetane_diesel").inputFluids(GTMaterials.CetaneBoostedDiesel.getFluid(2)).duration(45).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("rocket_fuel").inputFluids(GTMaterials.RocketFuel.getFluid(16)).duration(125).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("gasoline").inputFluids(GTMaterials.Gasoline.getFluid(1)).duration(50).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("high_octane_gasoline").inputFluids(GTMaterials.HighOctaneGasoline.getFluid(1)).duration(100).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("toluene").inputFluids(GTMaterials.Toluene.getFluid(1)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("light_oil").inputFluids(GTMaterials.OilLight.getFluid(32)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("raw_oil").inputFluids(GTMaterials.RawOil.getFluid(64)).duration(15).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.STEAM_TURBINE_FUELS.recipeBuilder("steam").inputFluids(GTMaterials.Steam.getFluid(640)).outputFluids(GTMaterials.DistilledWater.getFluid(4)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("natural_gas").inputFluids(GTMaterials.NaturalGas.getFluid(8)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("wood_gas").inputFluids(GTMaterials.WoodGas.getFluid(8)).duration(6).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("sulfuric_gas").inputFluids(GTMaterials.SulfuricGas.getFluid(32)).duration(25).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("sulfuric_naphtha").inputFluids(GTMaterials.SulfuricNaphtha.getFluid(4)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("coal_gas").inputFluids(GTMaterials.CoalGas.getFluid(1)).duration(3).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("methane").inputFluids(GTMaterials.Methane.getFluid(2)).duration(7).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("ethylene").inputFluids(GTMaterials.Ethylene.getFluid(1)).duration(4).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("refinery_gas").inputFluids(GTMaterials.RefineryGas.getFluid(1)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("ethane").inputFluids(GTMaterials.Ethane.getFluid(4)).duration(21).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("propene").inputFluids(GTMaterials.Propene.getFluid(1)).duration(6).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("butadiene").inputFluids(GTMaterials.Butadiene.getFluid(16)).duration(102).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("propane").inputFluids(GTMaterials.Propane.getFluid(4)).duration(29).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("butene").inputFluids(GTMaterials.Butene.getFluid(1)).duration(8).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("phenol").inputFluids(GTMaterials.Phenol.getFluid(1)).duration(9).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("benzene").inputFluids(GTMaterials.Benzene.getFluid(1)).duration(11).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("butane").inputFluids(GTMaterials.Butane.getFluid(4)).duration(37).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("lpg").inputFluids(GTMaterials.LPG.getFluid(1)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("nitrobenzene").inputFluids(GTMaterials.Nitrobenzene.getFluid(1)).duration(40).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("helium").inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Helium.getFluid(1)).duration(40).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("oxygen").inputFluids(GTMaterials.Oxygen.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Oxygen.getFluid(1)).duration(48).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("nitrogen").inputFluids(GTMaterials.Nitrogen.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Nitrogen.getFluid(1)).duration(64).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("argon").inputFluids(GTMaterials.Argon.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Argon.getFluid(1)).duration(96).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("iron").inputFluids(GTMaterials.Iron.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Iron.getFluid(1)).duration(112).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("tin").inputFluids(GTMaterials.Tin.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Tin.getFluid(1)).duration(128).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("nickel").inputFluids(GTMaterials.Nickel.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Nickel.getFluid(1)).duration(192).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("americium").inputFluids(GTMaterials.Americium.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Americium.getFluid(1)).duration(320).EUt(-GTValues.V[4]).save(provider);
    }
}

