/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidContainerIngredient;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class VanillaStandardRecipes {
    public static void init(Consumer<FinishedRecipe> provider) {
        VanillaStandardRecipes.compressingRecipes(provider);
        VanillaStandardRecipes.glassRecipes(provider);
        VanillaStandardRecipes.smashingRecipes(provider);
        VanillaStandardRecipes.woodRecipes(provider);
        VanillaStandardRecipes.cuttingRecipes(provider);
        VanillaStandardRecipes.dyingCleaningRecipes(provider);
        VanillaStandardRecipes.redstoneRecipes(provider);
        VanillaStandardRecipes.metalRecipes(provider);
        VanillaStandardRecipes.miscRecipes(provider);
        VanillaStandardRecipes.mixingRecipes(provider);
        VanillaStandardRecipes.dyeRecipes(provider);
    }

    private static void compressingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("stone_from_dust").duration(300).EUt(2L).inputItems(TagPrefix.plate, GTMaterials.Stone, 9).outputItems(new ItemStack((ItemLike)Blocks.STONE)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("sandstone").duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Blocks.SAND, 4)).outputItems(new ItemStack((ItemLike)Blocks.SANDSTONE)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("red_sandstone").duration(300).EUt(2L).inputItems((Object)new ItemStack((ItemLike)Blocks.RED_SAND), 4).outputItems(new ItemStack((ItemLike)Blocks.RED_SANDSTONE)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("bricks").duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.BRICK, 4)).outputItems(new ItemStack((ItemLike)Blocks.BRICKS)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("nether_bricks").duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.NETHER_BRICK, 4)).outputItems(new ItemStack((ItemLike)Blocks.NETHER_BRICKS)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("ice_from_snow").duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Blocks.SNOW)).outputItems(new ItemStack((ItemLike)Blocks.ICE)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("clay").duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.CLAY_BALL, 4)).outputItems(new ItemStack((ItemLike)Blocks.CLAY)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("snowballs_to_snow").duration(200).EUt(2L).inputItems(new ItemStack((ItemLike)Items.SNOWBALL, 4)).outputItems(new ItemStack((ItemLike)Items.SNOW_BLOCK)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("glowstone").duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 4)).outputItems(new ItemStack((ItemLike)Blocks.GLOWSTONE)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("packed_ice").inputItems(new ItemStack((ItemLike)Blocks.ICE, 9)).outputItems(new ItemStack((ItemLike)Blocks.PACKED_ICE)).duration(300).EUt(2L).addMaterialInfo(true).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("blue_ice").inputItems(new ItemStack((ItemLike)Blocks.PACKED_ICE, 9)).outputItems(new ItemStack((ItemLike)Blocks.BLUE_ICE)).duration(300).EUt(2L).addMaterialInfo(true).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("ice_from_dust").inputItems(TagPrefix.dust, GTMaterials.Ice).outputItems(new ItemStack((ItemLike)Blocks.ICE)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("dripstone_block_from_pointed_dripstone").inputItems(new ItemStack((ItemLike)Items.POINTED_DRIPSTONE, 4)).outputItems(new ItemStack((ItemLike)Blocks.DRIPSTONE_BLOCK)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("pointed_dripstone_from_dripstone_block").inputItems(new ItemStack((ItemLike)Blocks.DRIPSTONE_BLOCK)).outputItems(new ItemStack((ItemLike)Items.POINTED_DRIPSTONE, 4)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("hay_block").inputItems(new ItemStack((ItemLike)Items.WHEAT, 9)).circuitMeta(8).outputItems(new ItemStack((ItemLike)Blocks.HAY_BLOCK)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("wheat").inputItems(new ItemStack((ItemLike)Blocks.HAY_BLOCK)).outputItems(new ItemStack((ItemLike)Items.WHEAT, 9)).circuitMeta(9).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("wheat_from_hay_block").inputItems(new ItemStack((ItemLike)Blocks.HAY_BLOCK)).outputItems(new ItemStack((ItemLike)Items.WHEAT, 9)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("melon").inputItems(new ItemStack((ItemLike)Items.MELON_SLICE, 9)).circuitMeta(9).outputItems(new ItemStack((ItemLike)Blocks.MELON)).duration(200).EUt(2L).save(provider);
    }

    private static void glassRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "glass_dust_hammer", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Glass), "hG", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.GLASS));
        VanillaRecipeHelper.addShapedRecipe(provider, "quartz_sand", ChemicalHelper.get(TagPrefix.dust, GTMaterials.QuartzSand), "S", "m", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.SAND));
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("quartz_sand_from_sand").inputItems(new ItemStack((ItemLike)Blocks.SAND)).outputItems(TagPrefix.dust, GTMaterials.QuartzSand).duration(30).EUt(2L).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, "glass_dust_flint", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Glass), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dustTiny, GTMaterials.Flint));
        VanillaRecipeHelper.addShapelessRecipe(provider, "glass_full_dust_flint", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Glass, 8), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.Flint));
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("glass_from_quartzite").duration(160).EUt(GTValues.VA[0]).inputItems(TagPrefix.dustSmall, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.Quartzite, 4).outputItems(TagPrefix.dust, GTMaterials.Glass, 5).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("full_dust_glass_from_quartzite").duration(640).EUt(GTValues.VA[0]).inputItems(TagPrefix.dust, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.Quartzite, 16).outputItems(TagPrefix.dust, GTMaterials.Glass, 20).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("glass_from_quartz_sand").duration(200).EUt(GTValues.VA[0]).inputItems(TagPrefix.dustSmall, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.QuartzSand, 4).outputItems(TagPrefix.dust, GTMaterials.Glass, 4).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("full_dust_glass_from_sand").duration(800).EUt(GTValues.VA[0]).inputItems(TagPrefix.dust, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.QuartzSand, 16).outputItems(TagPrefix.dust, GTMaterials.Glass, 16).save(provider);
        GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("glass_from_sand").duration(20).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.SMELTS_TO_GLASS).outputItems(new ItemStack((ItemLike)Blocks.GLASS, 2)).save(provider);
        GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("form_glass").duration(80).EUt(GTValues.VA[1]).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(new ItemStack((ItemLike)Blocks.GLASS)).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("glass_bottle").duration(64).EUt(4L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BOTTLE).outputItems(new ItemStack((ItemLike)Items.GLASS_BOTTLE)).addMaterialInfo(true).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("glass_bottle").duration(32).EUt(16L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_BOTTLE).outputItems(new ItemStack((ItemLike)Items.GLASS_BOTTLE)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("glass_bottle").duration(12).EUt(4L).inputFluids(GTMaterials.Glass.getFluid(144)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BOTTLE).outputItems(new ItemStack((ItemLike)Items.GLASS_BOTTLE)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_glass_block").duration(12).EUt(4L).inputFluids(GTMaterials.Glass.getFluid(144)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(new ItemStack((ItemLike)Blocks.GLASS)).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("glass").duration(120).EUt(16L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(new ItemStack((ItemLike)Blocks.GLASS, 1)).save(provider);
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_glass_block_to_plate").duration(50).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.GLASS, 3)).outputItems(new ItemStack((ItemLike)Blocks.GLASS_PANE, 8)).addMaterialInfo(true).save(provider);
    }

    private static void smashingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("cobblestone_to_gravel").inputItems((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS).outputItems(new ItemStack((ItemLike)Blocks.GRAVEL)).EUt(16L).duration(10).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("gravel_to_sand").inputItems(new ItemStack((ItemLike)Blocks.GRAVEL)).outputItems(new ItemStack((ItemLike)Blocks.SAND)).EUt(16L).duration(10).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("gravel_to_flint").inputItems(new ItemStack((ItemLike)Blocks.GRAVEL, 1)).outputItems(TagPrefix.dust, GTMaterials.Stone).chancedOutput(new ItemStack((ItemLike)Items.FLINT), 3300, 0).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("sandstone_to_sand").inputItems(new ItemStack((ItemLike)Blocks.SANDSTONE)).outputItems(new ItemStack((ItemLike)Blocks.SAND)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("smooth_sandstone_to_sand").inputItems(new ItemStack((ItemLike)Blocks.SMOOTH_SANDSTONE)).outputItems(new ItemStack((ItemLike)Blocks.SAND)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("chiseled_sandstone_to_sand").inputItems(new ItemStack((ItemLike)Blocks.CHISELED_SANDSTONE)).outputItems(new ItemStack((ItemLike)Blocks.SAND)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("red_sandstone_to_red_sand").inputItems(new ItemStack((ItemLike)Blocks.RED_SANDSTONE)).outputItems(new ItemStack((ItemLike)Blocks.RED_SAND)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("smooth_red_sandstone_to_red_sand").inputItems(new ItemStack((ItemLike)Blocks.SMOOTH_RED_SANDSTONE)).outputItems(new ItemStack((ItemLike)Blocks.RED_SAND)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("chiseled_red_sandstone_to_red_sand").inputItems(new ItemStack((ItemLike)Blocks.CHISELED_RED_SANDSTONE)).outputItems(new ItemStack((ItemLike)Blocks.RED_SAND)).EUt(2L).duration(400).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, "clay_block_to_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Clay), Character.valueOf('m'), Blocks.CLAY);
        VanillaRecipeHelper.addShapelessRecipe(provider, "clay_ball_to_dust", ChemicalHelper.get(TagPrefix.dustSmall, GTMaterials.Clay), Character.valueOf('m'), Items.CLAY_BALL);
        VanillaRecipeHelper.addShapelessRecipe(provider, "brick_block_to_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Brick), Character.valueOf('m'), Blocks.BRICKS);
        VanillaRecipeHelper.addShapelessRecipe(provider, "brick_to_dust", ChemicalHelper.get(TagPrefix.dustSmall, GTMaterials.Brick), Character.valueOf('m'), Items.BRICK);
        VanillaRecipeHelper.addShapelessRecipe(provider, "wheat_to_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Wheat), Character.valueOf('m'), Items.WHEAT);
        VanillaRecipeHelper.addShapelessRecipe(provider, "gravel_to_flint", new ItemStack((ItemLike)Items.FLINT), Character.valueOf('m'), Blocks.GRAVEL);
        VanillaRecipeHelper.addShapelessRecipe(provider, "bone_to_bone_meal", new ItemStack((ItemLike)Items.BONE_MEAL, 4), Character.valueOf('m'), Items.BONE);
        VanillaRecipeHelper.addShapelessRecipe(provider, "blaze_rod_to_powder", new ItemStack((ItemLike)Items.BLAZE_POWDER, 3), Character.valueOf('m'), Items.BLAZE_ROD);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_cocoa").inputItems(new ItemStack((ItemLike)Items.COCOA_BEANS)).outputItems(TagPrefix.dust, GTMaterials.Cocoa).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_sugar_cane").inputItems(new ItemStack((ItemLike)Items.SUGAR_CANE)).outputItems(new ItemStack((ItemLike)Items.SUGAR)).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_melon_block").inputItems(new ItemStack((ItemLike)Blocks.MELON)).outputItems(new ItemStack((ItemLike)Items.MELON_SLICE, 8)).chancedOutput(new ItemStack((ItemLike)Items.MELON_SEEDS), 8500, 0).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_pumpkin").inputItems(new ItemStack((ItemLike)Blocks.PUMPKIN)).outputItems(new ItemStack((ItemLike)Items.PUMPKIN_SEEDS, 4)).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_melon_slice").inputItems(new ItemStack((ItemLike)Items.MELON_SLICE)).outputItems(new ItemStack((ItemLike)Items.MELON_SEEDS)).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_wool").inputItems((TagKey<Item>)ItemTags.WOOL).outputItems(new ItemStack((ItemLike)Items.STRING)).chancedOutput(new ItemStack((ItemLike)Items.STRING), 9000, 0).chancedOutput(new ItemStack((ItemLike)Items.STRING), 5000, 0).chancedOutput(new ItemStack((ItemLike)Items.STRING), 2000, 0).duration(200).EUt(2L).save(provider);
    }

    private static void woodRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_logs").inputItems((TagKey<Item>)ItemTags.LOGS).outputItems(TagPrefix.dust, GTMaterials.Wood, 6).chancedOutput(TagPrefix.dust, GTMaterials.Wood, 8500, 0).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_planks").inputItems((TagKey<Item>)ItemTags.PLANKS).outputItems(new ItemStack((ItemLike)Items.STICK, 2)).duration(10).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_saplings").inputItems((TagKey<Item>)ItemTags.SAPLINGS).outputItems(new ItemStack((ItemLike)Items.STICK)).outputItems(TagPrefix.dustTiny, GTMaterials.Wood).duration(16).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_wood_slabs").inputItems((TagKey<Item>)ItemTags.WOODEN_SLABS).outputItems(new ItemStack((ItemLike)Items.BOWL)).outputItems(TagPrefix.dustSmall, GTMaterials.Wood).duration(50).EUt(GTValues.VA[0]).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bookshelf").inputItems((TagKey<Item>)ItemTags.PLANKS, 6).inputItems(new ItemStack((ItemLike)Items.BOOK, 3)).outputItems(new ItemStack((ItemLike)Blocks.BOOKSHELF)).duration(100).EUt(4L).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chest").inputItems((TagKey<Item>)ItemTags.PLANKS, 8).outputItems(new ItemStack((ItemLike)Blocks.CHEST)).duration(100).EUt(4L).circuitMeta(8).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coal").inputItems((TagKey<Item>)ItemTags.COALS).inputItems(new ItemStack((ItemLike)Items.STICK)).outputItems(new ItemStack((ItemLike)Blocks.TORCH, 4)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coal_dust").inputItems(TagPrefix.dust, GTMaterials.Coal).inputItems(new ItemStack((ItemLike)Items.STICK)).outputItems(new ItemStack((ItemLike)Blocks.TORCH, 4)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_charcoal_dust").inputItems(TagPrefix.dust, GTMaterials.Charcoal).inputItems(new ItemStack((ItemLike)Items.STICK)).outputItems(new ItemStack((ItemLike)Blocks.TORCH, 4)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coke_gem").inputItems(TagPrefix.gem, GTMaterials.Coke).inputItems(new ItemStack((ItemLike)Items.STICK)).outputItems(new ItemStack((ItemLike)Blocks.TORCH, 8)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coke_dust").inputItems(TagPrefix.dust, GTMaterials.Coke).inputItems(new ItemStack((ItemLike)Items.STICK)).outputItems(new ItemStack((ItemLike)Blocks.TORCH, 8)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_torch").inputItems(new ItemStack((ItemLike)Blocks.TORCH)).inputItems((TagKey<Item>)ItemTags.SOUL_FIRE_BASE_BLOCKS).outputItems(new ItemStack((ItemLike)Blocks.SOUL_TORCH)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_lantern_from_lantern").inputItems(new ItemStack((ItemLike)Blocks.LANTERN)).inputItems((TagKey<Item>)ItemTags.SOUL_FIRE_BASE_BLOCKS).outputItems(new ItemStack((ItemLike)Blocks.SOUL_LANTERN)).duration(100).EUt(1L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "sticky_resin_torch", new ItemStack((ItemLike)Blocks.TORCH, 3), "X", "Y", Character.valueOf('X'), GTItems.STICKY_RESIN, Character.valueOf('Y'), new ItemStack((ItemLike)Items.STICK));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_sulfur", new ItemStack((ItemLike)Blocks.TORCH, 2), "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Sulfur), Character.valueOf('S'), new ItemStack((ItemLike)Items.STICK));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_phosphorus", new ItemStack((ItemLike)Blocks.TORCH, 6), "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Phosphorus), Character.valueOf('S'), new ItemStack((ItemLike)Items.STICK));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_coal_dust", new ItemStack((ItemLike)Blocks.TORCH, 4), "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Coal), Character.valueOf('S'), new ItemStack((ItemLike)Items.STICK));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_charcoal_dust", new ItemStack((ItemLike)Blocks.TORCH, 4), "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Charcoal), Character.valueOf('S'), new ItemStack((ItemLike)Items.STICK));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_coke", new ItemStack((ItemLike)Blocks.TORCH, 8), "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.gem, GTMaterials.Coke), Character.valueOf('S'), new ItemStack((ItemLike)Items.STICK));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_coke_dust", new ItemStack((ItemLike)Blocks.TORCH, 8), "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Coke), Character.valueOf('S'), new ItemStack((ItemLike)Items.STICK));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_creosote", new ItemStack((ItemLike)Blocks.TORCH, 16), new Object[]{"WB", "S ", Character.valueOf('W'), ItemTags.WOOL, Character.valueOf('S'), new ItemStack((ItemLike)Items.STICK), Character.valueOf('B'), new FluidContainerIngredient(GTMaterials.Creosote.getFluidTag(), 1000)});
        VanillaRecipeHelper.addShapedRecipe(provider, "soul_torch", new ItemStack((ItemLike)Blocks.SOUL_TORCH, 1), "WB", Character.valueOf('W'), ItemTags.SOUL_FIRE_BASE_BLOCKS, Character.valueOf('B'), new ItemStack((ItemLike)Blocks.TORCH));
        if (!ConfigHolder.INSTANCE.recipes.hardMiscRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "soul_lantern_from_lantern", new ItemStack((ItemLike)Blocks.SOUL_LANTERN, 1), "WB", Character.valueOf('W'), ItemTags.SOUL_FIRE_BASE_BLOCKS, Character.valueOf('B'), new ItemStack((ItemLike)Blocks.LANTERN));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_lantern_from_lantern").inputItems(new ItemStack((ItemLike)Blocks.LANTERN)).inputItems((TagKey<Item>)ItemTags.SOUL_FIRE_BASE_BLOCKS).outputItems(new ItemStack((ItemLike)Blocks.SOUL_LANTERN)).duration(100).EUt(1L).save(provider);
        }
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("redstone_torch").EUt(4L).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(new ItemStack((ItemLike)Items.STICK)).outputItems(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH, 1)).circuitMeta(3).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_sulfur").EUt(4L).inputItems(new ItemStack((ItemLike)Items.STICK)).inputItems(TagPrefix.dust, GTMaterials.Sulfur).outputItems(new ItemStack((ItemLike)Blocks.TORCH, 2)).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_phosphorus").EUt(4L).inputItems(new ItemStack((ItemLike)Items.STICK)).inputItems(TagPrefix.dust, GTMaterials.Phosphorus).outputItems(new ItemStack((ItemLike)Blocks.TORCH, 6)).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("ladder").EUt(4L).duration(40).circuitMeta(7).inputItems(new ItemStack((ItemLike)Items.STICK, 7)).outputItems(new ItemStack((ItemLike)Blocks.LADDER, 2)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("barrel").inputItems((TagKey<Item>)ItemTags.PLANKS, 7).outputItems(new ItemStack((ItemLike)Blocks.BARREL)).circuitMeta(24).duration(100).EUt(4L).save(provider);
    }

    private static void cuttingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("snow_layer").inputItems(new ItemStack((ItemLike)Blocks.SNOW_BLOCK)).outputItems(new ItemStack((ItemLike)Blocks.SNOW, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
    }

    private static void dyingCleaningRecipes(Consumer<FinishedRecipe> provider) {
        for (DyeColor color : DyeColor.values()) {
            String dyeName = color.getName();
            GTRecipeTypes.MIXER_RECIPES.recipeBuilder(dyeName + "_concrete_powder").duration(200).EUt(GTValues.VA[0]).inputItems((TagKey<Item>)Tags.Items.SAND, 4).inputItems((TagKey<Item>)Tags.Items.GRAVEL, 4).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_concrete_powder")), 8)).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder(dyeName + "_concrete").duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_concrete_powder")))).inputFluids(GTMaterials.Water.getFluid(1000)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_concrete")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            if (color != DyeColor.WHITE) {
                GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_concrete_to_" + dyeName).duration(20).EUt(GTValues.VA[0]).inputItems(CustomTags.CONCRETE_ITEM).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_concrete")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            }
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_terracotta_to_" + dyeName).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.TERRACOTTA)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_terracotta")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_glass_to_" + dyeName).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.GLASS)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_stained_glass")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_glass_pane_to_" + dyeName).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.GLASS_PANE)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_stained_glass_pane")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + dyeName + "_glass_to_pane").duration(20).EUt(GTValues.VA[0]).inputItems((Item)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_stained_glass")), 3).outputItems((Item)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_stained_glass_pane")), 8).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_candle_to_" + dyeName).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Items.CANDLE)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_candle")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            if (color != DyeColor.WHITE) {
                GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_wool_to_" + dyeName).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.WHITE_WOOL)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_wool")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
                GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_bed_to_" + dyeName).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.WHITE_BED)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_bed")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            }
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + dyeName + "_wool_to_carpet").duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_wool")), 1)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_carpet")), 2)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(dyeName + "_banner").duration(20).EUt(GTValues.VA[0]).circuitMeta(6).inputItems(new ItemStack((ItemLike)Items.STICK)).inputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_wool")), 6)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(dyeName + "_banner")))).save(provider);
        }
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_wool").inputItems((TagKey<Item>)ItemTags.WOOL).inputFluids(GTMaterials.Chlorine.getFluid(50)).outputItems(new ItemStack((ItemLike)Blocks.WHITE_WOOL)).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_carpet").inputItems((TagKey<Item>)ItemTags.WOOL_CARPETS).inputFluids(GTMaterials.Chlorine.getFluid(25)).outputItems(new ItemStack((ItemLike)Blocks.WHITE_CARPET)).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_terracotta").inputItems((TagKey<Item>)ItemTags.TERRACOTTA).inputFluids(GTMaterials.Chlorine.getFluid(50)).outputItems(Items.TERRACOTTA).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_stained_glass").inputItems((TagKey<Item>)Tags.Items.STAINED_GLASS).inputFluids(GTMaterials.Chlorine.getFluid(50)).outputItems(Items.GLASS).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_stained_glass_pane").inputItems((TagKey<Item>)Tags.Items.STAINED_GLASS_PANES).inputFluids(GTMaterials.Chlorine.getFluid(20)).outputItems(Items.GLASS_PANE).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_concrete").inputItems(CustomTags.CONCRETE_ITEM).inputFluids(GTMaterials.Chlorine.getFluid(20)).outputItems(Items.WHITE_CONCRETE).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("sticky_piston_to_piston").inputItems(new ItemStack((ItemLike)Blocks.STICKY_PISTON)).inputFluids(GTMaterials.Chlorine.getFluid(10)).outputItems(new ItemStack((ItemLike)Blocks.PISTON)).duration(30).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_candle").inputItems((TagKey<Item>)ItemTags.CANDLES).inputFluids(GTMaterials.Chlorine.getFluid(20)).outputItems(Items.CANDLE).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_bed").inputItems((TagKey<Item>)ItemTags.BEDS).inputFluids(GTMaterials.Chlorine.getFluid(20)).outputItems(Items.WHITE_BED).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
    }

    private static void redstoneRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_resin").inputItems((Supplier<? extends Item>)GTItems.STICKY_RESIN).inputItems(new ItemStack((ItemLike)Blocks.PISTON)).outputItems(new ItemStack((ItemLike)Blocks.STICKY_PISTON)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_slime").inputItems(new ItemStack((ItemLike)Items.SLIME_BALL)).inputItems(new ItemStack((ItemLike)Blocks.PISTON)).outputItems(new ItemStack((ItemLike)Blocks.STICKY_PISTON)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_glue").inputItems(new ItemStack((ItemLike)Blocks.PISTON)).inputFluids(GTMaterials.Glue.getFluid(100)).outputItems(new ItemStack((ItemLike)Blocks.STICKY_PISTON)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tripwire_hook_iron").inputItems(Items.STICK, 2).inputItems(TagPrefix.ring, GTMaterials.Iron, 2).outputItems(new ItemStack((ItemLike)Blocks.TRIPWIRE_HOOK, 1)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tripwire_hook_wrought_iron").inputItems(Items.STICK, 2).inputItems(TagPrefix.ring, GTMaterials.WroughtIron, 2).outputItems(new ItemStack((ItemLike)Blocks.TRIPWIRE_HOOK, 1)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("redstone_lamp").inputItems(TagPrefix.dust, GTMaterials.Redstone, 4).inputItems(TagPrefix.dust, GTMaterials.Glowstone, 4).outputItems(new ItemStack((ItemLike)Blocks.REDSTONE_LAMP)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("repeater").inputItems(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH, 2)).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(new ItemStack((ItemLike)Items.REPEATER)).duration(100).EUt(10L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_nether_quartz").inputItems(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH, 3)).inputItems(TagPrefix.gem, GTMaterials.NetherQuartz).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(new ItemStack((ItemLike)Items.COMPARATOR)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_certus_quartz").inputItems(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH, 3)).inputItems(TagPrefix.gem, GTMaterials.CertusQuartz).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(new ItemStack((ItemLike)Items.COMPARATOR)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_quartzite").inputItems(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH, 3)).inputItems(TagPrefix.gem, GTMaterials.Quartzite).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(new ItemStack((ItemLike)Items.COMPARATOR)).duration(100).EUt(1L).save(provider);
        if (!ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes) {
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("stone_pressure_plate").inputItems(new ItemStack((ItemLike)Blocks.STONE_SLAB)).outputItems(new ItemStack((ItemLike)Blocks.STONE_PRESSURE_PLATE, 8)).duration(250).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("polished_blackstone_pressure_plate").inputItems(new ItemStack((ItemLike)Blocks.POLISHED_BLACKSTONE_SLAB)).outputItems(new ItemStack((ItemLike)Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE, 8)).duration(250).EUt(GTValues.VA[0]).save(provider);
        }
    }

    private static void metalRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bucket").circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Iron, 3).outputItems(new ItemStack((ItemLike)Items.BUCKET)).duration(100).EUt(4L).addMaterialInfo(true).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "leather_horse_armor", new ItemStack((ItemLike)Items.LEATHER_HORSE_ARMOR), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.LEATHER_HELMET), Character.valueOf('P'), new ItemStack((ItemLike)Items.LEATHER), Character.valueOf('C'), new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE), Character.valueOf('L'), new ItemStack((ItemLike)Items.LEATHER_LEGGINGS), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "iron_horse_armor", new ItemStack((ItemLike)Items.IRON_HORSE_ARMOR), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.IRON_HELMET), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), new ItemStack((ItemLike)Items.IRON_CHESTPLATE), Character.valueOf('L'), new ItemStack((ItemLike)Items.IRON_LEGGINGS), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "golden_horse_armor", new ItemStack((ItemLike)Items.GOLDEN_HORSE_ARMOR), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.GOLDEN_HELMET), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('C'), new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE), Character.valueOf('L'), new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Gold));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "diamond_horse_armor", new ItemStack((ItemLike)Items.DIAMOND_HORSE_ARMOR), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.DIAMOND_HELMET), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Diamond), Character.valueOf('C'), new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), Character.valueOf('L'), new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), Character.valueOf('S'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Diamond));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "chainmail_helmet", new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), "PPP", "PhP", Character.valueOf('P'), Items.CHAIN);
        VanillaRecipeHelper.addShapedRecipe(provider, true, "chainmail_chestplate", new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), "PhP", "PPP", "PPP", Character.valueOf('P'), Items.CHAIN);
        VanillaRecipeHelper.addShapedRecipe(provider, true, "chainmail_leggings", new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), "PPP", "PhP", "P P", Character.valueOf('P'), Items.CHAIN);
        VanillaRecipeHelper.addShapedRecipe(provider, true, "chainmail_boots", new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), "P P", "PhP", Character.valueOf('P'), Items.CHAIN);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cauldron").inputItems(TagPrefix.plate, GTMaterials.Iron, 7).outputItems(new ItemStack((ItemLike)Items.CAULDRON, 1)).circuitMeta(7).duration(700).EUt(4L).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_bars").inputItems(TagPrefix.rod, GTMaterials.Iron, 3).outputItems(new ItemStack((ItemLike)Blocks.IRON_BARS, 4)).circuitMeta(3).duration(300).EUt(4L).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_trapdoor").inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(4).outputItems(new ItemStack((ItemLike)Blocks.IRON_TRAPDOOR)).duration(100).EUt(16L).addMaterialInfo(true).save(provider);
        if (!ConfigHolder.INSTANCE.recipes.hardAdvancedIronRecipes) {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_door").inputItems(TagPrefix.plate, GTMaterials.Iron, 6).circuitMeta(6).outputItems(new ItemStack((ItemLike)Items.IRON_DOOR, 3)).duration(100).EUt(16L).addMaterialInfo(true).save(provider);
        }
    }

    private static void miscRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardToolArmorRecipes) {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fishing_rod").inputItems(new ItemStack((ItemLike)Items.STRING)).inputItems(TagPrefix.rodLong, GTMaterials.Wood, 2).inputItems(TagPrefix.ring, GTMaterials.Iron).outputItems(new ItemStack((ItemLike)Items.FISHING_ROD, 1)).circuitMeta(16).duration(100).EUt(4L).save(provider);
        } else {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fishing_rod").inputItems(new ItemStack((ItemLike)Items.STRING, 2)).inputItems(TagPrefix.rod, GTMaterials.Wood, 3).outputItems(new ItemStack((ItemLike)Items.FISHING_ROD, 1)).circuitMeta(16).duration(100).EUt(4L).save(provider);
        }
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("book_from_leather").inputItems(new ItemStack((ItemLike)Items.PAPER, 3)).inputItems(new ItemStack((ItemLike)Items.LEATHER)).inputFluids(GTMaterials.Glue.getFluid(20)).outputItems(new ItemStack((ItemLike)Items.BOOK)).duration(32).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("book_from_pvc").inputItems(new ItemStack((ItemLike)Items.PAPER, 3)).inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride).inputFluids(GTMaterials.Glue.getFluid(20)).outputItems(new ItemStack((ItemLike)Items.BOOK)).duration(20).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("map").inputItems(new ItemStack((ItemLike)Items.PAPER, 8)).inputItems(new ItemStack((ItemLike)Items.COMPASS)).outputItems(new ItemStack((ItemLike)Items.MAP)).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("form_nether_brick").inputItems(TagPrefix.dust, GTMaterials.Netherrack).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).outputItems(new ItemStack((ItemLike)Items.NETHER_BRICK)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("form_brick").inputItems(new ItemStack((ItemLike)Items.CLAY_BALL)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).outputItems(new ItemStack((ItemLike)Items.BRICK)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lead").inputItems(new ItemStack((ItemLike)Items.STRING)).inputItems(new ItemStack((ItemLike)Items.SLIME_BALL)).outputItems(new ItemStack((ItemLike)Items.LEAD, 2)).duration(100).EUt(2L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("name_tag").inputItems(new ItemStack((ItemLike)Items.LEATHER)).inputItems(new ItemStack((ItemLike)Items.LEAD)).inputFluids(GTMaterials.Glue.getFluid(100)).outputItems(new ItemStack((ItemLike)Items.NAME_TAG)).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bow").inputItems(new ItemStack((ItemLike)Items.STRING, 3)).inputItems(Items.STICK, 3).outputItems(new ItemStack((ItemLike)Items.BOW, 1)).circuitMeta(10).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crossbow").inputItems(new ItemStack((ItemLike)Items.STRING, 2)).inputItems(Items.STICK, 3).inputItems(Items.TRIPWIRE_HOOK).outputItems(new ItemStack((ItemLike)Items.CROSSBOW, 1)).circuitMeta(11).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snowball").duration(128).EUt(4L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BALL).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(new ItemStack((ItemLike)Items.SNOWBALL)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snowball_distilled").duration(128).EUt(4L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BALL).inputFluids(GTMaterials.DistilledWater.getFluid(250)).outputItems(new ItemStack((ItemLike)Items.SNOWBALL)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snow_block").duration(512).EUt(4L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.Water.getFluid(1000)).outputItems(new ItemStack((ItemLike)Blocks.SNOW_BLOCK)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snow_block_distilled").duration(512).EUt(4L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.DistilledWater.getFluid(1000)).outputItems(new ItemStack((ItemLike)Blocks.SNOW_BLOCK)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("obsidian").duration(1024).EUt(16L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.Lava.getFluid(1000)).outputItems(new ItemStack((ItemLike)Blocks.OBSIDIAN)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_anvil").duration(1680).EUt(16L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_ANVIL).inputFluids(GTMaterials.Iron.getFluid(4464)).outputItems(new ItemStack((ItemLike)Blocks.ANVIL)).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("anvil").inputItems(TagPrefix.ingot, GTMaterials.Iron, 31).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_ANVIL).outputItems(new ItemStack((ItemLike)Blocks.ANVIL)).duration(1680).EUt(16L).save(provider);
        VanillaRecipeHelper.addSmeltingRecipe(provider, "sticky_resin_from_slime", new ItemStack((ItemLike)Items.SLIME_BALL), GTItems.STICKY_RESIN.asStack(), 0.3f);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("wool_from_string").inputItems(new ItemStack((ItemLike)Items.STRING, 4)).circuitMeta(4).outputItems(new ItemStack((ItemLike)Blocks.WHITE_WOOL)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("mossy_cobblestone_from_vine").inputItems(new ItemStack((ItemLike)Blocks.COBBLESTONE)).inputItems(new ItemStack((ItemLike)Blocks.VINE)).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE)).duration(40).EUt(1L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("mossy_cobblestone_from_moss_block").inputItems(new ItemStack((ItemLike)Blocks.COBBLESTONE)).inputItems(new ItemStack((ItemLike)Blocks.MOSS_BLOCK)).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE)).duration(40).EUt(1L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("mossy_stone_bricks_from_vine").inputItems(new ItemStack((ItemLike)Blocks.STONE_BRICKS)).inputItems(new ItemStack((ItemLike)Blocks.VINE)).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(new ItemStack((ItemLike)Blocks.MOSSY_STONE_BRICKS)).duration(40).EUt(1L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("mossy_stone_bricks_from_moss_block").inputItems(new ItemStack((ItemLike)Blocks.STONE_BRICKS)).inputItems(new ItemStack((ItemLike)Blocks.MOSS_BLOCK)).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(new ItemStack((ItemLike)Blocks.MOSSY_STONE_BRICKS)).duration(40).EUt(1L).save(provider);
        GTRecipeTypes.CANNER_RECIPES.recipeBuilder("jack_o_lantern").EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Blocks.PUMPKIN)).inputItems(new ItemStack((ItemLike)Blocks.TORCH)).outputItems(new ItemStack((ItemLike)Blocks.JACK_O_LANTERN)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sea_lantern").EUt(4L).duration(40).inputItems(new ItemStack((ItemLike)Items.PRISMARINE_CRYSTALS, 5)).inputItems(new ItemStack((ItemLike)Items.PRISMARINE_SHARD, 4)).outputItems(new ItemStack((ItemLike)Blocks.SEA_LANTERN)).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("red_nether_bricks").EUt(4L).duration(40).inputItems(new ItemStack((ItemLike)Items.NETHER_BRICK, 2)).inputItems(new ItemStack((ItemLike)Items.NETHER_WART, 2)).outputItems(new ItemStack((ItemLike)Blocks.RED_NETHER_BRICKS)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("nether_brick_fence").duration(100).EUt(4L).circuitMeta(3).inputItems(new ItemStack((ItemLike)Blocks.NETHER_BRICKS)).outputItems(new ItemStack((ItemLike)Blocks.NETHER_BRICK_FENCE)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("end_rod").duration(100).EUt(4L).inputItems(new ItemStack((ItemLike)Items.POPPED_CHORUS_FRUIT)).inputItems(new ItemStack((ItemLike)Items.BLAZE_ROD)).outputItems(new ItemStack((ItemLike)Blocks.END_ROD, 4)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("shulker_box").duration(100).EUt(GTValues.VA[0]).inputItems((TagKey<Item>)Tags.Items.CHESTS_WOODEN).inputItems(new ItemStack((ItemLike)Items.SHULKER_SHELL, 2)).outputItems(new ItemStack((ItemLike)Blocks.SHULKER_BOX)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("painting").duration(100).EUt(4L).circuitMeta(1).inputItems((TagKey<Item>)ItemTags.WOOL).inputItems(new ItemStack((ItemLike)Items.STICK, 8)).outputItems(new ItemStack((ItemLike)Items.PAINTING)).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("item_frame").duration(100).EUt(4L).inputItems(new ItemStack((ItemLike)Items.LEATHER)).inputItems(new ItemStack((ItemLike)Items.STICK, 8)).outputItems(new ItemStack((ItemLike)Items.ITEM_FRAME)).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("flower_pot").duration(10).EUt(2L).inputItems(new ItemStack((ItemLike)Items.BRICK, 3)).outputItems(new ItemStack((ItemLike)Items.FLOWER_POT)).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("end_crystal").duration(30).EUt(16L).inputItems(new ItemStack((ItemLike)Items.GHAST_TEAR)).inputItems(new ItemStack((ItemLike)Items.ENDER_EYE)).inputFluids(GTMaterials.Glass.getFluid(1008)).outputItems(new ItemStack((ItemLike)Items.END_CRYSTAL)).addMaterialInfo(true, true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("rail").inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(new ItemStack((ItemLike)Items.STICK)).circuitMeta(1).outputItems(new ItemStack((ItemLike)Blocks.RAIL, 32)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("powered_rail").inputItems(TagPrefix.rod, GTMaterials.Gold, 12).inputItems(new ItemStack((ItemLike)Items.STICK)).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(1).outputItems(new ItemStack((ItemLike)Blocks.POWERED_RAIL, 12)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("detector_rail").inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(new ItemStack((ItemLike)Items.STICK)).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(5).outputItems(new ItemStack((ItemLike)Blocks.DETECTOR_RAIL, 12)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("activator_rail").inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(new ItemStack((ItemLike)Items.STICK, 2)).inputItems(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH)).circuitMeta(5).outputItems(new ItemStack((ItemLike)Blocks.ACTIVATOR_RAIL, 12)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("minecart").inputItems(TagPrefix.plate, GTMaterials.Iron, 3).inputItems(TagPrefix.ring, GTMaterials.Iron, 4).outputItems(new ItemStack((ItemLike)Items.MINECART)).duration(100).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "saddle", new ItemStack((ItemLike)Items.SADDLE), "LLL", "LCL", "RSR", Character.valueOf('L'), new ItemStack((ItemLike)Items.LEATHER), Character.valueOf('C'), ItemTags.WOOL_CARPETS, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new ItemStack((ItemLike)Items.STRING));
        GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("clay_from_dust").inputItems(TagPrefix.dust, GTMaterials.Clay).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(new ItemStack((ItemLike)Items.CLAY_BALL)).duration(600).EUt(24L).save(provider);
        GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("clay_from_dust_distilled").inputItems(TagPrefix.dust, GTMaterials.Clay).inputFluids(GTMaterials.DistilledWater.getFluid(250)).outputItems(new ItemStack((ItemLike)Items.CLAY_BALL)).duration(300).EUt(24L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("redstone_block").inputItems(TagPrefix.dust, GTMaterials.Redstone, 9).outputItems(new ItemStack((ItemLike)Blocks.REDSTONE_BLOCK)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("bone_block").inputItems(TagPrefix.dust, GTMaterials.Bone, 9).outputItems(new ItemStack((ItemLike)Blocks.BONE_BLOCK)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("purpur_block").inputItems(new ItemStack((ItemLike)Items.POPPED_CHORUS_FRUIT, 4)).outputItems(new ItemStack((ItemLike)Blocks.PURPUR_BLOCK, 4)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("magma_block").inputItems(new ItemStack((ItemLike)Items.MAGMA_CREAM, 4)).outputItems(new ItemStack((ItemLike)Blocks.MAGMA_BLOCK)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("slime_block").inputItems(new ItemStack((ItemLike)Items.SLIME_BALL, 9)).outputItems(new ItemStack((ItemLike)Blocks.SLIME_BLOCK)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("nether_wart_block").inputItems(new ItemStack((ItemLike)Items.NETHER_WART, 9)).circuitMeta(9).outputItems(new ItemStack((ItemLike)Blocks.NETHER_WART_BLOCK)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("prismarine").inputItems(new ItemStack((ItemLike)Items.PRISMARINE_SHARD, 4)).circuitMeta(4).outputItems(new ItemStack((ItemLike)Blocks.PRISMARINE)).duration(100).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("prismarine_bricks").inputItems(new ItemStack((ItemLike)Items.PRISMARINE_SHARD, 9)).circuitMeta(9).outputItems(new ItemStack((ItemLike)Blocks.PRISMARINE_BRICKS)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("eye_of_ender").inputFluids(GTMaterials.Blaze.getFluid(144)).inputItems(TagPrefix.gem, GTMaterials.EnderPearl).outputItems(new ItemStack((ItemLike)Items.ENDER_EYE)).duration(50).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("blaze_rod").inputItems(TagPrefix.dust, GTMaterials.Blaze, 4).outputItems(new ItemStack((ItemLike)Items.BLAZE_ROD)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("mud_to_clay").inputItems(Items.MUD).outputItems(Items.CLAY).duration(40).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("ender_chest").duration(100).EUt(4L).inputItems(new ItemStack((ItemLike)Blocks.OBSIDIAN, 8)).inputItems(new ItemStack((ItemLike)Items.ENDER_EYE)).outputItems(new ItemStack((ItemLike)Blocks.ENDER_CHEST)).addMaterialInfo(!ConfigHolder.INSTANCE.recipes.hardMiscRecipes).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("armor_stand").duration(30).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.SMOOTH_STONE_SLAB, 1)).inputItems(new ItemStack((ItemLike)Items.STICK, 6)).outputItems(new ItemStack((ItemLike)Items.ARMOR_STAND)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("candle").inputFluids(GTMaterials.Wax.getFluid(144)).inputItems(new ItemStack((ItemLike)Items.STRING)).outputItems(new ItemStack((ItemLike)Blocks.CANDLE, 2)).duration(20).EUt(1L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("disc_fragment_5").inputItems(new ItemStack((ItemLike)Items.MUSIC_DISC_5)).outputItems(new ItemStack((ItemLike)Items.DISC_FRAGMENT_5, 9)).duration(100).EUt(6L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chest_minecart").EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Items.MINECART)).inputItems((TagKey<Item>)Tags.Items.CHESTS_WOODEN).outputItems(new ItemStack((ItemLike)Items.CHEST_MINECART)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace_minecart").EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Items.MINECART)).inputItems(new ItemStack((ItemLike)Blocks.FURNACE)).outputItems(new ItemStack((ItemLike)Items.FURNACE_MINECART)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tnt_minecart").EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Items.MINECART)).inputItems(new ItemStack((ItemLike)Blocks.TNT)).outputItems(new ItemStack((ItemLike)Items.TNT_MINECART)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hopper_minecart").EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Items.MINECART)).inputItems(new ItemStack((ItemLike)Blocks.HOPPER)).outputItems(new ItemStack((ItemLike)Items.HOPPER_MINECART)).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, "hay_block_to_hay", new ItemStack((ItemLike)Items.WHEAT, 9), Items.HAY_BLOCK, Character.valueOf('k'));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("conduit").inputItems(new ItemStack((ItemLike)Items.HEART_OF_THE_SEA)).inputItems(new ItemStack((ItemLike)Items.NAUTILUS_SHELL, 8)).outputItems(new ItemStack((ItemLike)Blocks.CONDUIT)).duration(200).EUt(16L).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("granite").inputItems(new ItemStack((ItemLike)Items.DIORITE)).inputItems(new ItemStack((ItemLike)Items.QUARTZ)).outputItems(new ItemStack((ItemLike)Items.GRANITE)).duration(80).EUt(4L).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("diorite").inputItems(new ItemStack((ItemLike)Items.COBBLESTONE, 2)).inputItems(new ItemStack((ItemLike)Items.QUARTZ, 2)).outputItems(new ItemStack((ItemLike)Items.DIORITE, 2)).duration(80).EUt(4L).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("andesite").inputItems(new ItemStack((ItemLike)Items.DIORITE)).inputItems(new ItemStack((ItemLike)Items.COBBLESTONE)).outputItems(new ItemStack((ItemLike)Items.ANDESITE, 2)).duration(80).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_block_of_quartz_into_quartz_pillar").inputItems(new ItemStack((ItemLike)Items.QUARTZ_BLOCK)).circuitMeta(5).outputItems(new ItemStack((ItemLike)Items.QUARTZ_PILLAR)).duration(80).EUt(1L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("packed_mud").inputItems(new ItemStack((ItemLike)Items.MUD)).inputItems(new ItemStack((ItemLike)Items.WHEAT)).outputItems(new ItemStack((ItemLike)Items.PACKED_MUD)).duration(80).EUt(4L).save(provider);
    }

    private static void mixingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("fire_charge").inputItems(TagPrefix.dust, GTMaterials.Coal).inputItems(TagPrefix.dust, GTMaterials.Gunpowder).inputItems(TagPrefix.dust, GTMaterials.Blaze).outputItems(new ItemStack((ItemLike)Items.FIRE_CHARGE, 3)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("coarse_dirt").inputItems(new ItemStack((ItemLike)Blocks.GRAVEL)).inputItems(new ItemStack((ItemLike)Blocks.DIRT)).outputItems(new ItemStack((ItemLike)Blocks.COARSE_DIRT, 2)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("mud").inputItems(new ItemStack((ItemLike)Blocks.DIRT)).circuitMeta(1).inputFluids(GTMaterials.Water.getFluid(144)).outputItems(new ItemStack((ItemLike)Blocks.MUD, 1)).duration(100).EUt(4L).save(provider);
    }

    private static void dyeRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("poppy_dye").inputItems(new ItemStack((ItemLike)Blocks.POPPY)).outputItems(new ItemStack((ItemLike)Items.RED_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("blue_orchid_dye").inputItems(new ItemStack((ItemLike)Blocks.BLUE_ORCHID)).outputItems(new ItemStack((ItemLike)Items.LIGHT_BLUE_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("allium_dye").inputItems(new ItemStack((ItemLike)Blocks.ALLIUM)).outputItems(new ItemStack((ItemLike)Items.MAGENTA_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("azure_bluet_dye").inputItems(new ItemStack((ItemLike)Blocks.AZURE_BLUET)).outputItems(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("red_tulip_dye").inputItems(new ItemStack((ItemLike)Blocks.RED_TULIP)).outputItems(new ItemStack((ItemLike)Items.RED_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("orange_tulip_dye").inputItems(new ItemStack((ItemLike)Blocks.ORANGE_TULIP)).outputItems(new ItemStack((ItemLike)Items.ORANGE_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("white_tulip_dye").inputItems(new ItemStack((ItemLike)Blocks.WHITE_TULIP)).outputItems(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pink_tulip_dye").inputItems(new ItemStack((ItemLike)Blocks.PINK_TULIP)).outputItems(new ItemStack((ItemLike)Items.PINK_DYE)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("oxeye_daisy_dye").inputItems(new ItemStack((ItemLike)Blocks.OXEYE_DAISY)).outputItems(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("dandelion_dye").inputItems(new ItemStack((ItemLike)Blocks.DANDELION)).outputItems(new ItemStack((ItemLike)Items.YELLOW_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("cornflower_dye").inputItems(new ItemStack((ItemLike)Blocks.CORNFLOWER)).outputItems(new ItemStack((ItemLike)Items.BLUE_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lily_of_the_valley_dye").inputItems(new ItemStack((ItemLike)Blocks.LILY_OF_THE_VALLEY)).outputItems(new ItemStack((ItemLike)Items.WHITE_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("wither_rose_dye").inputItems(new ItemStack((ItemLike)Blocks.WITHER_ROSE)).outputItems(new ItemStack((ItemLike)Items.BLACK_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("sunflower_dye").inputItems(new ItemStack((ItemLike)Blocks.SUNFLOWER)).outputItems(new ItemStack((ItemLike)Items.YELLOW_DYE, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lilac_dye").inputItems(new ItemStack((ItemLike)Blocks.LILAC)).outputItems(new ItemStack((ItemLike)Items.MAGENTA_DYE, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("rose_bush_dye").inputItems(new ItemStack((ItemLike)Blocks.ROSE_BUSH)).outputItems(new ItemStack((ItemLike)Items.RED_DYE, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("peony_dye").inputItems(new ItemStack((ItemLike)Blocks.PEONY)).outputItems(new ItemStack((ItemLike)Items.PINK_DYE, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("beetroot_dye").inputItems(new ItemStack((ItemLike)Items.BEETROOT)).outputItems(new ItemStack((ItemLike)Items.RED_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("torchflower_dye").inputItems(new ItemStack((ItemLike)Items.TORCHFLOWER)).outputItems(new ItemStack((ItemLike)Items.ORANGE_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pitcher_dye").inputItems(new ItemStack((ItemLike)Items.PITCHER_PLANT)).outputItems(new ItemStack((ItemLike)Items.CYAN_DYE, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pink_petals_dye").inputItems(new ItemStack((ItemLike)Items.PINK_PETALS)).outputItems(new ItemStack((ItemLike)Items.PINK_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("sea_pickle_dye").inputItems(new ItemStack((ItemLike)Items.SEA_PICKLE)).outputItems(new ItemStack((ItemLike)Items.LIME_DYE, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("white_dye").inputItems(new ItemStack((ItemLike)Items.BONE_MEAL)).outputItems(new ItemStack((ItemLike)Items.WHITE_DYE, 1)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lapis_dye").inputItems(new ItemStack((ItemLike)Items.LAPIS_LAZULI)).outputItems(new ItemStack((ItemLike)Items.BLUE_DYE)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("ink_dye").inputItems(new ItemStack((ItemLike)Items.INK_SAC)).outputItems(new ItemStack((ItemLike)Items.BLACK_DYE)).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dark_prismarine").inputItems(new ItemStack((ItemLike)Items.PRISMARINE_SHARD, 4)).inputFluids(GTMaterials.DyeBlack.getFluid(144)).outputItems(new ItemStack((ItemLike)Blocks.DARK_PRISMARINE)).duration(20).EUt(GTValues.VA[0]).save(provider);
    }
}

