/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc.alloyblast;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.misc.alloyblast.AlloyBlastRecipeProducer;
import org.jetbrains.annotations.NotNull;

public class CustomAlloyBlastRecipeProducer
extends AlloyBlastRecipeProducer {
    private final int circuitNum;
    private final int gasCircuitNum;
    private final int outputAmount;

    public CustomAlloyBlastRecipeProducer(int circuitNum, int gasCircuitNum, int outputAmount) {
        this.circuitNum = circuitNum;
        this.gasCircuitNum = gasCircuitNum;
        Preconditions.checkArgument((outputAmount != 0 ? 1 : 0) != 0, (Object)"output amount cannot be zero");
        this.outputAmount = outputAmount;
    }

    @Override
    protected int addInputs(@NotNull Material material, @NotNull GTRecipeBuilder builder) {
        int amount = super.addInputs(material, builder);
        return this.outputAmount < 0 ? amount : this.outputAmount;
    }

    @Override
    protected int getCircuitNum(int componentAmount) {
        return this.circuitNum < 0 ? super.getCircuitNum(componentAmount) : this.circuitNum;
    }

    @Override
    protected int getGasCircuitNum(int componentAmount) {
        return this.gasCircuitNum < 0 ? super.getGasCircuitNum(componentAmount) : this.gasCircuitNum;
    }
}

