/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.utils.KeyStorage;
import com.gregtechceu.gtceu.utils.GTMath;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MEOutputHatchPartMachine
extends MEHatchPartMachine
implements IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEOutputHatchPartMachine.class, MEHatchPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private KeyStorage internalBuffer;

    public MEOutputHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.OUT, args);
    }

    @Override
    protected NotifiableFluidTank createTank(int initialCapacity, int slots, Object ... args) {
        this.internalBuffer = new KeyStorage();
        return new InaccessibleInfiniteTank(this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isRemote()) {
            return;
        }
    }

    @Override
    public void onMachineRemoved() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && !this.internalBuffer.isEmpty()) {
            for (Object2LongMap.Entry<AEKey> entry : this.internalBuffer) {
                grid.getStorageService().getInventory().insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.actionSource);
            }
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected boolean shouldSubscribe() {
        return super.shouldSubscribe() && !this.internalBuffer.storage.isEmpty();
    }

    @Override
    protected void autoIO() {
        if (!this.shouldSyncME()) {
            return;
        }
        if (this.updateMEStatus()) {
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null && !this.internalBuffer.isEmpty()) {
                this.internalBuffer.insertInventory(grid.getStorageService().getInventory(), this.actionSource);
            }
            this.updateTankSubscription();
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 170, 65);
        group.addWidget((Widget)new LabelWidget(5, 0, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new LabelWidget(5, 10, "gtceu.gui.waiting_list"));
        group.addWidget((Widget)new AEListGridWidget.Fluid(5, 20, 3, this.internalBuffer));
        return group;
    }

    private class InaccessibleInfiniteTank
    extends NotifiableFluidTank {
        FluidStorageDelegate storage;

        public InaccessibleInfiniteTank(MetaMachine holder) {
            super(holder, List.of(new FluidStorageDelegate()), IO.OUT, IO.NONE);
            MEOutputHatchPartMachine.this.internalBuffer.setOnContentsChanged(this::onContentsChanged);
            this.storage = (FluidStorageDelegate)this.getStorages()[0];
            this.allowSameFluids = true;
        }

        @Override
        public int getTanks() {
            return 128;
        }

        @Override
        @NotNull
        public List<Object> getContents() {
            return Collections.emptyList();
        }

        @Override
        public double getTotalContentAmount() {
            return 0.0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        @Override
        public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        }

        @Override
        public int getTankCapacity(int tank) {
            return this.storage.getCapacity();
        }

        @Override
        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return true;
        }

        @Override
        @Nullable
        public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
            if (io != IO.OUT) {
                return left;
            }
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            Iterator<FluidIngredient> it = left.iterator();
            while (it.hasNext()) {
                FluidIngredient ingredient = it.next();
                if (ingredient.isEmpty()) {
                    it.remove();
                    continue;
                }
                FluidStack[] fluids = ingredient.getStacks();
                if (fluids.length == 0 || fluids[0].isEmpty()) {
                    it.remove();
                    continue;
                }
                FluidStack output = fluids[0];
                ingredient.shrink(this.storage.fill(output, action));
                if (ingredient.getAmount() > 0) continue;
                it.remove();
            }
            return left.isEmpty() ? null : left;
        }
    }

    private class FluidStorageDelegate
    extends CustomFluidTank {
        public FluidStorageDelegate() {
            super(0);
        }

        public int getCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void setFluid(FluidStack fluid) {
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            AEFluidKey key = AEFluidKey.of((Fluid)resource.getFluid(), (CompoundTag)resource.getTag());
            int amount = resource.getAmount();
            int oldValue = GTMath.saturatedCast(MEOutputHatchPartMachine.this.internalBuffer.storage.getOrDefault((Object)key, 0L));
            int changeValue = Math.min(Integer.MAX_VALUE - oldValue, amount);
            if (changeValue > 0 && action.execute()) {
                MEOutputHatchPartMachine.this.internalBuffer.storage.put((Object)key, (long)(oldValue + changeValue));
                MEOutputHatchPartMachine.this.internalBuffer.onChanged();
            }
            return changeValue;
        }

        @Override
        public boolean supportsFill(int tank) {
            return false;
        }

        @Override
        public boolean supportsDrain(int tank) {
            return false;
        }
    }
}

