/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.ProcessingPatternItem;
import appeng.helpers.patternprovider.PatternContainer;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.ButtonConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.FancyInvConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.FancyTankConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.machines.GTAEMachines;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AETextInputButtonWidget;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.slot.AEPatternViewSlotWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEBusPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferProxyPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.InternalSlotRecipeHandler;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MEPatternBufferPartMachine
extends MEBusPartMachine
implements ICraftingProvider,
PatternContainer,
IDataStickInteractable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEPatternBufferPartMachine.class, MEBusPartMachine.MANAGED_FIELD_HOLDER);
    protected static final int MAX_PATTERN_COUNT = 27;
    private final InternalInventory internalPatternInventory = new InternalInventory(){

        public int size() {
            return 27;
        }

        public ItemStack getStackInSlot(int slotIndex) {
            return MEPatternBufferPartMachine.this.patternInventory.getStackInSlot(slotIndex);
        }

        public void setItemDirect(int slotIndex, ItemStack stack) {
            MEPatternBufferPartMachine.this.patternInventory.setStackInSlot(slotIndex, stack);
            MEPatternBufferPartMachine.this.patternInventory.onContentsChanged(slotIndex);
            MEPatternBufferPartMachine.this.onPatternChange(slotIndex);
        }
    };
    @Persisted
    @DescSynced
    private final CustomItemStackHandler patternInventory = new CustomItemStackHandler(27);
    @Persisted
    protected final NotifiableItemStackHandler shareInventory;
    @Persisted
    protected final NotifiableFluidTank shareTank;
    @Persisted
    protected final InternalSlot[] internalInventory = new InternalSlot[27];
    private final BiMap<IPatternDetails, InternalSlot> detailsSlotMap = HashBiMap.create((int)27);
    @DescSynced
    @Persisted
    private String customName = "";
    private boolean needPatternSync;
    @Persisted
    private final Set<BlockPos> proxies = new ObjectOpenHashSet();
    private final Set<MEPatternBufferProxyPartMachine> proxyMachines = new ReferenceOpenHashSet();
    protected final InternalSlotRecipeHandler internalRecipeHandler;
    @Nullable
    protected TickableSubscription updateSubs;

    public MEPatternBufferPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.IN, args);
        this.patternInventory.setFilter(stack -> stack.getItem() instanceof ProcessingPatternItem);
        for (int i = 0; i < this.internalInventory.length; ++i) {
            this.internalInventory[i] = new InternalSlot();
        }
        this.getMainNode().addService(ICraftingProvider.class, (IGridNodeService)this);
        this.shareInventory = new NotifiableItemStackHandler(this, 9, IO.IN, IO.NONE);
        this.shareTank = new NotifiableFluidTank(this, 9, 8000, IO.IN, IO.NONE);
        this.internalRecipeHandler = new InternalSlotRecipeHandler(this, this.internalInventory);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().tell((Runnable)new TickTask(1, () -> {
                for (int i = 0; i < this.patternInventory.getSlots(); ++i) {
                    ItemStack pattern = this.patternInventory.getStackInSlot(i);
                    IPatternDetails patternDetails = PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)this.getLevel());
                    if (patternDetails == null) continue;
                    this.detailsSlotMap.put((Object)patternDetails, (Object)this.internalInventory[i]);
                }
                this.needPatternSync = true;
            }));
        }
    }

    @Override
    public List<RecipeHandlerList> getRecipeHandlers() {
        return this.internalRecipeHandler.getSlotHandlers();
    }

    @Override
    public boolean isWorkingEnabled() {
        return true;
    }

    @Override
    public void setWorkingEnabled(boolean ignored) {
    }

    @Override
    public boolean isDistinct() {
        return true;
    }

    @Override
    public void setDistinct(boolean ignored) {
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.updateSubscription();
    }

    protected void updateSubscription() {
        if (this.getMainNode().isOnline()) {
            this.updateSubs = this.subscribeServerTick(this.updateSubs, this::update);
        } else if (this.updateSubs != null) {
            this.updateSubs.unsubscribe();
            this.updateSubs = null;
        }
    }

    protected void update() {
        if (this.needPatternSync) {
            ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
            this.needPatternSync = false;
        }
    }

    public void addProxy(MEPatternBufferProxyPartMachine proxy) {
        this.proxies.add(proxy.getPos());
        this.proxyMachines.add(proxy);
    }

    public void removeProxy(MEPatternBufferProxyPartMachine proxy) {
        this.proxies.remove(proxy.getPos());
        this.proxyMachines.remove(proxy);
    }

    public @UnmodifiableView Set<MEPatternBufferProxyPartMachine> getProxies() {
        if (this.proxyMachines.size() != this.proxies.size()) {
            this.proxyMachines.clear();
            for (BlockPos pos : this.proxies) {
                MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)this.getLevel(), pos);
                if (!(metaMachine instanceof MEPatternBufferProxyPartMachine)) continue;
                MEPatternBufferProxyPartMachine proxy = (MEPatternBufferProxyPartMachine)metaMachine;
                this.proxyMachines.add(proxy);
            }
        }
        return Collections.unmodifiableSet(this.proxyMachines);
    }

    private void refundAll(ClickData clickData) {
        if (!clickData.isRemote) {
            for (InternalSlot internalSlot : this.internalInventory) {
                internalSlot.refund();
            }
        }
    }

    private void onPatternChange(int index) {
        if (this.isRemote()) {
            return;
        }
        InternalSlot internalInv = this.internalInventory[index];
        ItemStack newPattern = this.patternInventory.getStackInSlot(index);
        IPatternDetails newPatternDetails = PatternDetailsHelper.decodePattern((ItemStack)newPattern, (Level)this.getLevel());
        IPatternDetails oldPatternDetails = (IPatternDetails)this.detailsSlotMap.inverse().get((Object)internalInv);
        this.detailsSlotMap.forcePut((Object)newPatternDetails, (Object)internalInv);
        if (oldPatternDetails != null && !oldPatternDetails.equals(newPatternDetails)) {
            internalInv.refund();
        }
        this.needPatternSync = true;
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        configuratorPanel.attachConfigurators(new ButtonConfigurator((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.REFUND_OVERLAY}), this::refundAll).setTooltips(List.of(Component.translatable((String)"gui.gtceu.refund_all.desc"))));
        if (this.isHasCircuitSlot() && this.isCircuitSlotEnabled()) {
            configuratorPanel.attachConfigurators(new CircuitFancyConfigurator(this.circuitInventory.storage));
        }
        configuratorPanel.attachConfigurators(new FancyInvConfigurator(this.shareInventory.storage, (Component)Component.translatable((String)"gui.gtceu.share_inventory.title")).setTooltips(List.of(Component.translatable((String)"gui.gtceu.share_inventory.desc.0"), Component.translatable((String)"gui.gtceu.share_inventory.desc.1"))));
        configuratorPanel.attachConfigurators(new FancyTankConfigurator(this.shareTank.getStorages(), (Component)Component.translatable((String)"gui.gtceu.share_tank.title")).setTooltips(List.of(Component.translatable((String)"gui.gtceu.share_tank.desc.0"), Component.translatable((String)"gui.gtceu.share_inventory.desc.1"))));
    }

    @Override
    public Widget createUIWidget() {
        int rowSize = 9;
        int colSize = 3;
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int finalI = index;
                Widget slot = new AEPatternViewSlotWidget((IItemHandlerModifiable)this.patternInventory, index++, 8 + x * 18, 14 + y * 18).setOccupiedTexture(new IGuiTexture[]{GuiTextures.SLOT}).setItemHook(stack -> {
                    EncodedPatternItem iep;
                    ItemStack out;
                    Item patt12439$temp;
                    if (!stack.isEmpty() && (patt12439$temp = stack.getItem()) instanceof EncodedPatternItem && !(out = (iep = (EncodedPatternItem)patt12439$temp).getOutput(stack)).isEmpty()) {
                        return out;
                    }
                    return stack;
                }).setChangeListener(() -> this.onPatternChange(finalI)).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.PATTERN_OVERLAY});
                group.addWidget(slot);
            }
        }
        group.addWidget((Widget)new LabelWidget(8, 2, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new AETextInputButtonWidget(18 * rowSize + 8 - 70, 2, 70, 10).setText(this.customName).setOnConfirm(this::setCustomName).setButtonTooltips(new Component[]{Component.translatable((String)"gui.gtceu.rename.desc")}));
        return group;
    }

    public List<IPatternDetails> getAvailablePatterns() {
        return this.detailsSlotMap.keySet().stream().filter(Objects::nonNull).toList();
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.isFormed() && this.getMainNode().isActive() && this.detailsSlotMap.containsKey((Object)patternDetails) && this.checkInput(inputHolder))) {
            return false;
        }
        InternalSlot slot = (InternalSlot)this.detailsSlotMap.get((Object)patternDetails);
        if (slot != null) {
            slot.pushPattern(patternDetails, inputHolder);
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return false;
    }

    private boolean checkInput(KeyCounter[] inputHolder) {
        for (KeyCounter input : inputHolder) {
            boolean illegal = input.keySet().stream().map(AEKey::getType).map(AEKeyType::getId).anyMatch(id -> !id.equals((Object)AEKeyType.items().getId()) && !id.equals((Object)AEKeyType.fluids().getId()));
            if (!illegal) continue;
            return false;
        }
        return true;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Nullable
    public IGrid getGrid() {
        return this.getMainNode().getGrid();
    }

    public InternalInventory getTerminalPatternInventory() {
        return this.internalPatternInventory;
    }

    public PatternContainerGroup getTerminalGroup() {
        if (this.isFormed()) {
            IMultiController controller = this.getControllers().first();
            MultiblockMachineDefinition controllerDefinition = controller.self().getDefinition();
            if (!this.customName.isEmpty()) {
                return new PatternContainerGroup(AEItemKey.of((ItemStack)controllerDefinition.asStack()), (Component)Component.literal((String)this.customName), Collections.emptyList());
            }
            ItemStack circuitStack = this.isHasCircuitSlot() ? this.circuitInventory.storage.getStackInSlot(0) : ItemStack.EMPTY;
            int circuitConfiguration = circuitStack.isEmpty() ? -1 : IntCircuitBehaviour.getCircuitConfiguration(circuitStack);
            MutableComponent groupName = circuitConfiguration != -1 ? Component.translatable((String)controllerDefinition.getDescriptionId()).append(" - " + circuitConfiguration) : Component.translatable((String)controllerDefinition.getDescriptionId());
            return new PatternContainerGroup(AEItemKey.of((ItemStack)controllerDefinition.asStack()), (Component)groupName, Collections.emptyList());
        }
        if (!this.customName.isEmpty()) {
            return new PatternContainerGroup(AEItemKey.of((ItemLike)GTAEMachines.ME_PATTERN_BUFFER.getItem()), (Component)Component.literal((String)this.customName), Collections.emptyList());
        }
        return new PatternContainerGroup(AEItemKey.of((ItemLike)GTAEMachines.ME_PATTERN_BUFFER.getItem()), GTAEMachines.ME_PATTERN_BUFFER.get().getDefinition().getItem().getDescription(), Collections.emptyList());
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.patternInventory);
        this.clearInventory(this.shareInventory);
    }

    @Override
    public InteractionResult onDataStickShiftUse(Player player, ItemStack dataStick) {
        dataStick.getOrCreateTag().putIntArray("pos", new int[]{this.getPos().getX(), this.getPos().getY(), this.getPos().getZ()});
        return InteractionResult.SUCCESS;
    }

    public BufferData mergeInternalSlots() {
        Object2LongOpenCustomHashMap items = new Object2LongOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        Object2LongOpenHashMap fluids = new Object2LongOpenHashMap();
        for (InternalSlot slot : this.internalInventory) {
            slot.itemInventory.object2LongEntrySet().fastForEach(e -> items.addTo((Object)((ItemStack)e.getKey()), e.getLongValue()));
            slot.fluidInventory.object2LongEntrySet().fastForEach(e -> fluids.addTo((Object)((FluidStack)e.getKey()), e.getLongValue()));
        }
        return new BufferData((Object2LongMap<ItemStack>)items, (Object2LongMap<FluidStack>)fluids);
    }

    @Generated
    public CustomItemStackHandler getPatternInventory() {
        return this.patternInventory;
    }

    @Generated
    public NotifiableItemStackHandler getShareInventory() {
        return this.shareInventory;
    }

    @Generated
    public NotifiableFluidTank getShareTank() {
        return this.shareTank;
    }

    @Generated
    public InternalSlot[] getInternalInventory() {
        return this.internalInventory;
    }

    @Generated
    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Generated
    public InternalSlotRecipeHandler getInternalRecipeHandler() {
        return this.internalRecipeHandler;
    }

    public class InternalSlot
    implements ITagSerializable<CompoundTag>,
    IContentChangeAware {
        private Runnable onContentsChanged = () -> {};
        private final Object2LongOpenCustomHashMap<ItemStack> itemInventory = new Object2LongOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        private final Object2LongOpenHashMap<FluidStack> fluidInventory = new Object2LongOpenHashMap();
        private List<ItemStack> itemStacks = null;
        private List<FluidStack> fluidStacks = null;

        public boolean isItemEmpty() {
            return this.itemInventory.isEmpty();
        }

        public boolean isFluidEmpty() {
            return this.fluidInventory.isEmpty();
        }

        public void onContentsChanged() {
            this.itemStacks = null;
            this.fluidStacks = null;
            this.onContentsChanged.run();
        }

        private void add(AEKey what, long amount) {
            if (amount <= 0L) {
                return;
            }
            if (what instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)what;
                ItemStack stack = itemKey.toStack();
                this.itemInventory.addTo((Object)stack, amount);
            } else if (what instanceof AEFluidKey) {
                AEFluidKey fluidKey = (AEFluidKey)what;
                FluidStack stack = fluidKey.toStack(1);
                this.fluidInventory.addTo((Object)stack, amount);
            }
        }

        public List<ItemStack> getItems() {
            if (this.itemStacks == null) {
                this.itemStacks = new ArrayList<ItemStack>();
                this.itemInventory.object2LongEntrySet().stream().map(e -> GTMath.splitStacks((ItemStack)e.getKey(), e.getLongValue())).forEach(this.itemStacks::addAll);
            }
            return this.itemStacks;
        }

        public List<FluidStack> getFluids() {
            if (this.fluidStacks == null) {
                this.fluidStacks = new ArrayList<FluidStack>();
                this.fluidInventory.object2LongEntrySet().stream().map(e -> GTMath.splitFluidStacks((FluidStack)e.getKey(), e.getLongValue())).forEach(this.fluidStacks::addAll);
            }
            return this.fluidStacks;
        }

        public void refund() {
            IGrid network = MEPatternBufferPartMachine.this.getMainNode().getGrid();
            if (network != null) {
                long inserted;
                AEItemKey key;
                ItemStack stack;
                Object2LongMap.Entry entry;
                MEStorage networkInv = network.getStorageService().getInventory();
                IEnergyService energy = network.getEnergyService();
                ObjectIterator it = this.itemInventory.object2LongEntrySet().iterator();
                while (it.hasNext()) {
                    entry = (Object2LongMap.Entry)it.next();
                    stack = (ItemStack)entry.getKey();
                    long count = entry.getLongValue();
                    if (stack.isEmpty() || count == 0L) {
                        it.remove();
                        continue;
                    }
                    key = AEItemKey.of((ItemStack)stack);
                    if (key == null || (inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkInv, (AEKey)key, (long)count, (IActionSource)MEPatternBufferPartMachine.this.actionSource)) <= 0L) continue;
                    if ((count -= inserted) == 0L) {
                        it.remove();
                        continue;
                    }
                    entry.setValue(count);
                }
                it = this.fluidInventory.object2LongEntrySet().iterator();
                while (it.hasNext()) {
                    entry = (Object2LongMap.Entry)it.next();
                    stack = (FluidStack)entry.getKey();
                    long amount = entry.getLongValue();
                    if (stack.isEmpty() || amount == 0L) {
                        it.remove();
                        continue;
                    }
                    key = AEFluidKey.of((FluidStack)stack);
                    if (key == null || (inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkInv, (AEKey)key, (long)amount, (IActionSource)MEPatternBufferPartMachine.this.actionSource)) <= 0L) continue;
                    if ((amount -= inserted) == 0L) {
                        it.remove();
                        continue;
                    }
                    entry.setValue(amount);
                }
                this.onContentsChanged();
            }
        }

        public void pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
            patternDetails.pushInputsToExternalInventory(inputHolder, this::add);
            this.onContentsChanged();
        }

        @Nullable
        public List<Ingredient> handleItemInternal(List<Ingredient> left, boolean simulate) {
            boolean changed = false;
            ListIterator<Ingredient> it = left.listIterator();
            while (it.hasNext()) {
                Ingredient ingredient = it.next();
                if (ingredient.isEmpty()) {
                    it.remove();
                    continue;
                }
                ItemStack[] items = ingredient.getItems();
                if (items.length == 0 || items[0].isEmpty()) {
                    it.remove();
                    continue;
                }
                int amount = items[0].getCount();
                ObjectIterator it2 = this.itemInventory.object2LongEntrySet().iterator();
                while (it2.hasNext()) {
                    Object2LongMap.Entry entry = (Object2LongMap.Entry)it2.next();
                    ItemStack stack = (ItemStack)entry.getKey();
                    long count = entry.getLongValue();
                    if (stack.isEmpty() || count == 0L) {
                        it2.remove();
                        continue;
                    }
                    if (!ingredient.test(stack)) continue;
                    int extracted = Math.min(GTMath.saturatedCast(count), amount);
                    if (!simulate && extracted > 0) {
                        changed = true;
                        if ((count -= (long)extracted) == 0L) {
                            it2.remove();
                        } else {
                            entry.setValue(count);
                        }
                    }
                    if ((amount -= extracted) > 0) continue;
                    it.remove();
                    break;
                }
                if (amount <= 0) continue;
                if (ingredient instanceof SizedIngredient) {
                    SizedIngredient si = (SizedIngredient)ingredient;
                    si.setAmount(amount);
                    continue;
                }
                items[0].setCount(amount);
            }
            if (changed) {
                this.onContentsChanged();
            }
            return left.isEmpty() ? null : left;
        }

        @Nullable
        public List<FluidIngredient> handleFluidInternal(List<FluidIngredient> left, boolean simulate) {
            boolean changed = false;
            ListIterator<FluidIngredient> it = left.listIterator();
            while (it.hasNext()) {
                FluidIngredient ingredient = it.next();
                if (ingredient.isEmpty()) {
                    it.remove();
                    continue;
                }
                FluidStack[] fluids = ingredient.getStacks();
                if (fluids.length == 0 || fluids[0].isEmpty()) {
                    it.remove();
                    continue;
                }
                int amount = fluids[0].getAmount();
                ObjectIterator it2 = this.fluidInventory.object2LongEntrySet().iterator();
                while (it2.hasNext()) {
                    Object2LongMap.Entry entry = (Object2LongMap.Entry)it2.next();
                    FluidStack stack = (FluidStack)entry.getKey();
                    long count = entry.getLongValue();
                    if (stack.isEmpty() || count == 0L) {
                        it2.remove();
                        continue;
                    }
                    if (!ingredient.test(stack)) continue;
                    int extracted = Math.min(GTMath.saturatedCast(count), amount);
                    if (!simulate && extracted > 0) {
                        changed = true;
                        if ((count -= (long)extracted) == 0L) {
                            it2.remove();
                        } else {
                            entry.setValue(count);
                        }
                    }
                    if ((amount -= extracted) > 0) continue;
                    it.remove();
                    break;
                }
                if (amount <= 0) continue;
                ingredient.setAmount(amount);
            }
            if (changed) {
                this.onContentsChanged();
            }
            return left.isEmpty() ? null : left;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            ListTag itemsTag = new ListTag();
            for (Object2LongMap.Entry entry : this.itemInventory.object2LongEntrySet()) {
                CompoundTag ct = ((ItemStack)entry.getKey()).serializeNBT();
                ct.putLong("real", entry.getLongValue());
                itemsTag.add((Object)ct);
            }
            if (!itemsTag.isEmpty()) {
                tag.put("inventory", (Tag)itemsTag);
            }
            ListTag fluidsTag = new ListTag();
            for (Object2LongMap.Entry entry : this.fluidInventory.object2LongEntrySet()) {
                CompoundTag ct = ((FluidStack)entry.getKey()).writeToNBT(new CompoundTag());
                ct.putLong("real", entry.getLongValue());
                fluidsTag.add((Object)ct);
            }
            if (!fluidsTag.isEmpty()) {
                tag.put("fluidInventory", (Tag)fluidsTag);
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            ListTag items = tag.getList("inventory", 10);
            for (Tag t : items) {
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag ct = (CompoundTag)t;
                ItemStack stack = ItemStack.of((CompoundTag)ct);
                long count = ct.getLong("real");
                if (stack.isEmpty() || count <= 0L) continue;
                this.itemInventory.put((Object)stack, count);
            }
            ListTag fluids = tag.getList("fluidInventory", 10);
            for (Tag t : fluids) {
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag ct = (CompoundTag)t;
                FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)ct);
                long amount = ct.getLong("real");
                if (stack.isEmpty() || amount <= 0L) continue;
                this.fluidInventory.put((Object)stack, amount);
            }
        }

        @Generated
        public Runnable getOnContentsChanged() {
            return this.onContentsChanged;
        }

        @Generated
        public void setOnContentsChanged(Runnable onContentsChanged) {
            this.onContentsChanged = onContentsChanged;
        }
    }

    public record BufferData(Object2LongMap<ItemStack> items, Object2LongMap<FluidStack> fluids) {
    }
}

