/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.slot;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAESlot;
import com.gregtechceu.gtceu.utils.GTMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExportOnlyAEItemSlot
extends ExportOnlyAESlot
implements IItemHandlerModifiable {
    public ExportOnlyAEItemSlot() {
    }

    public ExportOnlyAEItemSlot(@Nullable GenericStack config, @Nullable GenericStack stock) {
        super(config, stock);
    }

    @Override
    public void addStack(GenericStack stack) {
        this.stock = this.stock == null ? stack : GenericStack.sum((GenericStack)this.stock, (GenericStack)stack);
        this.onContentsChanged();
    }

    @Override
    public void setStock(@Nullable GenericStack stack) {
        if (this.stock == null && stack == null) {
            return;
        }
        if (stack == null) {
            this.stock = null;
        } else {
            if (stack.equals((Object)this.stock)) {
                return;
            }
            this.stock = stack;
        }
        this.onContentsChanged();
    }

    public int getSlots() {
        return 1;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 0 && this.stock != null) {
            ItemStack itemStack;
            AEKey aEKey = this.stock.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                itemStack = itemKey.toStack(GTMath.saturatedCast(this.stock.amount()));
            } else {
                itemStack = ItemStack.EMPTY;
            }
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return false;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0 && this.stock != null) {
            int extracted = (int)Math.min(this.stock.amount(), (long)amount);
            AEKey aEKey = this.stock.what();
            if (!(aEKey instanceof AEItemKey)) {
                return ItemStack.EMPTY;
            }
            AEItemKey itemKey = (AEItemKey)aEKey;
            ItemStack result = itemKey.toStack(extracted);
            if (!simulate) {
                this.stock = ExportOnlyAESlot.copy(this.stock, this.stock.amount() - (long)extracted);
                if (this.stock.amount() == 0L) {
                    this.stock = null;
                }
            }
            this.onContentsChanged();
            return result;
        }
        return ItemStack.EMPTY;
    }

    public void onContentsChanged() {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }

    @Override
    public ExportOnlyAEItemSlot copy() {
        return new ExportOnlyAEItemSlot(this.config == null ? null : ExportOnlyAEItemSlot.copy(this.config), this.stock == null ? null : ExportOnlyAEItemSlot.copy(this.stock));
    }
}

