/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.utils;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Iterator;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class KeyStorage
implements ITagSerializable<ListTag>,
IContentChangeAware,
Iterable<Object2LongMap.Entry<AEKey>> {
    public final Object2LongMap<AEKey> storage = new Object2LongOpenHashMap();
    @Nullable
    private Runnable onContentsChanged;

    public void insertInventory(MEStorage inventory, IActionSource source) {
        Iterator<Object2LongMap.Entry<AEKey>> it = this.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            long amount;
            Object2LongMap.Entry<AEKey> entry = it.next();
            AEKey key = (AEKey)entry.getKey();
            long inserted = inventory.insert(key, amount = entry.getLongValue(), Actionable.MODULATE, source);
            if (inserted <= 0L) continue;
            changed = true;
            if (inserted >= amount) {
                it.remove();
                continue;
            }
            entry.setValue(amount - inserted);
        }
        if (changed) {
            this.onChanged();
        }
    }

    public void onChanged() {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }

    public ListTag serializeNBT() {
        ListTag list = new ListTag();
        for (Object2LongMap.Entry entry : this.storage.object2LongEntrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.put("key", (Tag)((AEKey)entry.getKey()).toTagGeneric());
            tag.putLong("value", entry.getLongValue());
            list.add((Object)tag);
        }
        return list;
    }

    public void deserializeNBT(ListTag tags) {
        for (int i = 0; i < tags.size(); ++i) {
            CompoundTag tag = tags.getCompound(i);
            AEKey key = AEKey.fromTagGeneric((CompoundTag)tag.getCompound("key"));
            long value = tag.getLong("value");
            this.storage.put((Object)key, value);
        }
    }

    @Override
    public Iterator<Object2LongMap.Entry<AEKey>> iterator() {
        return this.storage.object2LongEntrySet().iterator();
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Nullable
    @Generated
    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    @Generated
    public void setOnContentsChanged(@Nullable Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }
}

