/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.cctweaked.peripherals;

import com.gregtechceu.gtceu.api.capability.ICentralMonitor;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IMonitorModuleItem;
import com.gregtechceu.gtceu.common.item.modules.ImageModuleBehaviour;
import com.gregtechceu.gtceu.common.item.modules.TextModuleBehaviour;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.monitor.MonitorGroup;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CentralMonitorPeripheral
implements GenericPeripheral {
    public String id() {
        return "gtceu:central_monitor";
    }

    @LuaFunction
    public static MethodResult getGroups(ICentralMonitor centralMonitor) {
        return MethodResult.of(centralMonitor.getMonitorGroups().stream().map(LuaMonitorGroup::new).toList());
    }

    public static class LuaMonitorModule {
        private final ItemStack stack;

        public LuaMonitorModule(ItemStack stack) {
            this.stack = stack;
        }

        @Nullable
        private IMonitorModuleItem getModuleItem() {
            Item item = this.stack.getItem();
            if (item instanceof ComponentItem) {
                ComponentItem componentItem = (ComponentItem)item;
                for (IItemComponent component : componentItem.getComponents()) {
                    if (!(component instanceof IMonitorModuleItem)) continue;
                    IMonitorModuleItem moduleItem = (IMonitorModuleItem)component;
                    return moduleItem;
                }
            }
            return null;
        }

        @LuaFunction
        public String getType() {
            if (this.stack.isEmpty()) {
                return "none";
            }
            IMonitorModuleItem moduleItem = this.getModuleItem();
            if (moduleItem != null) {
                return moduleItem.getType();
            }
            return "invalid";
        }

        @LuaFunction
        public MethodResult getCurrentText() {
            IMonitorModuleItem iMonitorModuleItem = this.getModuleItem();
            if (iMonitorModuleItem instanceof TextModuleBehaviour) {
                TextModuleBehaviour textModule = (TextModuleBehaviour)iMonitorModuleItem;
                return MethodResult.of((Object)textModule.getText(this.stack).toString());
            }
            return MethodResult.of();
        }

        @LuaFunction
        public void setPlaceholderText(String text) {
            IMonitorModuleItem iMonitorModuleItem = this.getModuleItem();
            if (iMonitorModuleItem instanceof TextModuleBehaviour) {
                TextModuleBehaviour textModule = (TextModuleBehaviour)iMonitorModuleItem;
                textModule.setPlaceholderText(this.stack, text);
            }
        }

        @LuaFunction
        public MethodResult getScale() {
            IMonitorModuleItem iMonitorModuleItem = this.getModuleItem();
            if (iMonitorModuleItem instanceof TextModuleBehaviour) {
                TextModuleBehaviour textModule = (TextModuleBehaviour)iMonitorModuleItem;
                return MethodResult.of((Object)textModule.getScale(this.stack));
            }
            return MethodResult.of();
        }

        @LuaFunction
        public void setScale(double scale) {
            IMonitorModuleItem iMonitorModuleItem = this.getModuleItem();
            if (iMonitorModuleItem instanceof TextModuleBehaviour) {
                TextModuleBehaviour textModule = (TextModuleBehaviour)iMonitorModuleItem;
                textModule.setScale(this.stack, scale);
            }
        }

        @LuaFunction
        public MethodResult getImageUrl() {
            IMonitorModuleItem iMonitorModuleItem = this.getModuleItem();
            if (iMonitorModuleItem instanceof ImageModuleBehaviour) {
                ImageModuleBehaviour imageModule = (ImageModuleBehaviour)iMonitorModuleItem;
                return MethodResult.of((Object)imageModule.getUrl(this.stack));
            }
            return MethodResult.of();
        }

        @LuaFunction
        public void setImageUrl(String url) {
            IMonitorModuleItem iMonitorModuleItem = this.getModuleItem();
            if (iMonitorModuleItem instanceof ImageModuleBehaviour) {
                ImageModuleBehaviour imageModule = (ImageModuleBehaviour)iMonitorModuleItem;
                imageModule.setUrl(this.stack, url);
            }
        }
    }

    public static class LuaMonitorGroup {
        private final MonitorGroup group;

        public LuaMonitorGroup(MonitorGroup group) {
            this.group = group;
        }

        @LuaFunction
        public String getName() {
            return this.group.getName();
        }

        @LuaFunction
        public LuaMonitorModule getModule() {
            return new LuaMonitorModule(this.group.getItemStackHandler().getStackInSlot(0));
        }
    }
}

