/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.cctweaked.peripherals;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.placeholder.IPlaceholderInfoProviderCover;
import com.gregtechceu.gtceu.api.placeholder.MultiLineComponent;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderContext;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderHandler;
import com.gregtechceu.gtceu.common.cover.ComputerMonitorCover;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;

public class CoverHolderPeripheral
implements GenericPeripheral {
    public String id() {
        return "gtceu:coverable";
    }

    @LuaFunction
    public static MethodResult setBufferedText(ICoverable coverable, String face, int line, String text) {
        Direction direction = Direction.byName((String)face);
        if (direction == null) {
            return MethodResult.of((Object[])new Object[]{false, "invalid face"});
        }
        if (line < 1 || line > 100) {
            return MethodResult.of((Object[])new Object[]{false, "line must be from 1 to 100 (inclusive)"});
        }
        CoverBehavior coverBehavior = coverable.getCoverAtSide(direction);
        if (coverBehavior instanceof IPlaceholderInfoProviderCover) {
            IPlaceholderInfoProviderCover cover = (IPlaceholderInfoProviderCover)((Object)coverBehavior);
            cover.setDisplayTargetBufferLine(line, Component.literal((String)text));
            return MethodResult.of((Object[])new Object[]{true, "success"});
        }
        return MethodResult.of((Object[])new Object[]{false, "invalid cover"});
    }

    @LuaFunction
    public static MethodResult parsePlaceholders(ICoverable coverable, String face, String text) {
        Direction direction = Direction.byName((String)face);
        if (direction == null) {
            return MethodResult.of((Object[])new Object[]{false, "invalid face"});
        }
        CoverBehavior coverBehavior = coverable.getCoverAtSide(direction);
        if (coverBehavior instanceof ComputerMonitorCover) {
            ComputerMonitorCover cover = (ComputerMonitorCover)coverBehavior;
            return MethodResult.of((Object[])new Object[]{true, PlaceholderHandler.processPlaceholders(text, new PlaceholderContext(coverable.getLevel(), coverable.getPos(), direction, cover.itemStackHandler, cover, new MultiLineComponent(cover.getText()), cover.getPlaceholderUUID()))});
        }
        return MethodResult.of((Object[])new Object[]{false, "invalid cover"});
    }
}

