/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.storage.CreativeChestMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferProxyPartMachine;
import com.gregtechceu.gtceu.utils.GTMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum GTItemStorageProvider implements IServerExtensionProvider<MetaMachineBlockEntity, ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return GTCEu.id("custom_item_storage");
    }

    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> list) {
        return ItemStorageProvider.INSTANCE.getClientGroups(accessor, list);
    }

    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(ServerPlayer serverPlayer, ServerLevel serverLevel, MetaMachineBlockEntity mmbe, boolean b) {
        MetaMachine machine = mmbe.getMetaMachine();
        if (machine instanceof QuantumChestMachine) {
            QuantumChestMachine qcm = (QuantumChestMachine)machine;
            ItemStack stored = qcm.getStored();
            long amount = qcm.getStoredAmount();
            if (qcm instanceof CreativeChestMachine) {
                CreativeChestMachine ccm = (CreativeChestMachine)qcm;
                amount = (long)Math.ceil(1.0 * (double)ccm.getItemsPerCycle() / (double)ccm.getTicksPerCycle());
            }
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int stack : GTMath.split(amount)) {
                list.add(stored.copyWithCount(stack));
            }
            return list.isEmpty() ? Collections.emptyList() : List.of(new ViewGroup(list));
        }
        if (machine instanceof MEPatternBufferProxyPartMachine) {
            MEPatternBufferProxyPartMachine proxy = (MEPatternBufferProxyPartMachine)machine;
            MEPatternBufferPartMachine buffer = proxy.getBuffer();
            if (buffer == null) {
                return Collections.emptyList();
            }
            return ItemStorageProvider.INSTANCE.getGroups(serverPlayer, serverLevel, (Object)buffer.holder, b);
        }
        return ItemStorageProvider.INSTANCE.getGroups(serverPlayer, serverLevel, (Object)mmbe, b);
    }
}

