/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class MachineModeProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag serverData = blockAccessor.getServerData();
        if (serverData.contains("RecipeTypes") && serverData.contains("CurrentRecipeType")) {
            int currentRecipeTypeIndex = serverData.getInt("CurrentRecipeType");
            ListTag recipeTypesTagList = serverData.getList("RecipeTypes", 8);
            if (blockAccessor.showDetails()) {
                iTooltip.add((Component)Component.translatable((String)"gtceu.top.machine_mode"));
                for (int i = 0; i < recipeTypesTagList.size(); ++i) {
                    ResourceLocation recipeType = new ResourceLocation(recipeTypesTagList.getString(i));
                    MutableComponent text = currentRecipeTypeIndex == i ? Component.literal((String)" > ").withStyle(ChatFormatting.BLUE) : Component.literal((String)"   ");
                    text.append((Component)Component.translatable((String)"%s.%s".formatted(recipeType.getNamespace(), recipeType.getPath())));
                    iTooltip.add((Component)text);
                }
            } else {
                ResourceLocation recipeType = new ResourceLocation(recipeTypesTagList.getString(currentRecipeTypeIndex));
                iTooltip.add((Component)Component.translatable((String)"gtceu.top.machine_mode").append((Component)Component.translatable((String)"%s.%s".formatted(recipeType.getNamespace(), recipeType.getPath()))));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        MetaMachine metaMachine;
        MetaMachineBlockEntity blockEntity;
        GTRecipeType[] recipeTypes;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof MetaMachineBlockEntity && (recipeTypes = (blockEntity = (MetaMachineBlockEntity)blockEntity2).getMetaMachine().getDefinition().getRecipeTypes()) != null && recipeTypes.length > 1 && (metaMachine = blockEntity.getMetaMachine()) instanceof IRecipeLogicMachine) {
            IRecipeLogicMachine recipeLogicMachine = (IRecipeLogicMachine)((Object)metaMachine);
            ListTag recipeTypesTagList = new ListTag();
            GTRecipeType currentRecipeType = recipeLogicMachine.getRecipeType();
            int currentRecipeTypeIndex = -1;
            for (int i = 0; i < recipeTypes.length; ++i) {
                if (recipeTypes[i] == currentRecipeType) {
                    currentRecipeTypeIndex = i;
                }
                recipeTypesTagList.add((Object)StringTag.valueOf((String)recipeTypes[i].registryName.toString()));
            }
            compoundTag.put("RecipeTypes", (Tag)recipeTypesTagList);
            compoundTag.putInt("CurrentRecipeType", currentRecipeTypeIndex);
        }
    }

    public ResourceLocation getUid() {
        return GTCEu.id("machine_mode");
    }
}

