/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class ParallelProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (blockAccessor.getServerData().contains("parallel")) {
            int parallel = blockAccessor.getServerData().getInt("parallel");
            if (!blockAccessor.getServerData().getBoolean("exact") && parallel > 1) {
                MutableComponent parallels = Component.literal((String)FormattingUtil.formatNumbers(parallel)).withStyle(ChatFormatting.DARK_PURPLE);
                String key = "gtceu.multiblock.parallel";
                iTooltip.add((Component)Component.translatable((String)key, (Object[])new Object[]{parallels}));
            } else {
                int subtickParallel;
                int batch = blockAccessor.getServerData().getInt("batch");
                int totalRuns = parallel * batch * (subtickParallel = blockAccessor.getServerData().getInt("subtickParallel"));
                if (totalRuns == 1) {
                    return;
                }
                MutableComponent runs = Component.literal((String)FormattingUtil.formatNumbers(totalRuns)).withStyle(ChatFormatting.DARK_PURPLE);
                String key = "gtceu.multiblock.total_runs";
                iTooltip.add((Component)Component.translatable((String)key, (Object[])new Object[]{runs}));
                if (parallel > 1) {
                    MutableComponent parallels = Component.literal((String)FormattingUtil.formatNumbers(parallel)).withStyle(ChatFormatting.DARK_PURPLE);
                    String keyParallel = "gtceu.multiblock.parallel.exact";
                    iTooltip.add((Component)Component.translatable((String)keyParallel, (Object[])new Object[]{parallels}));
                }
                if (batch > 1) {
                    MutableComponent batches = Component.literal((String)FormattingUtil.formatNumbers(batch)).withStyle(ChatFormatting.DARK_PURPLE);
                    String keyBatch = "gtceu.multiblock.batch_enabled";
                    iTooltip.add((Component)Component.translatable((String)keyBatch, (Object[])new Object[]{batches}));
                }
                if (subtickParallel > 1) {
                    MutableComponent subticks = Component.literal((String)FormattingUtil.formatNumbers(subtickParallel)).withStyle(ChatFormatting.DARK_PURPLE);
                    String keySubtick = "gtceu.multiblock.subtick_parallels";
                    iTooltip.add((Component)Component.translatable((String)keySubtick, (Object[])new Object[]{subticks}));
                }
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity blockEntity2 = (MetaMachineBlockEntity)blockEntity;
            MetaMachine metaMachine = blockEntity2.getMetaMachine();
            if (metaMachine instanceof IParallelHatch) {
                IParallelHatch parallelHatch2 = (IParallelHatch)((Object)metaMachine);
                compoundTag.putInt("parallel", parallelHatch2.getCurrentParallel());
            } else {
                metaMachine = blockEntity2.getMetaMachine();
                if (metaMachine instanceof IMultiController) {
                    IRecipeLogicMachine rlm;
                    IMultiController controller = (IMultiController)((Object)metaMachine);
                    if (controller instanceof IRecipeLogicMachine && (rlm = (IRecipeLogicMachine)((Object)controller)).getRecipeLogic().isActive() && rlm.getRecipeLogic().getLastRecipe() != null) {
                        compoundTag.putInt("parallel", rlm.getRecipeLogic().getLastRecipe().parallels);
                        compoundTag.putInt("batch", rlm.getRecipeLogic().getLastRecipe().batchParallels);
                        compoundTag.putInt("subtickParallel", rlm.getRecipeLogic().getLastRecipe().subtickParallels);
                        compoundTag.putBoolean("exact", true);
                    } else {
                        controller.getParallelHatch().ifPresent(parallelHatch -> compoundTag.putInt("parallel", parallelHatch.getCurrentParallel()));
                    }
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return GTCEu.id("parallel_info");
    }
}

