/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.SteamParallelMultiblockMachine;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class RecipeLogicProvider
extends CapabilityBlockProvider<RecipeLogic> {
    public RecipeLogicProvider() {
        super(GTCEu.id("recipe_logic_provider"));
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getRecipeLogic(level, pos, side);
    }

    @Override
    protected void write(CompoundTag data, RecipeLogic capability) {
        data.putBoolean("Working", capability.isWorking());
        CompoundTag recipeInfo = new CompoundTag();
        GTRecipe recipe = capability.getLastRecipe();
        if (recipe != null) {
            EnergyStack.WithIO EUt = RecipeHelper.getRealEUtWithIO(recipe);
            recipeInfo.putLong("EUt", EUt.getTotalEU());
            recipeInfo.putLong("voltage", RecipeLogicProvider.getVoltage(capability));
            recipeInfo.putBoolean("isInput", EUt.isInput());
        }
        if (!recipeInfo.isEmpty()) {
            data.put("Recipe", (Tag)recipeInfo);
        }
    }

    public static long getVoltage(RecipeLogic capability) {
        long voltage = -1L;
        IRecipeLogicMachine iRecipeLogicMachine = capability.machine;
        if (iRecipeLogicMachine instanceof SimpleTieredMachine) {
            SimpleTieredMachine machine = (SimpleTieredMachine)iRecipeLogicMachine;
            voltage = GTValues.V[machine.getTier()];
        } else {
            iRecipeLogicMachine = capability.machine;
            if (iRecipeLogicMachine instanceof WorkableElectricMultiblockMachine) {
                WorkableElectricMultiblockMachine machine = (WorkableElectricMultiblockMachine)iRecipeLogicMachine;
                voltage = machine.getParts().stream().filter(EnergyHatchPartMachine.class::isInstance).map(EnergyHatchPartMachine.class::cast).mapToLong(dynamo -> GTValues.V[dynamo.getTier()]).max().orElse(-1L);
            }
        }
        if (voltage == -1L) {
            voltage = 32L;
        }
        return voltage;
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        CompoundTag recipeInfo;
        if (capData.getBoolean("Working") && !(recipeInfo = capData.getCompound("Recipe")).isEmpty()) {
            long EUt = recipeInfo.getLong("EUt");
            boolean isInput = recipeInfo.getBoolean("isInput");
            boolean isSteam = false;
            if (blockEntity instanceof MetaMachineBlockEntity) {
                MetaMachineBlockEntity mbe = (MetaMachineBlockEntity)blockEntity;
                MetaMachine machine = mbe.getMetaMachine();
                if (machine instanceof SimpleSteamMachine) {
                    SimpleSteamMachine ssm = (SimpleSteamMachine)machine;
                    EUt = (long)((double)EUt * ssm.getConversionRate());
                    isSteam = true;
                } else if (machine instanceof SteamParallelMultiblockMachine) {
                    SteamParallelMultiblockMachine smb = (SteamParallelMultiblockMachine)machine;
                    EUt = (long)((double)EUt * smb.getConversionRate());
                    isSteam = true;
                }
            }
            if (EUt > 0L) {
                MutableComponent text;
                if (isSteam) {
                    text = Component.translatable((String)"gtceu.jade.fluid_use", (Object[])new Object[]{FormattingUtil.formatNumbers(EUt)}).withStyle(ChatFormatting.GREEN);
                } else {
                    long voltage = recipeInfo.getLong("voltage");
                    byte tier = GTUtil.getTierByVoltage(voltage);
                    float minAmperage = (float)EUt / (float)voltage;
                    text = Component.translatable((String)"gtceu.jade.amperage_use", (Object[])new Object[]{FormattingUtil.formatNumber2Places(minAmperage)}).withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"gtceu.jade.at").withStyle(ChatFormatting.GREEN));
                    if (tier < GTValues.TIER_COUNT) {
                        text = text.append((Component)Component.literal((String)GTValues.VNF[tier]).withStyle(style -> style.withColor(GTValues.VC[tier])));
                    } else {
                        int speed = Mth.clamp((int)(tier - GTValues.TIER_COUNT - 1), (int)0, (int)GTValues.TIER_COUNT);
                        text = text.append((Component)Component.literal((String)"MAX").withStyle(style -> style.withColor(TooltipHelper.rainbowColor(speed))).append((Component)Component.literal((String)"+").withStyle(style -> style.withColor(GTValues.VC[speed])).append(FormattingUtil.formatNumbers(speed))));
                    }
                    text.append((Component)Component.translatable((String)"gtceu.universal.padded_parentheses", (Object[])new Object[]{Component.translatable((String)"gtceu.recipe.eu.total", (Object[])new Object[]{FormattingUtil.formatNumbers(EUt)})}).withStyle(ChatFormatting.WHITE));
                }
                if (isInput) {
                    tooltip.add((Component)Component.translatable((String)"gtceu.top.energy_consumption").append(" ").append((Component)text));
                } else {
                    tooltip.add((Component)Component.translatable((String)"gtceu.top.energy_production").append(" ").append((Component)text));
                }
            }
        }
    }
}

