/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jei.multipage;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.gui.widget.PatternPreviewWidget;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.integration.jei.multipage.MultiblockInfoWrapper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.ModularUIRecipeCategory;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MultiblockInfoCategory
extends ModularUIRecipeCategory<MultiblockInfoWrapper> {
    public static final RecipeType<MultiblockInfoWrapper> RECIPE_TYPE = new RecipeType(GTCEu.id("multiblock_info"), MultiblockInfoWrapper.class);
    private final IDrawable background;
    private final IDrawable icon;

    public MultiblockInfoCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(160, 160);
        this.icon = helpers.getGuiHelper().createDrawableItemStack(GTMultiMachines.ELECTRIC_BLAST_FURNACE.asStack());
    }

    public static void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(RECIPE_TYPE, GTRegistries.MACHINES.values().stream().filter(MultiblockMachineDefinition.class::isInstance).map(MultiblockMachineDefinition.class::cast).filter(MultiblockMachineDefinition::isRenderXEIPreview).map(MultiblockInfoWrapper::new).toList());
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, final @NotNull MultiblockInfoWrapper recipe, @NotNull IFocusGroup focuses) {
        super.createRecipeExtras(builder, (Object)recipe, focuses);
        final ArrayList slots = new ArrayList(builder.getRecipeSlots().getSlots());
        class ProxyRecipeWidget
        implements ISlottedRecipeWidget {
            private final ScreenPosition position = new ScreenPosition(0, 0);

            ProxyRecipeWidget() {
            }

            public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
                PatternPreviewWidget panel = (PatternPreviewWidget)recipe.getWidget();
                Position pos = panel.getSelfPosition();
                Size size = panel.getSize();
                boolean inParent = Widget.isMouseOver((int)pos.x, (int)pos.y, (int)size.width, (int)size.height, (double)mouseX, (double)mouseY);
                if (!inParent) {
                    return Optional.empty();
                }
                List widgets = recipe.modularUI.getFlatWidgetCollection();
                return slots.stream().filter(slot -> {
                    Optional slotName = slot.getSlotName();
                    if (slotName.isEmpty()) {
                        return false;
                    }
                    String name = (String)slotName.get();
                    int index = Integer.parseInt(name.substring(5));
                    Widget widget = (Widget)widgets.get(index);
                    slot.setPosition(widget.getPositionX(), widget.getPositionY());
                    return slot.isMouseOver(mouseX, mouseY);
                }).findFirst().map(slot -> new RecipeSlotUnderMouse(slot, 0, 0));
            }

            public ScreenPosition getPosition() {
                return this.position;
            }
        }
        builder.addSlottedWidget((ISlottedRecipeWidget)new ProxyRecipeWidget(), slots);
    }

    @Nullable
    public ResourceLocation getRegistryName(@NotNull MultiblockInfoWrapper recipe) {
        return recipe.definition.getId();
    }

    @NotNull
    public RecipeType<MultiblockInfoWrapper> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gtceu.jei.multiblock_info");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

