/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders;

import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class FluidVeinBuilderJS {
    private final ResourceLocation id;
    private int weight;
    private int minimumYield;
    private int maximumYield;
    private int depletionAmount;
    private int depletionChance = 1;
    private int depletedYield;
    private Supplier<Fluid> fluid;
    private final List<BiomeWeightModifier> biomes = new LinkedList<BiomeWeightModifier>();
    private final transient Set<ResourceKey<Level>> dimensions = new HashSet<ResourceKey<Level>>();

    public FluidVeinBuilderJS(ResourceLocation id) {
        this.id = id;
    }

    public FluidVeinBuilderJS yield(int min, int max) {
        return this.minimumYield(min).maximumYield(max);
    }

    public FluidVeinBuilderJS addSpawnDimension(ResourceLocation ... dimensions) {
        for (ResourceLocation dimension : dimensions) {
            this.dimensions.add((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension));
        }
        return this;
    }

    public FluidVeinBuilderJS biomes(int weight, String biomes) {
        Registry registry = (Registry)GTRegistries.builtinRegistry().registry(Registries.BIOME).get();
        this.biomes.add(new BiomeWeightModifier(() -> biomes.startsWith("#") ? registry.getOrCreateTag(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation(biomes.substring(1)))) : HolderSet.direct((Holder[])new Holder[]{registry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation(biomes)))}), weight));
        return this;
    }

    public FluidVeinBuilderJS biomes(int weight, String ... biomes) {
        Registry registry = (Registry)GTRegistries.builtinRegistry().registry(Registries.BIOME).get();
        LinkedList<HolderSet.Named> biomeKeys = new LinkedList<HolderSet.Named>();
        for (String biome : biomes) {
            biomeKeys.add((HolderSet.Named)(biome.startsWith("#") ? registry.getOrCreateTag(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation(biome.substring(1)))) : HolderSet.direct((Holder[])new Holder[]{registry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation(biome)))})));
        }
        this.biomes.add(new BiomeWeightModifier(() -> HolderSet.direct(biomeKeys.stream().flatMap(HolderSet::stream).toList()), weight));
        return this;
    }

    @HideFromJS
    public BedrockFluidDefinition build() {
        return new BedrockFluidDefinition(this.id, this.weight, this.minimumYield, this.maximumYield, this.depletionAmount, this.depletionChance, this.depletedYield, this.fluid, this.biomes, this.dimensions);
    }

    @NotNull
    @Generated
    public FluidVeinBuilderJS weight(int weight) {
        this.weight = weight;
        return this;
    }

    @NotNull
    @Generated
    public FluidVeinBuilderJS minimumYield(int minimumYield) {
        this.minimumYield = minimumYield;
        return this;
    }

    @NotNull
    @Generated
    public FluidVeinBuilderJS maximumYield(int maximumYield) {
        this.maximumYield = maximumYield;
        return this;
    }

    @NotNull
    @Generated
    public FluidVeinBuilderJS depletionAmount(int depletionAmount) {
        this.depletionAmount = depletionAmount;
        return this;
    }

    @NotNull
    @Generated
    public FluidVeinBuilderJS depletionChance(int depletionChance) {
        this.depletionChance = depletionChance;
        return this;
    }

    @NotNull
    @Generated
    public FluidVeinBuilderJS depletedYield(int depletedYield) {
        this.depletedYield = depletedYield;
        return this;
    }

    @NotNull
    @Generated
    public FluidVeinBuilderJS fluid(Supplier<Fluid> fluid) {
        this.fluid = fluid;
        return this;
    }
}

