/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.ResearchRecipeBuilder;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.recipe.condition.AdjacentBlockCondition;
import com.gregtechceu.gtceu.common.recipe.condition.AdjacentFluidCondition;
import com.gregtechceu.gtceu.common.recipe.condition.BiomeCondition;
import com.gregtechceu.gtceu.common.recipe.condition.CleanroomCondition;
import com.gregtechceu.gtceu.common.recipe.condition.DaytimeCondition;
import com.gregtechceu.gtceu.common.recipe.condition.DimensionCondition;
import com.gregtechceu.gtceu.common.recipe.condition.EnvironmentalHazardCondition;
import com.gregtechceu.gtceu.common.recipe.condition.FTBQuestCondition;
import com.gregtechceu.gtceu.common.recipe.condition.GameStageCondition;
import com.gregtechceu.gtceu.common.recipe.condition.HeraclesQuestCondition;
import com.gregtechceu.gtceu.common.recipe.condition.PositionYCondition;
import com.gregtechceu.gtceu.common.recipe.condition.RainingCondition;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.common.recipe.condition.ThunderCondition;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.CapabilityMap;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.ExtendedOutputItem;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.GTRecipeComponents;
import com.gregtechceu.gtceu.utils.ResearchManager;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.Generated;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GTRecipeSchema {
    public static final RecipeKey<ResourceLocation> ID = GTRecipeComponents.RESOURCE_LOCATION.key("id");
    public static final RecipeKey<Long> DURATION = TimeComponent.TICKS.key("duration").optional((Object)100L);
    public static final RecipeKey<CompoundTag> DATA = GTRecipeComponents.TAG.key("data").optional((Object)null);
    public static final RecipeKey<RecipeCondition[]> CONDITIONS = GTRecipeComponents.RECIPE_CONDITION.asArray().key("recipeConditions").optional((Object)new RecipeCondition[0]);
    public static final RecipeKey<ResourceLocation> CATEGORY = GTRecipeComponents.RESOURCE_LOCATION.key("category").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_INPUTS = GTRecipeComponents.IN.key("inputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_TICK_INPUTS = GTRecipeComponents.TICK_IN.key("tickInputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_OUTPUTS = GTRecipeComponents.OUT.key("outputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_TICK_OUTPUTS = GTRecipeComponents.TICK_OUT.key("tickOutputs").defaultOptional();
    public static final RecipeKey<Map<RecipeCapability<?>, ChanceLogic>> INPUT_CHANCE_LOGICS = GTRecipeComponents.CHANCE_LOGIC_MAP.key("inputChanceLogics").defaultOptional();
    public static final RecipeKey<Map<RecipeCapability<?>, ChanceLogic>> OUTPUT_CHANCE_LOGICS = GTRecipeComponents.CHANCE_LOGIC_MAP.key("outputChanceLogics").defaultOptional();
    public static final RecipeKey<Map<RecipeCapability<?>, ChanceLogic>> TICK_INPUT_CHANCE_LOGICS = GTRecipeComponents.CHANCE_LOGIC_MAP.key("tickInputChanceLogics").defaultOptional();
    public static final RecipeKey<Map<RecipeCapability<?>, ChanceLogic>> TICK_OUTPUT_CHANCE_LOGICS = GTRecipeComponents.CHANCE_LOGIC_MAP.key("tickOutputChanceLogics").defaultOptional();
    public static final RecipeSchema SCHEMA = new RecipeSchema(GTRecipeJS.class, GTRecipeJS::new, new RecipeKey[]{DURATION, DATA, CONDITIONS, ALL_INPUTS, ALL_TICK_INPUTS, ALL_OUTPUTS, ALL_TICK_OUTPUTS, INPUT_CHANCE_LOGICS, OUTPUT_CHANCE_LOGICS, TICK_INPUT_CHANCE_LOGICS, TICK_OUTPUT_CHANCE_LOGICS, CATEGORY}).constructor((recipe, schemaType, keys, from) -> recipe.id((ResourceLocation)from.getValue(recipe, ID)), new RecipeKey[]{ID}).constructor(RecipeConstructor.Factory.DEFAULT, new RecipeKey[0]).constructor(new RecipeKey[]{DURATION, CONDITIONS, ALL_INPUTS, ALL_OUTPUTS, ALL_TICK_INPUTS, ALL_TICK_OUTPUTS}).uniqueId(GTRecipeSchema::makeDefaultRecipeId);

    @Nullable
    public static String makeDefaultRecipeId(RecipeJS recipe) {
        String outputId = GTRecipeSchema.resolveRecipeIdFromOutputs(recipe, (CapabilityMap)recipe.getValue(ALL_OUTPUTS));
        if (outputId == null) {
            outputId = GTRecipeSchema.resolveRecipeIdFromOutputs(recipe, (CapabilityMap)recipe.getValue(ALL_TICK_OUTPUTS));
        }
        if (outputId == null) {
            return null;
        }
        return RecipeSchema.normalizeId((String)outputId).replace('/', '_');
    }

    @Nullable
    private static String resolveRecipeIdFromOutputs(RecipeJS recipe, @Nullable CapabilityMap map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        String item = GTRecipeSchema.parseItemOutputId(recipe, map);
        if (item != null) {
            return item;
        }
        return GTRecipeSchema.parseFluidOutputId(recipe, map);
    }

    @Nullable
    private static String parseItemOutputId(RecipeJS recipe, CapabilityMap map) {
        Content[] outputs = (Content[])map.get(ItemRecipeCapability.CAP);
        if (outputs != null && outputs.length > 0) {
            ExtendedOutputItem output = (ExtendedOutputItem)((Object)GTRecipeComponents.ITEM_OUT.baseComponent().read(recipe, outputs[0].content));
            Optional id = output.item.getItemHolder().unwrapKey();
            if (id.isPresent()) {
                return ((ResourceKey)id.get()).location().getPath();
            }
        }
        return null;
    }

    @Nullable
    private static String parseFluidOutputId(RecipeJS recipe, CapabilityMap map) {
        Content[] outputs = (Content[])map.get(FluidRecipeCapability.CAP);
        if (outputs != null && outputs.length > 0) {
            GTRecipeComponents.FluidIngredientJS output = (GTRecipeComponents.FluidIngredientJS)GTRecipeComponents.FLUID_OUT.baseComponent().read(recipe, outputs[0].content);
            FluidStack[] fluids = output.ingredient().getStacks();
            if (fluids.length == 0) {
                return null;
            }
            Optional id = fluids[0].getFluid().builtInRegistryHolder().unwrapKey();
            if (id.isPresent()) {
                return ((ResourceKey)id.get()).location().getPath();
            }
        }
        return null;
    }

    public static class GTRecipeJS
    extends RecipeJS {
        public boolean perTick;
        public int chance = ChanceLogic.getMaxChancedValue();
        public int maxChance = ChanceLogic.getMaxChancedValue();
        public int tierChanceBoost = 0;
        private ResourceLocation idWithoutType;
        public Consumer<GTRecipeJS> onSave;
        private final Collection<GTRecipeBuilder.ResearchRecipeEntry> researchRecipeEntries = new ArrayList<GTRecipeBuilder.ResearchRecipeEntry>();
        private boolean generatingRecipes = true;
        public List<MaterialStack> itemMaterialStacks = new ArrayList<MaterialStack>();
        public List<MaterialStack> fluidMaterialStacks = new ArrayList<MaterialStack>();
        public List<ItemStack> tempItemStacks = new ArrayList<ItemStack>();
        public boolean itemMaterialInfo = false;
        public boolean fluidMaterialInfo = false;
        public boolean removeMaterialInfo = false;

        @HideFromJS
        public GTRecipeJS id(ResourceLocation _id) {
            this.idWithoutType = new ResourceLocation(_id.getNamespace().equals("minecraft") ? this.type.id.getNamespace() : _id.getNamespace(), _id.getPath());
            this.id = this.idWithoutType.withPrefix(this.type.id.getPath() + "/");
            this.save();
            return this;
        }

        public <T> GTRecipeJS input(RecipeCapability<T> capability, Object ... obj) {
            CapabilityMap map;
            if (this.perTick) {
                if (this.getValue(ALL_TICK_INPUTS) == null) {
                    this.setValue(ALL_TICK_INPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_TICK_INPUTS);
            } else {
                if (this.getValue(ALL_INPUTS) == null) {
                    this.setValue(ALL_INPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_INPUTS);
            }
            if (map != null) {
                GTRecipeType recipeType = (GTRecipeType)GTRegistries.RECIPE_TYPES.get(this.type.id);
                if (map.get(capability) != null && ((Content[])map.get(capability)).length + obj.length > recipeType.getMaxInputs(capability)) {
                    ConsoleJS.SERVER.warn((Object)String.format("Trying to add more inputs than RecipeType can support, id: %s, Max %s%sInputs: %s", this.id, this.perTick ? "Tick " : "", capability.name, recipeType.getMaxInputs(capability)));
                }
                for (Object object : obj) {
                    map.add(capability, new Content(object, this.chance, this.maxChance, this.tierChanceBoost));
                }
            }
            this.save();
            return this;
        }

        public <T> GTRecipeJS output(RecipeCapability<T> capability, Object ... obj) {
            CapabilityMap map;
            if (this.perTick) {
                if (this.getValue(ALL_TICK_OUTPUTS) == null) {
                    this.setValue(ALL_TICK_OUTPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_TICK_OUTPUTS);
            } else {
                if (this.getValue(ALL_OUTPUTS) == null) {
                    this.setValue(ALL_OUTPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_OUTPUTS);
            }
            if (map != null) {
                GTRecipeType recipeType = (GTRecipeType)GTRegistries.RECIPE_TYPES.get(this.type.id);
                if (map.get(capability) != null && ((Content[])map.get(capability)).length + obj.length > recipeType.getMaxOutputs(capability)) {
                    ConsoleJS.SERVER.warn((Object)String.format("Trying to add more outputs than RecipeType can support, id: %s, Max %s%sOutputs: %s", this.id, this.perTick ? "Tick " : "", capability.name, recipeType.getMaxOutputs(capability)));
                }
                for (Object object : obj) {
                    map.add(capability, new Content(object, this.chance, this.maxChance, this.tierChanceBoost));
                }
            }
            this.save();
            return this;
        }

        public GTRecipeJS addCondition(RecipeCondition condition) {
            if (this.getValue(CONDITIONS) == null) {
                this.setValue(CONDITIONS, new RecipeCondition[]{condition});
            } else {
                this.setValue(CONDITIONS, (RecipeCondition[])ArrayUtils.add((Object[])((RecipeCondition[])this.getValue(CONDITIONS)), (Object)condition));
            }
            this.save();
            return this;
        }

        public GTRecipeJS category(GTRecipeCategory category) {
            this.setValue(CATEGORY, category.registryKey);
            this.save();
            return this;
        }

        public GTRecipeJS inputEU(EnergyStack eu) {
            return this.input(EURecipeCapability.CAP, eu);
        }

        public GTRecipeJS inputEU(long voltage, long amperage) {
            return this.inputEU(new EnergyStack(voltage, amperage));
        }

        public GTRecipeJS EUt(EnergyStack.WithIO eu) {
            if (eu.isEmpty()) {
                throw new RecipeExceptionJS(String.format("EUt can't be explicitly set to 0, id: %s", this.id));
            }
            if (eu.amperage() < 1L) {
                throw new RecipeExceptionJS(String.format("Amperage must be a positive integer, id: %s", this.id));
            }
            boolean lastPerTick = this.perTick;
            this.perTick = true;
            if (eu.isInput()) {
                this.inputEU(eu.stack());
            } else if (eu.isOutput()) {
                this.outputEU(eu.stack());
            }
            this.perTick = lastPerTick;
            return this;
        }

        public GTRecipeJS EUt(long voltage, long amperage) {
            return this.EUt(EnergyStack.WithIO.fromVA(voltage, amperage));
        }

        public GTRecipeJS outputEU(EnergyStack eu) {
            return this.output(EURecipeCapability.CAP, eu);
        }

        public GTRecipeJS outputEU(long voltage, long amperage) {
            return this.outputEU(new EnergyStack(voltage, amperage));
        }

        public GTRecipeJS inputCWU(int cwu) {
            return this.input(CWURecipeCapability.CAP, cwu);
        }

        public GTRecipeJS CWUt(int cwu) {
            if (cwu == 0) {
                throw new RecipeExceptionJS(String.format("CWUt can't be explicitly set to 0, id: %s", this.id));
            }
            boolean lastPerTick = this.perTick;
            this.perTick = true;
            if (cwu > 0) {
                this.inputCWU(cwu);
            } else if (cwu < 0) {
                this.outputCWU(-cwu);
            }
            this.perTick = lastPerTick;
            return this;
        }

        public GTRecipeJS totalCWU(int cwu) {
            this.durationIsTotalCWU(true);
            this.hideDuration(true);
            this.setValue(DURATION, cwu);
            return this;
        }

        public GTRecipeJS outputCWU(int cwu) {
            return this.output(CWURecipeCapability.CAP, cwu);
        }

        public GTRecipeJS itemInputs(InputItem ... inputs) {
            return this.inputItems(inputs);
        }

        public GTRecipeJS itemInput(MaterialEntry input) {
            return this.inputItems(input);
        }

        public GTRecipeJS itemInput(MaterialEntry input, int count) {
            return this.inputItems(input, count);
        }

        public GTRecipeJS inputItems(InputItem ... inputs) {
            for (InputItem stack : inputs) {
                MaterialStack matStack = ChemicalHelper.getMaterialStack((ItemLike)stack.ingredient.getItems()[0].getItem());
                ItemMaterialInfo matInfo = ChemicalHelper.getMaterialInfo(stack.ingredient.getItems()[0].getItem());
                if (this.chance != this.maxChance || this.chance == 0) continue;
                if (!matStack.isEmpty()) {
                    this.itemMaterialStacks.add(matStack.multiply(stack.count));
                }
                if (matInfo != null) {
                    for (MaterialStack ms : matInfo.getMaterials()) {
                        this.itemMaterialStacks.add(ms.multiply(stack.count));
                    }
                    continue;
                }
                this.tempItemStacks.add(stack.ingredient.getItems()[0].copyWithCount(stack.count));
            }
            return this.input(ItemRecipeCapability.CAP, inputs);
        }

        public GTRecipeJS inputItems(ItemStack ... inputs) {
            for (ItemStack itemStack : inputs) {
                MaterialStack matStack = ChemicalHelper.getMaterialStack(itemStack);
                ItemMaterialInfo matInfo = ChemicalHelper.getMaterialInfo(itemStack);
                if (this.chance == this.maxChance && this.chance != 0) {
                    if (!matStack.isEmpty()) {
                        this.itemMaterialStacks.add(matStack.multiply(itemStack.getCount()));
                    }
                    if (matInfo != null) {
                        for (MaterialStack ms : matInfo.getMaterials()) {
                            this.itemMaterialStacks.add(ms.multiply(itemStack.getCount()));
                        }
                    } else {
                        this.tempItemStacks.add(itemStack);
                    }
                }
                if (!itemStack.isEmpty()) continue;
                throw new RecipeExceptionJS(String.format("Input items is empty, id: %s", this.id));
            }
            return this.input(ItemRecipeCapability.CAP, Arrays.stream(inputs).map(stack -> InputItem.of((Ingredient)(stack.hasTag() ? StrictNBTIngredient.of((ItemStack)stack) : Ingredient.of((ItemStack[])new ItemStack[]{stack})), (int)stack.getCount())).toArray());
        }

        public GTRecipeJS inputItems(TagKey<Item> tag, int amount) {
            return this.inputItems(InputItem.of((Ingredient)Ingredient.of(tag), (int)amount));
        }

        public GTRecipeJS inputItems(Item input, int amount) {
            return this.inputItems(new ItemStack((ItemLike)input, amount));
        }

        public GTRecipeJS inputItems(Item input) {
            return this.inputItems(InputItem.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (int)1));
        }

        public GTRecipeJS inputItems(Supplier<? extends Item> input) {
            return this.inputItems(input.get());
        }

        public GTRecipeJS inputItems(Supplier<? extends Item> input, int amount) {
            return this.inputItems(new ItemStack((ItemLike)input.get(), amount));
        }

        public GTRecipeJS inputItems(TagPrefix orePrefix, Material material) {
            return this.inputItems(orePrefix, material, 1);
        }

        public GTRecipeJS inputItems(MaterialEntry input) {
            return this.inputItems(input.tagPrefix(), input.material(), 1);
        }

        public GTRecipeJS inputItems(MaterialEntry input, int count) {
            return this.inputItems(input.tagPrefix(), input.material(), count);
        }

        public GTRecipeJS inputItems(TagPrefix orePrefix, Material material, int count) {
            this.itemMaterialStacks.add(new MaterialStack(material, orePrefix.getMaterialAmount(material) * (long)count));
            return this.inputItems(ChemicalHelper.getTag(orePrefix, material), count);
        }

        public GTRecipeJS inputItems(MachineDefinition machine) {
            return this.inputItems(machine, 1);
        }

        public GTRecipeJS inputItems(MachineDefinition machine, int count) {
            return this.inputItems(machine.asStack(count));
        }

        public GTRecipeJS itemInputsRanged(ExtendedOutputItem ingredient, int min, int max) {
            return this.inputItemsRanged(ingredient.ingredient.getInner(), min, max);
        }

        public GTRecipeJS inputItemsRanged(Ingredient ingredient, int min, int max) {
            return this.input(ItemRecipeCapability.CAP, new Object[]{new ExtendedOutputItem(ingredient, 1, (IntProvider)UniformInt.of((int)min, (int)max))});
        }

        public GTRecipeJS inputItemsRanged(ItemStack stack, int min, int max) {
            return this.input(ItemRecipeCapability.CAP, new Object[]{new ExtendedOutputItem(stack, (IntProvider)UniformInt.of((int)min, (int)max))});
        }

        public GTRecipeJS itemInputsRanged(TagPrefix orePrefix, Material material, int min, int max) {
            return this.inputItemsRanged(ChemicalHelper.get(orePrefix, material), min, max);
        }

        public GTRecipeJS itemOutputs(ExtendedOutputItem ... outputs) {
            return this.outputItems(outputs);
        }

        public GTRecipeJS itemOutput(MaterialEntry materialEntry) {
            return this.outputItems(materialEntry.tagPrefix(), materialEntry.material());
        }

        public GTRecipeJS itemOutput(MaterialEntry materialEntry, int count) {
            return this.outputItems(materialEntry.tagPrefix(), materialEntry.material(), count);
        }

        public GTRecipeJS outputItems(ExtendedOutputItem ... outputs) {
            for (ExtendedOutputItem itemStack : outputs) {
                if (!itemStack.isEmpty()) continue;
                throw new RecipeExceptionJS(String.format("Output items is empty, id: %s", this.id));
            }
            return this.output(ItemRecipeCapability.CAP, (Object[])outputs);
        }

        public GTRecipeJS outputItems(Item input, int amount) {
            return this.outputItems(new ExtendedOutputItem(new ItemStack((ItemLike)input, amount), null));
        }

        public GTRecipeJS outputItems(Item input) {
            return this.outputItems(new ExtendedOutputItem(new ItemStack((ItemLike)input), null));
        }

        public GTRecipeJS outputItems(TagPrefix orePrefix, Material material) {
            return this.outputItems(orePrefix, material, 1);
        }

        public GTRecipeJS outputItems(TagPrefix orePrefix, Material material, int count) {
            return this.outputItems(new ExtendedOutputItem(ChemicalHelper.get(orePrefix, material, count), null));
        }

        public GTRecipeJS outputItems(MachineDefinition machine) {
            return this.outputItems(machine, 1);
        }

        public GTRecipeJS outputItems(MachineDefinition machine, int count) {
            return this.outputItems(new ExtendedOutputItem(machine.asStack(count), null));
        }

        public GTRecipeJS itemOutputsRanged(ExtendedOutputItem ingredient, int min, int max) {
            return this.outputItemsRanged(ingredient.ingredient.getInner(), min, max);
        }

        public GTRecipeJS outputItemsRanged(Ingredient ingredient, int min, int max) {
            return this.output(ItemRecipeCapability.CAP, new Object[]{new ExtendedOutputItem(ingredient, 1, (IntProvider)UniformInt.of((int)min, (int)max))});
        }

        public GTRecipeJS outputItemsRanged(ItemStack stack, int min, int max) {
            return this.output(ItemRecipeCapability.CAP, new Object[]{new ExtendedOutputItem(stack, (IntProvider)UniformInt.of((int)min, (int)max))});
        }

        public GTRecipeJS outputItemsRanged(TagPrefix orePrefix, Material material, int min, int max) {
            return this.outputItemsRanged(ChemicalHelper.get(orePrefix, material), min, max);
        }

        public GTRecipeJS notConsumable(InputItem itemStack) {
            int lastChance = this.chance;
            this.chance = 0;
            this.inputItems(itemStack);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS notConsumable(TagPrefix orePrefix, Material material) {
            int lastChance = this.chance;
            this.chance = 0;
            this.inputItems(orePrefix, material);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS notConsumableFluid(GTRecipeComponents.FluidIngredientJS fluid) {
            int lastChance = this.chance;
            this.chance = 0;
            this.inputFluids(fluid);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS circuit(int configuration) {
            if (configuration < 0 || configuration > 32) {
                throw new RecipeExceptionJS("Circuit configuration must be in the bounds 0 - 32");
            }
            return this.notConsumable(InputItem.of((Ingredient)IntCircuitIngredient.of(configuration), (int)1));
        }

        public GTRecipeJS chancedInput(InputItem stack, int chance, int tierChanceBoost) {
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                throw new RecipeExceptionJS(String.format("Chance cannot be less or equal to 0 or more than %s, Actual: %s, id: %s", ChanceLogic.getMaxChancedValue(), chance, this.id));
            }
            int lastChance = this.chance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance;
            this.tierChanceBoost = tierChanceBoost;
            this.inputItems(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedFluidInput(GTRecipeComponents.FluidIngredientJS stack, int chance, int tierChanceBoost) {
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                throw new RecipeExceptionJS(String.format("Chance cannot be less or equal to 0 or more than %s, Actual: %s, id: %s", ChanceLogic.getMaxChancedValue(), chance, this.id));
            }
            int lastChance = this.chance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance;
            this.tierChanceBoost = tierChanceBoost;
            this.inputFluids(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutput(ExtendedOutputItem stack, int chance, int tierChanceBoost) {
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                throw new RecipeExceptionJS(String.format("Chance cannot be less or equal to 0 or more than %s, Actual: %s, id: %s", ChanceLogic.getMaxChancedValue(), chance, this.id));
            }
            int lastChance = this.chance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance;
            this.tierChanceBoost = tierChanceBoost;
            this.outputItems(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutput(TagPrefix tag, Material mat, int chance, int tierChanceBoost) {
            return this.chancedOutput(new ExtendedOutputItem(ChemicalHelper.get(tag, mat), null), chance, tierChanceBoost);
        }

        public GTRecipeJS chancedOutput(TagPrefix tag, Material mat, int count, int chance, int tierChanceBoost) {
            return this.chancedOutput(new ExtendedOutputItem(ChemicalHelper.get(tag, mat, count), null), chance, tierChanceBoost);
        }

        public GTRecipeJS chancedOutput(ExtendedOutputItem stack, String fraction, int tierChanceBoost) {
            int maxChance;
            int chance;
            if (stack.isEmpty()) {
                return this;
            }
            String[] split = fraction.split("/");
            if (split.length > 2) {
                throw new RecipeExceptionJS(String.format("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"%s\".", fraction));
            }
            if (split.length == 1) {
                int chance2;
                try {
                    chance2 = (int)Double.parseDouble(split[0]);
                }
                catch (NumberFormatException e) {
                    throw new RecipeExceptionJS(String.format("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"%s\".", fraction));
                }
                return this.chancedOutput(stack, chance2, tierChanceBoost);
            }
            try {
                chance = Integer.parseInt(split[0]);
                maxChance = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                throw new RecipeExceptionJS(String.format("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"%s\".", fraction));
            }
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                throw new RecipeExceptionJS(String.format("Chance cannot be less or equal to 0 or more than %s, Actual: %s, id: %s", ChanceLogic.getMaxChancedValue(), chance, this.id));
            }
            if (chance >= maxChance || maxChance > ChanceLogic.getMaxChancedValue()) {
                throw new RecipeExceptionJS(String.format("Max Chance cannot be less or equal to Chance or more than %s, Actual: %s, id: %s", ChanceLogic.getMaxChancedValue(), maxChance, this.id));
            }
            int scalar = Math.floorDiv(ChanceLogic.getMaxChancedValue(), maxChance);
            int lastChance = this.chance;
            int lastMaxChance = this.maxChance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance *= scalar;
            this.maxChance = maxChance *= scalar;
            this.tierChanceBoost = tierChanceBoost;
            this.outputItems(stack);
            this.chance = lastChance;
            this.maxChance = lastMaxChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutput(TagPrefix prefix, Material material, int count, String fraction, int tierChanceBoost) {
            return this.chancedOutput(new ExtendedOutputItem(ChemicalHelper.get(prefix, material, count), null), fraction, tierChanceBoost);
        }

        public GTRecipeJS chancedOutput(TagPrefix prefix, Material material, String fraction, int tierChanceBoost) {
            return this.chancedOutput(prefix, material, 1, fraction, tierChanceBoost);
        }

        public GTRecipeJS chancedFluidOutput(FluidStackJS stack, int chance, int tierChanceBoost) {
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                throw new RecipeExceptionJS(String.format("Chance cannot be less or equal to 0 or more than %s, Actual: %s, id: %s", ChanceLogic.getMaxChancedValue(), chance, this.id));
            }
            int lastChance = this.chance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance;
            this.tierChanceBoost = tierChanceBoost;
            this.outputFluids(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedFluidOutput(FluidStackJS stack, String fraction, int tierChanceBoost) {
            int maxChance;
            int chance;
            if (stack.getAmount() == 0L) {
                return this;
            }
            String[] split = fraction.split("/");
            if (split.length > 2) {
                throw new RecipeExceptionJS(String.format("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"%s\".", fraction));
            }
            if (split.length == 1) {
                int chance2;
                try {
                    chance2 = (int)Double.parseDouble(split[0]);
                }
                catch (NumberFormatException e) {
                    throw new RecipeExceptionJS(String.format("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"%s\".", fraction));
                }
                return this.chancedFluidOutput(stack, chance2, tierChanceBoost);
            }
            try {
                chance = Integer.parseInt(split[0]);
                maxChance = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                throw new RecipeExceptionJS(String.format("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"%s\".", fraction), (Throwable)e);
            }
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                throw new RecipeExceptionJS(String.format("Chance cannot be less or equal to 0 or more than %s, Actual: %s, id: %s", ChanceLogic.getMaxChancedValue(), chance, this.id));
            }
            if (chance >= maxChance || maxChance > ChanceLogic.getMaxChancedValue()) {
                throw new RecipeExceptionJS(String.format("Max Chance cannot be less or equal to Chance or more than %s, Actual: %s, id: %s", ChanceLogic.getMaxChancedValue(), maxChance, this.id));
            }
            int scalar = Math.floorDiv(ChanceLogic.getMaxChancedValue(), maxChance);
            int lastChance = this.chance;
            int lastMaxChance = this.maxChance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance *= scalar;
            this.maxChance = maxChance *= scalar;
            this.tierChanceBoost = tierChanceBoost;
            this.outputFluids(stack);
            this.chance = lastChance;
            this.maxChance = lastMaxChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
            if (this.getValue(OUTPUT_CHANCE_LOGICS) == null) {
                this.setValue(OUTPUT_CHANCE_LOGICS, new HashMap());
            }
            ((Map)this.getValue(OUTPUT_CHANCE_LOGICS)).put(cap, logic);
            this.save();
            return this;
        }

        public GTRecipeJS chancedItemOutputLogic(ChanceLogic logic) {
            return this.chancedOutputLogic(ItemRecipeCapability.CAP, logic);
        }

        public GTRecipeJS chancedFluidOutputLogic(ChanceLogic logic) {
            return this.chancedOutputLogic(FluidRecipeCapability.CAP, logic);
        }

        public GTRecipeJS chancedInputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
            if (this.getValue(INPUT_CHANCE_LOGICS) == null) {
                this.setValue(INPUT_CHANCE_LOGICS, new HashMap());
            }
            ((Map)this.getValue(INPUT_CHANCE_LOGICS)).put(cap, logic);
            this.save();
            return this;
        }

        public GTRecipeJS chancedItemInputLogic(ChanceLogic logic) {
            return this.chancedInputLogic(ItemRecipeCapability.CAP, logic);
        }

        public GTRecipeJS chancedFluidInputLogic(ChanceLogic logic) {
            return this.chancedInputLogic(FluidRecipeCapability.CAP, logic);
        }

        public GTRecipeJS chancedTickOutputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
            if (this.getValue(TICK_OUTPUT_CHANCE_LOGICS) == null) {
                this.setValue(TICK_OUTPUT_CHANCE_LOGICS, new HashMap());
            }
            ((Map)this.getValue(TICK_OUTPUT_CHANCE_LOGICS)).put(cap, logic);
            this.save();
            return this;
        }

        public GTRecipeJS chancedTickInputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
            if (this.getValue(TICK_INPUT_CHANCE_LOGICS) == null) {
                this.setValue(TICK_INPUT_CHANCE_LOGICS, new HashMap());
            }
            ((Map)this.getValue(TICK_INPUT_CHANCE_LOGICS)).put(cap, logic);
            this.save();
            return this;
        }

        public GTRecipeJS inputFluids(GTRecipeComponents.FluidIngredientJS ... inputs) {
            for (GTRecipeComponents.FluidIngredientJS fluidIng : inputs) {
                for (FluidStack stack : fluidIng.ingredient().getStacks()) {
                    Material mat = ChemicalHelper.getMaterial(stack.getFluid());
                    if (mat.isNull()) continue;
                    this.fluidMaterialStacks.add(new MaterialStack(mat, (long)stack.getAmount() * 3628800L / 144L));
                }
            }
            return this.input(FluidRecipeCapability.CAP, inputs);
        }

        public GTRecipeJS inputFluidsRanged(FluidStackJS input, int min, int max) {
            return this.inputFluidsRanged(input, (IntProvider)UniformInt.of((int)min, (int)max));
        }

        public GTRecipeJS inputFluidsRanged(FluidStackJS input, IntProvider range) {
            FluidStack stack = new FluidStack(input.getFluid(), (int)input.getAmount(), input.getNbt());
            return this.input(FluidRecipeCapability.CAP, IntProviderFluidIngredient.of(FluidIngredient.of(stack), range));
        }

        public GTRecipeJS outputFluids(FluidStackJS ... outputs) {
            return this.output(FluidRecipeCapability.CAP, outputs);
        }

        public GTRecipeJS outputFluidsRanged(FluidStackJS output, int min, int max) {
            return this.outputFluidsRanged(output, (IntProvider)UniformInt.of((int)min, (int)max));
        }

        public GTRecipeJS outputFluidsRanged(FluidStackJS output, IntProvider range) {
            FluidStack stack = new FluidStack(output.getFluid(), (int)output.getAmount(), output.getNbt());
            return this.output(FluidRecipeCapability.CAP, IntProviderFluidIngredient.of(FluidIngredient.of(stack), range));
        }

        public GTRecipeJS addData(String key, Tag data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).put(key, data);
            this.save();
            return this;
        }

        @HideFromJS
        public GTRecipeJS addData(String key, int data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).putInt(key, data);
            this.save();
            return this;
        }

        @HideFromJS
        public GTRecipeJS addData(String key, long data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).putLong(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addDataString(String key, String data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).putString(key, data);
            this.save();
            return this;
        }

        @HideFromJS
        public GTRecipeJS addData(String key, float data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).putFloat(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addDataNumber(String key, double data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).putDouble(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addDataBool(String key, boolean data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).putBoolean(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS blastFurnaceTemp(int blastTemp) {
            return this.addData("ebf_temp", blastTemp);
        }

        public GTRecipeJS explosivesAmount(int explosivesAmount) {
            return this.addData("explosives_amount", explosivesAmount);
        }

        public GTRecipeJS explosivesType(ItemStack explosivesType) {
            return this.addData("explosives_type", (Tag)explosivesType.save(new CompoundTag()));
        }

        public GTRecipeJS solderMultiplier(int multiplier) {
            return this.addData("solder_multiplier", multiplier);
        }

        public GTRecipeJS disableDistilleryRecipes(boolean flag) {
            return this.addDataBool("disable_distillery", flag);
        }

        public GTRecipeJS fusionStartEU(long eu) {
            return this.addData("eu_to_start", eu);
        }

        public GTRecipeJS researchScan(boolean isScan) {
            return this.addDataBool("scan_for_research", isScan);
        }

        public GTRecipeJS durationIsTotalCWU(boolean durationIsTotalCWU) {
            return this.addDataBool("duration_is_total_cwu", durationIsTotalCWU);
        }

        public GTRecipeJS hideDuration(boolean hideDuration) {
            return this.addDataBool("hide_duration", hideDuration);
        }

        public GTRecipeJS cleanroom(CleanroomType cleanroomType) {
            return this.addCondition(new CleanroomCondition(cleanroomType));
        }

        public GTRecipeJS dimension(ResourceLocation dimension, boolean reverse) {
            return this.addCondition(new DimensionCondition(dimension).setReverse(reverse));
        }

        public GTRecipeJS dimension(ResourceLocation dimension) {
            return this.dimension(dimension, false);
        }

        public GTRecipeJS biome(ResourceLocation biome, boolean reverse) {
            return this.biome((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome), reverse);
        }

        public GTRecipeJS biome(ResourceLocation biome) {
            return this.biome(biome, false);
        }

        public GTRecipeJS biome(ResourceKey<Biome> biome, boolean reverse) {
            return this.addCondition(new BiomeCondition(biome).setReverse(reverse));
        }

        public GTRecipeJS biome(ResourceKey<Biome> biome) {
            return this.biome(biome, false);
        }

        public GTRecipeJS rain(float level, boolean reverse) {
            return this.addCondition(new RainingCondition(level).setReverse(reverse));
        }

        public GTRecipeJS rain(float level) {
            return this.rain(level, false);
        }

        public GTRecipeJS thunder(float level, boolean reverse) {
            return this.addCondition(new ThunderCondition(level).setReverse(reverse));
        }

        public GTRecipeJS thunder(float level) {
            return this.thunder(level, false);
        }

        public GTRecipeJS posY(int min, int max, boolean reverse) {
            return this.addCondition(new PositionYCondition(min, max).setReverse(reverse));
        }

        public GTRecipeJS posY(int min, int max) {
            return this.posY(min, max, false);
        }

        public GTRecipeJS environmentalHazard(MedicalCondition condition, boolean reverse) {
            return this.addCondition(new EnvironmentalHazardCondition(condition).setReverse(reverse));
        }

        public GTRecipeJS environmentalHazard(MedicalCondition condition) {
            return this.environmentalHazard(condition, false);
        }

        public GTRecipeJS adjacentFluids(Fluid ... fluids) {
            return this.adjacentFluids(false, fluids);
        }

        public GTRecipeJS adjacentFluids(boolean isReverse, Fluid ... fluids) {
            return this.addCondition(AdjacentFluidCondition.fromFluids(fluids).setReverse(isReverse));
        }

        public GTRecipeJS adjacentFluid(Fluid ... fluids) {
            return this.adjacentFluid(false, fluids);
        }

        public GTRecipeJS adjacentFluid(boolean isReverse, Fluid ... fluids) {
            return this.addCondition(AdjacentFluidCondition.fromFluids(fluids).setReverse(isReverse));
        }

        public GTRecipeJS adjacentFluid(ResourceLocation ... tagNames) {
            return this.adjacentFluid(false, tagNames);
        }

        public GTRecipeJS adjacentFluid(boolean isReverse, ResourceLocation ... tagNames) {
            List<TagKey<Fluid>> tags = Arrays.stream(tagNames).map(id -> TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)id)).toList();
            return this.addCondition(AdjacentFluidCondition.fromTags(tags).setReverse(isReverse));
        }

        public GTRecipeJS adjacentFluidTag(ResourceLocation ... tagNames) {
            return this.adjacentFluidTag(false, tagNames);
        }

        public GTRecipeJS adjacentFluidTag(boolean isReverse, ResourceLocation ... tagNames) {
            List<TagKey<Fluid>> tags = Arrays.stream(tagNames).map(id -> TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)id)).toList();
            return this.addCondition(AdjacentFluidCondition.fromTags(tags).setReverse(isReverse));
        }

        public GTRecipeJS adjacentBlocks(Block ... blocks) {
            return this.adjacentBlocks(false, blocks);
        }

        public GTRecipeJS adjacentBlocks(boolean isReverse, Block ... blocks) {
            return this.addCondition(AdjacentBlockCondition.fromBlocks(blocks).setReverse(isReverse));
        }

        public GTRecipeJS adjacentBlock(Block ... blocks) {
            return this.adjacentBlock(false, blocks);
        }

        public GTRecipeJS adjacentBlock(boolean isReverse, Block ... blocks) {
            return this.addCondition(AdjacentBlockCondition.fromBlocks(blocks).setReverse(isReverse));
        }

        public GTRecipeJS adjacentBlockTag(ResourceLocation ... tagNames) {
            return this.adjacentBlockTag(false, tagNames);
        }

        public GTRecipeJS adjacentBlockTag(boolean isReverse, ResourceLocation ... tagNames) {
            List<TagKey<Block>> tags = Arrays.stream(tagNames).map(id -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id)).toList();
            return this.addCondition(AdjacentBlockCondition.fromTags(tags).setReverse(isReverse));
        }

        public GTRecipeJS adjacentBlock(ResourceLocation ... tagNames) {
            return this.adjacentBlock(false, tagNames);
        }

        public GTRecipeJS adjacentBlock(boolean isReverse, ResourceLocation ... tagNames) {
            List<TagKey<Block>> tags = Arrays.stream(tagNames).map(id -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id)).toList();
            return this.addCondition(AdjacentBlockCondition.fromTags(tags).setReverse(isReverse));
        }

        public GTRecipeJS daytime(boolean isNight) {
            return this.addCondition(new DaytimeCondition().setReverse(isNight));
        }

        public GTRecipeJS daytime() {
            return this.daytime(false);
        }

        public GTRecipeJS heraclesQuest(String questId, boolean isReverse) {
            if (!GTCEu.Mods.isHeraclesLoaded()) {
                throw new RecipeExceptionJS("Heracles not loaded!");
            }
            if (questId.isEmpty()) {
                throw new RecipeExceptionJS(String.format("Quest ID cannot be empty for recipe %s", this.id));
            }
            return this.addCondition(new HeraclesQuestCondition(isReverse, questId));
        }

        public GTRecipeJS heraclesQuest(String questId) {
            return this.heraclesQuest(questId, false);
        }

        public GTRecipeJS gameStage(String stageName) {
            return this.gameStage(stageName, false);
        }

        public GTRecipeJS gameStage(String stageName, boolean isReverse) {
            if (!GTCEu.Mods.isGameStagesLoaded()) {
                throw new RecipeExceptionJS("GameStages is not loaded, ignoring recipe condition");
            }
            return this.addCondition(new GameStageCondition(isReverse, stageName));
        }

        public GTRecipeJS ftbQuest(String questId, boolean isReverse) {
            if (!GTCEu.Mods.isFTBQuestsLoaded()) {
                throw new RecipeExceptionJS("FTBQuests is not loaded!");
            }
            if (questId.isEmpty()) {
                throw new RecipeExceptionJS(String.format("Quest ID cannot be empty for recipe %s", this.id));
            }
            long qID = QuestObjectBase.parseCodeString((String)questId);
            if (qID == 0L) {
                throw new RecipeExceptionJS(String.format("Quest %s not found for recipe %s", questId, this.id));
            }
            return this.addCondition(new FTBQuestCondition(isReverse, qID));
        }

        public GTRecipeJS ftbQuest(String questId) {
            return this.ftbQuest(questId, false);
        }

        private boolean applyResearchProperty(ResearchData.ResearchEntry researchEntry) {
            if (!ConfigHolder.INSTANCE.machines.enableResearch) {
                return false;
            }
            if (researchEntry == null) {
                throw new RecipeExceptionJS("Assembly Line Research Entry cannot be empty.", (Throwable)new IllegalArgumentException());
            }
            if (!this.generatingRecipes) {
                throw new RecipeExceptionJS("Cannot generate recipes when using researchWithoutRecipe()", (Throwable)new IllegalStateException());
            }
            if (this.getValue(CONDITIONS) == null) {
                this.setValue(CONDITIONS, new RecipeCondition[0]);
            }
            ResearchCondition condition = Arrays.stream((RecipeCondition[])this.getValue(CONDITIONS)).filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
            if (condition != null) {
                condition.data.add(researchEntry);
            } else {
                condition = new ResearchCondition();
                condition.data.add(researchEntry);
                this.addCondition(condition);
            }
            return true;
        }

        public GTRecipeJS researchWithoutRecipe(@NotNull String researchId) {
            return this.researchWithoutRecipe(researchId, ResearchManager.getDefaultScannerItem());
        }

        public GTRecipeJS researchWithoutRecipe(@NotNull String researchId, @NotNull ItemStack dataStack) {
            this.applyResearchProperty(new ResearchData.ResearchEntry(researchId, dataStack));
            this.generatingRecipes = false;
            return this;
        }

        public GTRecipeJS scannerResearch(UnaryOperator<ResearchRecipeBuilder.ScannerRecipeBuilder> research) {
            GTRecipeBuilder.ResearchRecipeEntry entry = ((ResearchRecipeBuilder.ScannerRecipeBuilder)research.apply(new ResearchRecipeBuilder.ScannerRecipeBuilder())).build(this.id);
            if (this.applyResearchProperty(new ResearchData.ResearchEntry(entry.researchId(), entry.dataStack()))) {
                this.researchRecipeEntries.add(entry);
            }
            return this;
        }

        public GTRecipeJS scannerResearch(@NotNull ItemStack researchStack) {
            return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(researchStack));
        }

        public GTRecipeJS stationResearch(UnaryOperator<ResearchRecipeBuilder.StationRecipeBuilder> research) {
            GTRecipeBuilder.ResearchRecipeEntry entry = ((ResearchRecipeBuilder.StationRecipeBuilder)research.apply(new ResearchRecipeBuilder.StationRecipeBuilder())).build(this.id);
            if (this.applyResearchProperty(new ResearchData.ResearchEntry(entry.researchId(), entry.dataStack()))) {
                this.researchRecipeEntries.add(entry);
            }
            return this;
        }

        public GTRecipeJS addMaterialInfo(boolean item) {
            this.itemMaterialInfo = item;
            return this;
        }

        public GTRecipeJS addMaterialInfo(boolean item, boolean fluid) {
            this.itemMaterialInfo = item;
            this.fluidMaterialInfo = fluid;
            return this;
        }

        public GTRecipeJS removePreviousMaterialInfo() {
            this.removeMaterialInfo = true;
            return this;
        }

        public ResourceLocation getOrCreateId() {
            boolean wasNull = this.id == null;
            super.getOrCreateId();
            if (wasNull) {
                this.idWithoutType = this.id.withPath(p -> StringUtils.substringAfter((String)p, (int)47));
            }
            return this.id;
        }

        @Nullable
        public Recipe<?> createRecipe() {
            if (this.onSave != null) {
                this.onSave.accept(this);
            }
            return super.createRecipe();
        }

        public InputItem readInputItem(Object from) {
            if (from instanceof SizedIngredient) {
                SizedIngredient ingr = (SizedIngredient)((Object)from);
                return InputItem.of((Ingredient)ingr.getInner(), (int)ingr.getAmount());
            }
            if (from instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)from;
                if (!jsonObject.has("type") || !jsonObject.get("type").getAsString().equals(SizedIngredient.TYPE.toString())) {
                    return InputItem.of((Object)from);
                }
                SizedIngredient sizedIngredient = SizedIngredient.fromJson(jsonObject);
                return InputItem.of((Ingredient)sizedIngredient.getInner(), (int)sizedIngredient.getAmount());
            }
            return InputItem.of((Object)from);
        }

        public JsonElement writeInputItem(InputItem value) {
            Ingredient ingredient = value.ingredient;
            if (ingredient instanceof SizedIngredient) {
                SizedIngredient sized = (SizedIngredient)ingredient;
                return sized.toJson();
            }
            return SizedIngredient.create(value.ingredient, value.count).toJson();
        }

        public OutputItem readOutputItem(Object from) {
            if (from instanceof ExtendedOutputItem) {
                ExtendedOutputItem outputItem = (ExtendedOutputItem)((Object)from);
                return outputItem;
            }
            if (from instanceof OutputItem) {
                OutputItem outputItem = (OutputItem)from;
                return outputItem;
            }
            if (from instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)from;
                return ExtendedOutputItem.of(ingredient, 1);
            }
            if (from instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)from;
                float chance = 1.0f;
                if (jsonObject.has("chance")) {
                    chance = jsonObject.get("chance").getAsFloat();
                }
                if (jsonObject.has("content")) {
                    jsonObject = jsonObject.getAsJsonObject("content");
                }
                Ingredient ingredient = Ingredient.fromJson((JsonElement)jsonObject);
                return OutputItem.of((ItemStack)ingredient.getItems()[0], (double)chance);
            }
            return OutputItem.of((Object)from);
        }

        public JsonElement writeOutputItem(OutputItem value) {
            if (value.rolls != null) {
                return IntProviderIngredient.of(value.item, value.rolls).toJson();
            }
            if (value instanceof ExtendedOutputItem) {
                ExtendedOutputItem extended = (ExtendedOutputItem)value;
                Ingredient ingredient = extended.ingredient.getInner();
                if (ingredient instanceof IntProviderIngredient) {
                    IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
                    return intProvider.toJson();
                }
                return extended.ingredient.toJson();
            }
            return SizedIngredient.create(value.item).toJson();
        }

        public InputFluid readInputFluid(Object from) {
            return GTRecipeComponents.FluidIngredientJS.of(from);
        }

        public JsonElement writeInputFluid(InputFluid value) {
            if (value instanceof GTRecipeComponents.FluidIngredientJS) {
                GTRecipeComponents.FluidIngredientJS ing = (GTRecipeComponents.FluidIngredientJS)value;
                return ing.ingredient().toJson();
            }
            dev.architectury.fluid.FluidStack fluid = ((FluidStackJS)value).getFluidStack();
            return FluidIngredient.of(fluid.getFluid(), (int)fluid.getAmount(), fluid.getTag()).toJson();
        }

        public OutputFluid readOutputFluid(Object from) {
            return GTRecipeComponents.FluidIngredientJS.of(from);
        }

        public JsonElement writeOutputFluid(OutputFluid value) {
            if (value instanceof GTRecipeComponents.FluidIngredientJS) {
                GTRecipeComponents.FluidIngredientJS ing = (GTRecipeComponents.FluidIngredientJS)value;
                return ing.ingredient().toJson();
            }
            if (value instanceof FluidIngredient) {
                FluidIngredient ingredient = (FluidIngredient)value;
                return ingredient.toJson();
            }
            dev.architectury.fluid.FluidStack fluid = ((FluidStackJS)value).getFluidStack();
            return FluidIngredient.of(fluid.getFluid(), (int)fluid.getAmount(), fluid.getTag()).toJson();
        }

        @NotNull
        @Generated
        public GTRecipeJS perTick(boolean perTick) {
            this.perTick = perTick;
            return this;
        }

        @NotNull
        @Generated
        public GTRecipeJS chance(int chance) {
            this.chance = chance;
            return this;
        }

        @NotNull
        @Generated
        public GTRecipeJS maxChance(int maxChance) {
            this.maxChance = maxChance;
            return this;
        }

        @NotNull
        @Generated
        public GTRecipeJS tierChanceBoost(int tierChanceBoost) {
            this.tierChanceBoost = tierChanceBoost;
            return this;
        }

        @Generated
        public ResourceLocation idWithoutType() {
            return this.idWithoutType;
        }

        @NotNull
        @Generated
        public GTRecipeJS onSave(Consumer<GTRecipeJS> onSave) {
            this.onSave = onSave;
            return this;
        }

        @Generated
        public Collection<GTRecipeBuilder.ResearchRecipeEntry> researchRecipeEntries() {
            return this.researchRecipeEntries;
        }
    }
}

