/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map;

import com.gregtechceu.gtceu.integration.map.GroupingMapRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ButtonState {
    private static final Map<String, Button> buttons = new HashMap<String, Button>();
    private static List<Button> sortedButtons;

    public static void toggleButton(Button button) {
        button.enabled = !button.enabled;
        GroupingMapRenderer.getInstance().setLayerActive(button.name, button.enabled);
        if (button.enabled) {
            for (String name : buttons.keySet()) {
                if (name.equals(button.name)) continue;
                ButtonState.buttons.get((Object)name).enabled = false;
                GroupingMapRenderer.getInstance().setLayerActive(name, false);
            }
        }
    }

    public static void toggleButton(String buttonName) {
        ButtonState.toggleButton(buttons.get(buttonName));
    }

    public static boolean isEnabled(Button button) {
        return button.enabled;
    }

    public static boolean isEnabled(String buttonName) {
        return ButtonState.buttons.get((Object)buttonName).enabled;
    }

    public static int buttonAmount() {
        return buttons.size();
    }

    public static List<Button> getAllButtons() {
        if (sortedButtons == null) {
            sortedButtons = new ArrayList<Button>(buttons.values());
        }
        return sortedButtons;
    }

    public static class Button {
        public boolean enabled = false;
        public final String name;

        public Button(String name) {
            this.name = name;
        }

        public static void makeButton(String name) {
            buttons.put(name, new Button(name));
        }
    }
}

