/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map;

import com.gregtechceu.gtceu.integration.map.GroupingMapRenderer;
import com.gregtechceu.gtceu.integration.map.cache.client.IClientCache;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.commons.io.FileUtils;

public class ClientCacheManager {
    public static final File clientCacheDir = new File(Minecraft.getInstance().gameDirectory, "gtceu" + File.separator + "prospection_cache");
    private static final char resourceLocationSeparator = '=';
    private static final String filePrefix = "DIM";
    private static final String fileEnding = ".nbt";
    private static File worldFolder;
    private static final Reference2ObjectMap<IClientCache, ClientCacheInfo> caches;
    private static boolean shouldInit;

    private static String sanitizeFilename(String input) {
        return input.replaceAll("(?U)[^\\w-]+", "_").trim();
    }

    public static void init(String worldId) {
        if (shouldInit) {
            LocalPlayer player = Minecraft.getInstance().player;
            worldFolder = new File(clientCacheDir, ClientCacheManager.sanitizeFilename(player.getName().getString()) + "_" + String.valueOf(player.getUUID()) + File.separator + ClientCacheManager.sanitizeFilename(worldId));
            worldFolder.mkdirs();
            ClientCacheManager.clearCaches();
            ClientCacheManager.loadCaches();
            shouldInit = false;
        }
    }

    private static void loadCaches() {
        for (IClientCache cache : caches.keySet()) {
            cache.setupCacheFiles();
            ClientCacheInfo cacheInfo = (ClientCacheInfo)caches.get((Object)cache);
            cacheInfo.cacheFolder = new File(worldFolder, cacheInfo.key);
            cacheInfo.cacheFolder.mkdirs();
            for (String dimFilePrefix : cacheInfo.dimFilePrefixes) {
                for (File dimFile : ClientCacheManager.getDimFiles(cacheInfo.cacheFolder, dimFilePrefix)) {
                    ResourceKey dimId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.of((String)dimFile.getName().substring(dimFilePrefix.length() + filePrefix.length(), dimFile.getName().length() - fileEnding.length()), (char)'='));
                    try {
                        cache.readDimFile(dimFilePrefix, (ResourceKey<Level>)dimId, NbtIo.readCompressed((InputStream)new FileInputStream(dimFile)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            for (String singleFileName : cacheInfo.singleFiles) {
                File singleFile = new File(cacheInfo.cacheFolder, singleFileName + fileEnding);
                if (!singleFile.exists()) continue;
                try {
                    cache.readSingleFile(singleFileName, NbtIo.readCompressed((InputStream)new FileInputStream(singleFile)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void clearCaches() {
        for (IClientCache cache : caches.keySet()) {
            cache.clear();
        }
        GroupingMapRenderer.getInstance().clear();
    }

    public static void saveCaches() {
        for (IClientCache cache : caches.keySet()) {
            ClientCacheInfo cacheInfo = (ClientCacheInfo)caches.get((Object)cache);
            for (String dimFilePrefix : cacheInfo.dimFilePrefixes) {
                for (ResourceKey<Level> dim : cache.getExistingDimensions(dimFilePrefix)) {
                    CompoundTag data = cache.saveDimFile(dimFilePrefix, dim);
                    if (data == null) continue;
                    File dimFile = new File(cacheInfo.cacheFolder, dimFilePrefix + filePrefix + dim.location().getNamespace() + "=" + dim.location().getPath() + fileEnding);
                    try {
                        NbtIo.writeCompressed((CompoundTag)data, (OutputStream)new FileOutputStream(dimFile));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            for (String singleFileName : cacheInfo.singleFiles) {
                CompoundTag data = cache.saveSingleFile(singleFileName);
                if (data == null) continue;
                File singleFile = new File(cacheInfo.cacheFolder, singleFileName + fileEnding);
                try {
                    NbtIo.writeCompressed((CompoundTag)data, (OutputStream)new FileOutputStream(singleFile));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void resetCaches() {
        ClientCacheManager.clearCaches();
        for (ClientCacheInfo cacheInfo : caches.values()) {
            FileUtils.deleteQuietly((File)cacheInfo.cacheFolder);
            cacheInfo.cacheFolder.mkdirs();
        }
    }

    public static void registerClientCache(IClientCache cache, String key) {
        caches.put((Object)cache, (Object)new ClientCacheInfo(key));
    }

    public static void addDimFiles(IClientCache cache, String prefix) {
        ((ClientCacheInfo)ClientCacheManager.caches.get((Object)cache)).dimFilePrefixes.add(prefix);
    }

    public static void addSingleFile(IClientCache cache, String prefix) {
        ((ClientCacheInfo)ClientCacheManager.caches.get((Object)cache)).singleFiles.add(prefix);
    }

    public static List<ProspectionInfo> getProspectionShareData() {
        ArrayList<ProspectionInfo> result = new ArrayList<ProspectionInfo>();
        for (IClientCache cache : caches.keySet()) {
            ClientCacheInfo cacheInfo = (ClientCacheInfo)caches.get((Object)cache);
            for (String dimPrefix : cacheInfo.dimFilePrefixes) {
                for (ResourceKey<Level> dim : cache.getExistingDimensions(dimPrefix)) {
                    CompoundTag data = cache.saveDimFile(dimPrefix, dim);
                    if (data == null) continue;
                    result.add(new ProspectionInfo(cacheInfo.key, dimPrefix, true, dim, data));
                }
            }
            for (String singleFileName : cacheInfo.singleFiles) {
                CompoundTag data = cache.saveSingleFile(singleFileName);
                if (data == null) continue;
                result.add(new ProspectionInfo(cacheInfo.key, singleFileName, false, (ResourceKey<Level>)Level.OVERWORLD, data));
            }
        }
        return result;
    }

    public static void processProspectionShare(String cacheName, String key, boolean isDimCache, ResourceKey<Level> dim, CompoundTag data) {
        for (IClientCache cache : caches.keySet()) {
            ClientCacheInfo cacheInfo = (ClientCacheInfo)caches.get((Object)cache);
            if (!cacheInfo.key.equals(cacheName)) continue;
            if (isDimCache) {
                cache.readDimFile(key, dim, data);
                break;
            }
            cache.readSingleFile(key, data);
            break;
        }
    }

    public static void allowReinit() {
        shouldInit = true;
    }

    private static List<File> getDimFiles(File parent, String prefix) {
        List<File> list;
        block8: {
            Stream<Path> stream = Files.walk(parent.toPath(), 1, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(prefix + filePrefix)).map(Path::toFile).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    @Generated
    public static File getWorldFolder() {
        return worldFolder;
    }

    static {
        caches = new Reference2ObjectArrayMap();
        shouldInit = true;
    }

    private static class ClientCacheInfo {
        public String key;
        public File cacheFolder;
        public Set<String> dimFilePrefixes;
        public Set<String> singleFiles;

        public ClientCacheInfo(String key) {
            this.key = key;
            this.dimFilePrefixes = new HashSet<String>();
            this.singleFiles = new HashSet<String>();
        }
    }

    public static class ProspectionInfo {
        public String cacheName;
        public String key;
        public boolean isDimCache;
        public ResourceKey<Level> dim;
        public CompoundTag data;

        public ProspectionInfo(String cacheName, String key, boolean isDimCache, ResourceKey<Level> dim, CompoundTag data) {
            this.cacheName = cacheName;
            this.key = key;
            this.isDimCache = isDimCache;
            this.dim = dim;
            this.data = data;
        }
    }
}

