/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.cache.fluid;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.integration.map.GroupingMapRenderer;
import com.gregtechceu.gtceu.integration.map.layer.builtin.FluidRenderLayer;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class FluidCache {
    private final Table<ResourceKey<Level>, ChunkPos, ProspectorMode.FluidInfo> fluidCache = HashBasedTable.create();

    public void addFluid(ResourceKey<Level> dim, int chunkX, int chunkZ, ProspectorMode.FluidInfo fluid) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        if (!this.fluidCache.contains(dim, (Object)pos)) {
            this.fluidCache.put(dim, (Object)pos, (Object)fluid);
            GroupingMapRenderer.getInstance().addMarker(FluidRenderLayer.getName(fluid).getString(), FluidRenderLayer.getId(fluid, pos), dim, pos, fluid);
        }
    }

    public void fromNbt(CompoundTag nbt) {
        ListTag fluidList = nbt.getList("fluids", 10);
        for (Tag fluidTagRaw : fluidList) {
            if (!(fluidTagRaw instanceof CompoundTag)) continue;
            CompoundTag fluidTag = (CompoundTag)fluidTagRaw;
            ResourceKey dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(fluidTag.getString("dim")));
            ChunkPos pos = new ChunkPos(fluidTag.getLong("pos"));
            ProspectorMode.FluidInfo fluid = ProspectorMode.FluidInfo.fromNbt(fluidTag);
            this.fluidCache.put((Object)dim, (Object)pos, (Object)fluid);
            GroupingMapRenderer.getInstance().addMarker(FluidRenderLayer.getName(fluid).getString(), FluidRenderLayer.getId(fluid, pos), (ResourceKey<Level>)dim, pos, fluid);
        }
    }

    public CompoundTag toNbt() {
        CompoundTag result = new CompoundTag();
        ListTag fluidList = new ListTag();
        for (Map.Entry dimensions : this.fluidCache.rowMap().entrySet()) {
            for (Map.Entry entry : ((Map)dimensions.getValue()).entrySet()) {
                CompoundTag tag = ((ProspectorMode.FluidInfo)entry.getValue()).toNbt();
                tag.putLong("pos", ((ChunkPos)entry.getKey()).toLong());
                tag.putString("dim", ((ResourceKey)dimensions.getKey()).location().toString());
                fluidList.add((Object)tag);
            }
        }
        result.put("fluids", (Tag)fluidList);
        return result;
    }

    public void clear() {
        this.fluidCache.clear();
    }
}

