/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.ftbchunks.veins.ore;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.client.util.DrawUtil;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.ftbchunks.FTBChunksOptions;
import com.gregtechceu.gtceu.integration.map.layer.builtin.OreRenderLayer;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.icon.MapIcon;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.api.client.waypoint.Waypoint;
import dev.ftb.mods.ftbchunks.api.client.waypoint.WaypointManager;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class OreVeinIcon
implements MapIcon {
    protected final GeneratedVeinMetadata veinMetadata;
    protected String name = null;

    public OreVeinIcon(GeneratedVeinMetadata veinMetadata) {
        this.veinMetadata = veinMetadata;
    }

    public double getIconScale(MapType mapType) {
        return mapType.isLargeMap() ? (double)ConfigHolder.INSTANCE.compat.minimap.oreIconSize / 8.0 : super.getIconScale(mapType);
    }

    public boolean isEnabled() {
        return FTBChunksOptions.showLayer("ore_veins") && (!this.veinMetadata.depleted() || !FTBChunksOptions.hideDepleted());
    }

    public String getName() {
        return this.name == null ? (this.name = OreRenderLayer.getName(this.veinMetadata).getString()) : this.name;
    }

    @NotNull
    public Material getMaterial() {
        return OreRenderLayer.getMaterial(this.veinMetadata);
    }

    public Vec3 getPos(float v) {
        return this.veinMetadata.center().getCenter();
    }

    public boolean onMousePressed(BaseScreen baseScreen, MouseButton mouseButton) {
        if (!this.isEnabled() || !(baseScreen instanceof LargeMapScreen)) {
            return false;
        }
        LargeMapScreen largeMapScreen = (LargeMapScreen)baseScreen;
        if (mouseButton.isLeft()) {
            this.toggleWaypoint(largeMapScreen);
            return true;
        }
        if (mouseButton.isRight()) {
            this.openContextMenu(largeMapScreen);
            return true;
        }
        return false;
    }

    private void openContextMenu(LargeMapScreen screen) {
        MutableComponent title = Component.literal((String)this.getName());
        if (this.veinMetadata.depleted()) {
            title.append(" (").append((Component)Component.translatable((String)"gtceu.minimap.ore_vein.depleted")).append(")");
        }
        ContextMenuItem markDepleted = new ContextMenuItem((Component)Component.translatable((String)"button.gtceu.mark_as_depleted.name"), Icons.REMOVE, b -> this.veinMetadata.depleted(!this.veinMetadata.depleted()));
        Material material = this.getMaterial();
        Color4I color = material.isNull() ? Color4I.rgba((int)-1) : Color4I.rgba((int)material.getMaterialARGB());
        Icon waypointIcon = WaypointType.DEFAULT.getIcon().withColor(color);
        ContextMenuItem toggleWaypoint = new ContextMenuItem((Component)Component.translatable((String)"button.gtceu.toggle_waypoint.name"), waypointIcon, b -> this.toggleWaypoint(screen));
        List<ContextMenuItem> contextMenu = List.of(ContextMenuItem.title((Component)title), ContextMenuItem.SEPARATOR, markDepleted, toggleWaypoint);
        screen.openContextMenu(contextMenu);
    }

    public void toggleWaypoint(LargeMapScreen screen) {
        ResourceKey dimension = screen.currentDimension();
        MapManager mapManager = MapManager.getInstance().orElse(null);
        WaypointManager waypointManager = FTBChunksAPI.clientApi().getWaypointManager(dimension).orElse(null);
        if (mapManager == null || waypointManager == null) {
            return;
        }
        WaypointImpl waypoint = new WaypointImpl(WaypointType.DEFAULT, mapManager.getDimension(dimension), this.veinMetadata.center());
        if (waypointManager.getAllWaypoints().contains(waypoint)) {
            waypointManager.removeWaypoint((Waypoint)waypoint);
        } else {
            Material material = this.getMaterial();
            int color = material.isNull() ? -1 : material.getMaterialARGB();
            waypointManager.addWaypointAt(this.veinMetadata.center(), this.getName()).setColor(color).setHidden(false);
        }
        screen.refreshWidgets();
    }

    public boolean onKeyPressed(BaseScreen baseScreen, Key key) {
        if (!this.isEnabled()) {
            return false;
        }
        if (key.is(261)) {
            this.veinMetadata.depleted(!this.veinMetadata.depleted());
            return true;
        }
        return false;
    }

    public void addTooltip(TooltipList list) {
        if (!this.isEnabled()) {
            return;
        }
        OreRenderLayer.getTooltip(this.getName(), this.veinMetadata).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
    }

    public void draw(MapType mapType, GuiGraphics graphics, int x, int y, int w, int h, boolean outsideVisibleArea, int iconAlpha) {
        if (outsideVisibleArea || !this.isEnabled()) {
            return;
        }
        int iconSize = ConfigHolder.INSTANCE.compat.minimap.oreIconSize;
        Material material = this.getMaterial();
        int color = material.isNull() ? -1 : material.getMaterialARGB();
        float[] colors = DrawUtil.floats(color);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MaterialIconSet iconSet = material.isNull() ? MaterialIconSet.METALLIC : material.getMaterialIconSet();
        ResourceLocation oreTexture = MaterialIconType.rawOre.getItemTexturePath(iconSet, true);
        if (oreTexture != null) {
            TextureAtlasSprite oreSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(oreTexture);
            graphics.blit(x, y, 0, w, h, oreSprite, colors[0], colors[1], colors[2], 1.0f);
        }
        if ((oreTexture = MaterialIconType.rawOre.getItemTexturePath(iconSet, "secondary", true)) != null) {
            int materialSecondaryARGB = material.isNull() ? -1 : material.getMaterialSecondaryARGB();
            colors = DrawUtil.floats(materialSecondaryARGB);
            TextureAtlasSprite oreSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(oreTexture);
            graphics.blit(x, y, 0, w, h, oreSprite, colors[0], colors[1], colors[2], 1.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int borderColor = ConfigHolder.INSTANCE.compat.minimap.getBorderColor(color | 0xFF000000);
        if ((borderColor & 0xFF000000) != 0) {
            int thickness = iconSize / 16;
            graphics.fill(x, y, x + w, y + h + thickness, borderColor);
            graphics.fill(x, y - thickness, x + w, y + h + thickness, borderColor);
            graphics.fill(x, y, x + w + thickness, y + h, borderColor);
            graphics.fill(x - thickness, y, x + w + thickness, y + h, borderColor);
        }
    }
}

