/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.xaeros.worldmap.ore;

import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.GroupingMapRenderer;
import com.gregtechceu.gtceu.integration.map.layer.builtin.OreRenderLayer;
import com.gregtechceu.gtceu.integration.map.xaeros.worldmap.ore.OreVeinElement;
import com.gregtechceu.gtceu.integration.map.xaeros.worldmap.ore.OreVeinElementContext;
import com.gregtechceu.gtceu.integration.map.xaeros.worldmap.ore.OreVeinElementRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.map.WorldMap;
import xaero.map.element.MapElementReader;
import xaero.map.gui.CursorBox;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.dropdown.rightclick.RightClickOption;

public class OreVeinElementReader
extends MapElementReader<OreVeinElement, OreVeinElementContext, OreVeinElementRenderer> {
    public boolean isHidden(OreVeinElement element, OreVeinElementContext context) {
        return !GroupingMapRenderer.getInstance().doShowLayer("ore_veins");
    }

    public boolean isInteractable(int location, OreVeinElement element) {
        return true;
    }

    public float getBoxScale(int location, OreVeinElement element, OreVeinElementContext context) {
        return context.worldmapWaypointsScale;
    }

    public double getRenderX(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        return element.getVein().center().getX();
    }

    public double getRenderZ(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        return element.getVein().center().getZ();
    }

    public int getInteractionBoxLeft(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        return -this.getInteractionBoxRight(element, context, partialTicks);
    }

    public int getInteractionBoxRight(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        return ConfigHolder.INSTANCE.compat.minimap.oreIconSize;
    }

    public int getInteractionBoxTop(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        return WorldMap.settings.waypointBackgrounds ? -41 : -12;
    }

    public int getInteractionBoxBottom(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        return WorldMap.settings.waypointBackgrounds ? 0 : 12;
    }

    public int getLeftSideLength(OreVeinElement element, Minecraft mc) {
        return 9 + element.getCachedNameLength();
    }

    public String getMenuName(OreVeinElement element) {
        return element.getName();
    }

    public int getMenuTextFillLeftPadding(OreVeinElement element) {
        return 0;
    }

    public String getFilterName(OreVeinElement element) {
        return this.getMenuName(element);
    }

    public ArrayList<RightClickOption> getRightClickOptions(final OreVeinElement element, IRightClickableElement target) {
        ArrayList<RightClickOption> rightClickOptions = new ArrayList<RightClickOption>();
        rightClickOptions.add(new RightClickOption("button.gtceu.toggle_waypoint.name", 0, target){

            public void onAction(Screen screen) {
                element.onMouseSelect();
            }
        });
        rightClickOptions.add(new RightClickOption("button.gtceu.mark_as_depleted.name", rightClickOptions.size(), target){

            public void onAction(Screen screen) {
                element.toggleDepleted();
            }
        });
        return rightClickOptions;
    }

    public boolean isRightClickValid(OreVeinElement element) {
        return true;
    }

    public int getRightClickTitleBackgroundColor(OreVeinElement element) {
        return element.getFirstMaterial().getMaterialRGB();
    }

    public boolean shouldScaleBoxWithOptionalScale() {
        return true;
    }

    public int getRenderBoxLeft(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        int left = this.getInteractionBoxLeft(element, context, partialTicks);
        return Math.min(left, -element.getCachedNameLength() * 3 / 2);
    }

    public int getRenderBoxRight(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        int right = this.getInteractionBoxRight(element, context, partialTicks) + 12;
        return Math.max(right, element.getCachedNameLength() * 3 / 2);
    }

    public int getRenderBoxTop(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        return this.getInteractionBoxTop(element, context, partialTicks);
    }

    public int getRenderBoxBottom(OreVeinElement element, OreVeinElementContext context, float partialTicks) {
        return this.getInteractionBoxBottom(element, context, partialTicks);
    }

    public CursorBox getTooltip(OreVeinElement element, OreVeinElementContext context, boolean overMenu) {
        List<Component> components = OreRenderLayer.getTooltip(element.getName(), element.getVein());
        String joined = components.stream().map(Component::getString).collect(Collectors.joining(" \n "));
        return new CursorBox(joined);
    }
}

