/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.rei;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTFluids;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluid;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluidHelper;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.rei.circuit.GTProgrammedCircuitCategory;
import com.gregtechceu.gtceu.integration.rei.multipage.MultiblockInfoDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.oreprocessing.GTOreProcessingDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.orevein.GTBedrockFluidDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.orevein.GTBedrockOreDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.orevein.GTOreVeinDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeREICategory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@REIPluginClient
public class GTREIPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new MultiblockInfoDisplayCategory());
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            registry.add((DisplayCategory)new GTOreProcessingDisplayCategory());
        }
        registry.add((DisplayCategory)new GTOreVeinDisplayCategory());
        registry.add((DisplayCategory)new GTBedrockFluidDisplayCategory());
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            registry.add((DisplayCategory)new GTBedrockOreDisplayCategory());
        }
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            if (!category.shouldRegisterDisplays()) continue;
            registry.add((DisplayCategory)new GTRecipeREICategory(category));
        }
        registry.add((DisplayCategory)new GTProgrammedCircuitCategory());
        GTRecipeREICategory.registerWorkStations(registry);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            GTOreProcessingDisplayCategory.registerWorkstations(registry);
        }
        GTOreVeinDisplayCategory.registerWorkstations(registry);
        GTBedrockFluidDisplayCategory.registerWorkstations(registry);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            GTBedrockOreDisplayCategory.registerWorkstations(registry);
        }
        registry.addWorkstations(GTRecipeREICategory.CATEGORIES.apply(GTRecipeTypes.CHEMICAL_RECIPES.getCategory()), new EntryStack[]{EntryStacks.of((ItemStack)GTMultiMachines.LARGE_CHEMICAL_REACTOR.asStack())});
    }

    public void registerDisplays(DisplayRegistry registry) {
        GTRecipeREICategory.registerDisplays(registry);
        MultiblockInfoDisplayCategory.registerDisplays(registry);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            GTOreProcessingDisplayCategory.registerDisplays(registry);
        }
        GTOreVeinDisplayCategory.registerDisplays(registry);
        GTBedrockFluidDisplayCategory.registerDisplays(registry);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            GTBedrockOreDisplayCategory.registerDisplays(registry);
        }
        registry.add((Display)new GTProgrammedCircuitCategory.GTProgrammedCircuitDisplay());
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        for (GTToolType gTToolType : GTToolType.getTypes().values()) {
            registry.group(GTCEu.id("tool/" + gTToolType.name), (Component)Component.translatable((String)("gtceu.tool.class." + gTToolType.name)), (List)EntryIngredients.ofItemTag(gTToolType.itemTags.get(0)));
        }
        for (Map.Entry entry : GTMaterialBlocks.MATERIAL_BLOCKS.columnMap().entrySet()) {
            Map value = (Map)entry.getValue();
            if (value.size() <= 1) continue;
            Material material = (Material)entry.getKey();
            ArrayList<ItemLike> items = new ArrayList<ItemLike>();
            for (Map.Entry t : value.entrySet()) {
                TagPrefix prefix = (TagPrefix)t.getKey();
                if (prefix == TagPrefix.frameGt || prefix == TagPrefix.block || prefix == TagPrefix.rawOreBlock) continue;
                items.add((ItemLike)t.getValue());
            }
            String name = material.getName();
            String label = GTREIPlugin.toUpperAllWords(name.replace("_", " "));
            registry.group(GTCEu.id("ore/" + name), (Component)Component.translatable((String)"tagprefix.stone", (Object[])new Object[]{label}), (List)EntryIngredients.ofItems(items));
        }
        ArrayList<EntryStack> stacks = new ArrayList<EntryStack>(BuiltInRegistries.POTION.size());
        for (Potion potion : BuiltInRegistries.POTION) {
            FluidStack stack = PotionFluidHelper.getFluidFromPotion(potion, 250);
            stacks.add(EntryStacks.of((dev.architectury.fluid.FluidStack)dev.architectury.fluid.FluidStack.create((Fluid)stack.getFluid(), (long)stack.getAmount(), (CompoundTag)stack.getTag())));
        }
        registry.group(GTCEu.id("potion_fluids"), (Component)Component.translatable((String)"gtceu.rei.group.potion_fluids"), stacks);
    }

    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerNbt(GTItems.PROGRAMMED_CIRCUIT.asItem());
        registry.registerNbt(GTItems.TURBINE_ROTOR.asItem());
    }

    public void registerFluidComparators(FluidComparatorRegistry registry) {
        PotionFluid potionFluid = (PotionFluid)((Object)GTFluids.POTION.get());
        registry.registerNbt(potionFluid.getSource());
        registry.registerNbt(potionFluid.getFlowing());
    }

    public void registerEntries(EntryRegistry registry) {
        for (Potion potion : BuiltInRegistries.POTION) {
            FluidStack stack = PotionFluidHelper.getFluidFromPotion(potion, 250);
            registry.addEntry(EntryStacks.of((dev.architectury.fluid.FluidStack)dev.architectury.fluid.FluidStack.create((Fluid)stack.getFluid(), (long)stack.getAmount(), (CompoundTag)stack.getTag())));
        }
    }

    private static String toUpperAllWords(String text) {
        StringBuilder result = new StringBuilder();
        result.append(text.substring(0, 1).toUpperCase(Locale.ROOT));
        for (int i = 1; i < text.length(); ++i) {
            if (" ".equals(text.substring(i - 1, i))) {
                result.append(text.substring(i, i + 1).toUpperCase(Locale.ROOT));
                continue;
            }
            result.append(text.charAt(i));
        }
        return result.toString();
    }
}

