/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.element;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.integration.top.element.FluidStyle;
import com.gregtechceu.gtceu.integration.top.element.IFluidStyle;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.mojang.blaze3d.systems.RenderSystem;
import mcjty.theoneprobe.api.IElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackElement
implements IElement {
    private final FluidStack fluidStack;
    private final IFluidStyle style;

    public FluidStackElement(FluidStack fluidStack, IFluidStyle style) {
        this.fluidStack = fluidStack;
        this.style = style;
    }

    public FluidStackElement(FriendlyByteBuf buf) {
        this.fluidStack = buf.readBoolean() ? FluidStack.readFromPacket((FriendlyByteBuf)buf) : FluidStack.EMPTY;
        this.style = new FluidStyle().width(buf.readInt()).height(buf.readInt());
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.disableBlend();
        if (!this.fluidStack.isEmpty()) {
            int width = this.style.getWidth() - 4;
            int height = this.style.getHeight() - 4;
            DrawerHelper.drawFluidForGui((GuiGraphics)guiGraphics, (com.lowdragmc.lowdraglib.side.fluid.FluidStack)FluidHelperImpl.toFluidStack((FluidStack)this.fluidStack), (long)this.fluidStack.getAmount(), (int)(x += 2), (int)(y += 2), (int)width, (int)height);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            String s = TextFormattingUtil.formatLongToCompactStringBuckets((long)this.fluidStack.getAmount(), (int)3) + "B";
            Font fontRenderer = Minecraft.getInstance().font;
            guiGraphics.drawString(fontRenderer, s, ((float)x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.width(s) + 21.0f, ((float)y + (float)height / 3.0f + 6.0f) * 2.0f, 0xFFFFFF, true);
            guiGraphics.pose().popPose();
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int getWidth() {
        return this.style.getWidth();
    }

    public int getHeight() {
        return this.style.getHeight();
    }

    public void toBytes(FriendlyByteBuf friendlyByteBuf) {
        if (!this.fluidStack.isEmpty()) {
            friendlyByteBuf.writeBoolean(true);
            this.fluidStack.writeToPacket(friendlyByteBuf);
        } else {
            friendlyByteBuf.writeBoolean(false);
        }
        friendlyByteBuf.writeInt(this.style.getWidth());
        friendlyByteBuf.writeInt(this.style.getHeight());
    }

    public ResourceLocation getID() {
        return GTCEu.id("fluid_element");
    }
}

