/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.element;

import com.gregtechceu.gtceu.GTCEu;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ProgressElement
implements IElement {
    private final float progress;
    @Nullable
    private final Component text;
    private final IProgressStyle style;

    public ProgressElement(float progress, Component text, IProgressStyle style) {
        this.progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
        this.text = text;
        this.style = style;
    }

    public ProgressElement(FriendlyByteBuf buf) {
        this.progress = buf.readFloat();
        this.text = buf.readComponent();
        this.style = new ProgressStyle().width(buf.readInt()).height(buf.readInt()).prefix(buf.readComponent()).suffix(buf.readComponent()).borderColor(buf.readInt()).filledColor(buf.readInt()).alternateFilledColor(buf.readInt()).backgroundColor(buf.readInt()).showText(buf.readBoolean()).numberFormat(NumberFormat.values()[buf.readByte()]).lifeBar(buf.readBoolean()).armorBar(buf.readBoolean()).alignment((ElementAlignment)buf.readEnum(ElementAlignment.class));
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        RenderHelper.drawThickBeveledBox((GuiGraphics)guiGraphics, (int)x, (int)y, (int)(x + this.getWidth()), (int)(y + this.getHeight()), (int)1, (int)this.style.getBorderColor(), (int)this.style.getBorderColor(), (int)this.style.getBackgroundColor());
        if (this.progress > 0.0f) {
            int dx = (int)Math.min(this.progress * (float)(this.getWidth() - 2), (float)(this.getWidth() - 2));
            if (this.style.getFilledColor() == this.style.getAlternatefilledColor()) {
                if (dx > 0) {
                    RenderHelper.drawThickBeveledBox((GuiGraphics)guiGraphics, (int)(x + 1), (int)(y + 1), (int)(x + dx + 1), (int)(y + this.getHeight() - 1), (int)1, (int)this.style.getFilledColor(), (int)this.style.getFilledColor(), (int)this.style.getFilledColor());
                }
            } else {
                for (int xx = 0; xx < x + dx; ++xx) {
                    int color = (xx & 1) == 0 ? this.style.getFilledColor() : this.style.getAlternatefilledColor();
                    RenderHelper.drawVerticalLine((GuiGraphics)guiGraphics, (int)xx, (int)(y + 1), (int)(y + this.getHeight() - 1), (int)color);
                }
            }
        }
        if (this.style.isShowText()) {
            Minecraft mc = Minecraft.getInstance();
            Font render = mc.font;
            int textWidth = render.width(this.text.getVisualOrderText());
            switch (this.style.getAlignment()) {
                case ALIGN_BOTTOMRIGHT: {
                    RenderHelper.renderText((Minecraft)mc, (GuiGraphics)guiGraphics, (int)(x + this.getWidth() - 3 - textWidth), (int)(y + 3), (Component)this.text);
                    break;
                }
                case ALIGN_CENTER: {
                    RenderHelper.renderText((Minecraft)mc, (GuiGraphics)guiGraphics, (int)(x + this.getWidth() / 2 - textWidth / 2), (int)(y + 3), (Component)this.text);
                    break;
                }
                case ALIGN_TOPLEFT: {
                    RenderHelper.renderText((Minecraft)mc, (GuiGraphics)guiGraphics, (int)(x + 3), (int)(y + 3), (Component)this.text);
                }
            }
        }
    }

    public int getWidth() {
        float width = 0.0f;
        width += 2.0f;
        if (this.text != null) {
            Font font = Minecraft.getInstance().font;
            width += (float)(font.width((FormattedText)this.text) + 3);
        }
        return (int)Math.max((float)this.style.getWidth(), width);
    }

    public int getHeight() {
        return this.text == null ? 8 : 14;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.progress);
        buf.writeComponent(this.text);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.writeComponent(this.style.getPrefixComp());
        buf.writeComponent(this.style.getSuffixComp());
        buf.writeInt(this.style.getBorderColor());
        buf.writeInt(this.style.getFilledColor());
        buf.writeInt(this.style.getAlternatefilledColor());
        buf.writeInt(this.style.getBackgroundColor());
        buf.writeBoolean(this.style.isShowText());
        buf.writeByte(this.style.getNumberFormat().ordinal());
        buf.writeBoolean(this.style.isLifeBar());
        buf.writeBoolean(this.style.isArmorBar());
        buf.writeEnum((Enum)this.style.getAlignment());
    }

    public ResourceLocation getID() {
        return GTCEu.id("progress");
    }

    public static class Factory
    implements IElementFactory {
        public IElement createElement(FriendlyByteBuf friendlyByteBuf) {
            return new ProgressElement(friendlyByteBuf);
        }

        public ResourceLocation getId() {
            return GTCEu.id("progress");
        }
    }
}

