/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import com.gregtechceu.gtceu.utils.GTUtil;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MaintenanceInfoProvider
extends CapabilityInfoProvider<IMaintenanceMachine> {
    @Override
    @Nullable
    protected IMaintenanceMachine getCapability(Level level, BlockPos blockPos, @Nullable Direction direction) {
        IMaintenanceMachine cap = GTCapabilityHelper.getMaintenanceMachine(level, blockPos, direction);
        if (cap != null) {
            return cap;
        }
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof IMultiController) {
            IMultiController controller = (IMultiController)((Object)metaMachine);
            for (IMultiPart part : controller.getParts()) {
                if (!(part instanceof IMaintenanceMachine)) continue;
                IMaintenanceMachine maintenanceMachine = (IMaintenanceMachine)part;
                return maintenanceMachine;
            }
        }
        return null;
    }

    @Override
    protected void addProbeInfo(IMaintenanceMachine maintenanceMachine, IProbeInfo iProbeInfo, Player player, BlockEntity blockEntity, IProbeHitData iProbeHitData) {
        IProbeInfo verticalPane = iProbeInfo.vertical(iProbeInfo.defaultLayoutStyle().spacing(0));
        if (maintenanceMachine.hasMaintenanceProblems()) {
            if (player.isShiftKeyDown()) {
                byte problems = maintenanceMachine.getMaintenanceProblems();
                for (byte i = 0; i < 6; i = (byte)((byte)(i + 1))) {
                    if ((problems >> i & 1) != 0) continue;
                    IProbeInfo horizontalPane = verticalPane.horizontal(verticalPane.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                    Tuple<ItemStack, MutableComponent> tuple = GTUtil.getMaintenanceText(i);
                    horizontalPane.item((ItemStack)tuple.getA(), new ItemStyle().width(16).height(16)).text((Component)tuple.getB());
                }
            } else {
                verticalPane.text(CompoundText.create().error((Component)Component.translatable((String)"gtceu.top.maintenance_broken")));
            }
        } else {
            verticalPane.text(CompoundText.create().ok((Component)Component.translatable((String)"gtceu.top.maintenance_fixed")));
        }
    }

    public ResourceLocation getID() {
        return GTCEu.id("maintenance_info");
    }
}

