/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.integration.jade.provider.RecipeLogicProvider;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class RecipeLogicInfoProvider
extends CapabilityInfoProvider<RecipeLogic> {
    public ResourceLocation getID() {
        return GTCEu.id("recipe_logic_provider");
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getRecipeLogic(level, pos, side);
    }

    @Override
    protected void addProbeInfo(RecipeLogic capability, IProbeInfo probeInfo, Player player, BlockEntity blockEntity, IProbeHitData data) {
        GTRecipe recipe;
        if (capability.isWorking() && (recipe = capability.getLastRecipe()) != null) {
            IMachineBlockEntity machineBlockEntity;
            MetaMachine machine;
            EnergyStack.WithIO EUt = RecipeHelper.getRealEUtWithIO(recipe);
            if (EUt.isEmpty()) {
                return;
            }
            String formatted = FormattingUtil.formatNumbers(EUt.getTotalEU()) + String.valueOf(TextStyleClass.INFO);
            MutableComponent text = null;
            if (blockEntity instanceof IMachineBlockEntity && (machine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof SteamMachine) {
                text = Component.translatable((String)"gtceu.jade.fluid_use", (Object[])new Object[]{formatted}).withStyle(ChatFormatting.GREEN);
            }
            if (text == null) {
                byte tier = GTUtil.getTierByVoltage(RecipeLogicProvider.getVoltage(capability));
                String minAmperage = FormattingUtil.formatNumber2Places((float)EUt.getTotalEU() / (float)GTValues.V[tier]) + String.valueOf(TextStyleClass.INFO);
                text = Component.translatable((String)"gtceu.jade.amperage_use", (Object[])new Object[]{minAmperage}).withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"gtceu.jade.at").withStyle(ChatFormatting.GREEN)).append(GTValues.VNF[tier]).append((Component)Component.translatable((String)"gtceu.universal.padded_parentheses", (Object[])new Object[]{Component.translatable((String)"gtceu.recipe.eu.total", (Object[])new Object[]{formatted})}).withStyle(ChatFormatting.WHITE));
            }
            if (EUt.isInput()) {
                probeInfo.text(CompoundText.create().text((Component)Component.translatable((String)"gtceu.top.energy_consumption").append(" ").append(text)).style(TextStyleClass.INFO));
            } else {
                probeInfo.text(CompoundText.create().text((Component)Component.translatable((String)"gtceu.top.energy_production").append(" ").append(text)).style(TextStyleClass.INFO));
            }
        }
    }
}

