/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.electric.TransformerMachine;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TransformerInfoProvider
implements IProbeInfoProvider {
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, iProbeHitData.getPos());
        if (metaMachine instanceof TransformerMachine) {
            TransformerMachine transformer = (TransformerMachine)metaMachine;
            boolean transformUp = transformer.isTransformUp();
            int voltage = transformer.getTier();
            int amp = transformer.getBaseAmp();
            int side = transformer.getFrontFacing().get3DDataValue();
            IProbeInfo verticalPane = iProbeInfo.vertical(iProbeInfo.defaultLayoutStyle().spacing(0));
            if (transformUp) {
                verticalPane.text((Component)Component.translatable((String)"gtceu.top.transform_up", (Object[])new Object[]{GTValues.VNF[voltage] + " \u00a7r(" + amp * 4 + "A) -> " + GTValues.VNF[voltage + 1] + " \u00a7r(" + amp + "A)"}));
            } else {
                verticalPane.text((Component)Component.translatable((String)"gtceu.top.transform_down", (Object[])new Object[]{GTValues.VNF[voltage + 1] + " \u00a7r(" + amp + "A) -> " + GTValues.VNF[voltage] + " \u00a7r(" + amp * 4 + "A)"}));
            }
            if (iProbeHitData.getSideHit() == Direction.from3DDataValue((int)side)) {
                verticalPane.text((Component)Component.translatable((String)(transformUp ? "gtceu.top.transform_output" : "gtceu.top.transform_input"), (Object[])new Object[]{GTValues.VNF[voltage + 1] + " \u00a7r(" + amp + "A)"}));
            } else {
                verticalPane.text((Component)Component.translatable((String)(transformUp ? "gtceu.top.transform_input" : "gtceu.top.transform_output"), (Object[])new Object[]{GTValues.VNF[voltage] + " \u00a7r(" + amp * 4 + "A)"}));
            }
        }
    }

    public ResourceLocation getID() {
        return GTCEu.id("transformer_provider");
    }
}

