/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.xei.entry.fluid;

import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FluidTagList
implements FluidEntryList {
    private final List<FluidTagEntry> entries = new ArrayList<FluidTagEntry>();

    public static FluidTagList of(@NotNull TagKey<Fluid> tag, int amount, @Nullable CompoundTag nbt) {
        FluidTagList list = new FluidTagList();
        list.add(tag, amount, nbt);
        return list;
    }

    public void add(FluidTagEntry entry) {
        this.entries.add(entry);
    }

    public void add(@NotNull TagKey<Fluid> tag, int amount, @Nullable CompoundTag nbt) {
        this.add(new FluidTagEntry(tag, amount, nbt));
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public List<FluidStack> getStacks() {
        return this.entries.stream().flatMap(FluidTagEntry::stacks).toList();
    }

    @Generated
    public List<FluidTagEntry> getEntries() {
        return this.entries;
    }

    public record FluidTagEntry(@NotNull TagKey<Fluid> tag, int amount, @Nullable CompoundTag nbt) {
        public Stream<FluidStack> stacks() {
            return BuiltInRegistries.FLUID.getTag(this.tag).map(HolderSet.ListBacked::stream).orElseGet(Stream::empty).map(holder -> new FluidStack((Fluid)holder.get(), this.amount, this.nbt));
        }
    }
}

