/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.syncdata;

import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.monitor.MonitorGroup;
import com.lowdragmc.lowdraglib.syncdata.payload.ObjectTypedPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class MonitorGroupPayload
extends ObjectTypedPayload<MonitorGroup> {
    @Nullable
    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("name", ((MonitorGroup)this.payload).getName());
        ListTag list = new ListTag();
        ((MonitorGroup)this.payload).getRelativePositions().forEach(pos -> list.add((Object)NbtUtils.writeBlockPos((BlockPos)pos)));
        if (((MonitorGroup)this.payload).getTargetRaw() != null) {
            tag.put("targetPos", (Tag)NbtUtils.writeBlockPos((BlockPos)((MonitorGroup)this.payload).getTargetRaw()));
            if (((MonitorGroup)this.payload).getTargetCoverSide() != null) {
                tag.putString("targetSide", ((MonitorGroup)this.payload).getTargetCoverSide().getSerializedName());
            }
        }
        tag.put("positions", (Tag)list);
        tag.putInt("dataSlot", ((MonitorGroup)this.payload).getDataSlot());
        tag.put("items", (Tag)((MonitorGroup)this.payload).getItemStackHandler().serializeNBT());
        tag.put("placeholderSlots", (Tag)((MonitorGroup)this.payload).getPlaceholderSlotsHandler().serializeNBT());
        return tag;
    }

    public void deserializeNBT(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            CustomItemStackHandler handler = new CustomItemStackHandler();
            CustomItemStackHandler placeholderSlotsHandler = new CustomItemStackHandler();
            handler.deserializeNBT(compoundTag.getCompound("items"));
            placeholderSlotsHandler.deserializeNBT(compoundTag.getCompound("placeholderSlots"));
            this.payload = new MonitorGroup(compoundTag.getString("name"), handler, placeholderSlotsHandler);
            ListTag list = compoundTag.getList("positions", 10);
            for (int i = 0; i < list.size(); ++i) {
                ((MonitorGroup)this.payload).add(NbtUtils.readBlockPos((CompoundTag)list.getCompound(i)));
            }
            if (compoundTag.contains("targetPos", 10)) {
                ((MonitorGroup)this.payload).setTarget(NbtUtils.readBlockPos((CompoundTag)compoundTag.getCompound("targetPos")));
                if (compoundTag.contains("targetSide", 8)) {
                    ((MonitorGroup)this.payload).setTargetCoverSide(Direction.byName((String)compoundTag.getString("targetSide")));
                }
                if (compoundTag.contains("dataSlot", 3)) {
                    ((MonitorGroup)this.payload).setDataSlot(compoundTag.getInt("dataSlot"));
                }
            }
        }
    }
}

