/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.ItemValueAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import com.gregtechceu.gtceu.core.mixins.forge.IntersectionIngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.forge.PartialNBTIngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.forge.StrictNBTIngredientAccessor;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public class IngredientEquality {
    public static final Comparator<Item> ITEM_COMPARATOR = Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
    public static final Comparator<Ingredient.Value> INGREDIENT_VALUE_COMPARATOR = new Comparator<Ingredient.Value>(){

        @Override
        public int compare(Ingredient.Value value1, Ingredient.Value value2) {
            if (value1 instanceof TagValueAccessor) {
                TagValueAccessor first = (TagValueAccessor)value1;
                if (!(value2 instanceof TagValueAccessor)) {
                    return 10;
                }
                TagValueAccessor second = (TagValueAccessor)value2;
                if (first.getTag() != second.getTag()) {
                    return 1;
                }
            } else if (value1 instanceof ItemValueAccessor) {
                ItemValueAccessor first = (ItemValueAccessor)value1;
                if (!(value2 instanceof ItemValueAccessor)) {
                    return 10;
                }
                ItemValueAccessor second = (ItemValueAccessor)value2;
                return ITEM_COMPARATOR.compare(first.getItem().getItem(), second.getItem().getItem());
            }
            return 0;
        }
    };
    public static final Comparator<Ingredient> INGREDIENT_COMPARATOR = new Comparator<Ingredient>(){

        @Override
        public int compare(Ingredient first, Ingredient second) {
            Ingredient.Value[] secondValues;
            if (first instanceof StrictNBTIngredient) {
                StrictNBTIngredient strict1 = (StrictNBTIngredient)first;
                if (second instanceof StrictNBTIngredientAccessor) {
                    StrictNBTIngredientAccessor strict2 = (StrictNBTIngredientAccessor)second;
                    return strict1.test(strict2.getStack()) ? 0 : 1;
                }
                return 1;
            }
            if (first instanceof PartialNBTIngredient) {
                PartialNBTIngredient partial1 = (PartialNBTIngredient)first;
                if (second instanceof PartialNBTIngredient) {
                    PartialNBTIngredient partial2 = (PartialNBTIngredient)second;
                    if (partial1.getItems().length != partial2.getItems().length) {
                        return 1;
                    }
                    for (ItemStack stack : partial1.getItems()) {
                        if (partial2.test(stack)) continue;
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            if (first instanceof IntersectionIngredient) {
                IntersectionIngredient intersection1 = (IntersectionIngredient)first;
                if (second instanceof IntersectionIngredient) {
                    IntersectionIngredient intersection2 = (IntersectionIngredient)second;
                    ArrayList ingredients1 = Lists.newArrayList(((IntersectionIngredientAccessor)intersection1).getChildren());
                    ArrayList ingredients2 = Lists.newArrayList(((IntersectionIngredientAccessor)intersection2).getChildren());
                    if (ingredients1.size() != ingredients2.size()) {
                        return 1;
                    }
                    ingredients1.sort(this);
                    ingredients2.sort(this);
                    for (int i = 0; i < ingredients1.size(); ++i) {
                        Ingredient ingredient2;
                        Ingredient ingredient1 = (Ingredient)ingredients1.get(i);
                        int result = this.compare(ingredient1, ingredient2 = (Ingredient)ingredients2.get(i));
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
                return 1;
            }
            Ingredient.Value[] firstValues = ((IngredientAccessor)first).getValues();
            if (firstValues.length != (secondValues = ((IngredientAccessor)second).getValues()).length) {
                return 1;
            }
            firstValues = (Ingredient.Value[])firstValues.clone();
            secondValues = (Ingredient.Value[])secondValues.clone();
            Arrays.parallelSort(firstValues, INGREDIENT_VALUE_COMPARATOR);
            Arrays.parallelSort(secondValues, INGREDIENT_VALUE_COMPARATOR);
            for (int i = 0; i < firstValues.length; ++i) {
                Ingredient.Value value1 = firstValues[i];
                Ingredient.Value value2 = secondValues[i];
                int result = INGREDIENT_VALUE_COMPARATOR.compare(value1, value2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    };

    public static boolean ingredientEquals(Ingredient first, Ingredient second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        first = SizedIngredient.getInner(first);
        second = SizedIngredient.getInner(second);
        return IngredientEquality.cmp(first, second);
    }

    private static boolean cmp(Ingredient first, Ingredient second) {
        return INGREDIENT_COMPARATOR.compare(first, second) == 0;
    }

    public static final class IngredientHashStrategy
    implements Hash.Strategy<Ingredient> {
        public static final IngredientHashStrategy INSTANCE = new IngredientHashStrategy();
        private static final ItemStackHashStrategy ITEM_TAG_STRATEGY = ItemStackHashStrategy.comparingAllButCount();
        private static final ItemStackHashStrategy ITEM_STRATEGY = ItemStackHashStrategy.comparingItem();

        public int hashCode(Ingredient o) {
            int hashCode;
            block5: {
                block7: {
                    block6: {
                        block4: {
                            hashCode = 537;
                            if (!(o instanceof StrictNBTIngredientAccessor)) break block4;
                            StrictNBTIngredientAccessor strict = (StrictNBTIngredientAccessor)o;
                            hashCode *= 31 * ITEM_TAG_STRATEGY.hashCode(strict.getStack());
                            break block5;
                        }
                        if (!(o instanceof PartialNBTIngredientAccessor)) break block6;
                        PartialNBTIngredientAccessor partial = (PartialNBTIngredientAccessor)o;
                        hashCode *= 31 * partial.getNbt().hashCode();
                        hashCode *= 31 * partial.getItems().hashCode();
                        break block5;
                    }
                    if (!(o instanceof IntersectionIngredientAccessor)) break block7;
                    IntersectionIngredientAccessor intersection = (IntersectionIngredientAccessor)o;
                    for (Ingredient ingredient : intersection.getChildren()) {
                        hashCode *= 31 * this.hashCode(ingredient);
                    }
                    break block5;
                }
                if (!(o instanceof IngredientAccessor)) break block5;
                IngredientAccessor ingredient = (IngredientAccessor)o;
                for (Ingredient.Value value : ingredient.getValues()) {
                    if (value instanceof TagValueAccessor) {
                        TagValueAccessor tagValue = (TagValueAccessor)value;
                        hashCode *= 31 * tagValue.getTag().hashCode();
                        continue;
                    }
                    for (ItemStack stack : value.getItems()) {
                        hashCode *= 31 * ITEM_STRATEGY.hashCode(stack);
                    }
                }
            }
            return hashCode;
        }

        public boolean equals(Ingredient a, Ingredient b) {
            return IngredientEquality.ingredientEquals(a, b);
        }
    }
}

