/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class OverlayedItemHandler {
    private final OverlayedItemHandlerSlot[] originalSlots;
    private final OverlayedItemHandlerSlot[] slots;
    private final IItemHandlerModifiable overlayedHandler;

    public OverlayedItemHandler(@NotNull IItemHandlerModifiable toOverlay) {
        this.slots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.originalSlots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.overlayedHandler = toOverlay;
    }

    public void reset() {
        for (int i = 0; i < this.originalSlots.length; ++i) {
            if (this.originalSlots[i] == null) continue;
            this.slots[i] = this.originalSlots[i].copy();
        }
    }

    public int getSlots() {
        return this.overlayedHandler.getSlots();
    }

    private void initSlot(int slot) {
        if (this.originalSlots[slot] == null) {
            ItemStack stackToMirror = this.overlayedHandler.getStackInSlot(slot);
            int slotLimit = this.overlayedHandler.getSlotLimit(slot);
            this.originalSlots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
            this.slots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
        }
    }

    public int insertStackedItemStack(@NotNull ItemStack stack, int amountToInsert) {
        int insertedAmount;
        int canInsertUpTo;
        int lastKnownPopulatedSlot = 0;
        int i = 0;
        while (i < this.slots.length) {
            this.initSlot(i);
            ItemStack slotKey = this.slots[i].getItemStack();
            if ((slotKey.isEmpty() || ItemStack.isSameItemSameTags((ItemStack)slotKey, (ItemStack)stack)) && (canInsertUpTo = Math.min(this.slots[i].getSlotLimit() - this.slots[i].getCount(), stack.getMaxStackSize())) > 0) {
                insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                this.slots[i].setItemStack(stack.copy());
                this.slots[i].setCount(this.slots[i].getCount() + insertedAmount);
                amountToInsert -= insertedAmount;
            }
            lastKnownPopulatedSlot = i++;
            if (amountToInsert != 0) continue;
            return 0;
        }
        if (amountToInsert > 0) {
            for (i = lastKnownPopulatedSlot + 1; i < this.slots.length; ++i) {
                OverlayedItemHandlerSlot slot = this.slots[i];
                if (!slot.getItemStack().isEmpty()) continue;
                canInsertUpTo = Math.min(stack.getMaxStackSize(), slot.getSlotLimit());
                if (canInsertUpTo > 0) {
                    insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                    slot.setItemStack(stack.copy());
                    slot.setCount(insertedAmount);
                    amountToInsert -= insertedAmount;
                }
                if (amountToInsert != 0) continue;
                return 0;
            }
        }
        return amountToInsert;
    }

    private static class OverlayedItemHandlerSlot {
        private ItemStack itemStack = ItemStack.EMPTY;
        private int count = 0;
        private int slotLimit;

        protected OverlayedItemHandlerSlot(@NotNull ItemStack stackToMirror, int slotLimit) {
            if (!stackToMirror.isEmpty()) {
                this.itemStack = stackToMirror.copy();
                this.count = stackToMirror.getCount();
                this.slotLimit = Math.min(this.itemStack.getMaxStackSize(), slotLimit);
            } else {
                this.slotLimit = slotLimit;
            }
        }

        protected OverlayedItemHandlerSlot(@NotNull ItemStack itemStack, int slotLimit, int count) {
            this.itemStack = itemStack;
            this.count = count;
            this.slotLimit = slotLimit;
        }

        public int getSlotLimit() {
            return this.slotLimit;
        }

        public int getCount() {
            return this.count;
        }

        @NotNull
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public void setItemStack(@NotNull ItemStack itemStack) {
            if (!ItemStack.isSameItemSameTags((ItemStack)this.itemStack, (ItemStack)itemStack)) {
                this.itemStack = itemStack;
                this.slotLimit = Math.min(itemStack.getMaxStackSize(), this.slotLimit);
            }
        }

        public void setCount(int count) {
            this.count = count;
        }

        @NotNull
        OverlayedItemHandlerSlot copy() {
            return new OverlayedItemHandlerSlot(this.itemStack, this.slotLimit, this.count);
        }
    }
}

