/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.Filter;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.NotImplementedException;

public interface FluidFilter
extends Filter<FluidStack, FluidFilter> {
    public static final Map<ItemLike, Function<ItemStack, FluidFilter>> FILTERS = new HashMap<ItemLike, Function<ItemStack, FluidFilter>>();
    public static final FluidFilter EMPTY = new FluidFilter(){

        @Override
        public boolean test(FluidStack fluidStack) {
            return true;
        }

        @Override
        public int testFluidAmount(FluidStack fluidStack) {
            return Integer.MAX_VALUE;
        }

        @Override
        public WidgetGroup openConfigurator(int x, int y) {
            throw new NotImplementedException("Not available for empty fluid filter");
        }

        @Override
        public CompoundTag saveFilter() {
            throw new NotImplementedException("Not available for empty fluid filter");
        }

        @Override
        public void setOnUpdated(Consumer<FluidFilter> onUpdated) {
            throw new NotImplementedException("Not available for empty fluid filter");
        }
    };

    public static FluidFilter loadFilter(ItemStack itemStack) {
        return FILTERS.get(itemStack.m_41720_()).apply(itemStack);
    }

    public int testFluidAmount(FluidStack var1);

    default public boolean supportsAmounts() {
        return !this.isBlackList();
    }
}

