/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.capability.IPropertyFluidFilter;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttributes;
import com.gregtechceu.gtceu.utils.GTMath;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class FluidPipeProperties
implements IMaterialProperty,
IPropertyFluidFilter {
    public static final int MAX_PIPE_CHANNELS = 9;
    private int throughput;
    private int channels;
    private int maxFluidTemperature;
    private boolean gasProof;
    private boolean cryoProof;
    private boolean plasmaProof;
    private final Object2BooleanMap<FluidAttribute> containmentPredicate = new Object2BooleanOpenHashMap();

    public FluidPipeProperties(int maxFluidTemperature, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof, int channels) {
        this.maxFluidTemperature = maxFluidTemperature;
        this.throughput = throughput;
        this.gasProof = gasProof;
        if (acidProof) {
            this.setCanContain(FluidAttributes.ACID, true);
        }
        this.cryoProof = cryoProof;
        this.plasmaProof = plasmaProof;
        this.channels = channels;
    }

    public FluidPipeProperties(int maxFluidTemperature, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        this(maxFluidTemperature, throughput, gasProof, acidProof, cryoProof, plasmaProof, 1);
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (!properties.hasProperty(PropertyKey.WOOD)) {
            properties.ensureSet(PropertyKey.INGOT, true);
        }
        if (properties.hasProperty(PropertyKey.ITEM_PIPE)) {
            throw new IllegalStateException("Material " + String.valueOf(properties.getMaterial()) + " has both Fluid and Item Pipe Property, which is not allowed!");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FluidPipeProperties)) {
            return false;
        }
        FluidPipeProperties that = (FluidPipeProperties)o;
        return this.maxFluidTemperature == that.maxFluidTemperature && this.throughput == that.throughput && this.gasProof == that.gasProof && this.channels == that.channels;
    }

    public int hashCode() {
        return GTMath.hashInts(this.maxFluidTemperature, this.throughput, Boolean.hashCode(this.gasProof), this.channels);
    }

    public String toString() {
        return "FluidPipeProperties{maxFluidTemperature=" + this.maxFluidTemperature + ", throughput=" + this.throughput + ", gasProof=" + this.gasProof + ", acidProof=" + this.isAcidProof() + ", cryoProof=" + this.cryoProof + ", plasmaProof=" + this.plasmaProof + ", channels=" + this.channels + "}";
    }

    @Override
    public boolean canContain(@NotNull FluidState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case FluidState.LIQUID -> true;
            case FluidState.GAS -> this.gasProof;
            case FluidState.PLASMA -> this.plasmaProof;
        };
    }

    public boolean isAcidProof() {
        return this.canContain(FluidAttributes.ACID);
    }

    @Override
    public boolean canContain(@NotNull FluidAttribute attribute) {
        return this.containmentPredicate.getBoolean((Object)attribute);
    }

    @Override
    public void setCanContain(@NotNull FluidAttribute attribute, boolean canContain) {
        this.containmentPredicate.put((Object)attribute, canContain);
    }

    @Override
    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull FluidAttribute> getContainedAttributes() {
        return this.containmentPredicate.keySet();
    }

    @Generated
    public int getThroughput() {
        return this.throughput;
    }

    @Generated
    public void setThroughput(int throughput) {
        this.throughput = throughput;
    }

    @Generated
    public int getChannels() {
        return this.channels;
    }

    @Generated
    public void setChannels(int channels) {
        this.channels = channels;
    }

    @Override
    @Generated
    public int getMaxFluidTemperature() {
        return this.maxFluidTemperature;
    }

    @Generated
    public void setMaxFluidTemperature(int maxFluidTemperature) {
        this.maxFluidTemperature = maxFluidTemperature;
    }

    @Override
    @Generated
    public boolean isGasProof() {
        return this.gasProof;
    }

    @Generated
    public void setGasProof(boolean gasProof) {
        this.gasProof = gasProof;
    }

    @Override
    @Generated
    public boolean isCryoProof() {
        return this.cryoProof;
    }

    @Generated
    public void setCryoProof(boolean cryoProof) {
        this.cryoProof = cryoProof;
    }

    @Override
    @Generated
    public boolean isPlasmaProof() {
        return this.plasmaProof;
    }

    @Generated
    public void setPlasmaProof(boolean plasmaProof) {
        this.plasmaProof = plasmaProof;
    }
}

