/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.config.ConfigHolder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.ArrayUtils;

public class ToolProperty
implements IMaterialProperty {
    private float harvestSpeed;
    private float attackDamage;
    private float attackSpeed;
    private int durability;
    private int harvestLevel;
    private int prospectingDepth;
    private int enchantability = 10;
    private boolean ignoreCraftingTools;
    private boolean isUnbreakable;
    private boolean isMagnetic;
    private int durabilityMultiplier = 1;
    private MaterialToolTier toolTier;
    private GTToolType[] types;
    private final Object2IntMap<Enchantment> enchantments = new Object2IntArrayMap();

    public ToolProperty(float harvestSpeed, float attackDamage, int durability, int harvestLevel, GTToolType[] types) {
        this.harvestSpeed = harvestSpeed;
        this.attackDamage = attackDamage;
        this.durability = durability;
        this.harvestLevel = harvestLevel;
        this.types = types;
        this.prospectingDepth = this.harvestLevel * 2 + 1;
    }

    public ToolProperty(float harvestSpeed, float attackDamage, int durability, int harvestLevel, int prospectingDepth, GTToolType[] types) {
        this(harvestSpeed, attackDamage, durability, harvestLevel, types);
        this.prospectingDepth = prospectingDepth;
    }

    public ToolProperty() {
        this(1.0f, 1.0f, 100, 2, (GTToolType[])GTToolType.getTypes().values().toArray(GTToolType[]::new));
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (!properties.hasProperty(PropertyKey.WOOD) && !properties.hasProperty(PropertyKey.GEM)) {
            properties.ensureSet(PropertyKey.INGOT, true);
        }
    }

    public void addEnchantmentForTools(Enchantment enchantment, int level) {
        if (ConfigHolder.INSTANCE.recipes.enchantedTools) {
            this.enchantments.put((Object)enchantment, level);
        }
    }

    public MaterialToolTier getTier(Material material) {
        if (this.toolTier == null) {
            this.toolTier = new MaterialToolTier(material);
        }
        return this.toolTier;
    }

    public boolean hasType(GTToolType toolType) {
        return ArrayUtils.contains((Object[])this.types, (Object)toolType);
    }

    public ToolProperty addTypes(GTToolType ... types) {
        this.types = (GTToolType[])ArrayUtils.addAll((Object[])this.types, (Object[])types);
        return this;
    }

    public ToolProperty removeTypes(GTToolType ... types) {
        this.types = (GTToolType[])Arrays.stream(this.types).filter(type -> !ArrayUtils.contains((Object[])types, (Object)type)).toArray(GTToolType[]::new);
        return this;
    }

    @Generated
    public float getHarvestSpeed() {
        return this.harvestSpeed;
    }

    @Generated
    public void setHarvestSpeed(float harvestSpeed) {
        this.harvestSpeed = harvestSpeed;
    }

    @Generated
    public float getAttackDamage() {
        return this.attackDamage;
    }

    @Generated
    public void setAttackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
    }

    @Generated
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Generated
    public void setAttackSpeed(float attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    @Generated
    public int getDurability() {
        return this.durability;
    }

    @Generated
    public void setDurability(int durability) {
        this.durability = durability;
    }

    @Generated
    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    @Generated
    public void setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
    }

    @Generated
    public int getProspectingDepth() {
        return this.prospectingDepth;
    }

    @Generated
    public void setProspectingDepth(int prospectingDepth) {
        this.prospectingDepth = prospectingDepth;
    }

    @Generated
    public int getEnchantability() {
        return this.enchantability;
    }

    @Generated
    public void setEnchantability(int enchantability) {
        this.enchantability = enchantability;
    }

    @Generated
    public boolean isIgnoreCraftingTools() {
        return this.ignoreCraftingTools;
    }

    @Generated
    public void setIgnoreCraftingTools(boolean ignoreCraftingTools) {
        this.ignoreCraftingTools = ignoreCraftingTools;
    }

    @Generated
    public boolean isUnbreakable() {
        return this.isUnbreakable;
    }

    @Generated
    public void setUnbreakable(boolean isUnbreakable) {
        this.isUnbreakable = isUnbreakable;
    }

    @Generated
    public boolean isMagnetic() {
        return this.isMagnetic;
    }

    @Generated
    public void setMagnetic(boolean isMagnetic) {
        this.isMagnetic = isMagnetic;
    }

    @Generated
    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    @Generated
    public void setDurabilityMultiplier(int durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
    }

    @Generated
    public GTToolType[] getTypes() {
        return this.types;
    }

    @Generated
    public void setTypes(GTToolType[] types) {
        this.types = types;
    }

    @Generated
    public Object2IntMap<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    public static class Builder {
        private final ToolProperty toolProperty;

        public static Builder of(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
            return new Builder(harvestSpeed, attackDamage, durability, harvestLevel, new GTToolType[]{GTToolType.SWORD, GTToolType.PICKAXE, GTToolType.SHOVEL, GTToolType.AXE, GTToolType.HOE, GTToolType.MINING_HAMMER, GTToolType.SPADE, GTToolType.SAW, GTToolType.HARD_HAMMER, GTToolType.WRENCH, GTToolType.FILE, GTToolType.CROWBAR, GTToolType.SCREWDRIVER, GTToolType.WIRE_CUTTER, GTToolType.SCYTHE, GTToolType.KNIFE, GTToolType.BUTCHERY_KNIFE, GTToolType.DRILL_LV, GTToolType.DRILL_MV, GTToolType.DRILL_HV, GTToolType.DRILL_EV, GTToolType.DRILL_IV, GTToolType.CHAINSAW_LV, GTToolType.WRENCH_LV, GTToolType.WRENCH_HV, GTToolType.WRENCH_IV, GTToolType.BUZZSAW, GTToolType.SCREWDRIVER_LV, GTToolType.WIRE_CUTTER_LV, GTToolType.WIRE_CUTTER_HV, GTToolType.WIRE_CUTTER_IV});
        }

        public static Builder of(float harvestSpeed, float attackDamage, int durability, int harvestLevel, GTToolType ... types) {
            return new Builder(harvestSpeed, attackDamage, durability, harvestLevel, types);
        }

        private Builder(float harvestSpeed, float attackDamage, int durability, int harvestLevel, GTToolType[] types) {
            this.toolProperty = new ToolProperty(harvestSpeed, attackDamage, durability, harvestLevel, types);
        }

        public Builder enchantability(int enchantability) {
            this.toolProperty.enchantability = enchantability;
            return this;
        }

        public Builder attackSpeed(float attackSpeed) {
            this.toolProperty.attackSpeed = attackSpeed;
            return this;
        }

        public Builder ignoreCraftingTools() {
            this.toolProperty.ignoreCraftingTools = true;
            return this;
        }

        public Builder unbreakable() {
            this.toolProperty.isUnbreakable = true;
            return this;
        }

        public Builder types(GTToolType ... types) {
            this.toolProperty.types = types;
            return this;
        }

        public Builder addTypes(GTToolType ... types) {
            this.toolProperty.types = (GTToolType[])ArrayUtils.addAll((Object[])this.toolProperty.types, (Object[])types);
            return this;
        }

        public Builder enchantment(Enchantment enchantment, int level) {
            this.toolProperty.addEnchantmentForTools(enchantment, level);
            return this;
        }

        public Builder magnetic() {
            this.toolProperty.isMagnetic = true;
            return this;
        }

        public Builder durabilityMultiplier(int multiplier) {
            this.toolProperty.durabilityMultiplier = multiplier;
            return this;
        }

        public ToolProperty build() {
            return this.toolProperty;
        }
    }
}

