/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.stack;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.UnmodifiableView;

public class ItemMaterialInfo {
    private final List<MaterialStack> sortedMaterials = new ArrayList<MaterialStack>();
    private int sortedHash = 0;
    private String toStringValue;

    public ItemMaterialInfo(MaterialStack ... materialStacks) {
        Reference2LongOpenHashMap materials = new Reference2LongOpenHashMap();
        for (MaterialStack mat : materialStacks) {
            materials.addTo((Object)mat.material(), mat.amount());
        }
        this.setSortedMaterials((Reference2LongMap<Material>)materials);
    }

    public ItemMaterialInfo(List<MaterialStack> materialStacks) {
        Reference2LongOpenHashMap materials = new Reference2LongOpenHashMap();
        for (MaterialStack stack : materialStacks) {
            materials.addTo((Object)stack.material(), stack.amount());
        }
        this.setSortedMaterials((Reference2LongMap<Material>)materials);
    }

    public ItemMaterialInfo(Reference2LongMap<Material> materialList) {
        this.setSortedMaterials(materialList);
    }

    public MaterialStack getMaterial() {
        return this.sortedMaterials.isEmpty() ? MaterialStack.EMPTY : this.sortedMaterials.get(0);
    }

    public @UnmodifiableView List<MaterialStack> getMaterials() {
        return Collections.unmodifiableList(this.sortedMaterials);
    }

    public void addMaterialStacks(List<MaterialStack> stacks) {
        Reference2LongOpenHashMap materials = new Reference2LongOpenHashMap();
        this.sortedMaterials.forEach(stack -> materials.addTo((Object)stack.material(), stack.amount()));
        stacks.forEach(stack -> materials.addTo((Object)stack.material(), stack.amount()));
        this.setSortedMaterials((Reference2LongMap<Material>)materials);
    }

    private void setSortedMaterials(Reference2LongMap<Material> matStacks) {
        this.sortedMaterials.clear();
        for (Reference2LongMap.Entry entry : matStacks.reference2LongEntrySet()) {
            this.sortedMaterials.add(new MaterialStack((Material)entry.getKey(), entry.getLongValue()));
        }
        this.sortedMaterials.sort(Comparator.comparingLong(MaterialStack::amount));
        this.sortedHash = this.sortedMaterials.hashCode();
        StringBuilder ret = new StringBuilder("[ ");
        for (MaterialStack matStack : this.sortedMaterials) {
            ret.append((float)matStack.amount() / 3628800.0f).append("x ").append(matStack.material().getResourceLocation()).append(" ");
        }
        ret.append("]");
        this.toStringValue = ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemMaterialInfo that = (ItemMaterialInfo)o;
        return this.hashCode() == o.hashCode() && this.sortedMaterials.equals(that.sortedMaterials);
    }

    public int hashCode() {
        return this.sortedHash;
    }

    public String toString() {
        return this.toStringValue;
    }
}

