/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.stack;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MaterialEntry(@NotNull TagPrefix tagPrefix, @NotNull Material material) {
    public static final MaterialEntry NULL_ENTRY = new MaterialEntry(TagPrefix.NULL_PREFIX, GTMaterials.NULL);
    private static final Map<String, MaterialEntry> PARSE_CACHE = new WeakHashMap<String, MaterialEntry>();

    public MaterialEntry(@NotNull TagPrefix tagPrefix, @NotNull Material material) {
        Preconditions.checkNotNull((Object)tagPrefix, (Object)"MaterialEntry TagPrefix cannot be null!");
        Preconditions.checkNotNull((Object)material, (Object)"MaterialEntry Material cannot be null!");
    }

    public MaterialEntry(TagPrefix tagPrefix) {
        this(tagPrefix, GTMaterials.NULL);
    }

    public boolean isEmpty() {
        return this == NULL_ENTRY || this.material() == GTMaterials.NULL || this.tagPrefix().isEmpty();
    }

    public boolean isIgnored() {
        return this.tagPrefix().isIgnored(this.material());
    }

    @Override
    public String toString() {
        if (this.tagPrefix.isEmpty()) {
            return this.material.getResourceLocation().toString();
        }
        TagKey<Item>[] tags = this.tagPrefix.getItemTags(this.material);
        if (tags.length == 0) {
            return this.tagPrefix.name + "/" + this.material.getName();
        }
        return tags[0].f_203868_().toString();
    }

    @Nullable
    public static MaterialEntry of(Object o) {
        if (o instanceof MaterialEntry) {
            MaterialEntry entry = (MaterialEntry)o;
            return entry;
        }
        if (o instanceof CharSequence) {
            CharSequence chars = (CharSequence)o;
            String str = chars.toString().trim();
            MaterialEntry cached = PARSE_CACHE.get(str);
            if (cached != null) {
                return cached;
            }
            String[] values = str.split(":", 2);
            if (values.length > 1) {
                TagPrefix prefix = TagPrefix.get(values[0]);
                if (prefix == null) {
                    throw new IllegalArgumentException("Invalid TagPrefix: " + values[0]);
                }
                cached = new MaterialEntry(prefix, GTMaterials.get(values[1]));
                PARSE_CACHE.put(str, cached);
                return cached;
            }
        }
        return null;
    }
}

